/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.Theme;

public class GSText
extends GWidget {
    protected JEditorPane editorPane;
    private JScrollPane scrollPane;
    private static boolean fixTimingIssueWithTextWidth = true;

    public GSText(Object parent, String name, String stext, int aw, int ah, int flags, MessageHandler mh) {
        super("GSText", parent, name, flags, mh);
        this.open(name, aw, ah, stext);
        this.addTo(parent);
    }

    public void open(String name, int aw, int ah, String stext) {
        this.open();
        super.open(name, aw * this.tw, ah * this.th + this.ta);
        this.setupGSTextArea(stext, aw, ah);
    }

    void setupGSTextArea(String stext, int aw, int ah) {
        if (stext == null) {
            throw new IllegalArgumentException("STEXT cannot be null.");
        }
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editorPane.setText(stext);
        this.editorPane.setVisible(true);
        this.editorPane.setSize(aw * this.tw, ah * this.th + this.ta);
        this.editorPane.setEditable(false);
        this.editorPane.setBackground(this.theme.cwbg);
        this.editorPane.setForeground(this.theme.cwfg);
        if (Shell.osname.equals("Linux")) {
            this.scrollPane = new JScrollPane(this.editorPane);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.panel.add(this.scrollPane);
        } else {
            this.panel.add(this.editorPane);
        }
        this.setBounds();
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        this.setBounds();
    }

    private void setBounds() {
        this.editorPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        if (this.scrollPane != null) {
            this.scrollPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (fixTimingIssueWithTextWidth && this.scrollPane != null && this.scrollPane.getVerticalScrollBar().isVisible()) {
            this.pw = w - this.bw - this.bw;
            this.editorPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
            this.scrollPane.setBounds(this.bw, this.bw + this.titleh, this.pw, this.ph);
        }
    }

    @Override
    public void setValue(String value) {
        this.editorPane.setText(value);
    }

    @Override
    public String getValue() {
        return this.editorPane.getText();
    }

    @Override
    public void setWidgetTheme(Object o) {
        super.setWidgetTheme(o);
        this.editorPane.setForeground(this.theme.getWidgetForeground());
        this.editorPane.setBackground(this.theme.getWidgetBackground());
    }

    @Override
    public void setTheme(Theme theme) {
        super.setTheme(theme);
        this.editorPane.setBackground(theme.cwbg);
        this.editorPane.setForeground(theme.cwfg);
    }

    @Override
    protected int processEventMessage(String name, int info, Object data) {
        if (this.button == 3 && !this.is(1)) {
            this.close();
            return 1;
        }
        return -1;
    }

    @ProvisionalUseOnly(value="temporary means of backing out fix")
    public static void setFixTimingIssueWithTextWidth(String useFix) {
        fixTimingIssueWithTextWidth = useFix.toLowerCase().equals("true");
    }
}

