/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Graphics;
import nxm.sys.inc.Filter;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Format;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Pipe;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Time;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;

public class GPipeMonitor
extends GWidget {
    public static final String flagsList = GWidget.flagsList + ",Slider,ShowRate";
    public static final int SLIDER = 256;
    public static final int SHOWRATE = 512;
    private static final String NOPIPE = "NOPIPE";
    private Midas M;
    private double pread;
    private double pwrite;
    private double prate;
    private double ptime;
    private int pw;
    private int iw;
    private int ip;
    private String prompt;
    private String format;
    private String sval;
    private MBox bp;
    private MBox bt;
    private MBox bc;
    private MBox br;
    private int digits;
    private int promptWidth = 0;
    private int mouseMode = 0;
    private Pipe pipe;
    private Format nf;
    private String[] pipeNames;

    public GPipeMonitor(Object parent, String name, Midas M, int flags, MessageHandler mh) {
        super("GPipeMonitor", parent, name, flags, mh);
        this.open(name, M);
        this.addTo(parent);
    }

    public GPipeMonitor(Object parent, Pipe pipe, int flags, MessageHandler mh) {
        super("GPipeMonitor", parent, pipe.getName(), flags, mh);
        this.open(pipe);
        this.addTo(parent);
    }

    public void open(Pipe pipe) {
        super.open();
        this.prompt = pipe.getName();
        this.promptWidth = this.stringWidth(this.prompt);
        this.nf = new Format();
        this.setFormat("##0.0#####");
        this.setup();
    }

    public void open(String name, Midas M) {
        super.open();
        this.M = M;
        this.prompt = name;
        if (this.prompt.equals("") || this.prompt.equals("VALUE")) {
            this.prompt = NOPIPE;
        }
        this.getPipeNames();
        this.nf = new Format();
        this.setFormat("##0.0#####");
        this.setup();
    }

    public void setFormat(String numFormat) {
        if (numFormat == null || numFormat.length() == 0) {
            return;
        }
        this.format = numFormat;
        this.digits = numFormat.length();
        this.nf.setFormat(this.format);
        this.setup();
    }

    private void getPipeNames() {
        this.promptWidth = this.stringWidth(NOPIPE);
        this.pipeNames = this.M.pipes.getKeys(PipeFilter.INSTANCE);
        this.ip = -1;
        for (int i = 0; i < this.pipeNames.length; ++i) {
            this.promptWidth = Math.max(this.promptWidth, this.stringWidth(this.pipeNames[i]));
            if (!this.prompt.equals(this.pipeNames[i])) continue;
            this.ip = i;
        }
    }

    @Override
    public void setup() {
        Object npipe;
        this.bw = this.is(32) ? 0 : 4;
        int h = this.th + this.ta - this.compression;
        int w = this.tw * this.digits;
        this.pw = this.promptWidth;
        this.bp = new MBox(this.bw + this.tw, this.bw, this.pw, h);
        this.bc = new MBox(this.bp.x + this.bp.w, this.bw, this.th + this.tw, h);
        this.bt = new MBox(this.bc.x + this.bc.w, this.bw + h / 2 - this.th / 2, w, this.th);
        this.pos.w = this.bt.x + this.bt.w + this.tw + this.bw;
        this.pos.h = h + this.bw + this.bw;
        if (this.fixWidth > this.pos.w) {
            this.pos.w = this.fixWidth;
            this.bt.w = this.pos.w - this.bt.x - this.bw - this.tw;
        }
        if (this.M != null && this.M.pipes != null && ((npipe = this.M.pipes.get(this.prompt)) == null || npipe instanceof Pipe)) {
            this.pipe = (Pipe)npipe;
        }
        this.layout();
    }

    @Override
    public void resize(int mode) {
        super.resize(mode);
        this.bt.w = this.pos.w - this.bt.x - this.bw - this.tw;
    }

    @Override
    @Deprecated
    public void paint() {
        this.refresh();
    }

    @Override
    @ProvisionalUseOnly(value="Treat this as protected and should only be called by subclass paintComponent methods")
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int ty = this.pos.h / 2 + this.ta / 2;
        this.shadowbox(g, 0, 0, this.pos.w, this.pos.h, -2, 0);
        g.setColor(this.theme.cwfg);
        g.drawString(this.prompt, this.bp.x, ty);
        this.drawDiamond(g, this.bc.x + this.bc.w / 2, this.bc.y + this.bc.h / 2 + 1, this.tw * 2 / 3, this.mouseMode);
        if (this.is(256)) {
            this.shadowbox(g, this.bt.x, this.bt.y, this.bt.w, this.bt.h, 0);
            int writeX = 1;
            int readX = 0;
            double factor = 1.0;
            if (this.pipe != null) {
                factor = (double)(this.bt.w - 4) / (double)this.pipe.getSize();
                writeX = (int)(this.pwrite % (double)this.pipe.getSize() * factor);
                readX = (int)(this.pread % (double)this.pipe.getSize() * factor);
            }
            g.setColor(this.theme.cwfh);
            if (writeX > readX) {
                this.iw = writeX - readX + 1;
                g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else if (writeX < readX) {
                this.iw = this.bt.w - 4 - readX;
                g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
                this.iw = writeX;
                g.fillRect(this.bt.x + 2, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else if (this.pwrite - this.pread == (double)this.pipe.getSize()) {
                this.iw = this.bt.w - 4;
                g.fillRect(this.bt.x + 2, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else {
                this.iw = writeX - readX + 1;
                g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
            }
        } else {
            g.setColor(this.theme.cwbg);
            g.fillRect(this.bt.x, this.bt.y, this.bt.w, this.bt.h);
        }
        if (this.is(512) && !NOPIPE.equals(this.prompt)) {
            this.sval = this.nf.form(this.prate);
            g.setColor(this.theme.cwfg);
            g.drawString(this.sval, this.bt.x + 2, this.bt.y + this.ta);
        }
    }

    @Deprecated
    public synchronized void drawData() {
        if (this.is(256)) {
            this.shadowbox(this.bt.x, this.bt.y, this.bt.w, this.bt.h, 0);
            int writeX = 1;
            int readX = 0;
            double factor = 1.0;
            if (this.pipe != null) {
                factor = (double)(this.bt.w - 4) / (double)this.pipe.getSize();
                writeX = (int)(this.pwrite % (double)this.pipe.getSize() * factor);
                readX = (int)(this.pread % (double)this.pipe.getSize() * factor);
            }
            this.g.setColor(this.theme.cwfh);
            if (writeX > readX) {
                this.iw = writeX - readX + 1;
                this.g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else if (writeX < readX) {
                this.iw = this.bt.w - 4 - readX;
                this.g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
                this.iw = writeX;
                this.g.fillRect(this.bt.x + 2, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else if (this.pwrite - this.pread == (double)this.pipe.getSize()) {
                this.iw = this.bt.w - 4;
                this.g.fillRect(this.bt.x + 2, this.bt.y + 2, this.iw, this.bt.h - 4);
            } else {
                this.iw = writeX - readX + 1;
                this.g.fillRect(this.bt.x + 2 + readX, this.bt.y + 2, this.iw, this.bt.h - 4);
            }
        } else {
            this.g.setColor(this.theme.cwbg);
            this.g.fillRect(this.bt.x, this.bt.y, this.bt.w, this.bt.h);
        }
        this.g.setColor(this.theme.cwfg);
        if (this.is(512) && !NOPIPE.equals(this.prompt)) {
            this.sval = this.nf.form(this.prate);
            this.g.drawString(this.sval, this.bt.x + 2, this.bt.y + this.ta);
        }
    }

    private void sendMessage() {
    }

    @Override
    public String getLegend() {
        if (this.mouseMode == 4) {
            return "(LM=SelectPipe,MM=Configure)";
        }
        return "(LM=ShowDetails,MM=ToggleSlider,RM=ToggleRate)";
    }

    @Override
    public int processEventMessage(String name, int info, Object data) {
        if (name.equals("POINTER")) {
            int mm = info < 0 ? 0 : (this.px < this.bc.x ? 4 : (this.px < this.bc.x + this.bc.x + this.bc.w ? (this.py < this.pos.h / 2 ? 1 : 2) : 8));
            if (mm != this.mouseMode) {
                this.mouseMode = mm;
                this.refresh(this.bc);
                if (info == 0) {
                    info = 1;
                }
            }
            this.formatReadOut(info);
        }
        if (!name.equals("BUTTON")) {
            return -1;
        }
        int button = info;
        if (button > 0 && this.px < this.bc.x) {
            if (button == 1 && this.M != null) {
                this.getPipeNames();
                String pipeList = NOPIPE + StringUtil.toStringBuilder(this.pipeNames, ",", null, false);
                new GMenu(this.parent, "Select Pipe", pipeList, this.ip + 2, 0, this);
            }
            if (button == 2) {
                this.configure();
            }
            if (button == 3 && !this.is(1)) {
                this.close();
            }
        } else if (button > 0 && this.px < this.bc.x + this.bc.w) {
            if (this.pipeNames.length == 0) {
                this.getPipeNames();
            }
            if (this.pipeNames.length == 0) {
                return 1;
            }
            if (button == 1 && this.py >= this.bc.h / 2) {
                ++this.ip;
            }
            if (button == 1 && this.py < this.bc.h / 2) {
                --this.ip;
            }
            if (button == 3) {
                --this.ip;
            }
            if (this.ip < 0) {
                this.ip = this.pipeNames.length - 1;
            }
            this.ip %= this.pipeNames.length;
            this.prompt = this.pipeNames[this.ip];
            this.setup();
            this.refresh();
        } else if (button > 0 && this.px > this.bt.x - 4 && this.px < this.pos.w) {
            if (button == 1 && this.pipe != null) {
                new GQuery(this.MW, this.prompt, this.pipe, 0, (MessageHandler)this);
            }
            if (button == 2) {
                this.flags ^= 0x100;
            }
            if (button == 3) {
                this.flags ^= 0x200;
            }
            this.refresh();
        }
        return 1;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals("GPIPEMONITOR.CFG")) {
            this.setFlags(msg.info);
        } else if (msg.name.equals("SELECT PIPE")) {
            this.setValue((String)msg.data);
        }
        return 1;
    }

    @Override
    public void setValue(String value) {
        if (this.prompt.equals(value)) {
            return;
        }
        if (value.equals(NOPIPE)) {
            this.prompt = value;
            this.pipe = null;
        } else {
            for (int i = 0; i < this.pipeNames.length; ++i) {
                if (!value.equals(this.pipeNames[i])) continue;
                this.prompt = value;
                this.ip = i;
                break;
            }
        }
        this.setup();
    }

    @Override
    public Object getValue() {
        return this.prompt;
    }

    @Override
    public boolean poll() {
        if (this.pipe == null) {
            return false;
        }
        double write = this.pipe.getInByte();
        double read = this.pipe.getOutByte();
        double time = Time.current();
        if (time - this.ptime > 1.0) {
            this.prate = this.pipe.getRate() * 1.0E-6;
            this.ptime = time;
            Object npipe = this.M.pipes.get(this.prompt);
            if (npipe != null && npipe != this.pipe && npipe instanceof Pipe) {
                this.pipe = (Pipe)npipe;
            }
        } else if (write == this.pwrite && read == this.pread) {
            return false;
        }
        this.pwrite = write;
        this.pread = read;
        this.refresh(this.bt);
        return true;
    }

    static enum PipeFilter implements Filter
    {
        INSTANCE;


        @Override
        public boolean accept(Object entry) {
            return entry instanceof Pipe;
        }
    }
}

