/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

public class ContourHighPrecision {
    public static final int P_L = 1;
    public static final int P_T = 2;
    public static final int P_R = 3;
    public static final int P_B = 4;
    public double xstart;
    public double xdelta;
    public double ystart;
    public double ydelta;
    public double zstart;
    public double zdelta;
    public int nx = 0;
    public int ny = 0;
    public int nz = 0;
    public int nxy = 0;
    public int maxout = 0;
    public int nout;
    private double[] work;
    private double z;
    private int[] chk;
    private int ix1;
    private int ix2;
    private int iy1;
    private int iy2;
    public double[] out;
    private static final int NUM_HEADER_VALUES = 6;
    private static final int[] statearray = new int[]{0, 4, 0, 3, 0, 2, 0, 2, 0, 0, 0, 0, 3, 1, 4, 1, 0, 0, 4, 1, 2, 4, 0, 0, 0, 1, 3, 0, 0, 3, 2, 0};

    public void setXAxis(double start, double delta, int n) {
        this.xstart = start;
        this.xdelta = delta;
        this.nx = n;
        this.setBounds(0, 0, this.nx, this.ny);
    }

    public void setYAxis(double start, double delta, int n) {
        this.ystart = start;
        this.ydelta = delta;
        this.ny = n;
        this.setBounds(0, 0, this.nx, this.ny);
    }

    public void setZAxis(double start, double delta, int n) {
        this.zstart = start;
        this.zdelta = delta;
        this.nz = n;
    }

    public void setBounds(int ix1, int iy1, int ix2, int iy2) {
        this.ix1 = Math.max(0, Math.min(this.nx, Math.min(ix1, ix2)));
        this.ix2 = Math.max(0, Math.min(this.nx, Math.max(ix1, ix2)));
        this.iy1 = Math.max(0, Math.min(this.ny, Math.min(iy1, iy2)));
        this.iy2 = Math.max(0, Math.min(this.ny, Math.max(iy1, iy2)));
    }

    public int process(double[] buf) {
        this.work = buf;
        if (this.nx * this.ny * 4 > this.maxout) {
            this.maxout = this.nx * this.ny * 4;
            this.out = new double[this.maxout];
        }
        if (this.nx * this.ny > this.nxy) {
            this.nxy = this.nx * this.ny;
            this.chk = new int[this.nxy];
        }
        this.nout = 0;
        for (int iz = 0; iz < this.nz; ++iz) {
            int ix;
            int ii;
            int iy;
            for (iy = this.iy1; iy < this.iy2; ++iy) {
                ii = iy * this.nx + this.ix1;
                for (ix = this.ix1; ix < this.ix2; ++ix) {
                    this.chk[ii++] = 0;
                }
            }
            this.z = this.zstart + (double)iz * this.zdelta;
            if (this.ix2 > this.ix1) {
                for (iy = this.iy1; iy < this.iy2 - 1; ++iy) {
                    ii = iy * this.nx + this.ix1;
                    if (this.chk[ii] == 0 && this.z > this.work[ii] ^ this.z > this.work[ii + this.nx]) {
                        this.doLine(this.ix1, iy, 1);
                    }
                    if (this.chk[(ii += this.ix2 - this.ix1 - 1) - 1] != 0 || !(this.z > this.work[ii] ^ this.z > this.work[ii + this.nx])) continue;
                    this.doLine(this.ix2 - 2, iy, 3);
                }
            }
            if (this.iy2 > this.iy1) {
                for (ix = this.ix1; ix < this.ix2 - 1; ++ix) {
                    ii = ix + this.iy1 * this.nx;
                    if (this.chk[ii] == 0 && this.z > this.work[ii] ^ this.z > this.work[ii + 1]) {
                        this.doLine(ix, this.iy1, 2);
                    }
                    if (this.chk[(ii += this.nx * (this.iy2 - this.iy1 - 1)) - this.nx] != 0 || !(this.z > this.work[ii] ^ this.z > this.work[ii + 1])) continue;
                    this.doLine(ix, this.iy2 - 2, 4);
                }
            }
            for (iy = this.iy1 + 1; iy < this.iy2 - 1; ++iy) {
                ii = iy * this.nx + this.ix1 + 1;
                ix = this.ix1 + 1;
                while (ix < this.ix2 - 1) {
                    if (this.chk[ii] == 0 && this.z > this.work[ii] ^ this.z > this.work[ii + 1]) {
                        this.doLine(ix, iy, 2);
                    }
                    ++ix;
                    ++ii;
                }
            }
        }
        return this.nout;
    }

    private void doLine(int ix, int iy, int inside) {
        int side = inside;
        int ii = ix + this.nx * iy;
        boolean inbounds = true;
        int n = this.nout + 6;
        while (this.nout < this.maxout && inbounds && this.chk[ii] != side) {
            double rr;
            this.chk[ii] = side;
            double z1 = this.work[ii];
            double z2 = this.work[ii + 1];
            double z3 = this.work[ii + 1 + this.nx];
            double z4 = this.work[ii + this.nx];
            if (n == this.nout + 6) {
                switch (side) {
                    case 1: {
                        rr = (this.z - z1) / (z4 - z1);
                        this.out[n++] = this.xstart + (double)ix * this.xdelta;
                        this.out[n++] = this.ystart + ((double)iy + rr) * this.ydelta;
                        break;
                    }
                    case 2: {
                        rr = (this.z - z1) / (z2 - z1);
                        this.out[n++] = this.xstart + ((double)ix + rr) * this.xdelta;
                        this.out[n++] = this.ystart + (double)iy * this.ydelta;
                        break;
                    }
                    case 3: {
                        rr = (this.z - z2) / (z3 - z2);
                        this.out[n++] = this.xstart + (double)(ix + 1) * this.xdelta;
                        this.out[n++] = this.ystart + ((double)iy + rr) * this.ydelta;
                        break;
                    }
                    case 4: {
                        rr = (this.z - z4) / (z3 - z4);
                        this.out[n++] = this.xstart + ((double)ix + rr) * this.xdelta;
                        this.out[n++] = this.ystart + (double)(iy + 1) * this.ydelta;
                    }
                }
            }
            int state = 1;
            if (this.z > z1) {
                state += 8;
            }
            if (this.z > z2) {
                state += 4;
            }
            if (this.z > z3) {
                state += 2;
            }
            if (this.z > z4) {
                ++state;
            }
            if (state > 8) {
                state = 17 - state;
            }
            int newside = statearray[state - 1 + (side - 1) * 8];
            switch (newside) {
                case 1: {
                    rr = (this.z - z1) / (z4 - z1);
                    this.out[n++] = this.xstart + (double)ix * this.xdelta;
                    this.out[n++] = this.ystart + ((double)iy + rr) * this.ydelta;
                    side = 3;
                    inbounds = --ix >= this.ix1;
                    break;
                }
                case 2: {
                    rr = (this.z - z1) / (z2 - z1);
                    this.out[n++] = this.xstart + ((double)ix + rr) * this.xdelta;
                    this.out[n++] = this.ystart + (double)iy * this.ydelta;
                    side = 4;
                    inbounds = --iy >= this.iy1;
                    break;
                }
                case 3: {
                    rr = (this.z - z2) / (z3 - z2);
                    this.out[n++] = this.xstart + (double)(ix + 1) * this.xdelta;
                    this.out[n++] = this.ystart + ((double)iy + rr) * this.ydelta;
                    side = 1;
                    inbounds = ++ix < this.ix2 - 1;
                    break;
                }
                case 4: {
                    rr = (this.z - z4) / (z3 - z4);
                    this.out[n++] = this.xstart + ((double)ix + rr) * this.xdelta;
                    this.out[n++] = this.ystart + (double)(iy + 1) * this.ydelta;
                    side = 2;
                    inbounds = ++iy < this.iy2 - 1;
                }
            }
            ii = ix + this.nx * iy;
        }
        int npts = (n - this.nout - 6) / 2;
        if (npts <= 1) {
            return;
        }
        this.out[this.nout + 0] = npts;
        this.out[this.nout + 1] = this.z;
        if (this.xdelta > 0.0) {
            this.out[this.nout + 2] = this.xstart;
            this.out[this.nout + 4] = this.xstart + (double)(this.nx - 1) * this.xdelta;
        } else {
            this.out[this.nout + 4] = this.xstart;
            this.out[this.nout + 2] = this.xstart + (double)(this.nx - 1) * this.xdelta;
        }
        if (this.ydelta > 0.0) {
            this.out[this.nout + 3] = this.ystart;
            this.out[this.nout + 5] = this.ystart + (double)(this.ny - 1) * this.ydelta;
        } else {
            this.out[this.nout + 5] = this.ystart;
            this.out[this.nout + 3] = this.ystart + (double)(this.ny - 1) * this.ydelta;
        }
        this.nout = n;
    }
}

