/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Vector;
import nxm.sys.lib.Data;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Table;
import nxm.sys.lib.XMValue;

class XMValueJava
implements XMValue.Backend {
    private char type;
    private Data data;
    private boolean scalar;
    private Vector<XMValue> list;
    private KeyVector kvlist;
    private Table table;

    public XMValueJava() {
        this.reset(' ');
    }

    private XMValueJava(char type) {
        this.reset(type);
    }

    private XMValue newXMValue(String v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(byte v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(short v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(int v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(long v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(float v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    private XMValue newXMValue(double v) {
        XMValueJava b = new XMValueJava();
        b.setValue(v);
        return new XMValue(b);
    }

    @Override
    public void setValue(String v) {
        this.reset('A');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(byte v) {
        this.reset('B');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(short v) {
        this.reset('I');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(int v) {
        this.reset('L');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(long v) {
        this.reset('X');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(float v) {
        this.reset('F');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(double v) {
        this.reset('D');
        this.data = new Data(v);
        this.scalar = true;
    }

    @Override
    public void setValue(byte[] v) {
        this.reset('B');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public void setValue(short[] v) {
        this.reset('I');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public void setValue(int[] v) {
        this.reset('L');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public void setValue(long[] v) {
        this.reset('X');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public void setValue(float[] v) {
        this.reset('F');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public void setValue(double[] v) {
        this.reset('D');
        this.data = new Data(v);
        this.scalar = false;
    }

    @Override
    public double toD() {
        return this.data.toD();
    }

    @Override
    public float toF() {
        return this.data.toF();
    }

    @Override
    public long toX() {
        return this.data.toX();
    }

    @Override
    public int toL() {
        return this.data.toNumber().intValue();
    }

    @Override
    public short toI() {
        return this.data.toI();
    }

    @Override
    public byte toB() {
        return this.data.toB();
    }

    @Override
    public String toA() {
        return this.data != null ? this.data.toString() : null;
    }

    @Override
    public String toZ() {
        return this.data != null ? this.data.toString() : null;
    }

    @Override
    public char getFormatType() {
        return this.type;
    }

    private XMValue newXMValue(String key, XMValue val) {
        XMValueJava b = new XMValueJava();
        b.reset('K');
        b.kvlist = new KeyVector();
        b.kvlist.add(key, val);
        return new XMValue(b);
    }

    private void reset(char t) {
        this.type = t;
        this.data = null;
        this.scalar = true;
        this.list = null;
        this.table = null;
        this.kvlist = null;
    }

    private XMValueJava copy() {
        XMValueJava b = new XMValueJava();
        b.setValue(this);
        return b;
    }

    @Override
    public void setValue(Data v) {
        this.reset((char)v.getFormatType());
        this.data = v.copy();
        this.data.setSPA(1);
        this.scalar = v.getSize() == 1;
    }

    @Override
    public void setValue(XMValue v) {
        int i;
        XMValue.Backend b = v.getBackend();
        if (b instanceof XMValueJava) {
            this.setValue((XMValueJava)b);
            return;
        }
        char t = v.getFormatType();
        int s = v.getSize();
        if (t == ' ') {
            this.reset(t);
            return;
        }
        if (t == 'A') {
            this.setValue(v.toA());
            return;
        }
        if (XMValue.isNumericType(t)) {
            this.reset(t);
            this.scalar = b.isScalar();
            if (this.scalar) {
                switch (t) {
                    case 'B': {
                        this.setValue(v.toB());
                        return;
                    }
                    case 'I': {
                        this.setValue(v.toI());
                        return;
                    }
                    case 'L': {
                        this.setValue(v.toL());
                        return;
                    }
                    case 'X': {
                        this.setValue(v.toX());
                        return;
                    }
                    case 'F': {
                        this.setValue(v.toF());
                        return;
                    }
                    case 'D': {
                        this.setValue(v.toD());
                        return;
                    }
                }
                throw new AssertionError((Object)("Invalid XMValue type '" + t + "'."));
            }
            switch (this.type) {
                case 'B': {
                    this.data = new Data("SB", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setB(i, v.get(i).toB());
                    }
                    break;
                }
                case 'I': {
                    this.data = new Data("SI", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setI(i, v.get(i).toI());
                    }
                    break;
                }
                case 'L': {
                    this.data = new Data("SL", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setL(i, v.get(i).toL());
                    }
                    break;
                }
                case 'X': {
                    this.data = new Data("SX", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setX(i, v.get(i).toX());
                    }
                    break;
                }
                case 'F': {
                    this.data = new Data("SF", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setF(i, v.get(i).toF());
                    }
                    break;
                }
                case 'D': {
                    this.data = new Data("SD", s);
                    for (i = 0; i < s; ++i) {
                        this.data.setD(i, v.get(i).toD());
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
                }
            }
        }
        if (t == 'C') {
            this.reset(t);
            this.list = new Vector();
            for (i = 0; i < s; ++i) {
                this.list.add(v.get(i));
            }
        }
        if (t == 'K') {
            this.reset(t);
            this.kvlist = new KeyVector();
            for (i = 0; i < s; ++i) {
                XMValue.KVPair pair = b.getPair(i);
                this.add(pair.getKey(), pair.getValue());
            }
        }
        if (t == 'H') {
            this.reset(t);
            this.table = new Table();
            XMValue.Backend bb = b.vectorize().getBackend();
            for (int i2 = 0; i2 < s; ++i2) {
                XMValue.KVPair pair = bb.getPair(i2);
                this.add(pair.getKey(), pair.getValue());
            }
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
    }

    private void setValue(XMValueJava b) {
        this.reset(b.type);
        if (b.data != null) {
            this.scalar = b.scalar;
            this.data = b.data.copy();
            return;
        }
        switch (this.type) {
            case ' ': {
                break;
            }
            case 'C': {
                this.list = new Vector<XMValue>(b.list);
                break;
            }
            case 'K': {
                this.kvlist = b.kvlist.copy();
                break;
            }
            case 'H': {
                this.table = b.table.copy();
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
            }
        }
    }

    @Override
    public int size() {
        if (this.data != null) {
            return this.data.getSize();
        }
        switch (this.type) {
            case ' ': {
                return 0;
            }
            case 'C': {
                return this.list.size();
            }
            case 'K': {
                return this.kvlist.size();
            }
            case 'H': {
                return this.table.size();
            }
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
    }

    @Override
    public void clear() {
        if (this.data != null) {
            this.data.setSize(0);
            return;
        }
        switch (this.type) {
            case ' ': {
                break;
            }
            case 'C': {
                this.list.clear();
                break;
            }
            case 'K': {
                this.kvlist.clear();
                break;
            }
            case 'H': {
                this.table.clear();
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
            }
        }
    }

    @Override
    public boolean isScalar() {
        return this.scalar;
    }

    @Override
    public XMValue get(int i) {
        switch (this.type) {
            case ' ': {
                return this.newXMValue(0);
            }
            case 'A': {
                return this.newXMValue(this.data.toString());
            }
            case 'B': {
                return this.newXMValue(this.data.getB(i - 1));
            }
            case 'O': {
                return this.newXMValue(this.data.getP(i - 1));
            }
            case 'I': {
                return this.newXMValue(this.data.getI(i - 1));
            }
            case 'L': {
                return this.newXMValue(this.data.getL(i - 1));
            }
            case 'X': {
                return this.newXMValue(this.data.getX(i - 1));
            }
            case 'F': {
                return this.newXMValue(this.data.getF(i - 1));
            }
            case 'D': {
                return this.newXMValue(this.data.getD(i - 1));
            }
            case 'C': {
                return this.list.get(i - 1);
            }
            case 'K': {
                return this.newXMValue(this.kvlist.getKey(i - 1), (XMValue)this.kvlist.get(i - 1));
            }
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
    }

    @Override
    public void set(int i, String k, XMValue v) {
        this.kvlist.set(i - 1, k, v);
    }

    @Override
    public void set(int i, XMValue v) {
        switch (this.type) {
            case 'A': {
                this.data = new Data(v.toA());
                break;
            }
            case 'Z': {
                this.data = new Data(v.toZ(), true);
                break;
            }
            case 'B': {
                this.data.setB(i - 1, v.toB());
                break;
            }
            case 'I': {
                this.data.setI(i - 1, v.toI());
                break;
            }
            case 'L': {
                this.data.setL(i - 1, v.toL());
                break;
            }
            case 'X': {
                this.data.setX(i - 1, v.toX());
                break;
            }
            case 'F': {
                this.data.setF(i - 1, v.toF());
                break;
            }
            case 'D': {
                this.data.setD(i - 1, v.toD());
                break;
            }
            case 'C': {
                this.list.set(i - 1, v);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
            }
        }
    }

    @Override
    public XMValue.KVPair getPair(int i) {
        String key = this.kvlist.getKey(i - 1);
        XMValue val = (XMValue)this.kvlist.get(i - 1);
        return new XMValue.KVPair(key, val);
    }

    @Override
    public XMValue get(String key) {
        switch (this.type) {
            case 'K': {
                return (XMValue)this.kvlist.get(key);
            }
            case 'H': {
                return (XMValue)this.table.get(key);
            }
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
    }

    @Override
    public void setValue(char type) {
        this.reset(type);
        switch (type) {
            case ' ': {
                break;
            }
            case 'A': {
                this.data = new Data("");
                break;
            }
            case 'Z': {
                this.data = new Data("", true);
                break;
            }
            case 'B': {
                this.data = new Data("SB", 0);
                break;
            }
            case 'O': {
                this.data = new Data("SO", 0);
                break;
            }
            case 'I': {
                this.data = new Data("SI", 0);
                break;
            }
            case 'L': {
                this.data = new Data("SL", 0);
                break;
            }
            case 'X': {
                this.data = new Data("SX", 0);
                break;
            }
            case 'F': {
                this.data = new Data("SF", 0);
                break;
            }
            case 'D': {
                this.data = new Data("SD", 0);
                break;
            }
            case 'C': {
                this.list = new Vector();
                break;
            }
            case 'K': {
                this.kvlist = new KeyVector();
                break;
            }
            case 'H': {
                this.table = new Table();
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + type + "'."));
            }
        }
    }

    @Override
    public void setValue(char type, int size, double value) {
        int i;
        this.reset(type);
        if (type == 'C') {
            XMValue v = this.newXMValue(value);
            this.list = new Vector();
            for (i = 0; i < size; ++i) {
                this.list.add(v);
            }
            return;
        }
        switch (type) {
            case 'B': {
                this.data = new Data("SB", size);
                byte v = (byte)value;
                while (i < size) {
                    this.data.setB(i++, v);
                }
                break;
            }
            case 'O': {
                this.data = new Data("SO", size);
                byte v = (byte)value;
                while (i < size) {
                    this.data.setP(i++, v);
                }
                break;
            }
            case 'I': {
                this.data = new Data("SI", size);
                short v = (short)value;
                while (i < size) {
                    this.data.setI(i++, v);
                }
                break;
            }
            case 'L': {
                this.data = new Data("SL", size);
                int v = (int)value;
                while (i < size) {
                    this.data.setL(i++, v);
                }
                break;
            }
            case 'X': {
                this.data = new Data("SX", size);
                long v = (long)value;
                while (i < size) {
                    this.data.setX(i++, v);
                }
                break;
            }
            case 'F': {
                this.data = new Data("SF", size);
                float v = (float)value;
                while (i < size) {
                    this.data.setF(i++, v);
                }
                break;
            }
            case 'D': {
                this.data = new Data("SD", size);
                double v = value;
                while (i < size) {
                    this.data.setD(i++, v);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + type + "'."));
            }
        }
    }

    @Override
    public boolean containsKey(String key) {
        switch (this.type) {
            case 'K': {
                return this.kvlist.findKey(key) >= 0;
            }
            case 'H': {
                return this.table.containsKey(key);
            }
        }
        throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
    }

    @Override
    public void add(XMValue v) {
        if (this.type == 'C') {
            this.list.add(v);
            return;
        }
        int size = this.data.getSize();
        this.data.setSize(size + 1);
        switch (this.type) {
            case 'B': {
                this.data.setB(size, v.toB());
                break;
            }
            case 'O': {
                this.data.setB(size, v.toB());
                break;
            }
            case 'I': {
                this.data.setI(size, v.toI());
                break;
            }
            case 'L': {
                this.data.setL(size, v.toL());
                break;
            }
            case 'X': {
                this.data.setX(size, v.toX());
                break;
            }
            case 'F': {
                this.data.setF(size, v.toF());
                break;
            }
            case 'D': {
                this.data.setD(size, v.toD());
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid XMValue type '" + this.type + "'."));
            }
        }
    }

    @Override
    public void add(String key, XMValue val) {
        switch (this.type) {
            case 'K': {
                this.kvlist.add(key, val);
                break;
            }
            case 'H': {
                this.table.put(key, (Object)val);
            }
        }
    }

    @Override
    public void put(String key, XMValue val) {
        switch (this.type) {
            case 'K': {
                this.kvlist.put(key, val);
                break;
            }
            case 'H': {
                this.table.put(key, (Object)val);
            }
        }
    }

    @Override
    public XMValue vectorize() {
        XMValueJava b = this.copy();
        b.scalar = false;
        return new XMValue(b);
    }

    @Override
    public XMValue keys() {
        String[] keys = this.type == 'H' ? this.table.getKeys() : this.kvlist.getKeys();
        XMValueJava b = new XMValueJava('C');
        b.list = new Vector();
        for (String key : keys) {
            b.list.add(this.newXMValue(key));
        }
        return new XMValue(b);
    }

    @Override
    public XMValue tablize() {
        if (this.type == 'H') {
            return new XMValue(this.copy());
        }
        XMValueJava v = new XMValueJava('H');
        v.table = new Table();
        for (int i = 0; i < this.kvlist.size(); ++i) {
            v.table.put(this.kvlist.getKey(i), this.kvlist.get(i));
        }
        return new XMValue(v);
    }

    @Override
    public XMValue items() {
        if (this.type == 'K') {
            return new XMValue(this.copy());
        }
        XMValueJava b = new XMValueJava('K');
        b.kvlist = new KeyVector();
        for (String key : this.table.getKeys()) {
            b.kvlist.add(key, this.table.get(key));
        }
        return new XMValue(b);
    }
}

