/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.InternalUseOnly;

@InternalUseOnly
public final class Vector3D {
    private Vector3D() {
    }

    @InternalUseOnly
    public static double dotProduct(double[] vector1, double[] vector2) {
        return vector1[0] * vector2[0] + vector1[1] * vector2[1] + vector1[2] * vector2[2];
    }

    @InternalUseOnly
    public static double mag(double[] vector) {
        return Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
    }

    @InternalUseOnly
    public static double[] norm(double[] vector) {
        return Vector3D.norm(vector, Vector3D.mag(vector));
    }

    @InternalUseOnly
    public static double[] norm(double[] vector, double magnitude) {
        double inverseMagnitude = 1.0 / magnitude;
        double[] normalizedVector = new double[vector.length];
        for (int i = 0; i < normalizedVector.length; ++i) {
            normalizedVector[i] = vector[i] * inverseMagnitude;
        }
        return normalizedVector;
    }

    @InternalUseOnly
    public static double[] subtract(double[] vector1, double[] vector2) {
        return new double[]{vector1[0] - vector2[0], vector1[1] - vector2[1], vector1[2] - vector2[2]};
    }

    @InternalUseOnly
    public static double[] add(double[] vector1, double[] vector2) {
        return new double[]{vector1[0] + vector2[0], vector1[1] + vector2[1], vector1[2] + vector2[2]};
    }

    @InternalUseOnly
    public static double angleBetween(double[] vector1, double[] vector2) {
        return Math.acos(Vector3D.dotProduct(vector1, vector2) / (Vector3D.mag(vector1) * Vector3D.mag(vector2)));
    }

    @InternalUseOnly
    public static double angleBetween(double[] commonPoint, double[] point1, double[] point2) {
        double[] vector1 = new double[]{point1[0] - commonPoint[0], point1[1] - commonPoint[1], point1[2] - commonPoint[2]};
        double[] vector2 = new double[]{point2[0] - commonPoint[0], point2[1] - commonPoint[1], point2[2] - commonPoint[2]};
        return Vector3D.angleBetween(vector1, vector2);
    }

    @InternalUseOnly
    public static double[] multByScalar(double[] vector, double scalar) {
        return new double[]{vector[0] * scalar, vector[1] * scalar, vector[2] * scalar};
    }

    @InternalUseOnly
    public static double[] crossProduct(double[] vector1, double[] vector2) {
        double[] crossProduct = new double[]{vector1[1] * vector2[2] - vector1[2] * vector2[1], vector1[2] * vector2[0] - vector1[0] * vector2[2], vector1[0] * vector2[1] - vector1[1] * vector2[0]};
        return crossProduct;
    }
}

