/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

public class Time
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 202210141030L;
    private static double lastTag = 0.0;
    private static String strTag;
    private static final int defPrecision = 3;
    public static final int MAX_PRECISION = 12;
    public static final int MIN_PRECISION = 0;
    public static final int STD = 1;
    public static final int ACQ = 2;
    public static final int EPOCH = 3;
    public static final int NORAD = 4;
    public static final int TCR = 5;
    public static final int VAX = 6;
    public static final int FILENAME = 7;
    public static final int HMS = 8;
    public static final int YMD = 9;
    public static final int ISO8601 = 10;
    public static final int FULL_STD = 11;
    public static final int ACQDATE = 12;
    public static final int ACQTIME = 13;
    public static final String formatList = "Std,Acq,Epoch,Norad,TCR,Vax,Filename,HMS,YMD,ISO8601,Full_Std,AcqDate,AcqTime";
    public static final String monthList = "JAN,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC";
    public static final String monthNameList = "January,February,March,April,May,June,July,August,September,October,November,December";
    public static final String dayList = "SUN,MON,TUE,WED,THU,FRI,SAT";
    public static final String dayNameList = "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday";
    public static final int[] dim;
    public static final int J1950TOJ1970 = -631152000;
    public static final int J1970TOJ1950 = 631152000;
    public static final int J1950TOJ2000 = -1577836800;
    public static final int J2000TOJ1950 = 1577836800;
    public static final int J1970TOJ2000 = -946684800;
    public static final int J2000TOJ1970 = 946684800;
    public static final double MJDTOJD = 2433282.5;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int SECONDS_PER_WEEK = 604800;
    public static final int SECONDS_PER_MONTH = 2678400;
    public static final int SECONDS_PER_YEAR = 31536000;
    public static final int SECONDS_PER_LEAP_YEAR = 31622400;
    public static final double MAX_INPUT_WSEC = 1.855425871008E14;
    private static final String YMD_REGEX = "[0-9]{4}[:-](([0][1-9])|([1][0-2])|[1-9])[:-](([0][1-9])|([1-2][0-9])|([3][0-1])|[1-9])";
    private static final String HMS_REGEX = "(([0-1][0-9])|([2][0-3])|[0-9]):(([0-5][0-9])|[0-9]):(([0-5][0-9])|(60)|[0-9])(\\.[0-9]*+)?";
    public static final Pattern STD_FORMAT_PATTERN;
    private static final int YMDHMS_LEN = 14;
    private static final int YMDHMS_YEAR = 0;
    private static final int YMDHMS_MON = 1;
    private static final int YMDHMS_DAY = 2;
    private static final int YMDHMS_HOUR = 3;
    private static final int YMDHMS_MIN = 4;
    private static final int YMDHMS_SEC = 5;
    private static final int YMDHMS_SOY = 6;
    private static final int YMDHMS_DOY = 7;
    private static final int YMDHMS_SOD = 8;
    private static final int YMDHMS_SECW = 9;
    private static final int YMDHMS_SECF = 10;
    private static final int YMDHMS_FOD = 11;
    private static final int YMDHMS_SOYW = 12;
    private static final int YMDHMS_SOYF = 13;
    private static final TimeZone UTC_TIMEZONE;
    private static DatatypeFactory DATATYPE_FACTORY;
    private double wsec;
    private double fsec;

    public Time() {
        this.wsec = 0.0;
        this.fsec = 0.0;
    }

    public Time(double seconds) {
        if (seconds > 1.855425871008E14) {
            Shell.warning("Invalid input time of " + seconds + " seconds. Max supported input value is " + 1.855425871008E14);
        }
        this.fromJ1950(seconds);
    }

    public Time(double wsec, double fsec) {
        if (wsec > 1.855425871008E14) {
            Shell.warning("Invalid input time of " + wsec + " wsec. Max supported input value is " + 1.855425871008E14);
        }
        this.fromJ1950(wsec, fsec);
    }

    public Time(Time time) {
        this.wsec = time.wsec;
        this.fsec = time.fsec;
        if (this.wsec > 1.855425871008E14) {
            Shell.warning("Invalid input Time of " + this.wsec + ". Max supported input value is " + 1.855425871008E14);
        }
    }

    public Time(String str) {
        this(str, 1);
    }

    public Time(String str, int fmt) {
        this.fromString(str, fmt);
    }

    public Time(long timeTicks, Time timeEpoch, double timeDelta) {
        this(timeEpoch);
        double _wsec = Math.floor((double)timeTicks * timeDelta);
        long fsecTicks = timeTicks - (long)_wsec * Time.ticksPerSecond(timeDelta);
        double _fsec = (double)fsecTicks * timeDelta;
        this.addTime(_wsec, _fsec);
    }

    public Time(String str, String simpleDateFmt) {
        this.fromString(str, simpleDateFmt);
    }

    public long toTimeTicks(Time timeEpoch, double timeDelta) {
        long ticksPerSecond = Time.ticksPerSecond(timeDelta);
        long wTicks = (long)(this.wsec - timeEpoch.wsec) * ticksPerSecond;
        long fTicks = Math.round((this.fsec - timeEpoch.fsec) * (double)ticksPerSecond);
        return wTicks + fTicks;
    }

    public static long toTimeTicks(double sec, Time timeEpoch, double timeDelta) {
        double tdiff = sec - timeEpoch.getSec();
        return (long)(tdiff / timeDelta);
    }

    public final String toString() {
        return Time.toStringBuffer(null, this.wsec, this.fsec, 1, -1).toString();
    }

    public final String toString(int dp) {
        return Time.toStringBuffer(null, this.wsec, this.fsec, 1, dp).toString();
    }

    public final String toString(int fmt, int dp) {
        return Time.toStringBuffer(null, this.wsec, this.fsec, fmt, dp).toString();
    }

    public final String toString(String fmtStr, int dp) {
        int fmt = Parser.find(formatList, fmtStr, -1, 0, 1);
        return Time.toStringBuffer(null, this.wsec, this.fsec, fmt, dp).toString();
    }

    public final String toString(String enhancedSimpleDateFormat) {
        if (enhancedSimpleDateFormat.contains("SSSS")) {
            enhancedSimpleDateFormat = this.createHighPrecisionSimpleDateFormat(enhancedSimpleDateFormat);
        }
        return MFormat.getDateFormatFor(enhancedSimpleDateFormat).format(this.wsec + this.fsec);
    }

    public String createHighPrecisionSimpleDateFormat(String enhancedSimpleDateFormat) {
        if (enhancedSimpleDateFormat == null) {
            return null;
        }
        int fracSecLocation = enhancedSimpleDateFormat.indexOf("SSSS");
        int formatStringLength = enhancedSimpleDateFormat.length();
        while (fracSecLocation >= 0) {
            int numFracSec = 4;
            for (int nextCharCheck = fracSecLocation + numFracSec; nextCharCheck < formatStringLength && enhancedSimpleDateFormat.charAt(nextCharCheck) == 'S'; ++nextCharCheck) {
                ++numFracSec;
            }
            String precisionFSecAsString = this.getPrecisionFSecAsString(numFracSec);
            enhancedSimpleDateFormat = enhancedSimpleDateFormat.substring(0, fracSecLocation) + "'" + precisionFSecAsString + "'" + enhancedSimpleDateFormat.substring(fracSecLocation + numFracSec);
            fracSecLocation = enhancedSimpleDateFormat.indexOf("SSSS");
        }
        return enhancedSimpleDateFormat;
    }

    private String getPrecisionFSecAsString(int numDigitsSpecified) {
        long precisionMultiplier;
        int numDigitsInString = Math.min(numDigitsSpecified, 15);
        long toForceZeroPadding = precisionMultiplier = (long)Time.getPrecisionMult(numDigitsInString);
        Long fSecStringPlusForceZeroFactor = (long)(this.fsec * (double)precisionMultiplier) + toForceZeroPadding;
        String precisionFSecAsString = fSecStringPlusForceZeroFactor.toString().substring(1);
        return precisionFSecAsString;
    }

    private static StringBuffer toStringBuffer(StringBuffer buf, double wsec, double fsec, int fmt, int dp) {
        if (buf == null) {
            buf = new StringBuffer(32);
        }
        if (dp < 0) {
            dp = 3;
        }
        if (wsec < 0.0) {
            buf.append('-');
            wsec = -wsec - 1.0;
            fsec = 1.0 - fsec;
        }
        if (fsec >= 1.0) {
            wsec += 1.0;
            fsec -= 1.0;
        }
        if (fsec < 0.0) {
            wsec -= 1.0;
            fsec += 1.0;
        }
        if (wsec > 1.855425871008E14) {
            throw new IllegalArgumentException("Invalid input date.  Input date of " + wsec + " is beyond the max value of " + 1.855425871008E14);
        }
        int day = (int)(wsec / 86400.0);
        boolean date = day > 365 || wsec < 0.0;
        double[] ymdhms = Time.toYMDHMS(null, wsec, fsec, dp, fmt);
        switch (fmt) {
            case 1: {
                if (date) {
                    Time.getYMD(buf, ymdhms, fmt).append(':').append(':');
                } else if (wsec > 86400.0) {
                    buf.append(day).append(':').append(':');
                }
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 10: {
                Time.getYMD(buf, ymdhms, fmt).append('T');
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 7: {
                Time.getYMD(buf, ymdhms, fmt).append('_');
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 9: {
                Time.getYMD(buf, ymdhms, fmt);
                break;
            }
            case 8: {
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 6: {
                if (date) {
                    Time.getYMD(buf, ymdhms, fmt).append(':');
                } else if (wsec > 86400.0) {
                    buf.append(day).append('-');
                }
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 2: {
                if (date) {
                    Time.getYYDDD(buf, ymdhms, fmt).append(':');
                } else if (wsec > 86400.0) {
                    buf.append(day).append(':');
                }
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 3: {
                int year = (int)ymdhms[0];
                String wsoy = Long.toString((long)ymdhms[12]);
                String fsoy = Long.toString((long)ymdhms[13]);
                if (date) {
                    buf.append(year).append(':');
                    buf.append(wsoy);
                } else {
                    buf.append((int)wsec);
                }
                if (dp == 0) break;
                buf.append('.');
                for (int i = fsoy.length(); i < dp; ++i) {
                    buf.append('0');
                }
                buf.append(fsoy);
                break;
            }
            case 4: {
                String fod = Long.toString((long)ymdhms[11]);
                Time.getYYDDD(buf, ymdhms, fmt).append('.');
                for (int i = fod.length(); i < 8; ++i) {
                    buf.append('0');
                }
                buf.append(fod);
                break;
            }
            case 5: {
                Time.getYYDDD(buf, ymdhms, fmt).append(':');
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 11: {
                Time.getYMD(buf, ymdhms, fmt).append(':').append(':');
                Time.getHMS(buf, ymdhms, dp, fmt);
                break;
            }
            case 12: {
                if (!date) break;
                Time.getYYDDD(buf, ymdhms, fmt);
                break;
            }
            case 13: {
                Time.getHMS(buf, ymdhms, 0, fmt);
                break;
            }
            default: {
                throw new MidasException("Time: Unknown time format fmt=" + fmt + ".");
            }
        }
        return buf;
    }

    private static StringBuffer getYMD(StringBuffer buf, double[] ymdhms, int fmt) {
        int y = (int)ymdhms[0];
        int m = (int)ymdhms[1];
        int d = (int)ymdhms[2];
        if (fmt == 7) {
            buf.append(y).append(m / 10).append(m % 10).append(d / 10).append(d % 10);
        } else if (fmt == 6) {
            String mStr = Parser.get(monthList, m);
            buf.append(d / 10).append(d % 10).append('-').append(mStr).append('-').append(y);
        } else if (fmt == 10) {
            buf.append(y).append('-').append(m / 10).append(m % 10).append('-').append(d / 10).append(d % 10);
        } else {
            buf.append(y).append(':').append(m / 10).append(m % 10).append(':').append(d / 10).append(d % 10);
        }
        return buf;
    }

    private static StringBuffer getYYDDD(StringBuffer buf, double[] ymdhms, int fmt) {
        int year = (int)ymdhms[0];
        int yr = year % 100;
        int doy = (int)ymdhms[7];
        if (fmt == 2) {
            buf.append(yr / 10).append(yr % 10).append('.').append(doy);
        } else if (fmt == 12) {
            buf.append(yr / 10).append(yr % 10).append('.').append(doy / 100).append(doy % 100 / 10).append(doy % 10);
        } else if (fmt == 4) {
            buf.append(yr / 10).append(yr % 10).append(doy / 100).append(doy % 100 / 10).append(doy % 10);
        } else {
            buf.append(doy);
        }
        return buf;
    }

    private static StringBuffer getHMS(StringBuffer buf, double[] ymdhms, int dp, int fmt) {
        int i;
        int h = (int)ymdhms[3];
        int m = (int)ymdhms[4];
        String wStr = Long.toString((long)ymdhms[9]);
        String fStr = Long.toString((long)ymdhms[10]);
        boolean dot = fmt != 7 && dp != 0;
        int wp = 2;
        if (fmt == 7) {
            buf.append(h / 10).append(h % 10);
            buf.append(m / 10).append(m % 10);
        } else {
            buf.append(h / 10).append(h % 10).append(':');
            buf.append(m / 10).append(m % 10).append(':');
        }
        if (wp != 0) {
            for (i = wStr.length(); i < wp; ++i) {
                buf.append('0');
            }
            buf.append(wStr);
        }
        if (dot) {
            buf.append('.');
        }
        if (fStr.length() > dp) {
            fStr = fStr.substring(0, dp);
        }
        for (i = fStr.length(); i < dp; ++i) {
            buf.append('0');
        }
        buf.append(fStr);
        if (fmt == 10) {
            buf.append('Z');
        }
        return buf;
    }

    private static double[] toYMDHMS(double[] ymdhms, double wsec, double fsec, int dp, int fmt) {
        int m;
        if (ymdhms == null) {
            ymdhms = new double[14];
        }
        int yr = Time.getYear(wsec);
        boolean leap = Time.isLeapYear(yr);
        double sodx = wsec % 86400.0;
        double sod = sodx + fsec;
        double soyx = wsec - 86400.0 * (double)Time.ymd2mjd(yr, 1, 1);
        double doy = (int)(soyx / 86400.0) + 1;
        double mult = Time.getPrecisionMult(dp);
        double secx = sodx % 60.0;
        int n = m = leap ? 23 : 11;
        while ((double)dim[m] >= doy) {
            --m;
        }
        boolean sp24 = wsec == 86400.0 && fsec == 0.0 && fmt != 5 && fmt != 7 && fmt != 11 && fmt != 10;
        ymdhms[0] = yr;
        ymdhms[1] = m <= 11 ? (double)(m + 1) : (double)(m - 11);
        ymdhms[2] = doy - (double)dim[m];
        ymdhms[3] = sp24 ? 24.0 : (double)((int)(sodx / 3600.0));
        ymdhms[4] = (int)(sodx % 3600.0 / 60.0);
        ymdhms[5] = (int)secx;
        ymdhms[6] = soyx + fsec;
        ymdhms[7] = doy;
        ymdhms[8] = sod;
        ymdhms[9] = Double.NaN;
        ymdhms[10] = Double.NaN;
        ymdhms[11] = Double.NaN;
        ymdhms[12] = Double.NaN;
        ymdhms[13] = Double.NaN;
        if (fmt != 0) {
            if (fmt == 4) {
                long fod = Math.round(sod / 86400.0 * 1.0E8);
                if ((double)fod >= 1.0E8) {
                    return Time.toYMDHMS(ymdhms, wsec + 1.0, 0.0, dp, fmt);
                }
                ymdhms[11] = fod;
            } else {
                long fract = Math.round(fsec * mult);
                if ((double)fract >= mult) {
                    return Time.toYMDHMS(ymdhms, wsec + 1.0, 0.0, dp, fmt);
                }
                if (fmt == 3) {
                    ymdhms[12] = soyx;
                    ymdhms[13] = fract;
                } else {
                    ymdhms[9] = secx;
                    ymdhms[10] = fract;
                }
            }
        }
        return ymdhms;
    }

    public String toFileName() {
        return Time.format(this.wsec, this.fsec, 7, 0);
    }

    public static double roundToMicro(double fsec) {
        double fsec6 = fsec * 1000000.0;
        double fsec6r = Math.round(fsec6);
        return fsec6r / 1000000.0;
    }

    public void fromJ1950(double sec) {
        this.wsec = Math.floor(sec);
        this.fsec = 0.0;
        this.addTime(0.0, Time.roundToMicro(sec - this.wsec));
    }

    public void fromJ1950(double wsec, double fsec) {
        double wwsec = Math.floor(wsec);
        double fwsec = wsec - wwsec;
        double wfsec = Math.floor(fsec);
        double ffsec = fsec - wfsec;
        wsec = wwsec + wfsec;
        fsec = fwsec + ffsec;
        if (fsec >= 1.0) {
            wsec += 1.0;
            fsec -= 1.0;
        }
        this.wsec = wsec;
        this.fsec = fsec;
    }

    @InternalUseOnly(value="Since added")
    Time fromJ1950x(double wsec, double fsec) {
        assert (wsec == Math.floor(wsec)) : "wsec [" + wsec + "] MUST not contain any fractional seconds";
        assert (fsec == Math.floor(fsec)) : "fsec [" + fsec + "] MUST not contain any whole seconds";
        this.wsec = wsec;
        this.fsec = fsec;
        return this;
    }

    public double toJ1950() {
        return this.wsec + this.fsec;
    }

    public static double toJ1970(double sec) {
        return sec + -6.31152E8;
    }

    public double toJ1970() {
        return this.wsec - 6.31152E8 + this.fsec;
    }

    public void fromJ1970(double sec) {
        this.fromJ1950(sec + 6.31152E8);
    }

    public void fromJ1970ms(long ms) {
        double j1970sec = 0.001 * (double)ms;
        this.wsec = (long)j1970sec + 631152000L;
        this.fsec = j1970sec - (double)((long)j1970sec);
    }

    public void fromJ2000(double sec) {
        this.fromJ1950(sec + 1.5778368E9);
    }

    public void fromCurrent() {
        this.fromJ1950(Time.current());
    }

    public void fromTimeCode(DataFile hcb) {
        this.fromTime(hcb.getTime());
    }

    public void fromAcqDate(DataFile hcb) {
        Object tDate = hcb.getKeywordsObject().get("ACQDATE");
        Object tTime = hcb.getKeywordsObject().get("ACQTIME");
        if (tDate == null || tTime == null) {
            Shell.warning("Unable to set time from ACQDATE + ACQTIME with ACQDATE=" + tDate + " and ACQTIME=" + tTime);
            return;
        }
        Time acqDate = new Time(tDate.toString(), 12);
        Time acqTime = new Time(tTime.toString(), 13);
        this.fromTime(acqDate.addTime(acqTime));
    }

    public void fromQuadwords(DataFile hcb) {
        double year = hcb.getQuadword(9);
        double soy = hcb.getQuadword(10);
        this.fromQuadwords(year, soy);
    }

    private void fromQuadwords(double year, double soy) {
        int yr = (int)year;
        this.wsec = Math.floor(soy);
        this.fsec = soy - this.wsec;
        this.wsec += (double)(86400 * Time.ymd2mjd(yr, 1, 1));
    }

    static void checkQuadwords(Midas M, DataFile hcb) {
        double TOL = 1.0E-4;
        double year = hcb.getQuadword(9);
        double soy = hcb.getQuadword(10);
        double gha = hcb.getQuadword(11);
        if (year == 0.0 && soy == 0.0) {
            return;
        }
        Time t = new Time();
        t.fromQuadwords(year, soy);
        double diff = t.getGHA() - gha;
        if (diff > 1.0E-4 || diff < -1.0E-4) {
            M.warning("DataFile: " + hcb.getName() + " appears to have incorrect GHA in quadwords, due to a bug in NeXtMidas 2.6.0 and earlier. This can be fixed by running 'TIMEX " + t + " QUAD=" + hcb.getName() + "'.");
        }
    }

    public final void fromString(String str) {
        this.fromString(str, 1);
    }

    public Time fromTime(Time time) {
        if (time == null) {
            return null;
        }
        if (time.wsec >= 1.855425871008E14) {
            Shell.warning("Invalid input from Time of " + time.wsec + ". Max supported input value is " + 1.855425871008E14);
        }
        this.wsec = time.wsec;
        this.fsec = time.fsec;
        return this;
    }

    public static double parseTime(String str) {
        return new Time(str).getSec();
    }

    public static double parseTime(String str, int fmt) {
        return new Time(str, fmt).getSec();
    }

    private static Time parseTime(MFormat fmt, String str) {
        try {
            Time t = Time.toTime(fmt.parseObject(str));
            if (t == null) {
                throw new MidasException("Unable to parse '" + str + "' using " + fmt + ".");
            }
            return t;
        }
        catch (ParseException e) {
            throw new MidasException("Unable to parse '" + str + "': " + e.getMessage(), e);
        }
    }

    public void toTimeCode(DataFile hcb) {
        hcb.setTime(this.wsec, this.fsec);
    }

    public void toAcqDate(DataFile hcb) {
        hcb.getKeywordsObject().put("ACQDATE", this.toString(12, 0));
        hcb.getKeywordsObject().put("ACQTIME", this.toString(13, 0));
    }

    public static Time toTime(Object obj) {
        return Time.toTime(obj, 1);
    }

    public static Time toTime(Object obj, int fmt) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof Calendar) {
            return new Time(Time.fromCalendar((Calendar)obj));
        }
        if (obj instanceof XMLGregorianCalendar) {
            return new Time(Time.fromXMLGregorianCalendar((XMLGregorianCalendar)obj));
        }
        if (obj instanceof Date) {
            return new Time(Time.fromDateObject((Date)obj));
        }
        if (obj instanceof Number) {
            return new Time(((Number)obj).doubleValue());
        }
        if (obj instanceof Data && ((Data)obj).isString()) {
            obj = obj.toString();
        }
        if (!(obj instanceof Data)) {
            String str = Convert.o2s(obj);
            if (fmt != 10 && StringUtil.isNumber(str)) {
                return new Time(Convert.s2d(str));
            }
            if (str.startsWith("(") && str.endsWith(")")) {
                try {
                    obj = Convert.o2o((Object)str, "CD", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            if (data.mode == 83 || data.mode == 49) {
                return new Time(data.toD());
            }
            if (data.mode == 67 || data.mode == 50) {
                double[] vals = new double[2];
                data.toArray(vals);
                return new Time(vals[0], vals[1]);
            }
            Shell.deprecate("Since NeXtMidas 2.7.0: Conversion of data format " + data.getFormat() + " to Time is deprecated.");
            return new Time(Convert.o2d(obj));
        }
        return new Time(obj.toString(), fmt);
    }

    public Date toDateObject() {
        return Time.toDateObject(this.wsec + this.fsec);
    }

    public static Date toDateObject(double sec) {
        long ms = (long)(sec * 1000.0) - 631152000000L;
        return new Date(ms);
    }

    public static double fromDateObject(Date date) {
        return (double)date.getTime() / 1000.0 + 6.31152E8;
    }

    public GregorianCalendar toCalendar() {
        GregorianCalendar cal = new GregorianCalendar(UTC_TIMEZONE);
        cal.setTime(this.toDateObject());
        return cal;
    }

    public static Time fromCalendar(Calendar cal) {
        return new Time(Time.fromDateObject(cal.getTime()));
    }

    public XMLGregorianCalendar toXMLGregorianCalendar() {
        if (DATATYPE_FACTORY == null) {
            try {
                DATATYPE_FACTORY = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new RuntimeException("Could not create new DatatypeFactory", e);
            }
        }
        GregorianCalendar cal = this.toCalendar();
        return DATATYPE_FACTORY.newXMLGregorianCalendar(cal);
    }

    public static Time fromXMLGregorianCalendar(XMLGregorianCalendar cal) {
        return Time.fromCalendar(cal.toGregorianCalendar());
    }

    public void toQuadwords(DataFile hcb) {
        hcb.setQuadword(9, this.getYear());
        hcb.setQuadword(10, this.getSoY());
        hcb.setQuadword(11, this.getGHA());
    }

    public int getMJD() {
        return (int)(this.wsec / 86400.0);
    }

    public int getYear() {
        return Time.getYear(this.wsec);
    }

    private static int getYear(double wsec) {
        int days = (int)(wsec / 86400.0);
        return (int)(((double)days + 712237.5) / 365.25 + 0.002);
    }

    public int getMonth() {
        int mon = this.getMonthIndex() + 1;
        return mon <= 12 ? mon : mon - 12;
    }

    public final String getMonthName() {
        return Parser.get(monthNameList, this.getMonth());
    }

    public final String getMonthTrigraph() {
        return Parser.get(monthList, this.getMonth());
    }

    public int getDay() {
        return this.getDoY() - dim[this.getMonthIndex()] + 1;
    }

    public int getDayOfWeek() {
        int dow = (this.getMJD() + 1) % 7;
        return dow == 0 ? 7 : dow;
    }

    private static int getDayOfWeek(int year, int mon, int day) {
        int dow = (Time.ymd2mjd(year, mon, day) + 1) % 7;
        return dow == 0 ? 7 : dow;
    }

    public String getDayOfWeekName() {
        return Parser.get(dayNameList, this.getDayOfWeek());
    }

    public String getDayOfWeekTrigraph() {
        return Parser.get(dayList, this.getDayOfWeek());
    }

    private int getMonthIndex() {
        int mon;
        int doy = this.getDoY();
        int n = mon = this.isLeapYear() ? 23 : 11;
        while (dim[mon] > doy) {
            --mon;
        }
        return mon;
    }

    public int getHour() {
        return (int)(this.getSoD() / 3600.0);
    }

    public int getMinute() {
        return (int)(this.getSoD() % 3600.0 / 60.0);
    }

    public int getSecond() {
        return (int)(this.getSoD() % 60.0);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public boolean isLeapYear() {
        return Time.isLeapYear(this.getYear());
    }

    private static int getCurrentYear() {
        double wsec = Math.floor(Time.current());
        return Time.getYear(wsec);
    }

    public int getDoY() {
        return (int)(this.getSoY() / 86400.0);
    }

    public double getMJS() {
        return this.toJ1950();
    }

    public double getSoY() {
        double wsecInYear = this.wsec - 86400.0 * (double)Time.ymd2mjd(this.getYear(), 1, 1);
        double truncFSec = (double)((long)(this.fsec * 1.0E8)) / 1.0E8;
        return wsecInYear + truncFSec;
    }

    public double getSoD() {
        return this.wsec % 86400.0 + (double)((long)(this.fsec * 1.0E10)) / 1.0E10;
    }

    public double getFoD() {
        return this.getSoD() / 86400.0;
    }

    public double getGHA() {
        return Time.RAGW(this.getSec() / 86400.0);
    }

    public double getJD() {
        return (double)this.getMJD() + 2433282.5;
    }

    public double getYiS() {
        return 86400.0 * (double)Time.ymd2mjd(this.getYear(), 1, 1);
    }

    public double getWSec() {
        return this.wsec;
    }

    public double getFSec() {
        return this.fsec;
    }

    public double getSec() {
        return this.wsec + this.fsec;
    }

    public void floor(double resolution) {
        this.wsec = resolution * Math.floor(this.wsec / resolution);
        this.fsec = resolution > 1.0 ? 0.0 : resolution * Math.floor(this.fsec / resolution);
    }

    public void modulo(double resolution) {
        this.wsec -= resolution * Math.floor(this.wsec / resolution);
    }

    public void round(double resolution) {
        double sec = this.wsec + this.fsec;
        sec = resolution * (double)Math.round(sec / resolution);
        this.fromJ1950(sec);
    }

    public double diff(Time time) {
        double diff = this.wsec - time.wsec;
        return diff + (this.fsec - time.fsec);
    }

    public Time addSec(double sec) {
        double _wsec = Math.rint(sec);
        double _fsec = sec - _wsec;
        return this.addTime(_wsec, _fsec);
    }

    public Time addTime(Time t) {
        return this.addTime(t.wsec, t.fsec);
    }

    private Time addTime(double _wsec, double _fsec) {
        this.wsec += _wsec;
        this.fsec += _fsec;
        if (this.fsec < 0.0 || this.fsec >= 1.0) {
            double sec = Math.floor(this.fsec);
            this.wsec += sec;
            this.fsec -= sec;
        }
        return this;
    }

    public static void pause(double sec) {
        long start = System.currentTimeMillis();
        long end = start + (long)(sec * 1000.0);
        long now = start;
        while (now < end) {
            try {
                Thread.sleep(end - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
    }

    public static void sleep(double seconds) {
        try {
            int msec = (int)(seconds * 1000.0);
            if (msec > 10) {
                Thread.sleep(msec);
            } else {
                Thread.sleep(msec, (int)((seconds * 1000.0 - (double)msec) * 1000000.0));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void usleep(int usec) {
        int msec = usec / 1000;
        int nsec = (usec - msec * 1000) * 1000;
        try {
            Thread.sleep(msec, nsec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static double current() {
        double time = 0.001 * (double)System.currentTimeMillis();
        return time + 6.31152E8;
    }

    public static Time currentTime() {
        return new Time(Time.current());
    }

    public static String toString(double time) {
        return Time.format(time, 1, 0);
    }

    public static String toString(double time, int fmt) {
        return Time.format(time, fmt, -1);
    }

    public static String toString(double time, int fmt, int dp) {
        return Time.format(time, fmt, dp);
    }

    public static String toString(double time, String format, int dp) {
        int fmt = Parser.find(formatList, format, -1, 0, 1);
        return Time.format(time, fmt, dp);
    }

    public static String tag() {
        double tag = Time.current();
        if (tag - lastTag > 0.1) {
            Time.setTag(tag);
        }
        return strTag;
    }

    public static synchronized void setTag(double tag) {
        strTag = Time.format(tag, 1, 1);
        lastTag = tag;
    }

    private static double getPrecisionMult(int dp) {
        switch (dp) {
            case 3: {
                return 1000.0;
            }
            case 6: {
                return 1000000.0;
            }
            case 9: {
                return 1.0E9;
            }
            case 12: {
                return 1.0E12;
            }
            case 0: {
                return 1.0;
            }
            case 1: {
                return 10.0;
            }
            case 2: {
                return 100.0;
            }
            case 4: {
                return 10000.0;
            }
            case 5: {
                return 100000.0;
            }
            case 7: {
                return 1.0E7;
            }
            case 8: {
                return 1.0E8;
            }
            case 10: {
                return 1.0E10;
            }
            case 11: {
                return 1.0E11;
            }
            case 15: {
                return 1.0E15;
            }
        }
        return Math.pow(10.0, dp);
    }

    static int getDecimalPrecision(double secs) {
        if (secs > 3.16224E7) {
            return 6;
        }
        if (secs == 0.0) {
            return 3;
        }
        if (secs <= 3600.0) {
            return 12;
        }
        if (secs > 2678400.0) {
            return 8;
        }
        if (secs > 604800.0) {
            return 9;
        }
        if (secs > 3600.0) {
            return 10;
        }
        return 3;
    }

    public static String format(double time) {
        return Time.format(time, 1, 0);
    }

    public static String format(double time, int format) {
        return Time.format(time, format, -1);
    }

    public static String format(double time, int fmt, int dp) {
        double sec = time + 5.0E-7;
        double wsec = Math.floor(sec);
        double fsec = 1.0E-6 * Math.floor(1000000.0 * (sec - wsec));
        return Time.toStringBuffer(null, wsec, fsec, fmt, dp).toString();
    }

    public static String format(double wsec, double fsec, int fmt, int dp) {
        return Time.toStringBuffer(null, wsec, fsec, fmt, dp).toString();
    }

    public static int format(double wsec, double fsec, StringBuffer sbuf, int fmt, int dp) {
        return Time.toStringBuffer(sbuf, wsec, fsec, fmt, dp).length();
    }

    public static String getFormat(int fmt) {
        return Parser.get(formatList, fmt);
    }

    public static double tod2sec(String str) {
        return new Time(str).getSec();
    }

    public static double tod2sec(byte[] buffer, int i1, int i2) {
        return Time.tod2sec(Convert.unpackS(buffer, i1, i2 - i1));
    }

    public static Time parse(String str) {
        return new Time(str);
    }

    public static Time parse(byte[] buffer, int i1, int i2) {
        return Time.parse(Convert.unpackS(buffer, i1, i2 - i1));
    }

    public void fromBytes(byte[] buffer, int i1, int i2) {
        this.fromString(Convert.unpackS(buffer, i1, i2 - i1), 1);
    }

    private static double parseTimeZone(String str) {
        if (str.charAt(0) == '-') {
            switch (str.length()) {
                case 3: {
                    return -(Integer.parseInt(str.substring(1)) * 3600);
                }
                case 5: {
                    return -(Integer.parseInt(str.substring(1, 3)) * 3600 + Integer.parseInt(str.substring(3)) * 60);
                }
                case 6: {
                    return -(Integer.parseInt(str.substring(1, 3)) * 3600 + Integer.parseInt(str.substring(4)) * 60);
                }
            }
        } else if (str.charAt(0) == '+') {
            switch (str.length()) {
                case 3: {
                    return Integer.parseInt(str.substring(1)) * 3600;
                }
                case 5: {
                    return Integer.parseInt(str.substring(1, 3)) * 3600 + Integer.parseInt(str.substring(3)) * 60;
                }
                case 6: {
                    return Integer.parseInt(str.substring(1, 3)) * 3600 + Integer.parseInt(str.substring(4)) * 60;
                }
            }
        }
        throw new MidasException("Invalid timezone specifier '" + str + "'");
    }

    private static int parseYearWeekDay(int year, String str) {
        int correction;
        int dow;
        int week;
        switch (str.length()) {
            case 7: {
                week = Integer.parseInt(str.substring(5));
                dow = 1;
                break;
            }
            case 8: {
                if (str.charAt(4) == 'W') {
                    week = Integer.parseInt(str.substring(5, 7));
                    dow = Integer.parseInt(str.substring(7));
                    break;
                }
                week = Integer.parseInt(str.substring(6));
                dow = 1;
                break;
            }
            case 10: {
                week = Integer.parseInt(str.substring(6, 8));
                dow = Integer.parseInt(str.substring(9));
                break;
            }
            default: {
                throw new MidasException("Invalid date specifier '" + str + "'");
            }
        }
        switch (Time.getDayOfWeek(year, 1, 1)) {
            case 1: {
                correction = -6;
                break;
            }
            case 2: {
                correction = -7;
                break;
            }
            case 3: {
                correction = -8;
                break;
            }
            case 4: {
                correction = -9;
                break;
            }
            case 5: {
                correction = -10;
                break;
            }
            case 6: {
                correction = -4;
                break;
            }
            case 7: {
                correction = -5;
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid day of week");
            }
        }
        return week * 7 + dow + correction;
    }

    public void fromString(String str, String simpleDateFmt) {
        MFormat inFormat = null;
        this.wsec = 0.0;
        this.fsec = 0.0;
        double strippedFSec = 0.0;
        if (str == null) {
            return;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        str = str.trim();
        if (simpleDateFmt != null) {
            int indexHighPrecFSec = simpleDateFmt.indexOf("SSSS");
            if (indexHighPrecFSec >= 0) {
                int indexBeyondFSec = this.getIndexBeyondFSec(simpleDateFmt, indexHighPrecFSec);
                int numSSSS = indexBeyondFSec - indexHighPrecFSec;
                int strStartSSSS = indexHighPrecFSec;
                int strBeyondSSSS = indexBeyondFSec;
                if (indexBeyondFSec == simpleDateFmt.length()) {
                    strBeyondSSSS = str.length();
                    strStartSSSS = strBeyondSSSS - numSSSS;
                } else {
                    int firstDot = str.indexOf(46);
                    if (firstDot >= indexHighPrecFSec && firstDot == str.lastIndexOf(46)) {
                        strStartSSSS = firstDot + 1;
                        strBeyondSSSS = strStartSSSS + numSSSS;
                    }
                }
                String fSecSubstring = str.substring(strStartSSSS, strBeyondSSSS);
                if (fSecSubstring.matches("[0-9]+")) {
                    strippedFSec = Double.valueOf("0." + fSecSubstring);
                    simpleDateFmt = simpleDateFmt.substring(0, indexHighPrecFSec) + simpleDateFmt.substring(indexBeyondFSec);
                    str = str.substring(0, strStartSSSS) + str.substring(strBeyondSSSS);
                } else {
                    throw new IllegalArgumentException("input string " + str + " and/or SimpleDateFormat:" + simpleDateFmt + " not supported");
                }
            }
            inFormat = MFormat.getDateFormatFor(simpleDateFmt);
        }
        if (inFormat == null) {
            this.fromString(str, 1);
        } else {
            this.fromTime(Time.parseTime(inFormat, str));
            this.addSec(strippedFSec);
        }
    }

    private int getIndexBeyondFSec(String inputFormat, int indexOfFracSec) {
        int nextCharCheck;
        int formatStringLength = inputFormat.length();
        for (nextCharCheck = indexOfFracSec + 4; nextCharCheck < formatStringLength && inputFormat.charAt(nextCharCheck) == 'S'; ++nextCharCheck) {
        }
        return nextCharCheck;
    }

    public void fromString(String str, int fmt) {
        boolean isACQorACQDATE = fmt == 12 || fmt == 2;
        this.wsec = 0.0;
        this.fsec = 0.0;
        if (str == null) {
            return;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
        }
        str = str.trim();
        if ((fmt == 1 || fmt == 11) && str.startsWith("T:")) {
            str = str.substring(2);
        }
        if ((fmt == 1 || fmt == 11) && StringUtil.isNumber(str)) {
            this.fromJ1950(Convert.o2d(str));
            return;
        }
        if ((fmt == 1 || fmt == 11) && (str.indexOf(84) > 0 || str.indexOf(90) > 0 || str.indexOf(45) > 0 && str.indexOf("::") < 0)) {
            fmt = 10;
        }
        char[] chars = str.toCharArray();
        int yrLen = 0;
        int year = 1950;
        int mon = 1;
        int day = 1;
        int doy = 1;
        boolean neg = chars[0] == '-';
        int first = neg ? 1 : 0;
        boolean error = false;
        NumberFormatException causeOfError = null;
        if (fmt == 4) {
            try {
                double sec = (Double.parseDouble(str.substring(first + 2)) - 1.0) * 86400.0;
                year = (chars[first + 0] - 48) * 10 + (chars[first + 1] - 48);
                yrLen = 2;
                this.wsec = Math.floor(sec);
                this.fsec = sec - this.wsec;
            }
            catch (NumberFormatException nfe) {
                error = true;
                causeOfError = nfe;
            }
        } else if (fmt == 7) {
            int sep = str.indexOf(95);
            try {
                year = Integer.parseInt(str.substring(first, sep - 4));
                mon = Integer.parseInt(str.substring(sep - 4, sep - 2));
                day = Integer.parseInt(str.substring(sep - 2, sep));
                this.wsec = (double)Integer.parseInt(str.substring(sep + 1, sep + 3)) * 3600.0 + (double)Integer.parseInt(str.substring(sep + 3, sep + 5)) * 60.0 + (double)Integer.parseInt(str.substring(sep + 5, sep + 7));
                this.fsec = Double.parseDouble("0." + str.substring(sep + 7));
                if (this.fsec >= 1.0) {
                    this.wsec += 1.0;
                    this.fsec -= 1.0;
                }
            }
            catch (NumberFormatException nfe) {
                error = true;
                causeOfError = nfe;
            }
        } else if (fmt == 10) {
            String s = neg ? str.substring(1) : str;
            double tz = 0.0;
            int t = s.indexOf(84);
            int w = s.indexOf(87);
            int z = s.lastIndexOf(90);
            int dot = s.lastIndexOf(46);
            int comma = s.lastIndexOf(44);
            int dash = s.lastIndexOf(45);
            int plus = s.lastIndexOf(43);
            int colon = s.lastIndexOf(58);
            int len = s.length();
            int n = t = t > 0 ? t : s.indexOf(32);
            if (t < 0) {
                String prefix;
                String string = prefix = neg ? "-" : "";
                if (colon > 0 || dot > 0 || comma > 0 || z > 0) {
                    this.fromString(prefix + "1950-01-01T" + s, fmt);
                } else if (len == 8 || s.indexOf(45) != dash) {
                    this.fromString(prefix + s + "T00:00:00Z", fmt);
                } else {
                    this.fromString(prefix + "1950-01-01T" + s, fmt);
                }
                return;
            }
            yrLen = 4;
            try {
                if (w > 0) {
                    year = Integer.parseInt(s.substring(0, 4));
                    doy = Time.parseYearWeekDay(year, s.substring(0, t));
                } else if (t == 8) {
                    if (chars[first + 4] == '-') {
                        year = Integer.parseInt(s.substring(0, 4));
                        doy = Integer.parseInt(s.substring(5, t));
                    } else {
                        year = Integer.parseInt(s.substring(0, 4));
                        mon = Integer.parseInt(s.substring(4, 6));
                        day = Integer.parseInt(s.substring(6, t));
                    }
                } else if (t == 10) {
                    year = Integer.parseInt(s.substring(0, 4));
                    mon = Integer.parseInt(s.substring(5, 7));
                    day = Integer.parseInt(s.substring(8, t));
                } else {
                    error = true;
                }
                if (z == len - 1) {
                    tz = 0.0;
                    len = z;
                } else if (dash > t) {
                    tz = Time.parseTimeZone(s.substring(dash));
                    len = dash;
                } else if (plus > t) {
                    tz = Time.parseTimeZone(s.substring(plus));
                    len = plus;
                }
                if (dot > 0) {
                    this.fsec = Double.parseDouble("0" + s.substring(dot, len));
                    if (this.fsec >= 1.0) {
                        this.wsec += 1.0;
                        this.fsec -= 1.0;
                    }
                    len = dot;
                } else if (comma > 0) {
                    this.fsec = Double.parseDouble("0." + s.substring(comma + 1, len));
                    if (this.fsec >= 1.0) {
                        this.wsec += 1.0;
                        this.fsec -= 1.0;
                    }
                    len = comma;
                }
                switch (len - t) {
                    case 3: {
                        this.wsec += (double)(Integer.parseInt(s.substring(t + 1, t + 3)) * 3600) + tz;
                        break;
                    }
                    case 5: {
                        this.wsec += (double)(Integer.parseInt(s.substring(t + 1, t + 3)) * 3600 + Integer.parseInt(s.substring(t + 3, t + 5)) * 60) + tz;
                        break;
                    }
                    case 6: {
                        this.wsec += (double)(Integer.parseInt(s.substring(t + 1, t + 3)) * 3600 + Integer.parseInt(s.substring(t + 4, t + 6)) * 60) + tz;
                        break;
                    }
                    case 7: {
                        this.wsec += (double)(Integer.parseInt(s.substring(t + 1, t + 3)) * 3600 + Integer.parseInt(s.substring(t + 3, t + 5)) * 60 + Integer.parseInt(s.substring(t + 5, t + 7))) + tz;
                        break;
                    }
                    case 9: {
                        this.wsec += (double)(Integer.parseInt(s.substring(t + 1, t + 3)) * 3600 + Integer.parseInt(s.substring(t + 4, t + 6)) * 60 + Integer.parseInt(s.substring(t + 7, t + 9))) + tz;
                        break;
                    }
                    default: {
                        error = true;
                        break;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                error = true;
                causeOfError = nfe;
            }
        } else if (fmt == 13) {
            if (str.length() != 8 || str.charAt(2) != ':' || str.charAt(5) != ':') {
                error = true;
                causeOfError = new NumberFormatException("Time String length or placement of ':' is incorrect - format should be strict HH:mm:ss");
            } else {
                try {
                    this.wsec = (double)Integer.parseInt(str.substring(0, 2)) * 3600.0 + (double)Integer.parseInt(str.substring(3, 5)) * 60.0 + (double)Integer.parseInt(str.substring(6, 8));
                }
                catch (NumberFormatException nfe) {
                    error = true;
                    causeOfError = nfe;
                }
            }
        } else {
            int dot;
            int field = 1;
            int wmult = 1;
            int end = chars.length;
            int wval = 0;
            int firstColon = str.indexOf(58);
            if (isACQorACQDATE) {
                boolean endsWithColon = str.lastIndexOf(58) == end - 1;
                boolean isYYYYMMDDFormat = false;
                int afterDayLoc = firstColon;
                if (firstColon < 0 || endsWithColon || fmt == 12) {
                    if (endsWithColon) {
                        --end;
                    }
                    if (str.indexOf(46) < 0) {
                        afterDayLoc = end;
                        isYYYYMMDDFormat = true;
                    } else {
                        field = 4;
                    }
                } else if (firstColon < 4) {
                    if (firstColon == 0) {
                        ++first;
                    }
                } else {
                    int firstDot = str.indexOf(46);
                    if (firstDot < 0 || firstDot > firstColon) {
                        isYYYYMMDDFormat = true;
                    }
                }
                if (isYYYYMMDDFormat) {
                    day = Integer.parseInt(str.substring(afterDayLoc - 2, afterDayLoc));
                    mon = Integer.parseInt(str.substring(afterDayLoc - 4, afterDayLoc - 2));
                    year = Integer.parseInt(str.substring(first, afterDayLoc - 4));
                    yrLen = afterDayLoc - 4 - first;
                    first = afterDayLoc + 1;
                }
            }
            if ((dot = str.lastIndexOf(".")) > 4 || !isACQorACQDATE && dot > 0) {
                try {
                    this.fsec = Double.parseDouble("0" + str.substring(dot));
                    if (this.fsec >= 1.0) {
                        this.wsec += 1.0;
                        this.fsec -= 1.0;
                    }
                    end = dot;
                    if (fmt == 3 && firstColon < 0) {
                        String beforeDot = str.substring(0, dot);
                        if (!beforeDot.contains(":")) {
                            this.wsec += Double.valueOf(beforeDot).doubleValue();
                        }
                        end = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    error = true;
                    causeOfError = nfe;
                }
            }
            for (int start = end; start >= first; --start) {
                boolean sep;
                int c = start == first ? 32 : chars[start - 1];
                boolean bl = sep = c == 58 || c == 45;
                if (isACQorACQDATE && field != 1) {
                    boolean bl2 = sep = sep || c == 46;
                }
                if (sep || start == first) {
                    block12 : switch (fmt) {
                        case 1: 
                        case 11: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break;
                                }
                                case 2: {
                                    this.wsec += (double)(wval * 60);
                                    break;
                                }
                                case 3: {
                                    this.wsec += (double)(wval * 3600);
                                    break;
                                }
                                case 4: {
                                    if (end - start == 0) break block12;
                                    ++field;
                                }
                                case 5: {
                                    day = wval;
                                    break;
                                }
                                case 6: {
                                    mon = wval;
                                    break;
                                }
                                case 7: {
                                    year = wval;
                                    yrLen = end - start;
                                    break;
                                }
                                default: {
                                    error = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break block12;
                                }
                                case 2: {
                                    this.wsec += (double)(wval * 60);
                                    break block12;
                                }
                                case 3: {
                                    this.wsec += (double)(wval * 3600);
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        case 9: {
                            switch (field) {
                                case 1: {
                                    day = wval;
                                    break block12;
                                }
                                case 2: {
                                    mon = wval;
                                    break block12;
                                }
                                case 3: {
                                    year = wval;
                                    yrLen = end - start;
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        case 2: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break block12;
                                }
                                case 2: {
                                    this.wsec += (double)(wval * 60);
                                    break block12;
                                }
                                case 3: {
                                    this.wsec += (double)(wval * 3600);
                                    break block12;
                                }
                                case 4: {
                                    day = wval;
                                    break block12;
                                }
                                case 5: {
                                    year = wval;
                                    yrLen = end - start;
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        case 5: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break block12;
                                }
                                case 2: {
                                    this.wsec += (double)(wval * 60);
                                    break block12;
                                }
                                case 3: {
                                    this.wsec += (double)(wval * 3600);
                                    break block12;
                                }
                                case 4: {
                                    day = wval;
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        case 6: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break;
                                }
                                case 2: {
                                    this.wsec += (double)(wval * 60);
                                    break;
                                }
                                case 3: {
                                    this.wsec += (double)(wval * 3600);
                                    break;
                                }
                                case 4: {
                                    if (end - start == 0) break block12;
                                    ++field;
                                }
                                case 5: {
                                    year = wval;
                                    yrLen = end - start;
                                    break;
                                }
                                case 6: {
                                    mon = Parser.find(monthList, str.substring(start, end), -1);
                                    break;
                                }
                                case 7: {
                                    day = wval;
                                    break;
                                }
                                default: {
                                    error = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (field) {
                                case 1: {
                                    this.wsec += (double)wval;
                                    break block12;
                                }
                                case 2: {
                                    year = wval;
                                    yrLen = end - start;
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        case 12: {
                            switch (field) {
                                case 4: {
                                    day = wval;
                                    break block12;
                                }
                                case 5: {
                                    year = wval;
                                    yrLen = end - start;
                                    break block12;
                                }
                            }
                            error = true;
                            break;
                        }
                        default: {
                            error = true;
                        }
                    }
                    ++field;
                    end = start - 1;
                    wval = 0;
                    wmult = 1;
                    continue;
                }
                if (c >= 48 && c <= 57) {
                    wval += (c - 48) * wmult;
                    wmult *= 10;
                    continue;
                }
                if (field == 6 && fmt == 6) continue;
                error = true;
            }
            if (fmt == 1 && field == 6 || fmt == 2 && field == 5) {
                ++day;
            }
        }
        if (error) {
            throw new MidasException("Time: Illegal time expression: " + str + " (fmt=" + Parser.get(formatList, fmt) + ")\n", causeOfError);
        }
        if (fmt == 5) {
            year = Time.getCurrentYear();
        } else if (fmt == 8) {
            year = 1950;
        } else if (yrLen != 4 && yrLen == 2) {
            year += year < 50 ? 2000 : 1900;
            if (fmt != 4 && fmt != 2) {
                Shell.getSharedMidasContext().deprecate("Time: Use of 2-digit years for time is deprecated, given '" + str + "'.");
            }
        }
        this.wsec += (double)Time.ymd2mjd(year, mon, day) * 86400.0;
        this.wsec += (double)(doy - 1) * 86400.0;
        if (neg) {
            this.wsec = -this.wsec;
        }
    }

    public static int ymd2mjd(int year, int month, int day) {
        int ly = 0;
        if (Time.isLeapYear(year)) {
            ly = 12;
        }
        int ndy = day + dim[month - 1 + ly];
        int mjd = (year - 1950) * 365 + (year + 3) / 4 - 488 + (ndy - 1);
        return mjd;
    }

    @Deprecated
    public static double RAGW(double DS50) {
        double CR = 0.017202791524949017;
        double THGR70 = 1.73213060363866;
        double TPI = Math.PI * 2;
        double FK4R = 5.06494548928754E-15;
        double TS70 = DS50 - 7304.0;
        double DS70 = Math.floor(TS70);
        double RAGW = 1.73213060363866 + 0.017202791524949017 * DS70 + 6.300388098704535 * (TS70 - DS70) + TS70 * TS70 * 5.06494548928754E-15;
        if ((RAGW = Math.IEEEremainder(RAGW, Math.PI * 2)) < -Math.PI) {
            RAGW += Math.PI * 2;
        }
        if (RAGW > Math.PI) {
            RAGW -= Math.PI * 2;
        }
        return RAGW;
    }

    public boolean equals(Object obj) {
        Time t = Time.toTime(obj);
        return t != null && t.wsec == this.wsec && t.fsec == this.fsec;
    }

    public boolean equals(Time t, double tolerance) {
        double diff = this.diff(t);
        return Math.abs(diff) <= tolerance;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.wsec) ^ Double.doubleToLongBits(this.fsec);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int compareTo(Object obj) {
        Time t = Time.toTime(obj);
        int comp = Double.compare(this.wsec, t.wsec);
        return comp != 0 ? comp : Double.compare(this.fsec, t.fsec);
    }

    public boolean isZero() {
        return this.wsec == 0.0 && this.fsec == 0.0;
    }

    public static boolean isSTDTimeString(String timeString) {
        Matcher matchSTD = STD_FORMAT_PATTERN.matcher(timeString);
        return matchSTD.matches();
    }

    static Time toTimeAndStringBuffer(double secs, StringBuffer sb, String prepend, String postpend) {
        Time time = new Time(secs, 0.0);
        if (sb != null) {
            sb.setLength(0);
            int decimalPlaces = Time.getDecimalPrecision(secs);
            sb.append(prepend).append(time.toString(decimalPlaces)).append(postpend);
        }
        return time;
    }

    public Number toNumber() {
        BigDecimal w = new BigDecimal(this.wsec, MathContext.DECIMAL64);
        BigDecimal f = new BigDecimal(this.fsec, MathContext.DECIMAL64);
        BigDecimal s = w.add(f);
        if (s.precision() <= 15) {
            return s.doubleValue();
        }
        return s;
    }

    static long ticksPerSecond(double timeDelta) {
        long ticksPerSecond = Math.round(1.0 / timeDelta);
        return ticksPerSecond;
    }

    public static Time add(Time a, double b) {
        return new Time(a).addSec(b);
    }

    public static Time add(double a, Time b) {
        return Time.add(b, a);
    }

    public static Time add(Time a, Time b) {
        return new Time(a).addTime(b);
    }

    public static Time add(double a, double b) {
        return new Time().addSec(a).addSec(b);
    }

    static {
        dim = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        STD_FORMAT_PATTERN = Pattern.compile("[0-9]{4}[:-](([0][1-9])|([1][0-2])|[1-9])[:-](([0][1-9])|([1-2][0-9])|([3][0-1])|[1-9])::(([0-1][0-9])|([2][0-3])|[0-9]):(([0-5][0-9])|[0-9]):(([0-5][0-9])|(60)|[0-9])(\\.[0-9]*+)?");
        UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
        DATATYPE_FACTORY = null;
    }
}

