/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.Constants;

public class TMatrix
implements Constants {
    public static final int AZIM = 1;
    public static final int ELEV = 2;
    public static final int ROLL = 3;
    public static final int YAW = 4;
    public static final int PITCH = 5;
    public double a11;
    public double a21;
    public double a31;
    public double b1;
    public double s1;
    public double a12;
    public double a22;
    public double a32;
    public double b2;
    public double s2;
    public double a13;
    public double a23;
    public double a33;
    public double b3;
    public double s3;
    private TMatrix r;

    public TMatrix() {
        this.identity();
    }

    public TMatrix(TMatrix p) {
        TMatrix.copy(p, this);
    }

    public void identity() {
        this.a11 = 1.0;
        this.a21 = 0.0;
        this.a31 = 0.0;
        this.b1 = 0.0;
        this.s1 = 1.0;
        this.a12 = 0.0;
        this.a22 = 1.0;
        this.a32 = 0.0;
        this.b2 = 0.0;
        this.s2 = 1.0;
        this.a13 = 0.0;
        this.a23 = 0.0;
        this.a33 = 1.0;
        this.b3 = 0.0;
        this.s3 = 1.0;
    }

    public void offset(double b1, double b2, double b3) {
        this.b1 = b1;
        this.b2 = b2;
        this.b3 = b3;
    }

    public void rotate(double angle, int type) {
        if (angle == 0.0) {
            return;
        }
        double a = angle * (Math.PI / 180);
        double sa = Math.sin(a);
        double ca = Math.cos(a);
        if (this.r == null) {
            this.r = new TMatrix();
        } else {
            this.r.identity();
        }
        switch (type) {
            case 1: {
                this.r.a11 = ca;
                this.r.a12 = -sa;
                this.r.a21 = sa;
                this.r.a22 = ca;
                break;
            }
            case 4: {
                this.r.a11 = ca;
                this.r.a12 = -sa;
                this.r.a21 = sa;
                this.r.a22 = ca;
                break;
            }
            case 2: {
                this.r.a11 = ca;
                this.r.a13 = -sa;
                this.r.a31 = sa;
                this.r.a33 = ca;
                break;
            }
            case 5: {
                this.r.a11 = ca;
                this.r.a13 = sa;
                this.r.a31 = -sa;
                this.r.a33 = ca;
                break;
            }
            case 3: {
                this.r.a22 = ca;
                this.r.a23 = -sa;
                this.r.a32 = sa;
                this.r.a33 = ca;
            }
        }
        TMatrix.multiply(this.r, this, this);
    }

    public void multiply(TMatrix q) {
        TMatrix.multiply(this, q, this);
    }

    public static void multiply(TMatrix p, TMatrix q, TMatrix r) {
        if (p == r) {
            p = new TMatrix(p);
        }
        if (q == r) {
            q = new TMatrix(q);
        }
        r.a11 = p.a11 * q.a11 + p.a12 * q.a21 + p.a13 * q.a31;
        r.a12 = p.a11 * q.a12 + p.a12 * q.a22 + p.a13 * q.a32;
        r.a13 = p.a11 * q.a13 + p.a12 * q.a23 + p.a13 * q.a33;
        r.b1 = p.a11 * q.b1 + p.a12 * q.b2 + p.a13 * q.b3 + p.b1;
        r.a21 = p.a21 * q.a11 + p.a22 * q.a21 + p.a23 * q.a31;
        r.a22 = p.a21 * q.a12 + p.a22 * q.a22 + p.a23 * q.a32;
        r.a23 = p.a21 * q.a13 + p.a22 * q.a23 + p.a23 * q.a33;
        r.b2 = p.a21 * q.b1 + p.a22 * q.b2 + p.a23 * q.b3 + p.b2;
        r.a31 = p.a31 * q.a11 + p.a32 * q.a21 + p.a33 * q.a31;
        r.a32 = p.a31 * q.a12 + p.a32 * q.a22 + p.a33 * q.a32;
        r.a33 = p.a31 * q.a13 + p.a32 * q.a23 + p.a33 * q.a33;
        r.b3 = p.a31 * q.b1 + p.a32 * q.b2 + p.a33 * q.b3 + p.b3;
    }

    public void transpose() {
        TMatrix.transpose(this, this);
    }

    public void transpose(TMatrix q) {
        TMatrix.transpose(this, q);
    }

    public static void transpose(TMatrix p, TMatrix q) {
        double t = p.a12;
        q.a12 = p.a21;
        q.a21 = t;
        t = p.a13;
        q.a13 = p.a31;
        q.a31 = t;
        t = p.a32;
        q.a32 = p.a23;
        q.a23 = t;
        double tb1 = p.b1;
        double tb2 = p.b2;
        double tb3 = p.b3;
        q.b1 = -(q.a11 * tb1 + q.a12 * tb2 + q.a13 * tb3);
        q.b2 = -(q.a21 * tb1 + q.a22 * tb2 + q.a23 * tb3);
        q.b3 = -(q.a31 * tb1 + q.a32 * tb2 + q.a33 * tb3);
    }

    public void invert() {
        TMatrix.invert(this, this);
    }

    public void invert(TMatrix q) {
        TMatrix.invert(this, q);
    }

    public static void invert(TMatrix p, TMatrix q) {
        if (p == q) {
            p = new TMatrix(p);
        }
        q.a11 = p.a22 * p.a33 - p.a23 * p.a32;
        q.a12 = -(p.a12 * p.a33 - p.a13 * p.a32);
        q.a13 = p.a12 * p.a23 - p.a13 * p.a22;
        q.a21 = -(p.a21 * p.a33 - p.a23 * p.a31);
        q.a22 = p.a11 * p.a33 - p.a13 * p.a31;
        q.a23 = -(p.a11 * p.a23 - p.a13 * p.a21);
        q.a31 = p.a21 * p.a32 - p.a22 * p.a31;
        q.a32 = -(p.a11 * p.a32 - p.a12 * p.a31);
        q.a33 = p.a11 * p.a22 - p.a12 * p.a21;
        double det = p.a11 * q.a11 + p.a12 * q.a21 + p.a13 * q.a31;
        if (det != 0.0) {
            det = 1.0 / det;
        }
        q.a11 *= det;
        q.a12 *= det;
        q.a13 *= det;
        q.a21 *= det;
        q.a22 *= det;
        q.a23 *= det;
        q.a31 *= det;
        q.a32 *= det;
        q.a33 *= det;
        q.b1 = -(q.a11 * p.b1 + q.a12 * p.b2 + q.a13 * p.b3);
        q.b2 = -(q.a21 * p.b1 + q.a22 * p.b2 + q.a23 * p.b3);
        q.b3 = -(q.a31 * p.b1 + q.a32 * p.b2 + q.a33 * p.b3);
    }

    public void copy() {
        TMatrix.copy(this, this);
    }

    public void copy(TMatrix q) {
        TMatrix.copy(this, q);
    }

    public static void copy(TMatrix p, TMatrix q) {
        q.a11 = p.a11;
        q.a21 = p.a21;
        q.a31 = p.a31;
        q.b1 = p.b1;
        q.s1 = p.s1;
        q.a12 = p.a12;
        q.a22 = p.a22;
        q.a32 = p.a32;
        q.b2 = p.b2;
        q.s2 = p.s2;
        q.a13 = p.a13;
        q.a23 = p.a23;
        q.a33 = p.a33;
        q.b3 = p.b3;
        q.s3 = p.s3;
    }

    public String toString() {
        String firstLine = "a11:" + this.a11 + " a21:" + this.a21 + " a31:" + this.a31 + " b1:" + this.b1 + " s1:" + this.s1;
        String secondLine = "a12:" + this.a11 + " a22:" + this.a22 + " a32:" + this.a32 + " b2:" + this.b2 + " s2:" + this.s2;
        String thirdLine = "a13:" + this.a13 + " a23:" + this.a23 + " a33:" + this.a33 + " b3:" + this.b1 + " s1:" + this.s1;
        return firstLine + "\n" + secondLine + "\n" + thirdLine;
    }
}

