/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.Chainable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Time;

public class Pipe
implements Chainable {
    private static boolean DEBUG = false;
    public static final int DISCON = -2;
    static final int DEFAULT_MAX_OUTLETS = 8;
    static final int DEFAULT_MAX_HISTORY = 10;
    @Deprecated
    public int inlet = 0;
    @Deprecated
    public int outlets = 0;
    @Deprecated
    public int outMask = 0;
    @Deprecated
    public int maxOut = 8;
    @Deprecated
    public int size = 131072;
    @Deprecated
    public volatile double inPtr = 0.0;
    @Deprecated
    public double[] outPtr;
    @Deprecated
    public byte[] buffer;
    protected Midas M;
    protected String name;
    protected Command[] refs;
    protected boolean[] restart;
    protected DataFile[] dfc;
    protected DataFile[] dfx;
    protected double timeLast = 0.0;
    protected double inPtrLast = 0.0;
    protected double lastModified;
    private int maxHistory = 10;
    private int[] historyCount;
    private DataFile[] historyTail;

    public Pipe(Midas M, String name) {
        this(M, name, 8);
    }

    public Pipe(Midas M, String name, int maxOut) {
        if (maxOut > 31) {
            throw new IllegalArgumentException("Cannot set max outlets (pipe readers) > 31, given " + maxOut);
        }
        this.M = M;
        this.name = name;
        this.maxOut = maxOut;
        this.outPtr = new double[maxOut + 1];
        this.refs = new Command[maxOut + 1];
        this.restart = new boolean[maxOut + 1];
        this.dfc = new DataFile[maxOut + 1];
        this.dfx = new DataFile[maxOut + 1];
        this.lastModified = Time.current();
        this.historyCount = new int[maxOut + 1];
        this.historyTail = new DataFile[maxOut + 1];
    }

    public String toString() {
        return "Raw Pipe Name=" + this.name;
    }

    public synchronized int attach(int dir, DataFile df) {
        int outlet = 0;
        if (dir > 0 || dir == 0 && df != null && df.cmd == this.refs[0]) {
            this.inlet = 1;
            df.setDataStart(this.inPtr);
            if (this.dfc[0] != null) {
                this.dfc[0] = this.linkDataFiles(this.dfc[0], df, -1);
                this.dfc[0].close();
            }
            if (this.dfx[0] != null) {
                this.dfx[0] = this.linkDataFiles(this.dfx[0], df, 0);
            }
            this.dfc[0] = df;
            this.dfx[0] = df;
            this.refs[0] = df.cmd;
            this.restart[0] = false;
        } else {
            for (int i = 1; i <= this.maxOut && outlet == 0; ++i) {
                int mask = 1 << i - 1;
                if (this.restart[i] && (this.outMask & mask) != 0 && df.cmd == this.refs[i]) {
                    outlet = i;
                    this.dfx[outlet] = this.linkDataFiles(this.dfx[outlet], df, outlet);
                    continue;
                }
                if (this.restart[i] || (this.outMask & mask) != 0) continue;
                outlet = i;
                this.outMask |= mask;
                this.outlets = Math.max(this.outlets, outlet);
                this.outPtr[outlet] = this.inPtr;
                this.dfc[outlet] = this.dfc[0];
            }
            if (outlet > 0) {
                this.refs[outlet] = df.cmd;
                this.restart[outlet] = false;
                this.dfx[outlet] = df;
            }
        }
        if (DEBUG) {
            this.debug("Attach flags=" + df.getFlagsString() + " dir=" + IOResource.dirToString(dir), df, outlet);
        }
        return outlet;
    }

    private synchronized DataFile linkDataFiles(DataFile old, DataFile df, int historyIndex) {
        if (old != null) {
            if (old == df) {
                old = df.copy();
                DataFile prevDF = old.getPreviousDataFile();
                if (prevDF != null) {
                    prevDF.setNextDataFile(old);
                }
                if (DEBUG) {
                    String id_df = Integer.toHexString(System.identityHashCode(df));
                    String id_old = Integer.toHexString(System.identityHashCode(old));
                    this.debug("\nlinkDataFiles: Special RESTART index=" + historyIndex + " old is same as new=" + id_df + " old clone=" + id_old + "  <---- RESTART");
                }
            }
            old.setNextDataFile(df);
            df.setPreviousDataFile(old);
            if (DEBUG) {
                String id_df = Integer.toHexString(System.identityHashCode(df));
                String id_old = Integer.toHexString(System.identityHashCode(old));
                String tmp = historyIndex < 0 ? "" : " count=" + this.historyCount[historyIndex];
                this.debug("linkDataFiles: index=" + historyIndex + " old=" + id_old + " new=" + id_df + tmp);
            }
            if (historyIndex >= 0) {
                this.trimHistory(old, df, historyIndex);
            }
        }
        return old;
    }

    private synchronized void trimHistory(DataFile old, DataFile df, int historyIndex) {
        if (historyIndex >= 0) {
            DataFile newTail = null;
            DataFile tail = this.historyTail[historyIndex];
            int count = this.historyCount[historyIndex];
            if (count < this.maxHistory || tail == null) {
                if (tail == null) {
                    this.historyCount[historyIndex] = 1;
                    newTail = old;
                    if (count > 1) {
                        this.warn("trimHistory: tail is null but count(" + count + ") > 1! index=" + historyIndex + " <=== WARN", df, historyIndex);
                    }
                } else {
                    int n = historyIndex;
                    this.historyCount[n] = this.historyCount[n] + 1;
                }
            } else {
                newTail = tail.getNextDataFile();
                tail.setNextDataFile(null);
                if (DEBUG) {
                    String id_tail = Integer.toHexString(System.identityHashCode(tail));
                    String id_newTail = Integer.toHexString(System.identityHashCode(newTail));
                    this.debug("trimHistory: TRIM history: index=" + historyIndex + " tail=" + id_tail + " newTail=" + id_newTail + "\n");
                }
                if (newTail != null) {
                    newTail.setPreviousDataFile(null);
                } else {
                    DataFile prevDF;
                    int ii;
                    newTail = old;
                    for (ii = 1; ii < this.maxHistory && (prevDF = df.getPreviousDataFile()) != null; ++ii) {
                        newTail = prevDF;
                    }
                    String id_old = Integer.toHexString(System.identityHashCode(old));
                    String id_newTail = Integer.toHexString(System.identityHashCode(newTail));
                    this.warn("trimHistory: WARN: unable to cut previous DataFile link since new tail is null! index=" + historyIndex + " setting tail=" + id_newTail + " ii=" + (ii + 1) + " old=" + id_old + " <=== WARN", df, historyIndex);
                }
            }
            if (newTail != null) {
                this.historyTail[historyIndex] = newTail;
            }
        }
    }

    public synchronized int detach(int outlet, DataFile df) {
        return this.detach(outlet, df, (df.flags & 0x100) != 0);
    }

    private synchronized int detach(int outlet, DataFile df, boolean reopen) {
        if (outlet == -2) {
            return outlet;
        }
        DataFile next = this.dfc[outlet].getNextDataFile();
        boolean bl = this.restart[outlet] = reopen || next != null;
        if (DEBUG) {
            this.debug("Detach flags=" + df.getFlagsString() + " reopen=" + reopen + " next=" + next, df, outlet);
        }
        if (outlet == 0) {
            if (!this.restart[outlet]) {
                this.inlet = 0;
            }
            this.restart[outlet] = true;
        } else {
            int i = outlet - 1;
            if (next != null) {
                this.dfc[outlet] = next;
                this.outPtr[outlet] = next.getDataStart();
                this.restart[outlet] = true;
            } else if (!this.restart[outlet]) {
                this.outMask &= ~(1 << i);
            }
            for (i = this.outlets - 1; i >= 0 && (this.outMask & 1 << i) == 0; --i) {
            }
            this.outlets = i + 1;
            outlet = -2;
        }
        return outlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double lastOut() {
        double out = this.inPtr;
        for (int i = 0; i < this.outlets; ++i) {
            if ((this.outMask & 1 << i) == 0 || !(this.outPtr[i + 1] < out)) continue;
            if (this.restart[i + 1]) {
                Pipe pipe = this;
                synchronized (pipe) {
                    int flags;
                    if (this.refs[i + 1].state != 7 && ((flags = this.dfx[i + 1].getFlags()) & 0x4000) == 0) {
                        this.M.info("PIPE: " + Convert.ref2String(this.refs[i + 1]) + " restarted, but did not reconnect to " + this.name);
                        this.detach(i + 1, this.dfx[i + 1], false);
                    }
                }
            }
            out = this.outPtr[i + 1];
        }
        this.outPtr[0] = out;
        return out;
    }

    public int readHeader(byte[] hb, int outlet) {
        if (outlet == -2) {
            return 0;
        }
        int bytes = Math.min(hb.length, this.dfc[outlet].hb.length);
        System.arraycopy(this.dfc[outlet].hb, 0, hb, 0, bytes);
        return bytes;
    }

    public int writeHeader(byte[] hb, int outlet) {
        int bytes = Math.min(hb.length, this.dfc[outlet].hb.length);
        System.arraycopy(hb, 0, this.dfc[outlet].hb, 0, bytes);
        this.lastModified = Time.current();
        return bytes;
    }

    public double avail(int outlet) {
        double status;
        double in = this.inPtr;
        if (outlet == 0) {
            status = (double)this.size - (in - this.lastOut());
        } else if (outlet < 0 || outlet > this.maxOut) {
            status = -3.0;
        } else {
            DataFile df = this.dfc[outlet];
            if (df.getNextDataFile() != null) {
                in = df.getDataStop();
            }
            if (!((status = in - this.outPtr[outlet]) > 0.0)) {
                if (status < 0.0) {
                    status = 0.0;
                } else if (this.inlet == 0) {
                    status = -1.0;
                } else if (df.getNextDataFile() != null) {
                    status = -2.0;
                }
            }
        }
        if (status > (double)this.size) {
            if (outlet == 0) {
                this.M.warning("Pipe overflow detected for " + this.name + " on pipe writer. avail=" + status + " > size=" + this.size + "! inPtr=" + this.inPtr + " in=" + in + " outPtr=" + this.getOutByte(outlet) + " outlet=" + outlet);
            } else {
                this.M.warning("Pipe overflow detected for " + this.name + " closing pipe reader. avail=" + status + " > size=" + this.size + "! inPtr=" + this.inPtr + " in=" + in + " outPtr=" + this.getOutByte(outlet) + " outlet=" + outlet);
            }
            status = -3.0;
        }
        return status;
    }

    public boolean isReady(int outlet, int numBytes) {
        double avail;
        if (numBytes > this.size) {
            throw new MidasException("Transfer length of " + numBytes + " bytes exceeds pipe size of " + this.size + " bytes");
        }
        if (outlet <= 0 || outlet > this.maxOut) {
            throw new MidasException("Invalid outlet number " + outlet);
        }
        double in = this.inPtr;
        DataFile df = this.dfc[outlet];
        if (df.getNextDataFile() != null) {
            in = df.getDataStop();
        }
        return (avail = in - this.outPtr[outlet]) >= (double)numBytes || this.inlet == 0 || df.getNextDataFile() != null;
    }

    public int write(byte[] buf, long lbuf, int boff, int bytes, int outlet) {
        int pmax;
        if (this.M.pipeMode == 3) {
            return 0;
        }
        if (this.M.pipeMode == 5 || this.M.pipeMode == 0) {
            return -1;
        }
        double out = this.lastOut();
        int poff = (int)(this.inPtr % (double)this.size);
        int bmax = this.size - poff;
        if (bmax < bytes) {
            bytes = bmax;
        }
        if ((pmax = this.size - (int)(this.inPtr - out)) < bytes) {
            bytes = pmax;
        }
        if (bytes > 0) {
            try {
                if (lbuf != 0L) {
                    Native.p2ja(lbuf, boff, this.buffer, poff, bytes);
                } else {
                    System.arraycopy(buf, boff, this.buffer, poff, bytes);
                }
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder(1400);
                sb.append("***************************************************************\n");
                sb.append("** Pipe.write: Exception details ************************************\n");
                sb.append("**                                                                 **\n");
                sb.append(StringUtil.padRight("**     Pipe name: " + this.getName(), 67) + "**\n");
                sb.append(StringUtil.padRight("**     buffer: " + buf, 67) + "**\n");
                if (buf != null) {
                    sb.append(StringUtil.padRight("**     buffer length: " + buf.length, 67) + "**\n");
                }
                sb.append(StringUtil.padRight("**     native buffer location: " + lbuf, 67) + "**\n");
                sb.append(StringUtil.padRight("**     buffer offset: " + boff, 67) + "**\n");
                sb.append(StringUtil.padRight("**     number bytes to write: " + bytes, 67) + "**\n");
                sb.append(StringUtil.padRight("**     outlet: " + outlet, 67) + "**\n");
                String pipeModeInfo = Parser.get("Off,Init,Run,Pause,Wait,Stop", this.M.pipeMode, -1) + " (" + this.M.pipeMode + ")";
                sb.append(StringUtil.padRight("**     pipeMode: " + pipeModeInfo, 67) + "**\n");
                sb.append(StringUtil.padRight("**     out/lastOut(): " + out, 67) + "**\n");
                sb.append(StringUtil.padRight("**     poff: " + poff, 67) + "**\n");
                sb.append(StringUtil.padRight("**     bmax: " + bmax, 67) + "**\n");
                sb.append(StringUtil.padRight("**     pmax: " + pmax, 67) + "**\n");
                sb.append("**                                                                 **\n");
                sb.append("** END Pipe.write: Exception details ********************************\n");
                sb.append("*********************************************************************");
                this.M.warning(sb);
                if (this.M.io.isOptionSet(CoreIO.IOOptions.WriteNoAbort)) {
                    this.M.printStackTrace("Pipe.write() exception suppressed with: 'ENV SET IOOptions +WriteNoAbort'\nPipe.write() Exception/stack trace info for " + this.getName(), e, true, 1);
                }
                throw e;
            }
            this.inPtr += (double)bytes;
            this.lastModified = Time.current();
        } else {
            bytes = 0;
        }
        return bytes;
    }

    public int read(byte[] buf, long lbuf, int boff, int bytes, int outlet) {
        int pmax;
        if (this.M.pipeMode == 3) {
            return 0;
        }
        if (this.M.pipeMode == 5 || this.M.pipeMode == 0) {
            return -1;
        }
        DataFile df = this.dfc[outlet];
        double out = this.outPtr[outlet];
        int poff = (int)(out % (double)this.size);
        int bmax = this.size - poff;
        if (bmax < bytes) {
            bytes = bmax;
        }
        double in = this.inPtr;
        if (df.getNextDataFile() != null) {
            in = df.getDataStop();
        }
        if ((pmax = (int)(in - out)) < bytes) {
            bytes = pmax;
        }
        if (bytes > 0) {
            if (bytes > this.size) {
                bytes = this.size;
            }
            if (lbuf != 0L) {
                Native.ja2p(this.buffer, poff, lbuf, boff, bytes);
            } else {
                System.arraycopy(this.buffer, poff, buf, boff, bytes);
            }
            this.outPtr[outlet] = out + (double)bytes;
        } else {
            if (df.getNextDataFile() != null) {
                return -2;
            }
            if (this.inlet == 0) {
                return -1;
            }
            bytes = 0;
        }
        return bytes;
    }

    public short getInlet() {
        return (short)this.inlet;
    }

    public short getOutlets() {
        return (short)this.outlets;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.3.2")
    public int getOutMask() {
        return this.outMask;
    }

    public boolean isAttached(int outlet) {
        if (outlet == 0) {
            return this.dfc[0] != null;
        }
        int mask = 1 << outlet - 1;
        return (this.outMask & mask) != 0;
    }

    public int getMaxOutlets() {
        return this.maxOut;
    }

    public int getSize() {
        return this.size;
    }

    public double getInByte() {
        return this.inPtr;
    }

    public double getOutByte() {
        return this.outPtr[0];
    }

    public double getOutByte(int i) {
        return this.outPtr[i];
    }

    public double getAvail() {
        return this.inPtr - this.outPtr[0];
    }

    public double getRate() {
        double time = Time.current();
        double xfer = this.inPtr - this.inPtrLast;
        double rate = xfer / (time - this.timeLast);
        this.timeLast = time;
        this.inPtrLast = this.inPtr;
        return rate;
    }

    public DataFile getDataFile() {
        return this.dfc[0];
    }

    public DataFile getDataFile(int outlet) {
        return outlet != -2 ? this.dfc[outlet] : null;
    }

    public Object getOwner(int outlet) {
        return outlet != -2 ? this.refs[outlet] : null;
    }

    public void setSize(int value) {
        if (this.buffer == null || value != this.size) {
            int mode = this.M.pipeMode;
            if (mode == 2) {
                this.M.pipeMode = 3;
                Time.sleep(0.2);
            }
            this.buffer = new byte[value];
            this.size = value;
            if (this.M.pipeMode != mode) {
                this.M.pipeMode = mode;
            }
        }
    }

    public void setInByte(double value) {
        this.inPtr = value;
    }

    public void setOutByte(double value) {
        this.outPtr[0] = value;
    }

    public void setOutByte(int i, double value) {
        this.outPtr[i] = value;
    }

    @Override
    public Object getNextLink() {
        return this.dfc[0];
    }

    @Override
    public Object getPrevLink() {
        return null;
    }

    public synchronized void awaken() {
        this.notifyAll();
    }

    public String getName() {
        return this.name;
    }

    public double getLastModified() {
        return this.lastModified;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    @InternalUseOnly(value="Since added")
    public synchronized void setMaxHistory(int newMax) {
        if (newMax < 2) {
            throw new IllegalArgumentException("Cannot set max history < 2, given " + newMax);
        }
        this.maxHistory = newMax;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.7.0")
    public static boolean isDebug() {
        return DEBUG;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.7.0")
    public static void setDebug(boolean newDebug) {
        DEBUG = newDebug;
    }

    private void msg(int severity, String msg) {
        String message = "Pipe " + this.name + ": " + msg;
        if (this.M != null) {
            this.M.message(message, severity);
        } else if (severity == 1) {
            Shell.warning(msg);
        } else {
            Shell.info(message);
        }
    }

    private void debug(String msg) {
        this.msg(0, msg);
    }

    private void debug(String msg, DataFile df, int outlet) {
        String id = df == null ? null : Convert.ref2String(df.cmd);
        this.debug(msg + " owner=" + id + " outlet=" + outlet);
    }

    private void warn(String msg, DataFile df, int outlet) {
        String id = df == null ? null : Convert.ref2String(df.cmd);
        this.msg(1, msg + " owner=" + id + " outlet=" + outlet);
    }
}

