/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import nxm.sys.inc.Debug;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ShellParent;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.OptionTreeAutoLoaderService;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;

public class NeXtMidas
implements ShellParent,
MidasReference {
    public static final int ALWAYS_CALL_SHELL_OPEN = 1;
    public static final int RESTORE_NONNULL_PREV_SHELL = 2;
    static final String flagList = "AlwaysCallShellOpen,RestoreNonNullPrevShell";
    private static final String DEF_WRITE_AUX = "HOME";
    private static final String DEF_READ_AUX = "HOME|RAM|DAT";
    private static final NeXtMidas INSTANCE = new NeXtMidas(new Terminal(), 2, new String[0]);
    private boolean DEBUG = false;
    private boolean noNative = true;
    private String path = "SYS";
    private Shell shell = null;
    private boolean runInteractiveTextTerminal = false;
    private List<String> executeList = Collections.synchronizedList(new LinkedList());
    private JPanel panel;
    private boolean haltOptionsCheck = false;
    EscapeCharMode escapeCharMode = null;
    Map<String, String> auxEntries = new LinkedHashMap<String, String>();
    private Terminal terminal = null;
    private final Shell prevShell;
    private final boolean alwaysCallShellOpen;
    private static boolean shellGuiExists = true;

    public NeXtMidas() {
        this((String[])null);
    }

    public NeXtMidas(String ... options) {
        this(new Terminal(), 1, options);
    }

    @InternalUseOnly
    public NeXtMidas(Terminal terminal, int flags, String ... options) {
        this.DEBUG = Convert.o2z(System.getProperty("nextmidas.debug"));
        this.noNative = Convert.o2z(System.getProperty("NONATIVE", "TRUE"));
        this.setNoNative(this.noNative);
        System.setProperty("NOEXTERNAL", "TRUE");
        this.alwaysCallShellOpen = (flags & 1) != 0;
        this.prevShell = Shell.getCurrent();
        this.shell = new Shell(this);
        this.setWriteAux(DEF_WRITE_AUX);
        this.setReadAux(DEF_READ_AUX);
        this.terminal = terminal;
        if (options != null) {
            this.parseOptions(options);
        }
        this.openShell();
        if (this.prevShell != null && (flags & 2) != 0) {
            Shell.setCurrentShell(this.prevShell);
        }
    }

    public static NeXtMidas getGlobalInstance() {
        return INSTANCE;
    }

    public static void main(String[] args) {
        NeXtMidas nxm = new NeXtMidas(null, 1, args);
        if (nxm.executeList.isEmpty()) {
            nxm.determineInteractiveShell(false);
        }
        nxm.runShell();
    }

    public void runShell() {
        for (String cmd : this.executeList) {
            this.runCommand(cmd);
        }
        if (this.runInteractiveTextTerminal) {
            this.shell.process();
        }
    }

    public void run() {
        this.runShell();
    }

    public void openShell() {
        Shell.setPriv(-1);
        if (this.prevShell == null || this.alwaysCallShellOpen) {
            this.shell.open();
        } else if (this.prevShell != null) {
            this.shell.M.results.setPrevious(this.prevShell.M.results);
            String[] prevDictionaryEntries = Arrays.copyOfRange(this.prevShell.M.dictionary.entry, 0, this.prevShell.M.dictionary.size);
            this.shell.M.dictionary.fromArray(prevDictionaryEntries);
        }
        if (this.auxEntries.size() > 0) {
            this.updateAuxList();
        }
    }

    public Command runCommand(String cmd) {
        return this.runCommand(cmd, this.panel);
    }

    public Command runCommand(String cmd, JPanel panel2) {
        if (this.DEBUG) {
            this.debug("running command: [[" + cmd + "]]" + (panel2 == null ? "" : " on panel = " + panel2));
        }
        Command command = this.shell.runCommand(cmd, panel2);
        return command;
    }

    @InternalUseOnly
    public String addOptionTreePathUsingSPI() {
        OptionTreeAutoLoaderService option = OptionTreeAutoLoaderService.getInstance();
        String optName = option.optionTreePathFromClasspath();
        return optName;
    }

    public boolean addOptionTreeToPathClasspath(String optName, OptionFlags optFlag) {
        boolean pathUpdated = false;
        if (optName == null || optName.length() <= 0) {
            this.shell.M.warning("No Option Tree specified");
        } else if (optFlag == null) {
            this.shell.M.warning("No enumeration option flag specified");
        } else if (optFlag.toString() == null) {
            this.shell.M.warning("The OptionFlag is not a valid option [ADD,ADD+,PUT");
        } else {
            String[] opts;
            String optVal = optName.toUpperCase();
            Parser parse = new Parser(optVal);
            for (String opt : opts = parse.getArray(parse.elements())) {
                String optCommand = "OPTION," + opt + ",CLASSPATH";
                this.runCommand(optCommand);
            }
            String flag = optFlag.toString();
            String npath = "PATH," + flag + ",\"" + optVal + "\"";
            this.runCommand(npath);
            pathUpdated = true;
        }
        return pathUpdated;
    }

    public void setNoNative(boolean value) {
        this.noNative = value;
        System.setProperty("NONATIVE", Boolean.toString(this.noNative));
    }

    public boolean getNoNative() {
        return this.noNative;
    }

    private static String replaceSeparators(String value, char sep) {
        return value.replace('|', sep).replace(',', sep).replace(':', sep).replace(';', sep);
    }

    public void parseOptions(String ... options) {
        int ii = 0;
        for (String option : options) {
            if ("--".equals(option)) {
                this.haltOptionsCheck = true;
            }
            if (this.DEBUG) {
                this.debug("  parseOptions() checking arg " + ii++ + ": [[" + option + "]]");
            }
            this.parseOption(option);
        }
        this.haltOptionsCheck = false;
        this.escapeCharMode = null;
        if (this.DEBUG) {
            this.debug("  Commands to execute list: " + this.executeList);
        }
    }

    public void parseOptions(Table options) {
        String[] keys = options.getKeys();
        String[] args = new String[keys.length];
        int index = 0;
        for (String key : keys) {
            Object value = options.get(key);
            args[index++] = value == null ? "-" + key : "-" + key + "=" + value;
        }
        this.parseOptions(args);
    }

    public void parseOption(String option) {
        if (!this.haltOptionsCheck) {
            String key = option;
            String value = null;
            int indexEQ = option.indexOf(61);
            if (indexEQ > 0) {
                key = option.substring(0, indexEQ).trim();
                value = option.substring(indexEQ + 1).trim();
            }
            this.setOption(key, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String key, String value) {
        if (key.charAt(0) != '-') {
            key = "-" + key;
        }
        if (this.escapeCharMode == EscapeCharMode.Percent) {
            value = StringUtil.decodePercentEncoding(value);
        }
        if ("-aux.read".equalsIgnoreCase(key)) {
            this.setReadAux(value);
            return;
        } else if ("-aux.write".equalsIgnoreCase(key)) {
            this.setWriteAux(value);
            return;
        } else if (key.length() > 5 && "-aux.".equalsIgnoreCase(key.substring(0, 5))) {
            String auxName = key.substring(5).toUpperCase();
            this.auxEntries.put(auxName, value);
            return;
        } else if ("-nonative".equalsIgnoreCase(key)) {
            this.setNoNative(value == null || Convert.o2z(value));
            return;
        } else if ("-headless".equalsIgnoreCase(key)) {
            Boolean headless = value == null || Convert.o2z(value);
            try {
                System.setProperty("HEADLESS", headless.toString());
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot set HEADLESS value", e);
            }
        } else if ("-path".equalsIgnoreCase(key)) {
            this.path = value;
            return;
        } else if ("-command".equalsIgnoreCase(key) || "-cmd".equalsIgnoreCase(key)) {
            this.executeList.add(value);
            return;
        } else if ("-shell".equalsIgnoreCase(key)) {
            this.determineInteractiveShell(false);
            return;
        } else if ("-prompt".equalsIgnoreCase(key)) {
            this.determineInteractiveShell(true);
            return;
        } else if ("-script".equalsIgnoreCase(key)) {
            if (value == null) return;
            this.executeList.add(this.getMacroCmd(value));
            return;
        } else if ("-debug".equalsIgnoreCase(key)) {
            this.executeList.add("debug/quiet off all");
            String debugCmd = value == null ? "debug on deprecate" : "debug/quiet on " + value;
            this.executeList.add(debugCmd);
            return;
        } else if ("-encoding".equalsIgnoreCase(key)) {
            if (value == null || value.length() == 0) {
                this.escapeCharMode = null;
                return;
            } else if (value.equalsIgnoreCase("None")) {
                this.escapeCharMode = null;
                return;
            } else if (value.equalsIgnoreCase("Percent")) {
                this.escapeCharMode = EscapeCharMode.Percent;
                return;
            } else {
                if (!value.equalsIgnoreCase("%")) throw new IllegalArgumentException("Illegal parameter " + key + "=" + value);
                this.escapeCharMode = EscapeCharMode.Percent;
            }
            return;
        } else if ("-version".equalsIgnoreCase(key) || "-v".equalsIgnoreCase(key)) {
            this.executeList.add("VERSION SYS");
            return;
        } else if ("-verboseversion".equalsIgnoreCase(key) || "-vv".equalsIgnoreCase(key)) {
            this.executeList.add("VERSION/ALL");
            return;
        } else {
            if (!"-help".equalsIgnoreCase(key) && !"-h".equalsIgnoreCase(key) && !"-?".equals(key)) throw new IllegalArgumentException("Illegal parameter " + key + "=" + value);
            this.executeList.add("");
        }
    }

    public static String getUsage() {
        return "Usage: [-options]*\n\nwhere options include:\n  -aux.<auxname>=<value>  Define a disk AUX entry to a path or URL\n  -aux.read=<auxlist>     Set the read AUX list\n  -aux.write=<aux>        Set the write AUX\n  -cmd=<command>          Alias for -command\n  -command=<command>      A command with any necessary arguments to execute.\n  -debug=<value>          Set debug to masked value (deprecate, trace, etc.)\n  -encoding=<type>        Set the type of escape char enocding (\"NONE\", \n                          \"Percent\", or \"%\")\n  -headless=[true|false]  Set HEADLESS mode\n  -help, -h, -?           Print this usage help message\n  -nonative=[true|false]  Disable(true)/enable(false) native code\n  -path=<path>            Set the PATH\n  -prompt                 Enter the NeXtMidas 'nM>' terminal shell prompt\n                          (executed after all commands and/or scripts)\n  -script=<macro>         Run a NeXtMidas macro from HOMEPATH, unless using an\n                          absolute path, \"nxm\" dot syntax, or a URL\n  -shell                  Open a NeXtMidas SHELLGUI (or -prompt if\n                          graphics is not available)\n  -verboseversion, -vv    Print out the verbose version of NeXtMidas, Java, etc.\n  -version, -v            Print out the NeXtMidas version\n\nNote: Multiple -command and -script options can be specified to run a series of\n      commands. They will be executed in the order specified (left to right).\n";
    }

    public static String getVersion() {
        return "NeXtMidas version 4.1.4";
    }

    public static String getVerboseVersion() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(NeXtMidas.getVersion()).append("\nNMROOT: ").append(INSTANCE.getNmRoot());
        sb.append("\nJava version: ").append(Shell.getProperty("java.version")).append(", class version: ").append(Shell.getProperty("java.class.version")).append(", vendor: ").append(Shell.getProperty("java.vendor"));
        sb.append("\nOS name: ").append(Shell.getProperty("os.name")).append(", version: ").append(Shell.getProperty("os.version")).append(", arch: ").append(Shell.getProperty("os.arch"));
        return sb.toString();
    }

    private void determineInteractiveShell(boolean forceTextTerminal) {
        if (forceTextTerminal || Shell.isHeadless() || !shellGuiExists) {
            this.runInteractiveTextTerminal = true;
            this.executeList.add("");
        } else {
            this.executeList.add("SHELLGUI;SYS");
        }
    }

    public void setReadAux(String readAuxList) {
        this.auxEntries.put("READ", NeXtMidas.replaceSeparators(readAuxList, '|'));
        this.updateAuxList();
    }

    public void setWriteAux(String writeAuxName) {
        this.auxEntries.put("WRITE", writeAuxName);
        this.updateAuxList();
    }

    public void addAuxEntry(String auxName, String path) {
        auxName = auxName.toUpperCase();
        this.shell.M.results.put("AUX." + auxName, (Object)path, 48);
        boolean exists = this.shell.M.io.dexists(path);
        if (!exists) {
            this.shell.M.warning("Specified path for AUX entry [" + auxName + "] does not exist at " + path);
        }
    }

    public void removeAuxEntry(String auxName) {
        auxName = auxName.toUpperCase();
        this.shell.M.results.remove("AUX." + auxName, 48);
    }

    public String getAuxPath(String auxName) {
        auxName = auxName.toUpperCase();
        return this.shell.M.results.getS("AUX." + auxName);
    }

    private void updateAuxList() {
        for (Map.Entry<String, String> e : this.auxEntries.entrySet()) {
            this.shell.M.results.put("AUX." + e.getKey(), (Object)e.getValue(), 48);
        }
    }

    private String getMacroCmd(String url) {
        String macroName = FileName.getRoot(url);
        String cmd = "%" + macroName + " /MFN=" + url;
        return cmd;
    }

    public void setDebug(String optionMask) {
        int debugIntMask = Parser.mask("IO,Macro,Pipes,Graphics,Results,Primitive,Shell,Args,Trace,Deprecate,SuperTrace", optionMask, 512);
        this.shell.M.setDebug(debugIntMask);
        Debug.saveGlobalDebugSettings(this.shell.M.results, debugIntMask);
    }

    public String getDebug() {
        return this.shell.M.getDebug();
    }

    public void setHeadless(boolean isHeadless) {
        try {
            Boolean headless = isHeadless;
            System.setProperty("HEADLESS", headless.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set HEADLESS value", e);
        }
    }

    public boolean isHeadless() {
        String headlessString = System.getProperty("HEADLESS", "true");
        Boolean isHeadless = Boolean.valueOf(headlessString);
        return isHeadless;
    }

    public void setPath(String newPath) {
        this.path = newPath;
        this.runCommand("PATH SET " + newPath);
    }

    public String getPath() {
        String globalPath = Shell.options.getS("PATH");
        if (globalPath == null) {
            return this.path;
        }
        if (!globalPath.equals(this.path)) {
            return globalPath;
        }
        return this.path;
    }

    @Override
    public String getNmRoot() {
        String nmroot = System.getProperty("NMROOT", OptionTree.findOptRoot("SYS"));
        if (nmroot.startsWith("file:") && !nmroot.contains(".jar")) {
            nmroot = nmroot.substring(5, nmroot.length());
        }
        return nmroot;
    }

    @Override
    public String getAux() {
        String write = Convert.o2s(this.shell.M.results.get("AUX.WRITE"));
        String read = Convert.o2s(this.shell.M.results.get("AUX.READ"));
        return write + " " + read;
    }

    @Override
    public String getOpts() {
        return OptionTree.getOptsHelper(this.path, this, false);
    }

    @Override
    public String getCWD() {
        String cwd = System.getProperty("user.dir");
        if (cwd != null) {
            cwd = FileUtil.terminatePath(cwd);
        }
        return cwd;
    }

    @Override
    public String getNMS() {
        return Shell.getProperty("NMSTARTUP.USER");
    }

    @Override
    public String getHome() {
        String home = System.getenv(DEF_WRITE_AUX);
        if (home == null) {
            home = Shell.getProperty("user.home");
        }
        if (home != null) {
            home = FileUtil.terminatePath(home);
        }
        return home;
    }

    @Override
    public String getServer() {
        return null;
    }

    @Override
    public String getTheme() {
        return Shell.getProperty("ENV.THEME");
    }

    @Override
    public String getStyle() {
        return Shell.getProperty("ENV.STYLE");
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    private final void debug(String msg) {
        System.out.println("DEBUG: " + msg);
    }

    public Shell getShell() {
        return this.shell;
    }

    public Midas getMidasContext() {
        return this.shell.M;
    }

    @Override
    public Midas getMidas() {
        return this.shell.M;
    }

    static {
        shellGuiExists = Shell.getCurrent().M.dictionary.isDictionaryEntry("SHELLGUI");
    }

    public static enum OptionFlags {
        ADD,
        ADD_PLUS,
        PUT;


        public String toString() {
            switch (this) {
                case ADD: {
                    return "ADD";
                }
                case ADD_PLUS: {
                    return "ADD+";
                }
                case PUT: {
                    return "PUT";
                }
            }
            return "";
        }
    }

    private static enum EscapeCharMode {
        Percent;

    }
}

