/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

@InternalUseOnly(value="Access to native code can crash the JVM if used incorrectly and may not always be available and can have platform specific behavior")
public class Native {
    static final int ROUND_DOWN = 1;
    static final int ROUND_CEILING = 2;
    static final int ROUND_FLOOR = 3;
    static final int ROUND_HALF_UP = 4;
    static final int ROUND_HALF_EVEN = 6;
    static final int ROUND_UNNECESSARY = 7;
    static final int ROUND_ROUND = -1;
    static final double DMAX = Double.MAX_VALUE;
    static final float FMAX = Float.MAX_VALUE;
    static final long XMAX = Long.MAX_VALUE;
    static final int LMAX = Integer.MAX_VALUE;
    static final short IMAX = Short.MAX_VALUE;
    static final byte BMAX = 127;
    static final byte NMAX = 7;
    static final byte IEEE = 73;
    static final byte EEEI = 69;
    static final byte VAX = 86;
    public static final String useList = "IO,Math,Cast,CastX,Convert,Cuda,Other";
    public static final int IO = 1;
    public static final int MATH = 2;
    public static final int CAST = 4;
    public static final int CASTX = 8;
    public static final int CONV = 16;
    public static final int CUDA = 32;
    public static final int OTHER = 64;
    public static boolean canUse;
    public static boolean useIO;
    public static boolean useMath;
    public static boolean useCast;
    public static boolean useCastX;
    public static boolean useConvert;
    public static boolean useCuda;
    public static boolean useOther;
    private static int use;
    private static int useable;
    private static boolean isInitUseComplete;

    @Deprecated
    public Native() {
    }

    public static void setCanUse(boolean state) {
        canUse = state;
        Native.setUse(use);
    }

    public static void setUse(String usestr) {
        Native.setUse(Parser.mask(useList, usestr, use));
    }

    public static void setUse(int mask) {
        use = mask & useable;
        useIO = canUse && (use & 1) != 0;
        useMath = canUse && (use & 2) != 0;
        useCast = canUse && (use & 4) != 0;
        useCastX = canUse && (use & 8) != 0;
        useConvert = canUse && (use & 0x10) != 0;
        useCuda = canUse && (use & 0x20) != 0;
        useOther = canUse && (use & 0x40) != 0;
    }

    public static String getUse() {
        return Parser.mask2s(useList, use);
    }

    public static String getUseable() {
        return Parser.mask2s(useList, useable);
    }

    public static void initUse() {
        if (isInitUseComplete) {
            return;
        }
        canUse = Shell.getPriv(16);
        if (canUse) {
            String noNative = Shell.getProperty("NONATIVE");
            canUse = noNative == null || StringUtil.isFalse(noNative);
        }
        isInitUseComplete = canUse = canUse && Shell.loadLibrary("sys", "lib", "Native");
        useable = 0;
        if (canUse) {
            useable |= 0x53;
            if (Native.castInit(new float[10], new double[11], new byte[12], new short[13], new int[14], new float[20], new double[21], new byte[22], new short[23], new int[24]) == 1) {
                useable |= 4;
            }
            if (Native.cudaInit() == 1) {
                useable |= 0x20;
            }
        }
        Native.setUse("ALL");
        Native.setUse("-CUDA");
    }

    public static native double[] castD(byte[] var0);

    public static native float[] castF(byte[] var0);

    public static native int[] castL(byte[] var0);

    public static native short[] castI(byte[] var0);

    public static native byte[] uncastD(Object var0);

    public static native byte[] uncastF(Object var0);

    public static native byte[] uncastL(Object var0);

    public static native byte[] uncastI(Object var0);

    private static native int castInit(Object var0, Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);

    private static native int cudaInit();

    static native int type(Object var0, int var1, byte var2, Object var3, int var4, byte var5, int var6, int var7, boolean var8);

    static native int rep(long var0, int var2, byte var3, int var4, byte var5, byte var6);

    static native int repsoi(long var0, int var2, byte var3, int var4, byte var5, byte var6, int var7, int var8);

    @Deprecated
    public static int cast(Object buf1, int off1, byte type1, Object buf2, int off2, byte type2, int size) {
        return Native.type(buf1, off1, type1, buf2, off2, type2, size, -1, true);
    }

    public static native void dumpClass(Object var0, int var1);

    public static native long getAddress(Object var0, int var1);

    public static native void dbf(Object var0, int var1, int var2);

    public static native float sqrtf(float var0);

    public static native float logf(float var0);

    public static native void copy(Object var0, Object var1, int var2);

    public static native long alloc(long var0);

    public static native int free(long var0);

    public static native void p2ja(long var0, int var2, Object var3, int var4, int var5);

    public static native void ja2p(Object var0, int var1, long var2, int var4, int var5);

    public static native void p2p(long var0, int var2, long var3, int var5, int var6);

    public static native void p2ps(long var0, int var2, int var3, long var4, int var6, int var7, int var8, int var9);

    public static native int fopen(String var0, int var1);

    public static native long fseek(int var0, long var1);

    public static native int fread(int var0, long var1, int var3, int var4);

    public static native int fwrite(int var0, long var1, int var3, int var4);

    public static native int freadb(int var0, Object var1, int var2, int var3);

    public static native int fwriteb(int var0, Object var1, int var2, int var3);

    public static native void fclose(int var0);

    public static native int chdir(String var0);

    public static native int statfs(String var0, Object var1);

    public static native int top(int var0, Object var1, int var2, int var3);

    public static native int jstr2fstr(String var0, long var1, int var3);

    static {
        isInitUseComplete = false;
    }
}

