/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Logger;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.NeXtMidas;
import nxm.sys.lib.StringUtil;

@InternalUseOnly(value="Instantiated by Midas class based on logging properties, should not be accessed directly")
public class MidasToJavaLog
extends Logger {
    public static final String LOG_CLASS = NeXtMidas.class.getName();
    public static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(LOG_CLASS);
    static final MidasToJavaLog BOOTSTRAP_JAVALOGGER;
    private static MidasToJavaLog LOGGER;

    MidasToJavaLog() {
        this(null);
    }

    MidasToJavaLog(Midas midas) {
        super(midas);
    }

    @Override
    public void processMessage(Midas midas, CharSequence type, CharSequence text, CharSequence from) {
        String _from;
        String _type = type == null ? "TEXT" : type.toString();
        String _text = text == null ? "" : text.toString();
        String string = _from = from == null ? null : from.toString();
        if (_from != null && _from.equals("UNKNOWN")) {
            _from = null;
        }
        Level level = _type.equals("DEPRECATE") || _type.equals("CONFIG") ? Level.CONFIG : (_type.equals("WARNING") || _type.equals("WARN") ? Level.WARNING : (_type.equals("ERROR") ? Level.SEVERE : Level.INFO));
        LOG.logp(level, LOG_CLASS, _from, _text);
    }

    private static MidasToJavaLog getBootstrapLogger() {
        try {
            LogManager mgr = LogManager.getLogManager();
            if (mgr == null) {
                return null;
            }
            String enable = mgr.getProperty("nxm.sys.lib.NeXtMidas.enable");
            if (enable != null && StringUtil.isTrue(enable)) {
                return new MidasToJavaLog();
            }
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize logging: " + t);
            t.printStackTrace();
        }
        return null;
    }

    static MidasToJavaLog setGlobalInstance(Midas midas, String javaUtilLoggingConfigUrl) {
        MidasToJavaLog previous = LOGGER;
        try {
            System.setProperty("java.util.logging.config.file", javaUtilLoggingConfigUrl);
            LogManager mgr = LogManager.getLogManager();
            IOResource iores = midas.io.findResource(javaUtilLoggingConfigUrl, -1);
            if (iores == null || !iores.exists()) {
                throw new FileNotFoundException();
            }
            if (!iores.open()) {
                throw new IOException("Unable to open logging config file (for read)");
            }
            mgr.readConfiguration(iores.getInputStream());
            iores.close();
            String enable = mgr.getProperty("nxm.sys.lib.NeXtMidas.enable");
            if (enable != null && StringUtil.isTrue(enable)) {
                LOGGER = new MidasToJavaLog(midas);
            }
            return previous;
        }
        catch (IOException io) {
            throw new MidasException("Unable to read logging config file at " + javaUtilLoggingConfigUrl, io);
        }
    }

    public static MidasToJavaLog getGlobalInstance() {
        return LOGGER;
    }

    @Override
    public void open(Object fn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void saveOff() {
    }

    @Override
    public int getSize() {
        return -1;
    }

    static {
        LOGGER = BOOTSTRAP_JAVALOGGER = MidasToJavaLog.getBootstrapLogger();
    }
}

