/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.Constants;
import nxm.sys.lib.Args;
import nxm.sys.lib.Data;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class MPULib
implements Constants {
    public static String factoryList = "Java,Native,GPU,Verilog,ICE";
    public static int JAVA = 0;
    public static int NATIVE = 1;
    public static int GPU = 2;
    public static int VERILOG = 3;
    public static int ICE = 4;

    public static MPULib forName(String name, Args args) {
        String path = "nxm." + args.option.toLowerCase() + ".lib";
        int impl = args.getSelectionIndex("/MPU", factoryList, 0, -1);
        return MPULib.forName(path, name, impl);
    }

    public static MPULib forName(String path, String name, int impl) {
        if (impl == JAVA) {
            name = path + "." + name;
        } else if (impl == NATIVE) {
            name = path + "." + name + "Native";
        } else if (impl == GPU) {
            name = path + "." + name + "GPU";
        } else if (impl == ICE) {
            name = "nxm.ice.lib." + name + "ICE";
        } else if (impl == VERILOG) {
            name = "nxm.ice.lib." + name + "Verilog";
        }
        return MPULib.forName(name);
    }

    public static MPULib forName(String className) {
        return (MPULib)Shell.getInstanceForClassName(className);
    }

    public int open() {
        return 0;
    }

    public int process(int n) {
        return 0;
    }

    public int process(byte[] buf1, int n1) {
        return 0;
    }

    public int process(byte[] buf1, int n1, byte[] buf2, int n2) {
        return 0;
    }

    public int process(byte[] buf1, int n1, byte[] buf2, int n2, byte[] buf3, int n3) {
        return 0;
    }

    public int close() {
        return 0;
    }

    public void set(String key, Data value) {
        if (!key.startsWith("BOGUS")) {
            throw new MidasException("Problem setting key=" + key + " to value=" + value);
        }
    }

    public void set(String key, String value) {
        this.set(key, new Data(value));
    }

    public void set(String key, double value) {
        this.set(key, new Data(value));
    }

    public void set(String key, float value) {
        this.set(key, new Data(value));
    }

    public void set(String key, int value) {
        this.set(key, new Data(value));
    }

    public void set(String key, boolean value) {
        this.set(key, new Data(value ? 1 : 0));
    }

    public Data get(String key, byte type) {
        Data value = null;
        if (!key.startsWith("BOGUS")) {
            throw new MidasException("Problem getting key=" + key);
        }
        return value;
    }

    public String getS(String key) {
        Data value = this.get(key, (byte)83);
        return value.toString();
    }

    public double getD(String key) {
        Data value = this.get(key, (byte)68);
        return value.toD();
    }

    public float getF(String key) {
        Data value = this.get(key, (byte)70);
        return value.toF();
    }

    public int getL(String key) {
        Data value = this.get(key, (byte)76);
        return value.toL();
    }

    public boolean getState(String key) {
        Data value = this.get(key, (byte)76);
        return value.toL() > 0;
    }
}

