/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.util.Vector;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.FileName;
import nxm.sys.lib.KmlFileModSwap;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import nxm.sys.lib.XmlFile;

public final class KmlFile
extends XmlFile
implements KmlFileModSwap,
ListFile {
    public final String propertyList = "Name,Size,Comment,Qualifiers,XStart,XDelta,XUnits,XFrame,YStart,YDelta,YUnits,YFrame";
    private double xstart = 0.0;
    private double xdelta = 1.0;
    private double ystart = 0.0;
    private double ydelta = 1.0;
    private double timecode = 0.0;
    private int xunits = 0;
    private int xframe = 1;
    private int yunits = 0;
    private int yframe = 1;
    private String format = "UNK";
    private Vector<String> lines = null;

    public KmlFile() {
    }

    public KmlFile(String filename) {
        this.init(null, (Object)filename);
    }

    public KmlFile(FileName fn) {
        this.init(null, (Object)fn);
    }

    @Deprecated
    public KmlFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public KmlFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public String getMimeType() {
        return "application/vnd.google-earth.kml+xml";
    }

    @Override
    public void connect(int mode) {
    }

    @Override
    public String listHeader() {
        String list3 = "KmlFile    :  " + this.getURL() + "\nVersion    :  KML2.2 ???\nSize       :  " + this.getSize() + "\n";
        return list3;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public double getStart() {
        return this.ystart;
    }

    @Override
    public double getDelta() {
        return this.ydelta;
    }

    @Override
    public int getUnits() {
        return this.yunits;
    }

    @Override
    public double getXStart() {
        return this.xstart;
    }

    @Override
    public double getXDelta() {
        return this.xdelta;
    }

    @Override
    public int getXUnits() {
        return this.xunits;
    }

    @Override
    public int getXFrame() {
        return this.xframe;
    }

    @Override
    public double getYStart() {
        return this.ystart;
    }

    @Override
    public double getYDelta() {
        return this.ydelta;
    }

    @Override
    public int getYUnits() {
        return this.yunits;
    }

    @Override
    public int getYFrame() {
        return this.yframe;
    }

    @Override
    public double getTimeAt(double offset) {
        return this.timecode;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public void setXStart(double value) {
        this.xstart = value;
    }

    public void setXDelta(double value) {
        this.xdelta = value;
    }

    public void setXUnits(int value) {
        this.xunits = value;
    }

    public void setXFrame(int value) {
        this.xframe = value;
    }

    public void setYStart(double value) {
        this.ystart = value;
    }

    public void setYDelta(double value) {
        this.ydelta = value;
    }

    public void setYUnits(int value) {
        this.yunits = value;
    }

    public void setYFrame(int value) {
        this.yframe = value;
    }

    public void setTimeCode(double value) {
        this.timecode = value;
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Data getDataBuffer(int size) {
        return null;
    }

    @Override
    public boolean open() {
        return super.open();
    }

    @Override
    public int read(Data data, int elements) {
        return -1;
    }

    private void readFile() {
        this.lines = new Vector(1024);
    }

    @Override
    public final void removeData(double offset) {
        this.removeData(offset, 1L);
    }

    @Override
    public void removeData(double offset, long count) {
        if (this.lines == null) {
            this.readFile();
        }
        Util.removeListElements(this.lines, (int)offset, (int)count);
    }

    @Override
    public double getNumberOfRows() {
        return this.lines == null ? 0.0 : (double)this.lines.size();
    }

    @Override
    public void insertData(double offset, Object obj) {
    }

    @Override
    public double avail() {
        return 1.0;
    }

    @Override
    public int setData(double offset, Table table) {
        this.setData(offset, "TEXT", table.getS("TEXT", ""));
        return 1;
    }

    @Override
    public void setData(double element, String fieldName, Object obj) {
        if (this.lines == null) {
            this.readFile();
        }
        if (fieldName.equals("TEXT")) {
            this.lines.set((int)this.offset, obj.toString());
        }
    }

    @Override
    public void setRecordDefs(Table defs) {
        if (defs.size() != 1 || !defs.getKeys()[0].equals("TEXT")) {
            throw new MidasException("KmlFile: Can not alter record definitions in a TextFile.");
        }
    }

    @Override
    public Table getRecordDefs() {
        Table tbl = new Table();
        tbl.setKey("TEXT", this.getRecordDef(0));
        return tbl;
    }

    @Override
    public Table getRecordDef(int i) {
        Table tbl = new Table();
        tbl.setKey("NAME", "TEXT");
        return tbl;
    }

    @Override
    public Table getDataTable(double offset) {
        if (offset < 0.0) {
            return null;
        }
        if (this.lines == null) {
            this.readFile();
        }
        Table tbl = null;
        if (offset < (double)this.lines.size() && offset >= 0.0) {
            tbl = new Table();
            tbl.setKey("TEXT", this.lines.get((int)offset));
        }
        return tbl;
    }

    @Override
    public boolean getProtected() {
        return true;
    }

    @Override
    public int getRecordDefCount() {
        return 1;
    }

    @Override
    public int readDataTable(Table tbl) {
        return 0;
    }
}

