/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class ICEPacket
implements PacketHandler {
    private static final String SUBRECORDS_COMMON = "KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD";
    public static final String SUBRECORDS_NORMAL = "KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD,RBST|SL,RBSZ|SL,RBDO|SL,RBDS|SL";
    public static final String SUBRECORDS_ABSC = "KEYS|4B,CNT|SL,ELEM|SL,USER|SI,CHAN|SI,SID|2B,REP|SB,BPA|SB,MODE|SB,TYPE|SB,TCM|SB,TCS|SB,TCO|SD,TCWS|SD,TCFS|SD,XDEL|SD,XSTA|SD";
    public static final int ABSC = 1;
    public static final int FIXED = 2;
    public static final int headerLength = 64;
    private int mhdrs = 8;
    public byte[] buf = new byte[this.mhdrs * 64];
    private int nhdrs = 0;
    private int ihdrs = 0;
    private int ipass = 0;
    private int fixedSize = 0;
    private int bpa = 1;
    private int ipoff = 0;
    private int flags;
    private long count = 0L;
    private double npktoff;
    private byte rep = Shell.rep;
    private static final int ICE_SYNC_1 = 101;
    private static final int ICE_SYNC_2 = 102;
    private static final int ICE_SYNC_3 = 103;
    public static final int HDR_ICE_SYNC_1 = 0;
    public static final int HDR_ICE_SYNC_2 = 1;
    public static final int HDR_ICE_SYNC_3 = 2;
    public static final int HDR_USER_KEY = 3;
    public static final int HDR_COUNT = 4;
    public static final int HDR_SIZE_ELEM = 8;
    public static final int HDR_USER = 12;
    public static final int HDR_CHANNEL = 14;
    public static final int HDR_ID_1 = 16;
    public static final int HDR_ID_2 = 17;
    public static final int HDR_REPRESENTATION = 18;
    public static final int HDR_BPA = 19;
    public static final int HDR_FORMAT = 20;
    public static final int HDR_TC_MODE = 22;
    public static final int HDR_TC_STATUS = 23;
    public static final int HDR_TC_OFFSET = 24;
    public static final int HDR_3_TOTAL_FRAMES = 24;
    public static final int HDR_3_FRAME_COUNT = 26;
    public static final int HDR_3_SPARE_1 = 28;
    public static final int HDR_3_SPARE_2 = 30;
    public static final int HDR_TC_WSEC = 32;
    public static final int HDR_TC_FSEC = 40;
    public static final int HDR_USER_DATA = 48;
    public static final int HDR_USER_DATA_F2 = 52;
    public static final int HDR_USER_DATA_D2 = 56;
    public static final int HDR_USER_DATA_F3 = 56;
    public static final int HDR_USER_DATA_F4 = 60;
    @InternalUseOnly
    public static final int XDELTA_POSITION_IN_USER_DATA = 0;
    @InternalUseOnly
    public static final int XSTART_POSITION_IN_USER_DATA = 1;
    @InternalUseOnly
    public static final long MAX_COUNT = 0xFFFFFFFFL;
    private static final int BYTES_PER_SHORT = 2;
    private static final int BYTES_PER_INTEGER = 4;
    private static final int BYTES_PER_FLOAT = 4;
    private static final int BYTES_PER_DOUBLE = 8;
    private static final int BYTES_PER_LONG = 8;

    public ICEPacket() {
        this("SB", 1024, 0);
    }

    public ICEPacket(byte[] ibuf, int offset) {
        this.setBytes(ibuf, offset);
    }

    public void setBytes(byte[] ibuf, int offset) {
        System.arraycopy(ibuf, offset, this.buf, 0, 64);
        this.rep = this.getRep();
        this.bpa = this.getBPA();
        this.count = this.getUnsignedCount();
    }

    public ICEPacket(String format, int size, int flags) {
        this.flags = flags;
        this.setRep(Shell.rep);
        this.setKeys((byte)0);
        this.setCount(0);
        if ((flags & 2) != 0) {
            this.setFixedSize(size);
        } else {
            this.setSize(size);
        }
        this.setUser((short)0);
        this.setChannel(1);
        this.setID((byte)0, (byte)0);
        this.setFormat(format);
        this.setTC(0, 0, 0.0, 0.0, 0.0);
        if ((flags & 1) != 0) {
            this.setAbscissa(0.0, 1.0);
        }
    }

    public void setKeys(byte userKey) {
        this.buf[0] = 101;
        this.buf[1] = 102;
        this.buf[2] = 103;
        this.setUserKey(userKey);
    }

    public void setUserKey(byte val) {
        this.buf[3] = val;
    }

    public byte getUserKey() {
        return this.buf[3];
    }

    public boolean hasSync() {
        return ICEPacket.hasSync(this.buf, 0);
    }

    public static boolean hasSync(byte[] buf, int boffset) {
        return buf[boffset + 0] == 101 && buf[boffset + 1] == 102 && buf[boffset + 2] == 103;
    }

    public void setCount(int count) {
        this.count = count;
        Convert.packL(this.buf, 4, count, this.rep);
    }

    public void setCount(long count) {
        this.count = count;
        Convert.packL(this.buf, 4, (int)count, this.rep);
    }

    public void upCount() {
        ++this.count;
        Convert.packL(this.buf, 4, (int)this.count, this.rep);
    }

    public void upCount(int n) {
        this.count += (long)n;
        Convert.packL(this.buf, 4, (int)this.count, this.rep);
    }

    public void setSize(int size) {
        Convert.packL(this.buf, 8, size, this.rep);
    }

    public void setUser(short user) {
        Convert.packI(this.buf, 12, user, this.rep);
    }

    public short getUser() {
        return Convert.unpackI(this.buf, 12, this.rep);
    }

    public void setChannel(int channel) {
        Convert.packI(this.buf, 14, (short)channel, this.rep);
    }

    public void setID(byte id1, byte id2) {
        this.buf[16] = id1;
        this.buf[17] = id2;
    }

    public void setRep(byte rep) {
        if (rep != this.rep) {
            Shell.getMidasContext().warning("Normally represention is the Shell default and is not set.  The represention is being changed from " + this.getRepString(this.rep) + " to " + this.getRepString(rep));
        }
        this.buf[18] = this.rep = rep;
    }

    public byte getRep() {
        return this.buf[18];
    }

    public static byte getRep(byte[] buf, int boffset) {
        return buf[boffset + 18];
    }

    public int getBPA() {
        return this.buf[19];
    }

    public void setBPA(int val) {
        this.buf[19] = (byte)val;
        this.bpa = this.buf[19];
    }

    public void setFormat(String format) {
        this.setBPA(Data.getBPA(format));
        this.buf[20] = (byte)format.charAt(0);
        this.buf[21] = (byte)format.charAt(1);
    }

    public void setTC(int mode, int status, double offset, double wsec, double fsec) {
        this.buf[22] = (byte)mode;
        this.buf[23] = (byte)status;
        Convert.packD(this.buf, 24, offset, this.rep);
        Convert.packD(this.buf, 32, wsec, this.rep);
        Convert.packD(this.buf, 40, fsec, this.rep);
    }

    public Time getTC() {
        double wsec = Convert.unpackD(this.buf, 32, this.rep);
        double fsec = Convert.unpackD(this.buf, 40, this.rep);
        return new Time(wsec, fsec);
    }

    public double getTCWSec() {
        return Convert.unpackD(this.buf, 32, this.rep);
    }

    public double getTCFSec() {
        return Convert.unpackD(this.buf, 40, this.rep);
    }

    public double getTCO() {
        return Convert.unpackD(this.buf, 24, this.rep);
    }

    public int getTCMode() {
        return this.buf[22];
    }

    public int getTCStatus() {
        return this.buf[23];
    }

    public void decTCO(int xfer) {
        double tcoff = Convert.unpackD(this.buf, 24, this.rep);
        Convert.packD(this.buf, 24, tcoff - (double)xfer, this.rep);
    }

    public int getTC(Time tc, double offset, double delta) {
        double wsec = Convert.unpackD(this.buf, 32, this.rep);
        double fsec = Convert.unpackD(this.buf, 40, this.rep);
        tc.fromJ1950(wsec, fsec);
        double tcoff = offset - Convert.unpackD(this.buf, 24, this.rep);
        tc.addSec(tcoff * delta);
        return this.buf[23];
    }

    public void setUserData(double val, int pos) {
        Convert.packD(this.buf, 48 + 8 * pos, val, this.rep);
    }

    public void setUserData(long val, int pos) {
        Convert.packX(this.buf, 48 + 8 * pos, val, this.rep);
    }

    public void setUserData(float val, int pos) {
        Convert.packF(this.buf, 48 + 4 * pos, val, this.rep);
    }

    public void setUserData(int val, int pos) {
        Convert.packL(this.buf, 48 + 4 * pos, val, this.rep);
    }

    public void setUserData(short val, int pos) {
        Convert.packI(this.buf, 48 + 2 * pos, val, this.rep);
    }

    public void setUserData(byte val, int pos) {
        this.buf[48 + pos] = val;
    }

    public double getUserDataD(int pos) {
        return Convert.unpackD(this.buf, 48 + 8 * pos, this.rep);
    }

    public long getUserDataX(int pos) {
        return Convert.unpackX(this.buf, 48 + 8 * pos, this.rep);
    }

    public float getUserDataF(int pos) {
        return Convert.unpackF(this.buf, 48 + 4 * pos, this.rep);
    }

    public int getUserDataL(int pos) {
        return Convert.unpackL(this.buf, 48 + 4 * pos, this.rep);
    }

    public short getUserDataI(int pos) {
        return Convert.unpackI(this.buf, 48 + 2 * pos, this.rep);
    }

    public byte getUserDataB(int pos) {
        return this.buf[48 + pos];
    }

    public void setAbscissa(double xstart, double xdelta) {
        Convert.packD(this.buf, 48, xdelta, this.rep);
        Convert.packD(this.buf, 56, xstart, this.rep);
    }

    public void setMode(String mode) {
        this.flags = mode.equals("ABSC") ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setFixedSize(int size) {
        this.fixedSize = size;
        this.setSize(size);
    }

    public int getChannel() {
        return Convert.unpackI(this.buf, 14, this.rep);
    }

    public int getCount() {
        this.count = Convert.unpackL(this.buf, 4, this.rep);
        return (int)this.count;
    }

    @InternalUseOnly
    public long getUnsignedCount() {
        this.count = Convert.unpackL(this.buf, 4, this.rep);
        if (this.count < 0L) {
            this.count = 0x100000000L + this.count;
        }
        return this.count;
    }

    public String getFormat() {
        return Convert.unpackS(this.buf, 20, 2);
    }

    public int getSize() {
        int size = this.fixedSize != 0 ? this.fixedSize : Convert.unpackL(this.buf, 8, this.rep);
        return size;
    }

    public int getBytes() {
        int bytes = this.bpa * Convert.unpackL(this.buf, 8, this.rep);
        return bytes;
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    @Deprecated
    public void setRBData(int off, int value) {
        Convert.packL(this.buf, 48 + off * 4, value, this.rep);
    }

    @Deprecated
    public int getRBData(int off) {
        return Convert.unpackL(this.buf, 48 + off * 4, this.rep);
    }

    @Override
    public String getConfiguration(DataFile df) {
        String config = "ICE";
        if (this.fixedSize != 0) {
            config = config + "/FS=" + this.fixedSize;
        }
        if ((this.flags & 1) != 0) {
            config = config + "/MODE=ABSC";
        }
        if (df.hp != null) {
            config = config + "/DET";
            String aux = df.hp.getAux();
            if (aux != null && aux.length() > 0) {
                config = config + "=" + aux;
            }
        }
        return config;
    }

    @Override
    public void setFileName(DataFile df, FileName filename) {
        DataFile hp = new DataFile();
        hp.init(df.cmd, (Object)filename, "3000", "NH", df.getPacketHandlerFlags());
        if ((this.flags & 1) != 0) {
            hp.setSubRecords(SUBRECORDS_ABSC);
        } else {
            hp.setSubRecords(SUBRECORDS_NORMAL);
        }
        if (this.fixedSize > 0) {
            hp.setSize((int)(df.getSize() / (double)this.fixedSize));
        }
        df.hp = hp;
    }

    @Override
    public double naturalDataOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)bpp);
        return npkt * (double)bpp;
    }

    @Override
    public double dataToPacketOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)bpp);
        double bpkthdr = npkt * 64.0;
        this.ipoff = (int)(boffset - npkt * (double)bpp);
        if (df.hp == null) {
            boffset += bpkthdr;
            if (this.ipoff > 0) {
                boffset += 64.0;
            }
        } else {
            if (this.ipoff > 0) {
                npkt += 1.0;
            }
            this.npktoff = npkt;
        }
        return boffset;
    }

    @Override
    public double packetToDataOffset(DataFile df, double boffset) {
        if (df.hp != null) {
            return boffset;
        }
        int bpp = this.fixedSize * this.bpa;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)(bpp + 64));
        return npkt * (double)bpp;
    }

    @Override
    public void open(DataFile df) {
        this.setFormat(df.getFormat());
        if (df.hp != null) {
            df.hp.open();
        }
    }

    @Override
    public void seek(DataFile df, double boffset) {
        boffset = this.dataToPacketOffset(df, boffset);
        if (df.hp != null) {
            df.hp.seek(this.npktoff);
        }
        if (df.io != null) {
            df.io.seek((long)(df.getDataStart() + boffset));
        }
    }

    @Override
    public int read(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        if (this.ipass == 0) {
            this.nhdrs = 0;
        }
        ++this.ipass;
        if (this.ipoff == 0) {
            if (this.nhdrs == this.mhdrs) {
                this.setMaxHeaders(this.mhdrs * 2);
            }
            if (df.hp != null) {
                df.hp.read(this.buf, this.nhdrs * 64, 64);
            } else {
                df.io.read(this.buf, this.nhdrs * 64, 64);
            }
            ++this.nhdrs;
        }
        int nbp = this.getBytes();
        int nb = Math.min(bytes, nbp - this.ipoff);
        nb = buf != null ? df.io.read(buf, boff, nb) : df.io.read(lbuf, boff, nb);
        if (nb < 0) {
            return nb;
        }
        this.ipoff += nb;
        if (this.ipoff == nbp) {
            this.ipoff = 0;
        }
        if (bytes > nb) {
            nb += this.read(df, buf, boff + nb, bytes - nb, lbuf);
        }
        --this.ipass;
        return nb;
    }

    @Override
    public int write(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        if (this.ipass == 0) {
            this.ihdrs = 0;
        }
        ++this.ipass;
        if (this.ipoff == 0) {
            if (df.hp != null) {
                df.hp.write(this.buf, this.ihdrs * 64, 64);
            } else {
                df.io.write(this.buf, this.ihdrs * 64, 64);
            }
            ++this.ihdrs;
        }
        int nbp = this.getBytes();
        int nb = Math.min(bytes, nbp - this.ipoff);
        nb = buf != null ? df.io.write(buf, boff, nb) : df.io.write(lbuf, boff, nb);
        if (nb < 0) {
            return nb;
        }
        this.ipoff += nb;
        if (this.ipoff == nbp) {
            this.ipoff = 0;
        }
        if (bytes > nb) {
            nb += this.write(df, buf, boff + nb, bytes - nb, lbuf);
        }
        --this.ipass;
        return nb;
    }

    @Override
    public void close(DataFile df) {
        if (df.hp != null) {
            df.hp.close();
        }
    }

    @Override
    public boolean hasHeader() {
        return this.nhdrs > 0;
    }

    @Override
    public String listHeader() {
        String list3 = "ICE-Packet Count=" + this.getUnsignedCount() + " Elem=" + this.getSize() + " Chan=" + this.getChannel() + " Form=" + this.getFormat() + " TC=" + this.getTC() + " at " + this.getTCO();
        return list3;
    }

    @Override
    public PacketHandler cloneOf() {
        PacketHandler ph = null;
        try {
            ph = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ph;
    }

    public void copyFrom(ICEPacket source) {
        this.setBytes(source.buf, 0);
    }

    private void setMaxHeaders(int nmhdrs) {
        byte[] nbuf = new byte[nmhdrs * 64];
        if (this.nhdrs > 0) {
            System.arraycopy(this.buf, 0, nbuf, 0, this.nhdrs * 64);
        }
        this.buf = nbuf;
        this.mhdrs = nmhdrs;
    }

    public void setBuffer(byte[] ibuf, int offset) {
        System.arraycopy(ibuf, offset, this.buf, 0, 64);
    }

    public String toString() {
        String iceHeaderInfo = "ICE Header " + this.getUnsignedCount() + " SYNC: " + this.hasSync() + " User key: " + this.getUserKey() + "\n   Size (elem): " + this.getSize() + "   User: " + this.getUser() + " Channel: " + this.getChannel() + "\n   Rep: " + this.getRep() + " BPA: " + this.getBPA() + "\n   Format: " + this.getFormat() + "   Timecode: " + this.getTC() + "\n   Data 1 / XDELTA: " + this.getUserDataD(0) + " Data 2 / XSTART: " + this.getUserDataD(1) + "\n";
        return iceHeaderInfo;
    }

    private String getRepString(byte rep) {
        String stringRep = "";
        switch ((char)rep) {
            case 'I': {
                stringRep = "IEEE";
                break;
            }
            case 'E': {
                stringRep = "EEEI";
                break;
            }
            case 'V': {
                stringRep = "VAX";
            }
        }
        return stringRep;
    }
}

