/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Webstart;

public class HttpResource
extends IOResource {
    public static final String EXIST_QUAL_KEY = "EXIST";
    public static final String existsList = "Status,CGI,List";
    public static final int CHECK_NONE = 0;
    public static final int CHECK_STATUS = 1;
    public static final int CHECK_CGI = 2;
    public static final int CHECK_LIST = 4;
    public static final int CHECK_ALL = -1;
    public static final int CHECK_DEF = 3;
    private static final String[] CGI_EXT = new String[]{".pl", ".rb", ".py", ".exe", ".csh", ".sh"};
    private static final String boundary = "---------------------------7d012941501d8";
    private static boolean debug = false;
    private int existsFlags = 3;
    private Boolean existResult = null;
    private DataInputStream sis;
    private DataOutputStream sos;
    private URLConnection urlCon;
    private URL url;
    private String userPasswd;
    private boolean isStream;
    private String method;
    private String postMime;
    private byte[] postData;
    private Table responseHeaders;

    public HttpResource() {
    }

    public HttpResource(String url) {
        this.setURL(url);
    }

    @Override
    public void setURL(String str) {
        int i = str.indexOf(64);
        if (i > 0) {
            int passwdLoc = str.indexOf(58) + 3;
            this.userPasswd = str.substring(passwdLoc, i);
            str = str.substring(0, passwdLoc) + str.substring(i + 1);
        }
        this.isStream = str.indexOf("/RAM/_") > 0 || str.indexOf("/ram/_") > 0;
        String prev_urlstr = this.getURL();
        if (!str.equals(prev_urlstr)) {
            super.setURL(str);
            try {
                this.url = new URI(str).toURL();
                this.url = HttpResource.createURLWithPort(this.url);
            }
            catch (Exception e) {
                throw new MidasException("HTTP URL: " + str, e);
            }
            this.existResult = null;
        }
    }

    public String getRequestMethod() {
        return this.getRequestMethod(this.dir);
    }

    private String getRequestMethod(int dir) {
        if (this.method != null) {
            return this.method;
        }
        if (dir <= -1) {
            return "GET";
        }
        if (dir >= 1) {
            return "PUT";
        }
        return "GET/PUT";
    }

    public void setRequestMethod(String val) {
        if (val == null) {
            this.method = null;
        } else if (this.dir <= -1 && (val.equals("GET") || val.equals("POST"))) {
            this.method = val;
        } else if (this.dir >= 1 && val.equals("PUT")) {
            this.method = val;
        } else if (this.dir == 0 && val.equals("GET/PUT")) {
            this.method = val;
        } else {
            throw new MidasException("Use of METHOD=" + val + " is not compatible with " + HttpResource.dirToString(this.dir));
        }
    }

    @Override
    public void setQualifiers(Table table) {
        super.setQualifiers(table);
        if (table == null) {
            return;
        }
        String meth = table.getS("METHOD", this.method);
        String exist = table.getS(EXIST_QUAL_KEY, null);
        this.setRequestMethod(meth);
        this.setExistsFlags(exist);
        if (meth != null && meth.equals("POST")) {
            String mime = table.getS("POSTMIME");
            Object obj = table.get("POSTDATA");
            byte[] data = Convert.o2ba(obj);
            if (obj != null && data == null) {
                throw new MidasException("Unable to convert " + obj + " to bytes.");
            }
            this.setPostData(mime, data);
        }
    }

    public void setPostData(String mime, byte[] data) {
        if (this.postMime == null && this.postData != null) {
            throw new NullPointerException("HttpResource: POST data specified, but no MIME type given.");
        }
        if (this.postMime != null && this.postData == null) {
            throw new NullPointerException("HttpResource: POST MIME type specified, but no data given.");
        }
        this.postMime = mime;
        this.postData = data;
    }

    public byte[] getPostData() {
        return this.postData;
    }

    public String getPostMime() {
        return this.postMime;
    }

    public int getExistsFlags() {
        return this.existsFlags;
    }

    public void setExistsFlags(int flags) {
        if (flags == this.existsFlags) {
            return;
        }
        this.existsFlags = flags;
        this.existResult = null;
    }

    public void setExistsFlags(String flagstr) {
        int mask = Parser.mask(existsList, flagstr, this.existsFlags);
        this.setExistsFlags(mask);
    }

    @Override
    public boolean exists() {
        if (this.url == null) {
            return false;
        }
        if (this.existsFlags == 0) {
            return true;
        }
        if (this.existResult != null) {
            return this.existResult;
        }
        boolean result = false;
        if ((this.existsFlags & 2) != 0 && this.existsCheckCgi()) {
            result = true;
        } else if ((this.existsFlags & 1) != 0 && this.existsCheckStatus()) {
            result = true;
        } else if ((this.existsFlags & 4) != 0 && this.existsCheckList()) {
            result = true;
        }
        this.existResult = result;
        return result;
    }

    public boolean existsCheckStatus() {
        try {
            URLConnection conn = this.openConnection(this.url, this.userPasswd, this.dir, "HEAD");
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.connect();
                int respCode = httpConn.getResponseCode();
                httpConn.disconnect();
                if (respCode == 401) {
                    this.M.info("Authorization required for " + this.url);
                }
                return respCode / 100 == 2;
            }
            return true;
        }
        catch (Exception e) {
            this.M.info(e);
            this.url = null;
            return false;
        }
    }

    public boolean existsCheckList() {
        try {
            int j = this.urlstr.lastIndexOf("/");
            String path = this.urlstr.substring(0, j + 1);
            String name = this.urlstr.substring(j + 1);
            URL root = new URI(path).toURL();
            String[] stringArray = this.getEntryList(root, this.userPasswd, null);
            int n = stringArray.length;
            int n2 = 0;
            if (n2 < n) {
                String fname = stringArray[n2];
                return fname.equals(name);
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean existsCheckCgi() {
        if (this.url.toString().indexOf("?") != -1) {
            return true;
        }
        for (int i = 0; i < CGI_EXT.length; ++i) {
            if (!this.url.getFile().endsWith(CGI_EXT[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStream() {
        return this.isStream;
    }

    @Override
    public boolean isStreaming() {
        return this.isStream && this.isOpen;
    }

    @Override
    public boolean open() {
        this.isOpen = false;
        try {
            String args;
            this.url = HttpResource.createURLWithPort(this.url);
            String surl = this.url.toString();
            int i = surl.indexOf(63);
            String path = i < 0 ? surl : surl.substring(0, i);
            int j = path.lastIndexOf(47);
            String name = j < 0 ? path : path.substring(j + 1);
            String string = args = i < 0 ? "" : surl.substring(i + 1);
            if (this.dir >= 0) {
                String mime = BaseFile.getInstanceFor(this.M, (Object)name).getMimeType();
                this.urlCon = this.openConnection(this.url, this.userPasswd, this.dir, "POST");
                this.urlCon.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------7d012941501d8");
                this.sos = new DataOutputStream(this.urlCon.getOutputStream());
                if (i > 0) {
                    this.sos.writeBytes("-----------------------------7d012941501d8\r\n");
                    this.sos.writeBytes("Content-Disposition: form-data; name=\"params\"\r\n");
                    this.sos.writeBytes("Content-Type: application/x-www-form-urlencoded\r\n");
                    this.sos.writeBytes("\r\n");
                    this.sos.writeBytes(args);
                    this.sos.writeBytes("\r\n");
                    this.sos.writeBytes("-----------------------------7d012941501d8\r\n");
                }
                this.sos.writeBytes("Content-Disposition: form-data; name=\"filedata\"\r\n");
                this.sos.writeBytes("Content-Type: " + mime + "\r\n");
                this.sos.writeBytes("\r\n");
            }
            if (this.dir == 0) {
                this.urlCon = this.openConnection(this.url, this.userPasswd, this.dir, null);
                this.sis = new DataInputStream(this.urlCon.getInputStream());
                this.length = this.urlCon.getContentLength();
            } else if (this.dir <= -1) {
                String meth = this.getRequestMethod(this.dir);
                if (meth.equals("GET")) {
                    this.urlCon = this.openConnection(this.url, this.userPasswd, -1, "GET");
                } else if (meth.equals("POST")) {
                    this.urlCon = this.openConnection(path, this.userPasswd, 0, "POST");
                    this.urlCon.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------7d012941501d8");
                    this.sos = new DataOutputStream(this.urlCon.getOutputStream());
                    this.sos.writeBytes("-----------------------------7d012941501d8\r\n");
                    this.sos.writeBytes("Content-Disposition: form-data; name=\"params\"\r\n");
                    this.sos.writeBytes("Content-Type: application/x-url-encoded\r\n");
                    this.sos.writeBytes("Content-Length: " + args.length() + "\r\n");
                    this.sos.writeBytes("Content-Transfer-Encoding: 7Bit\r\n");
                    this.sos.writeBytes("\r\n");
                    this.sos.writeBytes(args);
                    this.sos.writeBytes("\r\n");
                    if (this.postData != null) {
                        this.sos.writeBytes("-----------------------------7d012941501d8\r\n");
                        this.sos.writeBytes("Content-Disposition: form-data; name=\"data\"\r\n");
                        this.sos.writeBytes("Content-Type: " + this.postMime + "\r\n");
                        this.sos.writeBytes("Content-Length: " + this.postData.length + "\r\n");
                        this.sos.writeBytes("Content-Transfer-Encoding: binary\r\n");
                        this.sos.writeBytes("\r\n");
                        this.sos.write(this.postData);
                        this.sos.writeBytes("\r\n");
                    }
                    this.sos.writeBytes("-----------------------------7d012941501d8--\r\n");
                    this.sos.writeBytes("\r\n");
                    this.sos.flush();
                    this.sos.close();
                    this.sos = null;
                }
                this.sis = new DataInputStream(this.urlCon.getInputStream());
                this.length = this.urlCon.getContentLength();
                this.checkRangeSupport();
                this.checkRangeOfPartials();
            }
            this.isOpen = true;
            if (debug) {
                this.M.type("HttpResource.open() url=" + this.url + " responseHeaders=" + this.urlCon.getHeaderFields());
            }
        }
        catch (Exception e) {
            throw new MidasException("Caught error in HttpResource.open", e);
        }
        return this.isOpen;
    }

    private void checkRangeSupport() throws IOException {
        if (this.offset > 0L) {
            boolean noRangeSupport = false;
            String statusLine = this.urlCon.getHeaderField(0);
            if (statusLine != null) {
                if (statusLine.startsWith("HTTP/1.1 200")) {
                    Object isStrict;
                    String server = this.urlCon.getHeaderField("Server");
                    noRangeSupport = server == null ? ((isStrict = this.getQualifier("STRICTHTTP")) != null ? Convert.o2bool(isStrict, this.M) : this.M.io.isOptionSet(CoreIO.IOOptions.StrictHTTP)) : true;
                } else if (statusLine.startsWith("HTTP/1.0 200")) {
                    noRangeSupport = true;
                }
            }
            if (noRangeSupport) {
                long totalSkipped;
                long curSkipped = 0L;
                for (totalSkipped = 0L; totalSkipped < this.offset && (curSkipped = this.sis.skip(this.offset - totalSkipped)) >= 0L; totalSkipped += curSkipped) {
                }
                if (totalSkipped != this.offset) {
                    this.M.warning("Unable to skip to offset=" + this.offset + " currently at " + totalSkipped + " for url=" + this.url);
                } else if (debug) {
                    this.M.type("HttpResource.open() url=" + this.url + " successfully skipped to offset " + this.offset);
                }
            }
        }
    }

    private void checkRangeOfPartials() throws IOException {
        HttpURLConnection http;
        if (this.urlCon instanceof HttpURLConnection && (http = (HttpURLConnection)this.urlCon).getResponseCode() == 206) {
            Table headers = HttpResource.getHeaders(http);
            String range = headers.getS("Content-Range");
            String type = headers.getS("Content-Type");
            if (range == null) {
                if (type == null || !type.contains("multipart")) {
                    throw new MidasException("Invalid HTTP Patial (206) without range specified.  This probably indicates a problem with an HTTP cache returning invalid content. - headers:" + HttpResource.getHeaders(http));
                }
            } else {
                String[] ranges = range.split("[\\D]+");
                int startRange = Integer.valueOf(ranges[1]);
                if (debug) {
                    this.M.type("HttpResource.checkRangeOfPartials () startRange:" + startRange + " offset:" + this.offset);
                }
                if ((long)startRange != this.offset) {
                    throw new MidasException("Expecting HTTP Partial Content with start:" + this.offset + " but content range is:" + range + " - headers:" + HttpResource.getHeaders(http));
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.sis;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.sos;
    }

    @Override
    public boolean close() {
        if (!this.isOpen) {
            return this.isOpen;
        }
        this.closeConnection(this.url, this.userPasswd, this.dir);
        this.offset = 0L;
        this.isOpen = false;
        return this.isOpen;
    }

    @Override
    public boolean delete() {
        try {
            URLConnection conn = this.openConnection(this.url, this.userPasswd, -1, "DELETE");
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)conn;
                return http.getResponseCode() / 100 == 2;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getLength() {
        if (this.length > 0L) {
            return this.length;
        }
        return this.avail();
    }

    @Override
    public long avail() {
        if (this.sis == null || !this.isOpen) {
            return 0L;
        }
        try {
            long avail = this.sis.available();
            if (this.length > 0L) {
                avail = Math.min(avail, this.length - this.offset);
            }
            return avail;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean seek(long offset) {
        if (this.isOpen && offset != this.offset) {
            this.close();
        }
        this.offset = offset;
        return true;
    }

    @Override
    public int read(byte[] buf, int boff, int bytes) {
        if (!this.isOpen) {
            this.open();
        }
        int status = 0;
        int off = boff;
        while (bytes > 0) {
            try {
                status = this.sis.read(buf, off, bytes);
            }
            catch (IOException e) {
                status = -1;
            }
            if (status <= 0) break;
            bytes -= status;
            off += status;
        }
        bytes = off - boff;
        if (status < 0 && bytes == 0) {
            return status;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public int write(byte[] buf, int boff, int bytes) {
        if (!this.isOpen) {
            this.open();
        }
        try {
            this.sos.write(buf, boff, bytes);
        }
        catch (IOException e) {
            return -1;
        }
        this.offset += (long)bytes;
        return bytes;
    }

    @Override
    public IOResource getEntry(String name) {
        return null;
    }

    @Override
    public String[] getEntryList(FilenameFilter filter) {
        return this.getEntryList(this.url, this.userPasswd, filter);
    }

    private String[] getEntryList(URL url, String userPasswd, FilenameFilter filter) {
        int end;
        StringBuilder sb = new StringBuilder(1024);
        try {
            String line;
            URLConnection conn = this.openConnection(url, userPasswd, -1, "GET");
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
        }
        catch (IOException e) {
            throw new MidasException("Getting EntryList", e);
        }
        String uc = sb.toString().toUpperCase();
        ArrayList<String> list3 = new ArrayList<String>();
        String pathInURL = url.getPath();
        int pos = -1;
        while ((pos = uc.indexOf("<A ", pos + 1)) >= 0 && (end = uc.indexOf("</A>", pos)) >= 0) {
            String link = sb.substring(pos, end + 4);
            String href = HttpResource.getHrefTarget(link);
            if (href == null || href.length() == 0 || href.indexOf(63) >= 0) continue;
            if (href.startsWith(pathInURL)) {
                String tmphref = href.substring(pathInURL.length());
                if (tmphref.length() <= 0 || tmphref.indexOf(47) >= 0) continue;
                list3.add(tmphref);
                continue;
            }
            if (href.indexOf(47) >= 0) continue;
            list3.add(href);
        }
        String[] entries = list3.toArray(EMPTY_STRING_ARRAY);
        return this.filterEntries(filter, entries);
    }

    private URLConnection openConnection(String url, String userPasswd, int ioMode, String meth) throws IOException {
        URL newURL = null;
        try {
            newURL = new URI(url).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return this.openConnection(newURL, userPasswd, ioMode, meth);
    }

    private URLConnection openConnection(URL url, String userPasswd, int ioMode, String meth) throws IOException {
        URLConnection conn;
        if (meth == null) {
            meth = this.getRequestMethod(ioMode);
        }
        double timeout = 0.0;
        double connectTimeout = 0.0;
        String proxyHost = null;
        int proxyPort = -1;
        if (this.qualTable != null) {
            proxyHost = this.qualTable.getS("PROXYHOST");
            proxyPort = this.qualTable.getL("PROXYPORT", 80);
            timeout = this.qualTable.getD("TIMEOUT", 0.0);
            connectTimeout = this.qualTable.getD("CONNECTTIMEOUT", timeout);
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            InetSocketAddress isa = new InetSocketAddress(proxyHost, proxyPort);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, isa);
            conn = url.openConnection(proxy);
        } else {
            conn = url.openConnection();
        }
        String userAgent = "NeXtMidas/4.1.4 Java/" + Shell.getJavaVersion();
        conn.addRequestProperty("User-Agent", userAgent);
        HttpURLConnection http = null;
        if (conn instanceof HttpURLConnection) {
            http = (HttpURLConnection)conn;
        }
        if (timeout > 0.0) {
            int rtimeout = (int)(timeout * 1000.0);
            conn.setReadTimeout(rtimeout);
            if (rtimeout != conn.getReadTimeout()) {
                this.M.warning("This platform is unable to set timeout for " + url + " to " + rtimeout + "ms using " + conn.getReadTimeout() + "ms.");
            }
        }
        if (connectTimeout > 0.0) {
            int ctimeout = (int)(connectTimeout * 1000.0);
            conn.setConnectTimeout(ctimeout);
            if (ctimeout != conn.getConnectTimeout()) {
                this.M.warning("This platform is unable to set timeout for " + url + " to " + ctimeout + "ms using " + conn.getConnectTimeout() + "ms.");
            }
        }
        if (userPasswd != null) {
            String encoding = Convert.encodeBase64(userPasswd);
            conn.setRequestProperty("Authorization", "Basic " + encoding);
        }
        if (this.offset != 0L) {
            String header = "bytes=" + this.offset + "-";
            conn.setRequestProperty("Range", header);
        }
        if (ioMode >= 0) {
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
        }
        if (http != null) {
            http.setRequestMethod(meth);
        }
        if (Shell.getCurrent().parent instanceof Webstart) {
            conn.setUseCaches(false);
        }
        if (debug) {
            this.M.type("HttpResource.openConnection(); url=" + url + " request method=" + meth + " request range:" + conn.getRequestProperty("Range") + " connection headers=" + HttpResource.getHeaders(conn));
        }
        return conn;
    }

    private void closeConnection(URL url, String userPasswd, int ioMode) {
        try {
            if (this.sos != null) {
                this.sos.writeBytes("\r\n-----------------------------7d012941501d8--\r\n");
                this.sos.flush();
                this.sos.close();
                this.sis = new DataInputStream(this.urlCon.getInputStream());
                this.sis.close();
            }
            if (this.sis != null) {
                this.sis.close();
            }
        }
        catch (IOException e) {
            this.M.warning("IO exception in closeURL() call");
        }
    }

    private static String getHrefTarget(String href) {
        String hrefcp = href.toUpperCase();
        int hrefPos = hrefcp.indexOf("HREF=");
        if (hrefPos < 0) {
            return null;
        }
        char quote = href.charAt(hrefPos + 5);
        int end = href.indexOf(quote, hrefPos + 6);
        return end < 0 ? null : href.substring(hrefPos + 6, end);
    }

    public Table getResponseHeaders() {
        if (this.urlCon != null) {
            if (this.responseHeaders == null) {
                this.responseHeaders = HttpResource.getHeaders(this.urlCon);
            }
            return this.responseHeaders;
        }
        return HttpResource.getHeaders(this.urlCon);
    }

    private static Table getHeaders(URLConnection conn) {
        Table headers = new Table();
        if (conn != null) {
            String val;
            String statusLine = conn.getHeaderField(0);
            headers.put("STATUS_LINE", (Object)statusLine);
            int ii = 1;
            while ((val = conn.getHeaderField(ii)) != null) {
                String key = conn.getHeaderFieldKey(ii);
                if (key != null) {
                    headers.put(key, (Object)val);
                }
                ++ii;
            }
        }
        headers.setFlags("+READONLY");
        return headers;
    }

    @Override
    public long lastModified() {
        long utcSecs = this.urlCon == null ? 0L : this.urlCon.getLastModified();
        return utcSecs;
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static URL createURLWithPort(URL url) {
        if (url.getPort() > -1) {
            return url;
        }
        URL urlWithPort = null;
        try {
            urlWithPort = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getDefaultPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            Midas.log("The url was not formed correctly " + url.toString() + " " + e, 0);
        }
        return urlWithPort == null ? url : urlWithPort;
    }

    @InternalUseOnly(value="Testing purposes only")
    public URL getURLObject() {
        return this.url;
    }
}

