/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.SocketResource;
import org.apache.commons.net.ftp.FTPClient;

public class FtpResource
extends SocketResource {
    private FTPClient ftp;
    private String outName;
    private static String userName = "";
    private static String userPass = "";
    private static String ftpDir = "";
    private static final boolean isEmptyVersion = false;

    @Override
    public void setURL(String str) {
        this.urlstr = str;
        if (str.startsWith("ftp://")) {
            str = str.substring(6);
        } else if (str.startsWith("ftp:/")) {
            str = str.substring(5);
        } else if (str.startsWith("ftp:")) {
            str = str.substring(4);
        }
        int i = str.indexOf("/");
        if (i < 0) {
            throw new MidasException("Bad file name. Syntax: ftp:<ip address>:<port>/<filename> or ftp:<ip address>/<filename>");
        }
        this.outName = str.substring(i + 1);
        if ((i = (str = str.substring(0, i)).indexOf(":")) > 0) {
            this.port = Convert.s2l(str.substring(i + 1));
            this.host = str.substring(0, i);
        } else {
            this.port = -1;
            this.host = str;
        }
    }

    @Override
    public boolean open() {
        block11: {
            this.isOpen = false;
            double dataTOut = 0.0;
            double soTOut = 0.0;
            if (this.qualTable != null) {
                userName = this.qualTable.getS("USER", userName);
                userPass = this.qualTable.getS("PASS", userPass);
                ftpDir = this.qualTable.getS("FTPDIR", ftpDir);
                dataTOut = this.qualTable.getD("TIMEOUT", dataTOut);
                soTOut = this.qualTable.getD("SOTIMEOUT", soTOut);
            }
            int soTOutMs = (int)(soTOut * 1000.0);
            if (soTOut > 0.0 && soTOutMs <= 0) {
                soTOutMs = 1;
            }
            this.timeout = (int)(dataTOut * 1000.0);
            if (dataTOut > 0.0 && this.timeout <= 0) {
                this.timeout = 1;
            }
            try {
                this.ftp = new FTPClient();
                if (this.port > 0) {
                    this.ftp.connect(this.host, this.port);
                } else {
                    this.ftp.connect(this.host);
                }
                this.ftp.setSoTimeout(soTOutMs);
                this.ftp.login(userName, userPass);
                this.ftp.setDataTimeout(Duration.ofMillis(this.timeout));
                this.ftp.setFileType(2);
                if (!ftpDir.equals("")) {
                    this.ftp.cwd(ftpDir);
                }
                if (this.dir > 0) {
                    this.sos = this.getOutputStream(false);
                    System.out.printf("Putting file: %s on ftp:%s\n", this.outName, this.host);
                } else if (this.dir <= 0) {
                    this.sis = this.getInputStream(false);
                    System.out.printf("getting file: %s on ftp:%s\n", this.outName, this.host);
                }
                this.isOpen = true;
            }
            catch (Exception e) {
                if (!this.M.debug(256)) break block11;
                this.M.warning("FtpResource - exception during open()" + e);
            }
        }
        return this.isOpen;
    }

    @Override
    public boolean close() {
        try {
            if (this.sis != null) {
                this.sis.close();
                this.sis = null;
            }
            if (this.sos != null) {
                this.sos.close();
                this.sos = null;
            }
            if (this.ftp != null) {
                this.ftp.logout();
                this.ftp.disconnect();
                this.ftp = null;
            }
            this.isOpen = false;
        }
        catch (IOException e) {
            this.isOpen = true;
        }
        return this.isOpen;
    }

    @Override
    protected InputStream getInputStream(boolean indefinite) {
        while (this.isOpen && this.sis == null) {
            try {
                this.sis = this.ftp.retrieveFileStream(this.outName);
            }
            catch (Exception e) {
                throw new MidasException("Error getting file! " + e);
            }
        }
        return this.sis;
    }

    @Override
    protected OutputStream getOutputStream(boolean indefinite) {
        while (this.isOpen && this.sos == null) {
            try {
                this.sos = this.ftp.storeFileStream(this.outName);
            }
            catch (Exception e) {
                throw new MidasException("Error putting file! " + e);
            }
        }
        return this.sos;
    }

    @InternalUseOnly
    public static boolean getIsEmptyVersion() {
        return false;
    }
}

