/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;

public final class FortranUtil {
    private FortranUtil() {
    }

    public static void wrapperByteBuffer(File file) throws IOException {
        FortranUtil.wrapperByteBuffer(file, false);
    }

    public static void wrapperByteBuffer(File file, boolean isStatic) throws IOException {
        new BBMake(file, isStatic).processFile();
    }

    public static void wrapFortranStruct(File inFile, File outFile, File jniFile, String structure, String varName) throws IOException {
        FortranUtil.wrapFortranStruct(inFile, outFile, jniFile, structure, varName, null, null, false);
    }

    public static void wrapFortranStruct(File inFile, File outFile, File jniFile, String structure, String varName, String subs, String includes, boolean pkgPrivate) throws IOException {
        boolean isStatic;
        block2: {
            isStatic = varName != null && varName.trim().length() > 0;
            BBConv bbconv = new BBConv(subs, includes, isStatic, pkgPrivate);
            try {
                bbconv.process(inFile, outFile, jniFile, structure, varName);
            }
            catch (Exception e) {
                if (bbconv.includeList.empty()) break block2;
                throw new MidasException(bbconv.includeList.peek() + ": " + e.getMessage(), e);
            }
        }
        BBMake.processFile(outFile, isStatic);
    }

    private static class BBConv {
        static final boolean USE_JAVADOC_BREAK = true;
        private Vector<Struct> structs = new Vector();
        private Hashtable<String, Struct> structsMap = new Hashtable();
        private Stack<InputFile> includeList = new Stack();
        private final String classSubs;
        private final String includes;
        private final boolean isStatic;
        private final boolean pkgPrivate;

        private BBConv(String subs, String includes, boolean isStatic, boolean pkgPrivate) {
            this.classSubs = subs == null ? "Class_" : subs;
            this.includes = includes;
            this.isStatic = isStatic;
            this.pkgPrivate = pkgPrivate;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void process(File in, File outFile, File jniFile, String structure, String varName) throws IOException {
            this.includeList.push(new InputFile(in));
            PrintStream out = new PrintStream(new FileOutputStream(outFile));
            PrintStream jni = this.isStatic ? new PrintStream(new FileOutputStream(jniFile)) : null;
            Stack<String> unionDepth = new Stack<String>();
            Vector<JavaDef> defs = null;
            Vector<JavaDef> defines = new Vector<JavaDef>();
            Hashtable<String, JavaDef> definesMap = new Hashtable<String, JavaDef>();
            String line = this.getIn().readLine();
            String nextLine = this.getIn().readLine();
            String structName = null;
            String byteOffset = "0";
            String maxOffset = null;
            String[] nextLines = null;
            while (!this.includeList.isEmpty()) {
                block57: {
                    block55: {
                        JavaDef[] javaDefArray;
                        JavaDef jdef;
                        int n;
                        String comment;
                        block64: {
                            block63: {
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                block58: {
                                                    block56: {
                                                        if ((line = line.replaceAll("[\t]", "    ")).startsWith(" ")) break block56;
                                                        nextLines = this.readNextLines(nextLine);
                                                        line = nextLines[0];
                                                        nextLine = nextLines[1];
                                                        break block57;
                                                    }
                                                    if (nextLine == null || !nextLine.startsWith("     &")) break block58;
                                                    line = line + nextLine.substring(6);
                                                    nextLine = this.getIn().readLine();
                                                    break block57;
                                                }
                                                comment = null;
                                                int commentStart = line.indexOf(33);
                                                if (commentStart >= 0) {
                                                    comment = line.substring(commentStart + 1).replaceAll("\t", " ").trim();
                                                    line = line.substring(0, line.indexOf(33));
                                                } else {
                                                    comment = "";
                                                }
                                                line = line.replaceAll("[ ]", "").toUpperCase();
                                                if (line.length() == 0 || line.equals("IMPLICITNONE") || line.startsWith("EXTERNAL")) break block55;
                                                if (structName != null || !line.startsWith("STRUCTURE/") || !line.endsWith("/")) break block59;
                                                structName = line.substring(10, line.length() - 1);
                                                defs = new Vector<JavaDef>();
                                                break block55;
                                            }
                                            if (structName == null || !line.equals("ENDSTRUCTURE")) break block60;
                                            Struct struct = new Struct(this.toTitleCase(structName), BBConv.max(maxOffset, byteOffset), defs.toArray(new JavaDef[0]), comment);
                                            this.structs.add(struct);
                                            this.structsMap.put(struct.getName(), struct);
                                            structName = null;
                                            defs = null;
                                            byteOffset = "0";
                                            maxOffset = null;
                                            break block55;
                                        }
                                        if (structName == null || !line.equals("UNION")) break block61;
                                        unionDepth.push(byteOffset);
                                        break block55;
                                    }
                                    if (structName == null || !line.equals("ENDUNION") || unionDepth.size() <= 0) break block62;
                                    unionDepth.pop();
                                    byteOffset = maxOffset;
                                    break block55;
                                }
                                if (structName != null && line.equals("MAP") && unionDepth.size() > 0) break block55;
                                if (structName == null || !line.equals("ENDMAP") || unionDepth.size() <= 0) break block63;
                                maxOffset = BBConv.max(maxOffset, byteOffset);
                                byteOffset = ((String)unionDepth.peek()).toString();
                                break block55;
                            }
                            if (structName != null) break block64;
                            if (line.startsWith("PARAMETER(") && line.endsWith(")") && line.indexOf(61) > 0) {
                                String string = line.substring(10, line.indexOf(61));
                                String string2 = line.substring(line.indexOf(61) + 1, line.length() - 1);
                                JavaDef jdef2 = (JavaDef)definesMap.get(string);
                                if (jdef2 != null) {
                                    jdef2.setValue(string2);
                                    break block55;
                                } else {
                                    out.close();
                                    if (jni != null) {
                                        jni.close();
                                    }
                                    throw new RuntimeException("Can not find '" + string + "' as specified in '" + line + "'.");
                                }
                            }
                            if (line.startsWith("POINTER(") && line.endsWith(")")) {
                                Shell.info("Skipping POINTER  definition not used in Java (" + line + ").");
                                break block55;
                            } else if (line.startsWith("COMMON")) {
                                Shell.info("Skipping COMMON   definition not used in Java (" + line + ").");
                                break block55;
                            } else {
                                JavaDef[] javaDefArray2;
                                JavaDef[] javaDefArray3 = javaDefArray2 = this.toJavaDef(line, null, comment);
                                int jdef2 = javaDefArray3.length;
                                for (n = 0; n < jdef2; ++n) {
                                    jdef = javaDefArray3[n];
                                    defines.add(jdef);
                                    definesMap.put(jdef.getName(), jdef);
                                }
                            }
                            break block55;
                        }
                        JavaDef[] javaDefArray4 = javaDefArray = this.toJavaDef(line, byteOffset, comment);
                        int jdef2 = javaDefArray4.length;
                        for (n = 0; n < jdef2; ++n) {
                            jdef = javaDefArray4[n];
                            byteOffset = BBConv.add(byteOffset, jdef.getByteLength());
                            defs.add(jdef);
                            String type = jdef.getType();
                            if (jdef.getSize() == null) continue;
                            type = type + "[" + jdef.getSize() + "]";
                        }
                    }
                    nextLines = this.readNextLines(nextLine);
                    line = nextLines[0];
                    nextLine = nextLines[1];
                }
                if (line != null) continue;
                this.getIn().close();
                this.includeList.pop();
                line = "";
                nextLine = "";
            }
            if (structure == null || structure.length() == 0) {
                structure = null;
            } else {
                Iterator<Struct> commentStart;
                Struct mainStruct = this.structsMap.get(this.toTitleCase(structure));
                if (mainStruct != null) {
                    this.setUsageFlags(mainStruct);
                    out.println("/***********************************/");
                    out.println("/* THIS IS AN AUTO-GENERATED CLASS */");
                    out.println("/*       !!! DO NOT EDIT !!!       */");
                    out.println("/***********************************/");
                    out.println("// <BBMakeDefs>");
                    commentStart = this.structs.iterator();
                } else {
                    out.close();
                    if (jni != null) {
                        jni.close();
                    }
                    throw new MidasException("Structure '" + this.toTitleCase(structure) + "' not found.");
                }
                while (commentStart.hasNext()) {
                    Struct struct = commentStart.next();
                    JavaDef[] javaDefArray = struct.getJavaDefs();
                    if (!struct.isUsed()) continue;
                    if (this.toTitleCase(structure).equals(struct.getName())) {
                        out.println("// <MAIN>");
                    } else {
                        out.println("// <" + struct.getName() + " size=\"" + struct.getBytes() + "\">");
                    }
                    for (int j = 0; j < javaDefArray.length; ++j) {
                        String name = this.toTitleCase(javaDefArray[j].getName());
                        String off = javaDefArray[j].getOffset();
                        if (j != 0) {
                            String guess1 = BBConv.add(javaDefArray[j - 1].getOffset(), javaDefArray[j - 1].getByteLength());
                            String guess2 = BBConv.add(javaDefArray[j - 1].getByteLength(), javaDefArray[j - 1].getOffset());
                            if (off.equals(guess1) || off.equals(guess2)) {
                                off = "~";
                            }
                        }
                        String str = "//  " + StringUtil.padLeft(off, 4) + ", ";
                        str = str + javaDefArray[j].getType();
                        if (javaDefArray[j].getSize() != null) {
                            str = str + "[" + javaDefArray[j].getSize() + "]";
                        }
                        str = StringUtil.padRight(str, 30);
                        str = str + ", get" + name;
                        str = StringUtil.padRight(str, 55);
                        str = str + ", set" + name;
                        str = StringUtil.padRight(str, 80);
                        str = str + ", \"" + javaDefArray[j].getComment() + "\"";
                        out.println(str);
                    }
                    if (this.toTitleCase(structure).equals(struct.getName())) {
                        out.println("// </MAIN>");
                        continue;
                    }
                    out.println("// </" + struct.getName() + ">");
                }
                out.println("// </BBMakeDefs>");
            }
            String pkgName = outFile.getAbsolutePath();
            String className = outFile.getName();
            pkgName = pkgName.startsWith(Shell.getNmRoot()) ? pkgName.substring(Shell.getNmRoot().length()).replace(File.separatorChar, '.') : pkgName.replace(File.separatorChar, '.');
            if (className.endsWith(".java")) {
                className = className.substring(0, className.length() - 5);
            }
            if (pkgName.startsWith(".")) {
                pkgName = pkgName.substring(1);
            }
            if (pkgName.endsWith(className + ".java")) {
                pkgName = pkgName.substring(0, pkgName.length() - (className + ".java").length() - 1);
            }
            out.println("package " + pkgName + ";");
            out.println();
            out.println("import java.nio.ByteBuffer;");
            out.println("import java.nio.ByteOrder;");
            out.println();
            out.println("import nxm.sys.lib.Shell;");
            out.println();
            out.println();
            out.println("/** A class that wraps the native " + structure + " structure for " + varName + "; this is an automatically generated class. DO NOT EDIT!!!\n    @author Auto-Generated by: CONVERT IN=" + in + " CONV=FSTRUCT2JAVA OUT=" + outFile + " FORM=" + structure + "\n */");
            if (this.pkgPrivate) {
                out.println("class " + className + " {");
            } else {
                out.println("public class " + className + " {");
            }
            if (structure != null) {
                if (this.isStatic) {
                    out.println("  /** Loads the JNI library. */");
                    out.println("  static {");
                    out.println("    Shell.loadLibrary(" + className + ".class.getName());");
                    out.println("  }");
                    out.println("  ");
                    out.println("  /** The byte buffer to use. */");
                    out.println("  private static ByteBuffer byteBuffer;");
                    out.println("  ");
                    out.println("  /** Creates a new instance. */");
                    out.println("  private " + className + "() { }");
                    out.println("  ");
                    out.println("  /** Gets the byte buffer.");
                    out.println("      @return The byte buffer.");
                    out.println("   */");
                    out.println("  public static ByteBuffer getByteBuffer() {");
                    out.println("    if (byteBuffer == null) {");
                    out.println("      byteBuffer = getByteBuffer0();");
                    out.println("      byteBuffer.order(ByteOrder.nativeOrder());");
                    out.println("    }");
                    out.println("    return byteBuffer;");
                    out.println("  }");
                    out.println("  ");
                    out.println("  /** Gets the byte buffer. This should only be called by getByteBuffer().<br>");
                    out.println("      <br>");
                    out.println("      WARNING: The byte buffer returned by this method will need to have its");
                    out.println("               byte order set using byteBuffer.order(ByteOrder.nativeOrder())");
                    out.println("               before it can be accessed.");
                    out.println("               ");
                    out.println("      @return The byte buffer.");
                    out.println("   */");
                    out.println("  private static native ByteBuffer getByteBuffer0();");
                    out.println("  ");
                } else {
                    out.println("  /** The byte buffer to use. */");
                    out.println("  private final ByteBuffer byteBuffer;");
                    out.println("  ");
                    out.println("  /** Creates a new instance.");
                    out.println("      @param byteBuffer The byte buffer to use.");
                    out.println("   */");
                    out.println("  public " + className + "(ByteBuffer byteBuffer) {");
                    out.println("    this.byteBuffer = byteBuffer;");
                    out.println("  }");
                    out.println("  ");
                    out.println("  /** Gets the byte buffer.");
                    out.println("      @return The byte buffer.");
                    out.println("   */");
                    out.println("  public ByteBuffer getByteBuffer() {");
                    out.println("    return byteBuffer;");
                    out.println("  }");
                }
            }
            for (JavaDef javaDef : defines) {
                String flags = "public static final";
                String type = javaDef.getType();
                String value = "";
                String cmt = "unknown";
                boolean skip = false;
                if (javaDef.getComment() != null && javaDef.getComment().trim().length() > 0) {
                    cmt = javaDef.getComment();
                }
                if (javaDef.getValue() != null) {
                    value = " = " + javaDef.getValue();
                } else {
                    if (structure == null) {
                        skip = true;
                    }
                    flags = "protected";
                }
                if (structure != null && this.toTitleCase(structure).equals(type)) {
                    type = className;
                    if (value.equals("")) {
                        flags = "public static final";
                        value = " = new " + className + "()";
                    }
                } else if (type.startsWith("Boolean(") && type.endsWith(")")) {
                    type = type.substring(8, type.length() - 1);
                } else if (type.indexOf("String(") >= 0 && type.endsWith(")")) {
                    type = "String";
                    if (value != null && value.startsWith(" = '") && value.endsWith("'")) {
                        value = " = \"" + value.substring(4, value.length() - 1) + "\"";
                    }
                } else {
                    value = value.replaceAll("([0-9]+)([dDeE][+])([0-9]+)", "$1e$3");
                    value = value.replaceAll("([0-9]+)([dDeE][-])([0-9]+)", "$1e$3");
                    if (type.equals("float")) {
                        value = value + "f";
                    }
                    if (type.equals("double")) {
                        value = value + "d";
                    }
                }
                if (this.structsMap.get(type) != null && !this.structsMap.get(type).isUsed()) {
                    skip = true;
                }
                if (!skip) {
                    cmt = cmt.replaceAll("[.]", "&#46;");
                    out.println("  /** " + cmt + " */");
                    out.println("  " + flags + " " + type + " " + javaDef.getName() + value + ";");
                    out.println("  ");
                    continue;
                }
                Shell.info("Skipping VARIABLE definition not used in Java (" + javaDef.getName() + ").");
            }
            out.println("}");
            out.println();
            String string = pkgName.replace('.', '_') + "_" + className;
            if (this.isStatic) {
                jni.println("");
                if (this.includes != null && this.includes.trim().length() > 0) {
                    String[] stringArray;
                    for (String includeFile : stringArray = this.includes.trim().split("[,]")) {
                        if ((includeFile = includeFile.trim()).length() <= 0) continue;
                        if (includeFile.startsWith("<") && includeFile.endsWith(">")) {
                            jni.println("#include " + includeFile);
                            continue;
                        }
                        jni.println("#include \"" + includeFile + "\"");
                    }
                }
                jni.println("#include <" + string + ".h>");
                jni.println("");
                jni.println("");
                jni.println("#ifdef __cplusplus");
                jni.println("extern \"C\"");
                jni.println("{");
                jni.println("#endif");
                jni.println("");
                jni.println("");
                jni.println("JNIEXPORT jobject JNICALL Java_" + string + "_getByteBuffer0(JNIEnv * env, jclass obj) {");
                jni.println("  return (*env)->NewDirectByteBuffer(env, " + varName + ", sizeof(" + structure + "));");
                jni.println("}");
                jni.println("");
                jni.println("#ifdef __cplusplus");
                jni.println("}");
                jni.println("#endif");
                jni.close();
            }
            this.getIn().close();
            out.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private JavaDef[] toJavaDef(String line, String offset, String comment) {
            JavaDef jdef = null;
            JavaDef[] jdefs = null;
            int indexStar = line.indexOf(42);
            int indexParens = line.indexOf(40);
            String primType = null;
            String typeLen = null;
            String arrayLen = null;
            String name = null;
            if (line.startsWith("RECORD/")) {
                String ln = line.substring(7);
                int end = ln.indexOf(47);
                primType = ln.substring(0, end);
                name = ln.substring(end + 1);
                if (name.indexOf(40) > 1) {
                    arrayLen = BBConv.getArrayLength(name.substring(name.indexOf(40) + 1, name.indexOf(41)));
                    name = name.substring(0, name.indexOf(40));
                }
                jdef = new JavaDef(this.toTitleCase(primType), arrayLen, name, offset, comment, null, true);
            } else if (indexStar > 0 && (indexParens < 0 || indexParens > indexStar)) {
                int end;
                primType = line.substring(0, indexStar);
                if (line.charAt(indexStar + 1) == '(') {
                    end = line.indexOf(41);
                    typeLen = line.substring(indexStar + 2, end);
                    name = line.substring(end + 1);
                } else {
                    for (end = indexStar + 1; end <= line.length() && Character.isDigit(line.charAt(end)); ++end) {
                    }
                    typeLen = line.substring(indexStar + 1, end);
                    name = line.substring(end);
                }
                if (name.indexOf(40) > 1) {
                    arrayLen = BBConv.getArrayLength(name.substring(name.indexOf(40) + 1, name.indexOf(41)));
                    name = name.substring(0, name.indexOf(40));
                }
                String totalLen = null;
                if (arrayLen != null && arrayLen.indexOf(44) > 0) {
                    String mult = null;
                    while (arrayLen.indexOf(44) > 0) {
                        String subLength = arrayLen.substring(0, arrayLen.indexOf(44));
                        arrayLen = arrayLen.substring(arrayLen.indexOf(44) + 1);
                        mult = BBConv.mul(mult, subLength);
                    }
                    arrayLen = BBConv.mul(mult, arrayLen);
                }
                totalLen = BBConv.mul(typeLen, arrayLen);
                if (primType.equals("INTEGER")) {
                    if (typeLen.equals("1")) {
                        jdef = new JavaDef("byte", arrayLen, name, offset, comment);
                    } else if (typeLen.equals("2")) {
                        jdef = new JavaDef("short", arrayLen, name, offset, comment);
                    } else if (typeLen.equals("4")) {
                        jdef = new JavaDef("int", arrayLen, name, offset, comment);
                    } else {
                        if (!typeLen.equals("8")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                        jdef = new JavaDef("long", arrayLen, name, offset, comment);
                    }
                } else if (primType.equals("FLOAT") || primType.equals("REAL")) {
                    if (typeLen.equals("4")) {
                        jdef = new JavaDef("float", arrayLen, name, offset, comment);
                    } else {
                        if (!typeLen.equals("8")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                        jdef = new JavaDef("double", arrayLen, name, offset, comment);
                    }
                } else if (primType.equals("COMPLEX")) {
                    if (typeLen.equals("8")) {
                        jdef = new JavaDef("float[2]", arrayLen, name, offset, comment);
                    } else {
                        if (!typeLen.equals("16")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                        jdef = new JavaDef("double[2]", arrayLen, name, offset, comment);
                    }
                } else if (primType.equals("LOGICAL")) {
                    if (typeLen.equals("1")) {
                        jdef = new JavaDef("Boolean(byte)", arrayLen, name, offset, comment);
                    } else if (typeLen.equals("2")) {
                        jdef = new JavaDef("Boolean(short)", arrayLen, name, offset, comment);
                    } else if (typeLen.equals("4")) {
                        jdef = new JavaDef("Boolean(int)", arrayLen, name, offset, comment);
                    } else {
                        if (!typeLen.equals("8")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                        jdef = new JavaDef("Boolean(long)", arrayLen, name, offset, comment);
                    }
                } else if (primType.equals("BYTE")) {
                    jdef = typeLen.equals("1") ? new JavaDef("byte", arrayLen, name, offset, comment) : new JavaDef("byte", totalLen, name, offset, comment);
                } else {
                    if (!primType.equals("CHARACTER")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                    jdef = totalLen.equals("1") ? new JavaDef("AsciiChar", null, name, offset, comment) : new JavaDef("FortranString(" + totalLen + ")", null, name, offset, comment);
                }
            } else if (line.startsWith("BYTE")) {
                jdefs = this.toJavaDef("BYTE*1" + line.substring(4), offset, comment);
            } else {
                if (!line.startsWith("CHARACTER")) throw new RuntimeException("Unknown type '" + primType + "' in '" + line + "'.");
                jdefs = this.toJavaDef("CHARACTER*1" + line.substring(9), offset, comment);
            }
            if (jdefs != null) return jdefs;
            if (jdef.getName().indexOf(44) <= 1) return new JavaDef[]{jdef};
            String[] varNames = jdef.getName().split(",");
            jdefs = new JavaDef[varNames.length];
            int i = 0;
            while (i < varNames.length) {
                jdefs[i] = new JavaDef(jdef.getType(), jdef.getSize(), varNames[i], jdef.getOffset(), jdef.getComment());
                ++i;
            }
            return jdefs;
        }

        private void setUsageFlags(Struct struct) {
            JavaDef[] params;
            struct.setUsed(true);
            for (JavaDef javaDef : params = struct.getJavaDefs()) {
                Struct type = this.structsMap.get(javaDef.getType());
                if (type == null || type.isUsed()) continue;
                this.setUsageFlags(type);
            }
        }

        private static String getArrayLength(String length) {
            String arrayLen = null;
            int comma = length.indexOf(44);
            int colon = length.indexOf(58);
            if (comma > 0) {
                arrayLen = BBConv.mul(BBConv.getArrayLength(length.substring(0, comma)), BBConv.getArrayLength(length.substring(comma + 1)));
            } else if (colon > 0) {
                String first = length.substring(0, length.indexOf(58));
                String last = length.substring(length.indexOf(58) + 1);
                arrayLen = first.equals("1") ? last : (first.equals("0") ? BBConv.add(last, "1") : BBConv.add(last, "1") + "-" + first);
            } else {
                arrayLen = length;
            }
            return arrayLen;
        }

        static String add(String a, String b) {
            String res = BBConv.tryQuickMath(a, b, "0");
            if (res == null) {
                a = BBConv.removeParens(a);
                b = BBConv.removeParens(b);
                int indexA = a.lastIndexOf(43);
                int indexB = b.lastIndexOf(43);
                res = StringUtil.isInteger(a) && StringUtil.isInteger(b) ? Integer.toString(Convert.s2l(a) + Convert.s2l(b)) : (indexA > 0 && StringUtil.isInteger(a.substring(indexA + 1)) ? a.substring(0, indexA) + "+" + BBConv.add(a.substring(indexA + 1), b) : (indexB > 0 && StringUtil.isInteger(b.substring(indexB + 1)) ? b.substring(0, indexB) + "+" + BBConv.add(a, b.substring(indexB + 1)) : (StringUtil.isInteger(a) ? BBConv.addParens(b) + "+" + BBConv.addParens(a) : BBConv.addParens(a) + "+" + BBConv.addParens(b))));
            }
            return res;
        }

        static String mul(String a, String b) {
            String res = BBConv.tryQuickMath(a, b, "1");
            if (res == null) {
                a = BBConv.removeParens(a);
                b = BBConv.removeParens(b);
                res = StringUtil.isInteger(a) && StringUtil.isInteger(b) ? Integer.toString(Convert.s2l(a) * Convert.s2l(b)) : BBConv.addParens(a) + "*" + BBConv.addParens(b);
            }
            return res;
        }

        static String max(String a, String b) {
            String res = BBConv.tryQuickMath(a, b, "0");
            if (res == null) {
                a = BBConv.removeParens(a);
                b = BBConv.removeParens(b);
                if (a.startsWith("Math.max") && a.endsWith(")") && b.startsWith("Math.max") && b.endsWith(")")) {
                    String numA = a.substring(9, a.indexOf(44)).trim();
                    String strA = a.substring(a.indexOf(44) + 1, a.length() - 1).trim();
                    String numB = b.substring(9, b.indexOf(44)).trim();
                    String strB = b.substring(b.indexOf(44) + 1, b.length() - 1).trim();
                    if (StringUtil.isNumber(numA) && StringUtil.isNumber(numB)) {
                        a = BBConv.max(numA, numB);
                        b = BBConv.max(strA, strB);
                    } else if (StringUtil.isNumber(numA)) {
                        a = numA;
                        b = BBConv.max(strA, b);
                    } else if (StringUtil.isNumber(numB)) {
                        a = numB;
                        b = BBConv.max(strB, a);
                    }
                } else if (a.startsWith("Math.max") && a.endsWith(")")) {
                    String numA = a.substring(9, a.indexOf(44)).trim();
                    String strA = a.substring(a.indexOf(44) + 1, a.length() - 1).trim();
                    if (StringUtil.isNumber(numA) && StringUtil.isNumber(b)) {
                        a = BBConv.max(numA, b);
                        b = strA;
                    } else if (StringUtil.isNumber(numA)) {
                        a = numA;
                        b = BBConv.max(strA, b);
                    }
                } else if (b.startsWith("Math.max") && b.endsWith(")")) {
                    String numB = b.substring(9, b.indexOf(44)).trim();
                    String strB = b.substring(b.indexOf(44) + 1, b.length() - 1).trim();
                    if (StringUtil.isNumber(numB) && StringUtil.isNumber(a)) {
                        a = BBConv.max(numB, a);
                        b = strB;
                    } else if (StringUtil.isNumber(numB)) {
                        a = numB;
                        b = BBConv.max(strB, a);
                    }
                }
                if (StringUtil.isInteger(a) && StringUtil.isInteger(b)) {
                    res = Integer.toString(Math.max(Convert.s2l(a), Convert.s2l(b)));
                } else {
                    if (!a.startsWith("Math.max(") || !a.endsWith(")")) {
                        a = BBConv.addParens(a);
                    }
                    if (!b.startsWith("Math.max(") || !b.endsWith(")")) {
                        b = BBConv.addParens(b);
                    }
                    res = StringUtil.isInteger(b) ? "Math.max(" + b + ", " + a + ")" : "Math.max(" + a + ", " + b + ")";
                }
            }
            return res;
        }

        private static String addParens(String str) {
            if (!str.matches("[0-9A-Za-z_]+")) {
                str = "(" + str + ")";
            }
            return str;
        }

        private static String removeParens(String str) {
            str = str.trim();
            while (str.startsWith("(") && str.endsWith(")")) {
                str = str.substring(1, str.length() - 1).trim();
            }
            return str;
        }

        private static String tryQuickMath(String a, String b, String ident) {
            String res = null;
            if (a == null) {
                res = b;
            } else if (b == null) {
                res = a;
            } else if (a.equals(ident)) {
                res = b;
            } else if (b.equals(ident)) {
                res = a;
            }
            return res;
        }

        static String getPrimitiveLength(String type) {
            String length = null;
            if (type != null) {
                if (type.equals("double")) {
                    length = "8";
                }
                if (type.equals("float")) {
                    length = "4";
                }
                if (type.equals("long")) {
                    length = "8";
                }
                if (type.equals("int")) {
                    length = "4";
                }
                if (type.equals("short")) {
                    length = "2";
                }
                if (type.equals("byte")) {
                    length = "1";
                }
                if (type.equals("char")) {
                    length = "2";
                }
            }
            return length;
        }

        static String getLength(String type) {
            String length = BBConv.getPrimitiveLength(type);
            if (length == null) {
                if (type.startsWith("Boolean(") && type.endsWith(")")) {
                    length = BBConv.getPrimitiveLength(type.substring(8, type.length() - 1).trim());
                } else if (type.equals("AsciiChar")) {
                    length = "1";
                } else if (type.startsWith("AsciiString(")) {
                    length = type.substring(12, type.length() - 1);
                } else if (type.startsWith("FortranString(")) {
                    length = type.substring(14, type.length() - 1);
                } else if (type.startsWith("CString(")) {
                    length = type.substring(8, type.length() - 1);
                }
            }
            return length;
        }

        private String toTitleCase(String str) {
            if (str != null && str.length() != 0) {
                if (str.length() == 1) {
                    str = str.toUpperCase();
                } else {
                    str = Character.toUpperCase(str.charAt(0)) + str.substring(1).toLowerCase();
                    int index = 0;
                    if (str.endsWith("_")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    while ((index = str.indexOf(95)) > 0) {
                        if (str.length() >= index + 2) {
                            str = str.substring(0, index) + Character.toUpperCase(str.charAt(index + 1)) + str.substring(index + 2);
                            continue;
                        }
                        str = str.substring(0, index) + Character.toUpperCase(str.charAt(index + 1));
                    }
                }
            }
            if (str.endsWith("struct")) {
                str = str.subSequence(0, str.length() - 6) + "Struct";
            }
            if (str.equals("Class")) {
                str = this.classSubs;
            }
            return str;
        }

        private BufferedReader getIn() {
            return this.includeList.peek().getReader();
        }

        private String[] readNextLines(String nextLine) throws IOException {
            String tempNextLine;
            String line = null;
            String string = tempNextLine = nextLine != null ? nextLine.replaceAll("[ \t]", "").toUpperCase() : "";
            if (tempNextLine.indexOf(33) >= 0) {
                tempNextLine = tempNextLine.substring(0, tempNextLine.indexOf(33));
            }
            if (tempNextLine.startsWith("INCLUDE") && tempNextLine.endsWith("'")) {
                String fname = tempNextLine.substring(8, tempNextLine.length() - 1);
                String url = Shell.getSharedMidasContext().io.findResource(fname, -1).getURL();
                if (!url.startsWith("file:")) {
                    throw new MidasException("Can't find include file '" + fname + "'");
                }
                this.includeList.push(new InputFile(new File(url.substring(5))));
                line = "";
                nextLine = this.getIn().readLine();
            } else {
                line = nextLine;
                nextLine = this.getIn().readLine();
            }
            return new String[]{line, nextLine};
        }

        private static class InputFile {
            private final File file;
            private final LineNumberReader lineNum;
            private final BufferedReader in;

            public InputFile(File inFile) throws IOException {
                this.file = inFile;
                this.lineNum = new LineNumberReader(new FileReader(inFile));
                this.in = new BufferedReader(this.lineNum);
            }

            public String toString() {
                return this.file.getName() + "(" + this.lineNum.getLineNumber() + ")";
            }

            private BufferedReader getReader() {
                return this.in;
            }
        }

        private static class Struct {
            private String bytes;
            private String name;
            private JavaDef[] defs;
            private String comment;
            private boolean used = false;

            public Struct(String name, String bytes, JavaDef[] defs, String comment) {
                this.name = name;
                this.bytes = bytes;
                this.defs = defs;
                this.comment = comment;
            }

            private String getName() {
                return this.name;
            }

            private String getComment() {
                return this.comment;
            }

            private String getBytes() {
                return this.bytes;
            }

            private JavaDef[] getJavaDefs() {
                return this.defs;
            }

            private boolean isUsed() {
                return this.used;
            }

            private void setUsed(boolean used) {
                this.used = used;
            }
        }

        private class JavaDef {
            private String type;
            private String size;
            private String name;
            private String offset;
            private String comment;
            private String val;
            private boolean rec;

            public JavaDef(String type, String size, String name, String offset, String comment) {
                this(type, size, name, offset, comment, null, false);
            }

            public JavaDef(String type, String size, String name, String offset, String comment, String val, boolean isRecord) {
                this.type = type;
                this.size = size;
                this.name = name;
                this.offset = offset;
                this.comment = comment;
                this.val = val;
                this.rec = isRecord;
            }

            private void setValue(String val) {
                this.val = val;
            }

            private String getType() {
                return this.type;
            }

            private String getSize() {
                return this.size;
            }

            private String getName() {
                return this.name;
            }

            private String getValue() {
                return this.val;
            }

            private String getOffset() {
                return this.offset;
            }

            private String getComment() {
                return this.comment;
            }

            private boolean isRecord() {
                return this.rec;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private String getByteLength() {
                String bytes = null;
                if (!this.isRecord()) return BBConv.mul(BBConv.getLength(this.getType()), this.getSize());
                Struct struct = (Struct)BBConv.this.structsMap.get(this.getType());
                if (struct == null) throw new RuntimeException("Can not reference '" + this.getType() + "' before it is defined.");
                return BBConv.mul(struct.getBytes(), this.getSize());
            }
        }
    }

    private static class BBMake {
        private static final String BBMAKE_DEFS_START = "\\s*//\\s*[<]BBMakeDefs[>].*";
        private static final String BBMAKE_DEFS_END = "\\s*//\\s*[<]/BBMakeDefs[>].*";
        private static final String BBMAKE_GENCODE_START = "\\s*//\\s*[<]BBMakeGenCode[>].*";
        private static final String BBMAKE_GENCODE_END = "\\s*//\\s*[<]/BBMakeGenCode[>].*";
        private static final String tab = "  ";
        private int insertIndex = -1;
        private Vector<String> fileData = new Vector();
        private Vector<RecordDef> records = new Vector();
        private Hashtable<String, RecordDef> recordsMap = new Hashtable();
        private Vector<String> dumpCode = new Vector();
        private String index = null;
        private File file = null;
        private boolean isStatic;
        private static final String SET_PRIMITIVE_VALUE = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$($type$ val) {\n    getByteBuffer().$method$($pos$, val);\n  }\n";
        private static final String SET_PRIMITIVE_ARRAY = "  /** Sets the $text$.\n      @param val The $text$ (must be an array of size $size$).\n   */\n  $mods$ void $name$($type$[] val) {\n    if (val.length != $size$) {\n      throw new IllegalArgumentException(\"$name$: expected array of\"\n        + \"length $size$, given array of length \"+val.length+\".\");\n    }\n    for (int i = 0; i < val.length; i++) {\n      int off = i * $bytes$;\n      getByteBuffer().$method$(($pos$)+off, val[i]);\n    }\n  }\n  /** Sets the $text$ at the specified index.\n      @param val The $text$ at the specified index.\n      @since 3.1.2\n   */\n  $mods$ void $name$At(int index, $type$ val) {\n    if (index >= $size$) {\n      throw new IllegalArgumentException(\"$name$: index [\"+index+\"] is out of range [\"+$size$+\"]\");\n    }\n    int off = index * $bytes$;\n    getByteBuffer().$method$(($pos$)+off, val);\n  }\n";
        private static final String SET_PRIMITIVE_ARRAY_FROM_SHORT_TO_BYTE = "  /** Sets the $text$ at the specified index by an short integer value.\n      This is meant for INTERNAL USE ONLY and is subject to change/removal.\n      @param val The $text$ at the specified index (this short integer will be casted to a byte integer).\n      @since 3.1.3\n   */\n  $mods$ final void $name$At(int index, short val) {\n    $name$At(index, (byte)val);\n  }\n";
        private static final String GET_PRIMITIVE_VALUE = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ $type$ $name$() {\n    return getByteBuffer().$method$($pos$);\n  }\n";
        private static final String GET_PRIMITIVE_ARRAY = "  /** gets the $text$.\n      @return The $text$ (an array of size $size$).\n   */\n  $mods$ $type$[] $name$() {\n    $type$[] val = new $type$[$size$];\n    for (int i = 0; i < val.length; i++) {\n      int off = i * $bytes$;\n      val[i] = getByteBuffer().$method$(($pos$)+off);\n    }\n    return val;\n  }\n  /** Gets the $text$ at the specified index.\n      @return The $text$ at the specified index.\n      @since 3.1.2\n   */\n  $mods$ $type$ $name$At(int index) {\n    int off = index * $bytes$;\n    $type$ val = getByteBuffer().$method$(($pos$)+off);\n    return val;\n  }";
        private static final String SET_ASCII_CHAR = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(char val) {\n    if (val > 0x7f) {\n      throw new IllegalArgumentException(\"Expected ASCII character given '\"+val+\"'.\");\n    }\n    getByteBuffer().put($pos$, (byte)val);\n  }\n";
        private static final String GET_ASCII_CHAR = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ char $name$() {\n    return (char)getByteBuffer().get($pos$);\n  }\n";
        private static final String SET_ASCII_STRING = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(String val) {\n    for (int i = 0; i < $size$; i++) {\n      if (i < val.length()) {\n        char letter = val.charAt(i);\n        if (letter > 0x7f) {\n          throw new IllegalArgumentException(\"Expected ASCII character given '\"+letter+\"'.\");\n        } else {\n            getByteBuffer().put(($pos$)+i, (byte)letter);\n        }\n      } else {\n        getByteBuffer().put(($pos$)+i, (byte)' ');\n      }\n    }\n  }\n";
        private static final String SET_FORTRAN_STRING = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(String val) {\n    for (int i = 0; i < $size$; i++) {\n      if (i < val.length()) {\n        char letter = val.charAt(i);\n        if (letter > 0x7f) {\n          throw new IllegalArgumentException(\"Expected ASCII character given '\"+letter+\"'.\");\n        } else {\n            getByteBuffer().put(($pos$)+i, (byte)letter);\n        }\n      } else {\n        getByteBuffer().put(($pos$)+i, (byte)' ');\n      }\n    }\n  }\n";
        private static final String SET_C_STRING = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(String val) {\n    final byte NULL = 0;\n    for (int i = 0; i < $size$; i++) {\n      if (i < val.length()) {\n        char letter = val.charAt(i);\n        if (letter > 0x7f) {\n          throw new IllegalArgumentException(\"Expected ASCII character \"\ngiven '\"+letter+\"'.\");\n        } else {\n            getByteBuffer().put(($pos$)+i, (byte)letter);\n        }\n      } else {\n        getByteBuffer().put(($pos$)+i, NULL);\n      }\n    }\n  }\n";
        private static final String GET_ASCII_STRING = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ String $name$() {\n    StringBuilder str = new StringBuilder();\n    \n    for (int i = 0; i < $size$; i++) {\n      str.append((char)getByteBuffer().get(($pos$)+i));\n    }\n    return str.toString();\n  }\n";
        private static final String GET_FORTRAN_STRING = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ String $name$() {\n    StringBuilder str = new StringBuilder();\n    StringBuilder pad = null; // Trailing spaces\n    \n    for (int i = 0; i < $size$; i++) {\n      char letter = (char)getByteBuffer().get(($pos$)+i);\n      \n      if (i == 0) {\n        str.append(letter);\n      } else if (letter == ' ') {\n        if (pad == null) {\n          pad = new StringBuilder(\" \");\n        } else {\n          pad.append(letter);\n        }\n      } else {\n        if (pad != null) {\n          str.append(pad);\n          pad = null;\n        }\n        str.append(letter);\n      }\n    }\n    return str.toString();\n  }\n";
        private static final String GET_C_STRING = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ String $name$() {\n    final byte NULL = 0;\n    StringBuilder str = new StringBuilder();\n    \n    for (int i = 0; i < $size$; i++) {\n      char letter = (char)getByteBuffer().get(($pos$)+i);\n      \n      if (letter == NULL) {\n        break;\n      } else {\n        str.append(letter);\n      }\n    }\n    return str.toString();\n  }\n";
        private static final String SET_BOOLEAN = "  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(boolean val) {\n    byte num = (val)? (byte)1 : 0;\n    getByteBuffer().$method$($pos$, num);\n  }\n";
        private static final String GET_BOOLEAN = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ boolean $name$() {\n    return (getByteBuffer().$method$($pos$) != 0);\n  }\n";
        private static final String GET_RECORD_VALUE = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ $type$ $name$() {\n    return new $type$(getByteBuffer(), $pos$);\n  }\n";
        private static final String GET_RECORD_ARRAY = "  /** Gets the $text$.\n      @return The $text$.\n   */\n  $mods$ $type$[] $name$() {\n    $type$[] val = new $type$[$size$];\n    for (int i = 0; i < val.length; i++) {\n      int offset = i * $bytes$;\n      val[i] = new $type$(getByteBuffer(), ($pos$)+offset);\n    }\n    return val;\n  }\n";
        private static final String CLASS_DEFINITION_START = "  /** Defines the $name$ structure. */\n  public static class $name$ {\n    /** The byte buffer. */\n    private final ByteBuffer byteBuffer;\n    \n    /** The offset index. */\n    private final int offset;\n    \n    /** Creates a new instance.\n        @param byteBuffer The byte buffer.\n        @param offset     The offset index.\n     */\n    private $name$(ByteBuffer byteBuffer, int offset) {\n      this.byteBuffer = byteBuffer;\n      this.offset     = offset;\n    }\n    /** Gets the byte buffer.\n        @return The byte buffer.\n     */\n    private ByteBuffer getByteBuffer() {\n      return byteBuffer;\n    }\n";
        private static final String CLASS_DEFINITION_END = "  }\n";

        private BBMake(File file, boolean isStatic) {
            this.file = file;
            this.isStatic = isStatic;
        }

        public static void processFile(File file) throws IOException {
            BBMake.processFile(file, false);
        }

        public static void processFile(File file, boolean isStatic) throws IOException {
            new BBMake(file, isStatic).processFile();
        }

        private void processFile() throws IOException {
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            this.readFile(in);
            in.close();
            PrintStream out = new PrintStream(new FileOutputStream(this.file));
            this.writeFile(out);
            out.close();
        }

        private void readFile(BufferedReader in) throws IOException {
            String line;
            int lastCloseBrace = -1;
            block0: while ((line = in.readLine()) != null) {
                if (line.matches(BBMAKE_DEFS_START)) {
                    RecordDef recdef = null;
                    this.fileData.add(line);
                    while ((line = in.readLine()) != null) {
                        this.fileData.add(line);
                        if (line.matches(BBMAKE_DEFS_END)) continue block0;
                        String def = line.trim();
                        if (def.startsWith("//")) {
                            def = def.substring(2).trim();
                        }
                        if (def.startsWith("#") || def.length() == 0) continue;
                        if (recdef != null && def.startsWith("<")) {
                            String tag = "</" + recdef.getName() + ">";
                            if (def.equals(tag)) {
                                recdef = null;
                                continue;
                            }
                            throw new RuntimeException("Expected '" + tag + "', but found '" + def + "'.");
                        }
                        if (recdef == null && def.startsWith("<")) {
                            if (def.equals("<MAIN>")) {
                                recdef = new RecordDef("MAIN", null);
                            } else {
                                int index = def.indexOf(" size=");
                                if (index < 0) {
                                    throw new RuntimeException("No size specified for record '" + def + "'.");
                                }
                                String name = def.substring(1, index).trim();
                                String size = def.substring(index + 6, def.length() - 1).trim();
                                if (size.startsWith("\"") && size.endsWith("\"")) {
                                    size = size.substring(1, size.length() - 1).trim();
                                }
                                if (size.length() == 0 || size.indexOf(34) > 0) {
                                    throw new RuntimeException("Illegal size specified for record '" + def + "'.");
                                }
                                recdef = new RecordDef(name, size);
                            }
                            this.records.add(recdef);
                            this.recordsMap.put(recdef.getName(), recdef);
                            continue;
                        }
                        if (recdef == null) {
                            throw new RuntimeException("Definition is not part of a given record '" + def + "'.");
                        }
                        recdef.getRecordDefs().add(def);
                    }
                    continue;
                }
                if (line.matches(BBMAKE_GENCODE_START)) {
                    this.insertIndex = this.fileData.size();
                    while ((line = in.readLine()) != null && !line.matches(BBMAKE_GENCODE_END)) {
                    }
                    continue;
                }
                if (line.trim().equals("}")) {
                    lastCloseBrace = this.fileData.size();
                }
                this.fileData.add(line);
            }
            if (this.insertIndex < 0) {
                this.insertIndex = lastCloseBrace;
            }
            in.close();
        }

        private void writeFile(PrintStream out) throws IOException {
            for (int i = 0; i < this.fileData.size(); ++i) {
                if (i == this.insertIndex) {
                    this.writeCode(out);
                }
                out.println(this.fileData.get(i));
            }
        }

        private void writeCode(PrintStream out) throws IOException {
            out.println("  // <BBMakeGenCode>//GEN-BEGIN:BBMakeGenCode");
            out.println("  /* This next section of code generated by BBDEF2JAVA in CONVERT.");
            out.println("     DO NOT EDIT THIS CODE, it will be re-written every time");
            out.println("     BBDEF2JAVA is run and any changes will be lost.");
            out.println("   */");
            out.println("  //   <editor-fold defaultstate=\"collapsed\" desc=\" Generated Code \">");
            RecordDef main = this.recordsMap.get("MAIN");
            if (main != null) {
                this.writeCode(out, main, true);
                String mods = this.isStatic ? "public static" : "public";
                String spaces = "                    ";
                out.println("  /** Dumps the data in the buffer to a String. This method is for");
                out.println("      debugging purposes only its syntax may change in the future");
                out.println("      without notice.");
                out.println("      ");
                out.println("      @return A string listing the current data in the buffer.");
                out.println("   */");
                out.println(tab + mods + " String dumpData() {");
                out.println("    StringBuilder sb = new StringBuilder();");
                for (String method : this.dumpCode) {
                    String pad = spaces.substring(Math.min(spaces.length(), method.length()));
                    out.println("    sb.append(\"" + method + pad + " = \").append(" + method + "()" + pad + ").append('\\n');");
                }
                out.println("    return sb.toString();");
                out.println("  }");
            }
            for (RecordDef rec : this.records) {
                if (rec.getName().equals("MAIN")) continue;
                out.println(CLASS_DEFINITION_START.replaceAll("[$]name[$]", rec.getName()));
                this.writeCode(out, rec, false);
                out.println("    /** Summarizes the record.");
                out.println("        @return A string listing the current data in the record.");
                out.println("     */");
                out.println("    public String toString() {");
                out.println("      StringBuilder sb = new StringBuilder();");
                out.println("      sb.append(\"" + rec.getName() + ": {\");");
                for (String method : this.dumpCode) {
                    out.println("      sb.append(\" " + method + " = \").append(" + method + "());  ");
                }
                out.println("      sb.append(\" }\");");
                out.println("      return sb.toString();");
                out.println("    }");
                out.println(CLASS_DEFINITION_END);
            }
            out.println("  //   </editor-fold>");
            out.println("  // </BBMakeGenCode>//GEN-END:BBMakeGenCode");
        }

        private void writeCode(PrintStream out, RecordDef def, boolean isMain) throws IOException {
            Vector<String> recordDefs = def.getRecordDefs();
            this.setIndex("0");
            this.dumpCode.clear();
            for (String record : recordDefs) {
                this.writeMethod(out, record, isMain);
            }
        }

        private void writeMethod(PrintStream out, String def, boolean isMain) throws IOException {
            String[] defs = this.parseDefs(def);
            String pos = defs[0];
            String type = defs[1].replaceAll("[ ]", "");
            String getName = defs[2];
            String setName = defs[3];
            String text = defs[4];
            String size = null;
            String getMethod = null;
            String setMethod = null;
            if (pos.equals("~")) {
                pos = this.getIndex();
            } else {
                this.setIndex(pos);
            }
            if (!isMain) {
                pos = "(this.offset + (" + pos + "))";
            }
            if (text.startsWith("\"")) {
                text = text.substring(1).trim();
            }
            if (text.endsWith("\"")) {
                text = text.substring(0, text.length() - 1).trim();
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1).trim();
            }
            if (getName.length() == 0) {
                getName = "<none>";
            }
            if (setName.length() == 0) {
                setName = "<none>";
            }
            if (text.length() == 0) {
                text = "unknown";
            }
            if (type.indexOf("(") > 0 && type.endsWith(")")) {
                String strType = type.substring(0, type.indexOf("(")).trim();
                String strSize = type.substring(type.indexOf("(") + 1, type.length() - 1).trim();
                type = strType;
                size = strSize;
            }
            if (type.indexOf("[") > 0 && type.endsWith("]")) {
                String primType = type.substring(0, type.indexOf("[")).trim();
                String arraySize = type.substring(type.indexOf("[") + 1, type.length() - 1).trim();
                type = primType;
                size = arraySize;
            }
            if (BBConv.getPrimitiveLength(type) != null) {
                String bytes = BBConv.getPrimitiveLength(type);
                String get = null;
                String set = null;
                if (type.equals("byte")) {
                    get = "get";
                    set = "put";
                } else {
                    get = "get" + type.substring(0, 1).toUpperCase() + type.substring(1);
                    set = "put" + type.substring(0, 1).toUpperCase() + type.substring(1);
                }
                if (!getName.equals("<none>")) {
                    getMethod = size == null ? this.useTemplate(GET_PRIMITIVE_VALUE, text, getName, type, get, pos, size, bytes) : this.useTemplate(GET_PRIMITIVE_ARRAY, text, getName, type, get, pos, size, bytes);
                }
                if (!setName.equals("<none>")) {
                    if (size == null) {
                        setMethod = this.useTemplate(SET_PRIMITIVE_VALUE, text, setName, type, set, pos, size, bytes);
                    } else {
                        setMethod = this.useTemplate(SET_PRIMITIVE_ARRAY, text, setName, type, set, pos, size, bytes);
                        if (setName.equals("setReadAux") && type.equals("byte")) {
                            setMethod = setMethod + this.useTemplate(SET_PRIMITIVE_ARRAY_FROM_SHORT_TO_BYTE, text, setName, type, set, pos, size, bytes);
                        }
                    }
                }
                this.addToIndex(BBConv.getPrimitiveLength(type), size);
            } else if (type.equals("AsciiChar") && size == null) {
                if (!getName.equals("<none>")) {
                    getMethod = this.useTemplate(GET_ASCII_CHAR, text, getName, null, null, pos, null, null);
                }
                if (!setName.equals("<none>")) {
                    setMethod = this.useTemplate(SET_ASCII_CHAR, text, setName, null, null, pos, null, null);
                }
                this.addToIndex("1");
            } else if (size != null && type.equals("AsciiString")) {
                if (!getName.equals("<none>")) {
                    getMethod = this.useTemplate(GET_ASCII_STRING, text, getName, null, null, pos, size, null);
                }
                if (!setName.equals("<none>")) {
                    setMethod = this.useTemplate("  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(String val) {\n    for (int i = 0; i < $size$; i++) {\n      if (i < val.length()) {\n        char letter = val.charAt(i);\n        if (letter > 0x7f) {\n          throw new IllegalArgumentException(\"Expected ASCII character given '\"+letter+\"'.\");\n        } else {\n            getByteBuffer().put(($pos$)+i, (byte)letter);\n        }\n      } else {\n        getByteBuffer().put(($pos$)+i, (byte)' ');\n      }\n    }\n  }\n", text, setName, null, null, pos, size, null);
                }
                this.addToIndex(size);
            } else if (size != null && type.equals("CString")) {
                if (!getName.equals("<none>")) {
                    getMethod = this.useTemplate(GET_C_STRING, text, getName, null, null, pos, size, null);
                }
                if (!setName.equals("<none>")) {
                    setMethod = this.useTemplate(SET_C_STRING, text, setName, null, null, pos, size, null);
                }
                this.addToIndex(size);
            } else if (size != null && type.equals("FortranString")) {
                if (!getName.equals("<none>")) {
                    getMethod = this.useTemplate(GET_FORTRAN_STRING, text, getName, null, null, pos, size, null);
                }
                if (!setName.equals("<none>")) {
                    setMethod = this.useTemplate("  /** Sets the $text$.\n      @param val The $text$.\n   */\n  $mods$ void $name$(String val) {\n    for (int i = 0; i < $size$; i++) {\n      if (i < val.length()) {\n        char letter = val.charAt(i);\n        if (letter > 0x7f) {\n          throw new IllegalArgumentException(\"Expected ASCII character given '\"+letter+\"'.\");\n        } else {\n            getByteBuffer().put(($pos$)+i, (byte)letter);\n        }\n      } else {\n        getByteBuffer().put(($pos$)+i, (byte)' ');\n      }\n    }\n  }\n", text, setName, null, null, pos, size, null);
                }
                this.addToIndex(size);
            } else if (BBConv.getPrimitiveLength(size) != null && type.equals("Boolean")) {
                String get = null;
                String set = null;
                if (size.equals("byte")) {
                    get = "get";
                    set = "put";
                } else {
                    get = "get" + size.substring(0, 1).toUpperCase() + size.substring(1);
                    set = "put" + size.substring(0, 1).toUpperCase() + size.substring(1);
                }
                if (!getName.equals("<none>")) {
                    getMethod = this.useTemplate(GET_BOOLEAN, text, getName, size, get, pos, null, null);
                }
                if (!setName.equals("<none>")) {
                    setMethod = this.useTemplate(SET_BOOLEAN, text, setName, size, set, pos, null, null);
                }
                this.addToIndex(BBConv.getPrimitiveLength(size));
            } else if (!type.equals("MAIN") && this.recordsMap.get(type) != null) {
                RecordDef recdef = this.recordsMap.get(type);
                String bytes = recdef.getSize();
                if (!getName.equals("<none>")) {
                    getMethod = size == null ? this.useTemplate(GET_RECORD_VALUE, text, getName, type, null, pos, size, bytes) : this.useTemplate(GET_RECORD_ARRAY, text, getName, type, null, pos, size, bytes);
                }
                this.addToIndex(bytes, size);
            } else {
                throw new RuntimeException("Invalid type '" + type + "'");
            }
            if (isMain && this.isStatic) {
                if (getMethod != null) {
                    getMethod = getMethod.replaceAll("[$]mods[$]", "public static");
                }
                if (setMethod != null) {
                    setMethod = setMethod.replaceAll("[$]mods[$]", "public static");
                }
            } else {
                if (getMethod != null) {
                    getMethod = getMethod.replaceAll("[$]mods[$]", "public");
                }
                if (setMethod != null) {
                    setMethod = setMethod.replaceAll("[$]mods[$]", "public");
                }
                if (!isMain) {
                    if (getMethod != null) {
                        getMethod = tab + getMethod.replaceAll("\n", "\n  ");
                    }
                    if (setMethod != null) {
                        setMethod = tab + setMethod.replaceAll("\n", "\n  ");
                    }
                }
            }
            if (getMethod != null) {
                out.println(getMethod);
            }
            if (setMethod != null) {
                out.println(setMethod);
            }
            if (getMethod != null) {
                this.dumpCode.add(getName);
            }
        }

        private String[] parseDefs(String def) {
            Parser parser = new Parser(def);
            parser.clean(false);
            return parser.getArray(parser.elements());
        }

        private String getIndex() {
            if (this.index == null) {
                this.index = "0";
            }
            return this.index;
        }

        private void setIndex(String val) {
            this.index = val;
        }

        private void addToIndex(String val) {
            this.index = BBConv.add(this.index, val);
        }

        private void addToIndex(String val, String mult) {
            this.addToIndex(BBConv.mul(val, mult));
        }

        private String useTemplate(String temp, String text, String name, String type, String method, String pos, String size, String bytes) {
            if (text == null) {
                text = "";
            }
            if (name == null) {
                name = "";
            }
            if (type == null) {
                type = "";
            }
            if (method == null) {
                method = "";
            }
            if (pos == null) {
                pos = "";
            }
            if (size == null) {
                size = "";
            }
            if (bytes == null) {
                bytes = "";
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
            text = text.replaceAll("[.]", "&#46;");
            return temp.replaceAll("[$]text[$]", StringUtil.textToReplacement(text)).replaceAll("[$]name[$]", StringUtil.textToReplacement(name)).replaceAll("[$]type[$]", StringUtil.textToReplacement(type)).replaceAll("[$]method[$]", StringUtil.textToReplacement(method)).replaceAll("[$]pos[$]", StringUtil.textToReplacement(pos)).replaceAll("[$]size[$]", StringUtil.textToReplacement(size)).replaceAll("[$]bytes[$]", StringUtil.textToReplacement(bytes));
        }

        private static class RecordDef {
            private final String name;
            private final String size;
            private final Vector<String> defs = new Vector();

            public RecordDef(String name, String size) {
                this.name = name;
                this.size = size;
            }

            public String getName() {
                return this.name;
            }

            public String getSize() {
                return this.size;
            }

            public Vector<String> getRecordDefs() {
                return this.defs;
            }
        }
    }
}

