/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.File;
import java.io.FilenameFilter;
import nxm.sys.lib.FileName;

public abstract class FileVisitor {
    private FilenameFilter filter;
    private String ignore = "CVS";

    public FileVisitor(FilenameFilter ff) {
        this.filter = ff;
    }

    public void execute(String name) {
        File fd = new File(name);
        this.execute(fd);
    }

    public void addIgnore(String newIgnore) {
        if (this.ignore.indexOf(newIgnore) == -1) {
            this.ignore = this.ignore + "|" + newIgnore;
        }
    }

    public boolean isValidArea(File file) {
        if (file.isFile()) {
            return true;
        }
        FileName fname = new FileName(file.getAbsolutePath());
        String[] elems = fname.getPathElements();
        if (elems.length > 2) {
            String name = elems[elems.length - 1].toUpperCase();
            String gparentName = elems[elems.length - 3].toUpperCase();
            if (name.equals("NXM") && gparentName.equals("NXM")) {
                return false;
            }
        }
        return true;
    }

    public void execute(File fd) {
        if (fd == null || !fd.exists()) {
            return;
        }
        if (this.ignore.indexOf(fd.getName()) >= 0) {
            return;
        }
        if (fd.isDirectory()) {
            if (this.isValidArea(fd)) {
                String[] contents = fd.list(this.filter);
                for (int i = 0; i < contents.length; ++i) {
                    this.execute(new File(fd, contents[i]));
                }
            }
        } else if (this.filter.accept(fd.getParentFile(), fd.getName())) {
            this.visit(fd.getAbsolutePath());
        }
    }

    public abstract void visit(String var1);
}

