/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.ListFile;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class DbfFile
extends BaseFile
implements ListFile {
    public static final int BUFSZ = 32;
    private int fileCode;
    private int fileLength;
    private int dataStart;
    private int recordSize;
    private List<Field> fields;

    public DbfFile() {
    }

    @Deprecated
    public DbfFile(Object ref, Object filename) {
        if (ref instanceof MidasReference) {
            this.init((MidasReference)ref, filename);
        } else {
            this.init(Convert.ref2Midas(ref), filename);
        }
    }

    public DbfFile(MidasReference ref, Object filename) {
        this.init(ref, filename);
    }

    @Override
    public double getNumberOfRows() {
        return this.fileLength;
    }

    @Override
    public double getSize() {
        return this.fileLength;
    }

    @Override
    public boolean getProtected() {
        return false;
    }

    @Override
    public int getRecordDefCount() {
        return this.fields.size();
    }

    @Override
    public final void removeData(double o) {
        this.removeData(o, 1L);
    }

    @Override
    public int seek(double o) {
        return super.seek(this.toByteOffset(o));
    }

    @Override
    public String toString() {
        return "DbfFile " + (this.io != null ? this.io.getTypeString() : "") + " Resource";
    }

    @Override
    public String listHeader() {
        StringBuilder str = new StringBuilder(256);
        str.append("DbfFile     :  ").append(this.getURL()).append('\n');
        str.append("File Code   :  ").append(this.fileCode).append('\n');
        str.append("Record Size :  ").append(this.recordSize).append('\n');
        str.append("Data Start  :  ").append(this.dataStart).append('\n');
        str.append("Size        :  ").append(this.getSize()).append('\n');
        if (this.fields != null) {
            str.append("Fields      :  ").append(this.fields.size()).append('\n');
            this.fields.forEach(f -> str.append("  ").append(f).append('\n'));
        } else {
            str.append("Fields      :  n/a\n");
        }
        return str.toString();
    }

    @Override
    public String listElements(double start, int elements, String format, int flags) {
        return this.getDataTable(start) + "\n";
    }

    @Override
    public int listElementsPerLine(int lineWidth, String form, int flags) {
        return 1;
    }

    @InternalUseOnly(value="Only used by LayerShape")
    public String[] getElementArray(String elem) {
        return this.getElementArray(elem, 0, this.fileLength - 1);
    }

    @InternalUseOnly(value="Only used by LayerShape")
    public String[] getElementArray(String elem, int first, int last) {
        String[] vals = new String[last - first + 1];
        int n = 0;
        for (int i = first; i <= last; ++i) {
            Table t = this.getDataTable(i);
            vals[n++] = t.getS(elem);
        }
        return vals;
    }

    @Deprecated
    public String getTypeString() {
        return "unknown";
    }

    @Override
    public boolean open() {
        if (!super.open()) {
            return false;
        }
        if ((this.flags & 1) != 0) {
            byte[] hb = new byte[1024];
            this.io.read(hb, 0, 32, 0L);
            this.fileCode = hb[0];
            this.fileLength = Convert.unpackL(hb, 4, (byte)69);
            this.dataStart = Convert.unpackI(hb, 8, (byte)69);
            this.recordSize = Convert.unpackI(hb, 10, (byte)69);
            int numFields = (this.dataStart - 32 - 1) / 32;
            int start = 1;
            this.fields = new ArrayList<Field>(numFields);
            for (int i = 0; i < numFields; ++i) {
                Field f = new Field(this, start);
                start += f.getLength();
                this.fields.add(f);
            }
        } else {
            this.fileCode = 3;
            this.fileLength = 0;
            this.dataStart = 33;
            this.recordSize = 0;
            this.fields = new ArrayList<Field>(8);
            this.update();
        }
        return true;
    }

    @Override
    public void update() {
        byte[] hb = new byte[32];
        byte[] eoh = new byte[]{13};
        Time now = Time.currentTime();
        int newDataStart = this.fields.size() * 32 + 32 + 1;
        if (newDataStart < this.dataStart) {
            this.removeBytes(32L, newDataStart - this.dataStart);
        }
        if (newDataStart > this.dataStart) {
            this.insertBytes(32L, newDataStart - this.dataStart);
        }
        this.dataStart = newDataStart;
        this.recordSize = 1;
        int off = 32;
        for (Field f : this.fields) {
            this.io.write(f.buf, 0, f.buf.length, off);
            off += f.buf.length;
            this.recordSize += f.length;
        }
        this.io.write(eoh, 0, eoh.length, off);
        Convert.packB(hb, 0, (byte)this.fileCode);
        Convert.packB(hb, 1, (byte)(now.getYear() % 100));
        Convert.packB(hb, 2, (byte)now.getMonth());
        Convert.packB(hb, 3, (byte)now.getDay());
        Convert.packL(hb, 4, this.fileLength, (byte)69);
        Convert.packI(hb, 8, (short)this.dataStart, (byte)69);
        Convert.packI(hb, 10, (short)this.recordSize, (byte)69);
        this.io.write(hb, 0, 32, 0L);
    }

    private long toByteOffset(double off) {
        return (long)((double)this.dataStart + off * (double)this.recordSize);
    }

    public Field[] getFields() {
        return this.fields.toArray(new Field[this.fields.size()]);
    }

    @Override
    public Table getDataTable(double off) {
        if (off < 0.0) {
            return null;
        }
        byte[] db = new byte[this.recordSize];
        int status = this.io.read(db, 0, this.recordSize, this.toByteOffset(off));
        if (status <= 0) {
            return null;
        }
        Table tbl = new Table();
        if (db[0] == 42) {
            tbl.put("_DELETED_", true);
        }
        this.fields.forEach(f -> {
            Object val;
            String str = Convert.unpackS(db, f.start, f.length);
            switch (f.type) {
                case 'D': {
                    str = str.trim();
                    str = str.substring(0, 4) + ":" + str.substring(5, 7) + ":" + str.substring(7) + "::00:00:00";
                    val = Double.valueOf(str);
                    break;
                }
                case 'F': 
                case 'N': {
                    val = f.numdec == 0 ? (double)Integer.valueOf(str.trim()).intValue() : Double.valueOf(str.trim());
                    break;
                }
                case 'L': {
                    if (Shell.getMidasContext().io.isOptionSet(CoreIO.IOOptions.ShapeFileBooleanAsString)) {
                        if (StringUtil.isTrue(str.trim().toUpperCase())) {
                            val = "TRUE";
                            break;
                        }
                        if (StringUtil.isTrue(str.trim().toUpperCase())) {
                            val = "FALSE";
                            break;
                        }
                        val = "?";
                        break;
                    }
                    val = str.isEmpty() || str.equals("?") ? null : Boolean.valueOf(StringUtil.isTrue(str));
                    break;
                }
                default: {
                    val = str;
                }
            }
            tbl.setKey(f.name, val);
        });
        return tbl;
    }

    @Override
    public int setData(double off, Table tbl) {
        if (off < 0.0) {
            return 0;
        }
        byte[] db = new byte[this.recordSize];
        if (off > (double)this.fileLength) {
            this.fileLength = (int)off;
            this.io.setLength(this.toByteOffset(this.fileLength));
        }
        db[0] = (byte)(tbl.getState("_DELETED_", false) ? 42 : 32);
        this.fields.forEach(f -> {
            String str;
            block0 : switch (f.type) {
                case 'D': {
                    Time t = Time.toTime(tbl.get(f.name));
                    str = t.toString(7).substring(0, 8);
                    break;
                }
                case 'F': 
                case 'N': {
                    BigDecimal num = new BigDecimal(tbl.getS(f.name, "0"));
                    str = num.setScale(f.numdec, RoundingMode.HALF_EVEN).toString();
                    str = StringUtil.padLeft(str, f.length);
                    break;
                }
                case 'L': {
                    switch (tbl.getS(f.name, "").toUpperCase()) {
                        case "?": {
                            str = "?";
                            break block0;
                        }
                        case " ": {
                            str = "?";
                            break block0;
                        }
                        case "": {
                            str = "?";
                            break block0;
                        }
                        case "NULL": {
                            str = "?";
                            break block0;
                        }
                    }
                    str = tbl.getState(f.name) ? "T" : "F";
                    break;
                }
                default: {
                    str = tbl.getS(f.name, "");
                }
            }
            Convert.packS(db, f.start, f.length, str);
        });
        this.io.write(db, 0, db.length, this.toByteOffset(off));
        return 1;
    }

    @Override
    public void setData(double off, String fieldName, Object obj) {
        Table tbl = this.getDataTable(off);
        if (tbl == null) {
            tbl = new Table();
        }
        tbl.put(fieldName, obj);
        this.setData(off, tbl);
    }

    @Override
    public void insertData(double off, Object obj) {
        if (off < 0.0) {
            off = this.getSize();
        }
        this.insertBytes(this.toByteOffset(off), this.recordSize);
        ++this.fileLength;
        this.setData(off, (Table)obj);
    }

    @Override
    public void removeData(double off, long count) {
        if (count < 0L) {
            count = (long)((double)this.fileLength - off);
        }
        this.removeBytes(this.toByteOffset(off), count * (long)this.recordSize);
        this.fileLength -= (int)count;
    }

    @Override
    public void setRecordDefs(Table defs) {
        int start = 1;
        this.fields.clear();
        for (String key : defs.getKeys()) {
            Field f = new Field(this, defs.getTable(key), start);
            start += f.getLength();
            this.fields.add(f);
        }
        this.update();
    }

    @Override
    public Table getRecordDefs() {
        Table tbl = new Table();
        this.fields.forEach(f -> tbl.put(f.name, (Object)f.toTable()));
        return tbl;
    }

    @Override
    public Table getRecordDef(int i) {
        return this.fields.get(i).toTable();
    }

    @Deprecated
    public Record[] getRecords() {
        ArrayList<Record> list3 = new ArrayList<Record>(1024);
        while (this.dataStart < this.fileLength) {
            Record record = new Record();
            this.dataStart += record.readFrom(this);
            list3.add(record);
        }
        Record[] records = list3.toArray(new Record[list3.size()]);
        return records;
    }

    @Deprecated
    public class Record {
        public byte[] db;

        public Record() {
            this.db = new byte[DbfFile.this.recordSize];
        }

        public int getLength() {
            return DbfFile.this.recordSize;
        }

        public int readFrom(DbfFile sf) {
            sf.read(this.db, 0, 52);
            return this.getLength();
        }
    }

    public class Field
    implements Tablizable {
        protected final byte[] buf = new byte[32];
        protected final DbfFile dbf;
        public final String name;
        public final String format;
        public final char type;
        public final int start;
        public final int length;
        public final int numdec;

        protected Field(DbfFile dbf, int start) {
            this.dbf = dbf;
            this.start = start;
            dbf.read(this.buf, 0, 32);
            this.name = Convert.unpackS(this.buf, 0, 11);
            this.type = Character.toUpperCase(Convert.unpackC(this.buf, 11));
            this.length = Convert.unpackB(this.buf, 16) & 0xFF;
            this.numdec = Convert.unpackB(this.buf, 17) & 0xFF;
            switch (this.type) {
                case 'D': {
                    this.format = "SD";
                    break;
                }
                case 'F': {
                    this.format = this.numdec == 0 ? "SL" : "SD";
                    break;
                }
                case 'N': {
                    this.format = this.numdec == 0 ? "SL" : "SD";
                    break;
                }
                case 'L': {
                    this.format = "1A";
                    break;
                }
                default: {
                    int n = Math.max(1, (this.length + 7) / 8);
                    this.format = n <= 9 ? n + "A" : (n == 10 ? "XA" : (n <= 16 ? "TA" : "AA"));
                }
            }
        }

        protected Field(DbfFile dbf, Table def, int start) {
            int defNumdec;
            int defLength;
            String defType;
            this.dbf = dbf;
            this.name = def.getS("NAME");
            this.format = def.getS("FORMAT");
            this.start = start;
            switch (this.format.charAt(1)) {
                case 'A': {
                    defType = "C";
                    defLength = Data.getBPA(this.format);
                    defNumdec = 0;
                    break;
                }
                case 'Z': {
                    defType = "C";
                    defLength = Data.getBPA(this.format);
                    defNumdec = 0;
                    break;
                }
                case 'N': {
                    defType = "N";
                    defLength = 4;
                    defNumdec = 0;
                    break;
                }
                case 'B': {
                    defType = "N";
                    defLength = 4;
                    defNumdec = 0;
                    break;
                }
                case 'I': {
                    defType = "N";
                    defLength = 6;
                    defNumdec = 0;
                    break;
                }
                case 'L': {
                    defType = "N";
                    defLength = 12;
                    defNumdec = 0;
                    break;
                }
                case 'X': {
                    defType = "N";
                    defLength = 19;
                    defNumdec = 0;
                    break;
                }
                case 'F': {
                    defType = "N";
                    defLength = 19;
                    defNumdec = 15;
                    break;
                }
                case 'D': {
                    defType = "N";
                    defLength = 19;
                    defNumdec = 15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad format: " + this.format);
                }
            }
            char _type = def.getS("TYPE", defType).charAt(0);
            int _length = def.getL("LENGTH", defLength);
            int _numdec = def.getL("NUMDEC", defNumdec);
            switch (_type) {
                case 'C': {
                    _length = Math.min(254, _length);
                    _numdec = 0;
                    break;
                }
                case 'D': {
                    _length = 8;
                    _numdec = 0;
                    break;
                }
                case 'F': {
                    _length = Math.min(19, _length);
                    _numdec = Math.min(15, _numdec);
                    break;
                }
                case 'L': {
                    _length = 1;
                    _numdec = 0;
                    break;
                }
                case 'M': {
                    _length = 10;
                    _numdec = 0;
                    break;
                }
                case 'N': {
                    _length = Math.min(19, _length);
                    _numdec = Math.min(15, _numdec);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DBF type: " + _type);
                }
            }
            this.type = _type;
            this.length = _length;
            this.numdec = _numdec;
            Convert.packS(this.buf, 0, 11, StringUtil.padRight(this.name, 11, '\u0000'));
            Convert.packC(this.buf, 11, this.type);
            Convert.packB(this.buf, 16, (byte)this.length);
            Convert.packB(this.buf, 17, (byte)this.numdec);
        }

        @Deprecated
        public int readFrom(DbfFile dbf) {
            throw new UnsupportedOperationException();
        }

        @InternalUseOnly(value="This method should be marked 'protected' as it only used when reading from a DBF file")
        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "DBF Field: " + this.toTable();
        }

        @Override
        public Table toTable() {
            Table tbl = new Table();
            tbl.setKey("NAME", this.name);
            tbl.setKey("FORMAT", this.format);
            tbl.setKey("TYPE", Character.valueOf(this.type));
            tbl.setKey("LENGTH", this.length);
            tbl.setKey("NUMDEC", this.numdec);
            return tbl;
        }
    }
}

