/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.TextFile;

public class CommandLine {
    private String RawCommandName = null;
    private String CommandOption = null;
    private String CommandSupport = null;
    private String CommandNargsString = null;
    private String CommandDefaults = null;
    public static final String DEFAULT_OPTION = "USER";
    public static final String DEFAULT_SUPPORT = "M";
    public static final String VALID_SUPPORTS = "IPMHDOU";
    public static final String ALL_SUPPORTS = "IPMHDOU%";
    private static boolean Debug = false;

    public CommandLine(String cmdName, String path) {
        this.setAllFromFile(cmdName, path);
    }

    public CommandLine(String cmdLine) {
        this(CommandLine.parseRawName(cmdLine), null, CommandLine.parseSupport(cmdLine), CommandLine.parseNargsString(cmdLine), CommandLine.parseDefaults(cmdLine));
    }

    public CommandLine(String cmdName, String opt, String support, int nargs, String defaults) {
        this(cmdName, opt, support, Integer.toString(nargs), defaults);
    }

    public CommandLine(String cmdName, String opt, String support, String sargs, String defaults) {
        this.setName(cmdName);
        this.setOption(opt);
        this.setSupport(support);
        this.setNargsString(sargs);
        this.setDefaults(defaults);
    }

    public String getName() {
        int lstar;
        String cmdName = this.RawCommandName;
        if (cmdName != null && (lstar = cmdName.indexOf("*")) > 0) {
            cmdName = cmdName.substring(0, lstar) + cmdName.substring(lstar + 1);
        }
        return cmdName;
    }

    public String getAbbrevName() {
        String cmdName = this.RawCommandName;
        int lstar = cmdName.indexOf("*");
        if (lstar > 0) {
            cmdName = cmdName.substring(0, lstar);
        }
        return cmdName;
    }

    public String getRawName() {
        return this.RawCommandName;
    }

    public String getSupport() {
        return this.CommandSupport;
    }

    public String getNargsString() {
        return this.CommandNargsString;
    }

    public int getNargs() {
        return CommandLine.nargsStringToInt(this.CommandNargsString);
    }

    public String getDefaults() {
        return this.CommandDefaults;
    }

    public String getDefault(int defnum) {
        String defstr = null;
        if (this.CommandDefaults != null) {
            Parser defParser = new Parser(this.CommandDefaults);
            defParser.clean();
            defstr = defParser.get(defnum);
        }
        return defstr;
    }

    public String getCommandLine() {
        String cmdLine = "";
        if (this.RawCommandName != null) {
            cmdLine = CommandLine.buildCommandLine(this.RawCommandName, this.CommandSupport, this.CommandNargsString, this.CommandDefaults);
        }
        return cmdLine;
    }

    public String getOption() {
        return this.CommandOption;
    }

    public boolean isInCommandsFile(String path) {
        boolean exists = false;
        if (CommandLine.getCommandLine(this.getName(), path) != null) {
            exists = true;
        }
        return exists;
    }

    public static int nargsStringToInt(String sargs) {
        int nargs = -1;
        if (sargs != null) {
            try {
                int index = sargs.indexOf("+");
                if (index > 0) {
                    sargs = sargs.substring(0, index);
                }
                nargs = Integer.parseInt(sargs);
            }
            catch (NumberFormatException e) {
                nargs = 0;
            }
        }
        return nargs;
    }

    public static String parseSupport(String cmdLine) {
        Parser cmdParser = new Parser(cmdLine);
        cmdParser.clean();
        return cmdParser.get(2);
    }

    public static String parseName(String cmdLine) {
        String name = CommandLine.parseRawName(cmdLine);
        int la = name.indexOf("*");
        if (la > 0) {
            name = name.substring(0, la) + name.substring(la + 1);
        }
        return name;
    }

    public static String parseRawName(String cmdLine) {
        Parser cmdParser = new Parser(cmdLine);
        cmdParser.clean();
        return cmdParser.get(1);
    }

    public static String parseNargsString(String cmdLine) {
        Parser cmdParser = new Parser(cmdLine);
        cmdParser.clean();
        return cmdParser.get(3);
    }

    public static String parseDefaults(String cmdLine) {
        String defaultsString;
        Parser cmdParser = new Parser(cmdLine);
        cmdParser.clean();
        int nargs = CommandLine.getNargs(cmdLine);
        if (nargs > 0) {
            String val = cmdParser.get(4);
            if (val == null || val == "" || val == " ") {
                val = ",";
            }
            defaultsString = val + ",";
            for (int i = 2; i <= cmdParser.elements() - 3; ++i) {
                val = cmdParser.get(i + 3);
                if (val == null || val == "" || val == " ") {
                    val = ",";
                }
                defaultsString = defaultsString + val + ",";
            }
        } else {
            defaultsString = "";
        }
        CommandLine.debug("parseDefaults; returning " + defaultsString);
        return defaultsString;
    }

    public void setName(String name) {
        if (name != null) {
            this.RawCommandName = name.toUpperCase();
        }
    }

    public boolean setAbbrevName(String abbrevName) {
        String setNameStr = null;
        String cmdName = this.getName();
        String rawCmdName = this.getRawName();
        if (abbrevName.equalsIgnoreCase(rawCmdName)) {
            setNameStr = rawCmdName + "*";
        } else if (abbrevName.length() == cmdName.length()) {
            setNameStr = abbrevName + "*";
        } else {
            int lstar = abbrevName.indexOf("*");
            if (lstar > 0) {
                String nameToStar = abbrevName.substring(0, lstar);
                if (cmdName.length() >= lstar && cmdName.substring(0, lstar).equalsIgnoreCase(nameToStar)) {
                    String rawName = cmdName.substring(0, lstar);
                    String afterStar = cmdName.substring(lstar);
                    if (afterStar.length() > 0) {
                        rawName = rawName + "*" + afterStar;
                    }
                    setNameStr = rawName;
                }
            } else {
                String cmdAbbrev;
                int la = abbrevName.length();
                if (la > 0 && cmdName.length() >= la && (cmdAbbrev = cmdName.substring(0, la)).equalsIgnoreCase(abbrevName)) {
                    String rawName = cmdName.substring(0, la);
                    if (!cmdAbbrev.equalsIgnoreCase(cmdName)) {
                        rawName = rawName + "*" + cmdName.substring(la);
                    }
                    setNameStr = rawName;
                }
            }
        }
        if (setNameStr != null) {
            this.setName(setNameStr);
        }
        return setNameStr != null;
    }

    public void setOption(String opt) {
        this.CommandOption = opt;
    }

    public void setSupport(String support) {
        this.CommandSupport = support;
    }

    public void setNargsString(String nargsString) {
        int nargs = 0;
        String sargs = nargsString;
        int plusIndex = nargsString.indexOf("+");
        String moreString = "";
        if (sargs != null) {
            if (plusIndex > 0) {
                sargs = sargs.substring(0, plusIndex);
                moreString = "+";
            }
            try {
                nargs = Integer.parseInt(sargs);
            }
            catch (NumberFormatException e) {
                nargs = 0;
            }
        }
        this.setNargsString(nargs);
        this.CommandNargsString = this.CommandNargsString + moreString;
    }

    public void setDefaults(String defaults) {
        this.CommandDefaults = defaults;
    }

    public static boolean isValidSupport(String in) {
        boolean status;
        if (in == null) {
            status = false;
        } else {
            int len = in.length();
            status = len > 0;
            for (int ii = 0; ii < len && status; ++ii) {
                char ch = in.charAt(ii);
                status = VALID_SUPPORTS.indexOf(ch) >= 0;
            }
        }
        return status;
    }

    public static String getValidSupports() {
        return VALID_SUPPORTS;
    }

    public static String buildCommandLine(String cmdName, String support, String nargsString, String defaults) {
        String line = "";
        String tabstr = "";
        String cmdNamePad = StringUtil.padRight(cmdName, 15) + " ";
        String padString = StringUtil.padRight(support + "," + nargsString, 7) + " ";
        line = cmdNamePad + padString + defaults;
        return line;
    }

    private String getOption(String path) {
        return CommandLine.getOption(this.RawCommandName, path);
    }

    private static int getNargs(String cmdLine) {
        String sargs = CommandLine.parseNargsString(cmdLine);
        int nargs = CommandLine.nargsStringToInt(sargs);
        return nargs;
    }

    private void setNargsString(int nargs) {
        this.CommandNargsString = Integer.toString(nargs);
    }

    private static String getOption(String cmdName, String path) {
        String optionOut = null;
        String cmdLine = null;
        Parser pathParser = new Parser(path);
        for (int i = 1; i <= pathParser.elements(); ++i) {
            Midas M = new Midas();
            String opt = pathParser.get(i);
            String fname = M.io.name("CFG", "COMMANDS", "CNF", opt);
            TextFile textFile = new TextFile(M, (Object)fname);
            cmdLine = CommandLine.getCommandLineFromText(cmdName, textFile);
            if (cmdLine == null) continue;
            optionOut = opt;
            break;
        }
        return optionOut;
    }

    private static String getCommandLine(String cmdName, String path) {
        String cmdLineOut = null;
        Parser pathParser = new Parser(path);
        for (int i = 1; i <= pathParser.elements(); ++i) {
            Midas M = new Midas();
            String opt = pathParser.get(i);
            String fname = M.io.name("CFG", "COMMANDS", "CNF", opt);
            TextFile textFile = new TextFile(M, (Object)fname);
            String cmdLine = CommandLine.getCommandLineFromText(cmdName, textFile);
            if (cmdLine == null) continue;
            cmdLineOut = cmdLine;
            break;
        }
        return cmdLineOut;
    }

    private void setAllFromFile(String cmdName, String path) {
        Parser pathParser = new Parser(path);
        String opt = null;
        Midas M = new Midas();
        String fname = null;
        String cmdLine = null;
        for (int i = 1; i <= pathParser.elements(); ++i) {
            opt = pathParser.get(i);
            fname = M.io.name("CFG", "COMMANDS", "CNF", opt);
            TextFile textFile = new TextFile(M, (Object)fname);
            cmdLine = CommandLine.getCommandLineFromText(cmdName, textFile);
            if (cmdLine == null) continue;
            this.setOption(opt);
            this.setName(CommandLine.parseRawName(cmdLine));
            this.setSupport(CommandLine.parseSupport(cmdLine));
            this.setNargsString(CommandLine.parseNargsString(cmdLine));
            this.setDefaults(CommandLine.parseDefaults(cmdLine));
            break;
        }
    }

    private static String getCommandLineFromText(String cmdName, TextFile infile) {
        boolean done = false;
        String lineout = null;
        if (cmdName != null && infile.open(33)) {
            while (!done) {
                String line = infile.read();
                if (line == null) {
                    done = true;
                    continue;
                }
                String curname = CommandLine.parseRawName(line);
                int la = curname.indexOf("*");
                if (la > 0) {
                    curname = curname.substring(0, la) + curname.substring(la + 1);
                }
                if (curname.compareTo(cmdName) != 0) continue;
                lineout = line;
                done = true;
            }
            infile.close();
        }
        return lineout;
    }

    private static void debug(String str) {
        if (Debug) {
            System.out.println(str);
        }
    }
}

