/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import nxm.sys.inc.CommandParent;
import nxm.sys.inc.Commandable;
import nxm.sys.inc.IDable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyObjectNames;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Args;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Message;
import nxm.sys.lib.MessageQueue;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Terminal;
import nxm.sys.lib.Time;

public class Command
implements Commandable,
Runnable,
MessageHandler,
IDable,
MidasReference {
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public static String flagsList;
    private CommandParent cmdParent = null;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    @KeyObjectNames
    public Midas M;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public MessageQueue MQ;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for internal use only")
    public MessageQueue queue;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public Args MA;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for internal use only")
    public Args args;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public Results MR;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public Terminal MT;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for internal use only")
    private DataOp MD;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for internal use only")
    public Thread thread;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public int state;
    private int setState;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public String name;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public char support;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public String option;
    private Object engine;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public String id;
    protected boolean verbose;
    @InternalUseOnly(value="since 3.5.4, this has always been meant for read-only use by callers")
    public boolean isPiped = false;
    private Properties properties = null;
    protected double pollTime = 0.0125;
    private MessageHandler msgHandler = null;
    private DataFile progressDF = null;
    private String progressText = null;
    private double progressMax = 1.0;
    private Object gpw;
    private String gpr;
    private static final Class<?> GPROGRESS_CLASS;
    private static final Constructor<?> GPROGRESS_CONST;
    private static final Method GPROGRESS_SET_LABEL;
    private static final Method GPROGRESS_SET_PROGRESS;
    private static final Method GPROGRESS_CLOSE;
    private boolean nmPromptCmd;

    public void setArgs(Args args) {
        if (this.cmdParent != null) {
            args = this.cmdParent.setArgs(this, args);
        }
        args.cmd = this;
        this.MA = this.args = args;
        this.name = args.name;
        this.option = args.option;
        this.support = args.support;
        this.id = args.getU("/ID");
        if (this.id.indexOf(94) >= 0) {
            this.id = null;
        }
    }

    public void setArg(String key, String value) {
        this.MA.put(key, value);
    }

    public synchronized int checkin(Midas M) {
        this.M = M;
        this.MR = M.results;
        this.MT = M.terminal;
        this.MD = new DataOp();
        this.MQ = this.queue = this.getQueue();
        this.verbose = this.MA.getState("/VERBOSE", M.macro == null);
        this.pollTime = this.args.getD("/POLL", M.pause);
        return 0;
    }

    private void initSwitches() {
        this.setMsgID(this.MA.getU("/MSGID"), true);
    }

    private void openSwitches() {
        if (this.MA.find("/GPW")) {
            if (this.progressText == null) {
                this.progressText = this.MA.getRaw();
            }
            if (GPROGRESS_CLASS != null) {
                try {
                    this.gpw = GPROGRESS_CONST.newInstance(this, "Progress", "Run,Pause,Abort", this.progressText, 0, 0, 0, this);
                    GPROGRESS_SET_LABEL.invoke(this.gpw, "PROGRESS");
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    LogUtilities.log(Level.WARNING, "Error instantiating GProgress", e);
                }
            }
        }
        this.gpr = this.MA.getU("/GPR", null);
    }

    public synchronized void checkout() {
        this.M = null;
        this.MR = null;
        this.MT = null;
        this.MQ = null;
        this.MD = null;
    }

    public final Midas getContext() {
        return this.M;
    }

    protected MessageQueue getQueue() {
        return new MessageQueue(this.M, this);
    }

    @Override
    public int open() {
        return 0;
    }

    @Override
    public int process() {
        return -1;
    }

    @Override
    public int close() {
        return 0;
    }

    public synchronized void setMessageHandler(MessageHandler mh) {
        this.msgHandler = mh;
        this.MA.remove("/MSGID");
    }

    public MessageHandler getMessageHandler() {
        return this.msgHandler;
    }

    public void setNmPromptCmd(boolean nmPromptCmd) {
        this.nmPromptCmd = nmPromptCmd;
    }

    public boolean isNmPromptCmd() {
        return this.nmPromptCmd;
    }

    public void setMsgID(String regName) {
        this.setMsgID(regName, false);
    }

    private synchronized void setMsgID(String regName, boolean init) {
        if (StringUtil.isNull(regName) || regName.length() == 0) {
            this.msgHandler = null;
            this.MA.remove("/MSGID");
        } else {
            this.msgHandler = this.M.registry.getMessageHandler(regName, 5);
            if (this.msgHandler != null) {
                this.setArg("/MSGID", regName);
            } else if (init) {
                this.M.warning("Can not use /MSGID='" + regName + "', REG." + regName + " is not a Command or an instance of MessageHandler.");
            } else {
                this.M.error("Can not use setMsgID('" + regName + "'), REG." + regName + " is not a Command or an instance of MessageHandler.");
            }
        }
    }

    public synchronized String getMsgID() {
        String regName = this.MA.getU("/MSGID");
        return regName == null && this.msgHandler != null ? "<unknown>" : regName;
    }

    protected void sendMessage(String name, int info, Object data) {
        Message msg = new Message(name, info, data);
        this.sendMessage(msg);
    }

    protected void sendMessage(Message msg) {
        MessageHandler mh = this.getMessageHandler();
        if (mh != null && mh != msg.from) {
            msg.to = mh;
            msg.from = this;
            mh.processMessage(msg);
        }
    }

    @Override
    public synchronized int processMessage(Message msg) {
        if (msg.name.equals("SET")) {
            Table t = (Table)msg.data;
            Table.Iterator ti = t.iterator();
            while (ti.getNext()) {
                KeyObject.setKey(this, ti.key, ti.value);
            }
        } else if (msg.name.equals("GET")) {
            Table t = (Table)msg.data;
            Table.Iterator ti = t.iterator();
            while (ti.getNext()) {
                t.put(ti.key, KeyObject.getKey(this, ti.key));
            }
            msg.name = "RET";
            this.MQ.put(msg, msg.from);
        } else if (msg.name.startsWith("SET.")) {
            String key = msg.name.substring(4);
            KeyObject.setKey(this, key, msg.data);
        } else if (msg.name.startsWith("GET.")) {
            String key = msg.name.substring(4);
            msg.name = "RET." + key;
            msg.data = KeyObject.getKey(this, key);
            this.MQ.put(msg, msg.from);
        } else {
            if (msg.name.equals("PROGRESS")) {
                String text = (String)msg.data;
                if (text.equals("RUN")) {
                    this.setState(12);
                } else if (text.equals("PAUSE")) {
                    this.setState(11);
                } else if (text.equals("ABORT")) {
                    this.setState(9);
                } else if (text.equals("EXIT")) {
                    this.setState(9);
                }
                return 0;
            }
            if (msg.name.equals("NULL")) {
                return 0;
            }
            if (msg.name.equals("EXIT")) {
                this.setState(9);
            } else {
                return -1;
            }
        }
        return 0;
    }

    public int processMessage(String name, int info, Object data) {
        return this.processMessage(new Message(name, info, data));
    }

    public int processMessages(int maxmsg) {
        Message msg;
        int status = -1;
        if (this.queue == null) {
            return status;
        }
        while (maxmsg-- != 0 && (msg = this.queue.get()) != null) {
            try {
                status = this.processMessage(msg);
            }
            catch (Exception e) {
                this.processMessageException(msg, e);
            }
        }
        return status;
    }

    private void processMessageException(Message m, Exception e) {
        if (this.M.macro != null && !(m instanceof ErrorMessage)) {
            ErrorMessage msg = new ErrorMessage("ERROR", 0, e, this.M.macro, this);
            this.M.macro.processMessage(msg);
        } else {
            this.M.printStackTrace("Error processing message " + m, e);
        }
    }

    public void processException(Exception e) {
        this.processException((Throwable)e);
    }

    void processException(Throwable e) {
        if (this.M != null && this.M.macro != null) {
            ErrorMessage msg = new ErrorMessage("ERROR", 0, e, this.M.macro, this);
            this.M.macro.processMessage(msg);
        } else if (this.M != null) {
            this.M.printStackTrace(e);
        } else {
            e.printStackTrace();
        }
        try {
            this.state = 10;
            this.close();
            this.state = -3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.runEnter();
        try {
            while (this.state != 4 && this.state != -3) {
                int status;
                int n = status = this.cmdParent == null ? this.runSingle() : this.cmdParent.runSingle(this, this.state, this.setState);
                if (status == -1) {
                    Time.sleep(this.pollTime);
                    continue;
                }
                if (status != 8) continue;
                Time.sleep(0.1);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        this.runExit();
        this.checkout();
    }

    protected void runEnter() {
        if (this.cmdParent != null) {
            this.cmdParent.runEnter(this);
        }
        if (this.M.timer > 0L) {
            this.M.timer = System.currentTimeMillis();
        }
        if (this.M.verify != 0) {
            this.verify();
        }
        this.state = 0;
        if (!this.putInRegistry()) {
            return;
        }
        if (this.id == null) {
            this.id = this.MA.getU("/ID");
        }
        if (this.id.length() > 0) {
            Object old = this.M.getRegistry().get(this.id);
            if (old != null) {
                this.M.warning("Duplicate entries for /ID=" + this.id + " found in registry; overriding " + old + " with " + this + ". This behavior is deprecated as of NeXtMidas 2.5.0 and will be an ERROR in future releases.");
            }
            this.M.getRegistry().put(this.id, this);
        } else {
            this.id = this.M.getRegistry().putInstance(this.name, this);
        }
        if (this.M.macro != null && this.M.macro.isTxt()) {
            this.M.macro.prepTxtCommand(this);
        }
        this.setState = this.MA.getSelectionIndex("/STATE", "Exit,Suspend,Wait,Init,Open,Process,Close,Done,Start,Stop,Restart,Sleep,Finish,Abort,Pause,Resume", 5, -4);
    }

    public int runSingle() {
        int status = -1;
        if (this.isPiped && this.M.pipeMode != 2) {
            if (this.M.pipeMode == 1) {
                status = 8;
            } else if (this.M.pipeMode == 5) {
                status = 9;
            } else if (this.M.pipeMode == 0) {
                status = 9;
            }
        }
        if (this.setState != 0) {
            if (this.cmdParent != null) {
                this.cmdParent.processMessages(this, -1);
            } else {
                this.processMessages(-1);
            }
            status = this.setState;
            this.setState = 0;
        } else if (status == -1) {
            if (this.state == 2) {
                if (this.cmdParent != null) {
                    status = this.cmdParent.processMessages(this, 1);
                } else if (this.queue != null) {
                    status = this.processMessages(1);
                }
                if (status == -1 && this.M.pipeMode != 3) {
                    if (this.engine == null) {
                        status = this.process();
                    } else {
                        int maxloop = this.processReady();
                        for (int i = 0; i < maxloop && (status = this.process()) == 0; ++i) {
                        }
                    }
                }
                if (this.gpw != null) {
                    try {
                        GPROGRESS_SET_PROGRESS.invoke(this.gpw, this.getProgress());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LogUtilities.log(Level.WARNING, "Caught an exception setting the progress", e);
                    }
                }
                if (this.gpr != null) {
                    this.MR.put(this.gpr, this.getProgress());
                }
            } else if (this.state == -2) {
                status = 8;
            } else if (this.state == 0) {
                status = 8;
            }
        }
        if (this.finishing()) {
            status = 9;
        }
        if (this.getInterrupt()) {
            int interruptCount = this.M.terminal.getInterrupt();
            if (this.M.macro != null) {
                int pm = this.M.pipeMode;
                if (pm == 1 || pm == 2 || pm == 3 || pm == 4) {
                    this.M.macro.setPipeMode(5);
                    this.M.pipeMode = 5;
                } else {
                    status = 9;
                }
            } else if (!this.args.cmd.args.getState("/BG")) {
                this.M.terminal.setInterrupt(0);
                status = 9;
            }
            if (interruptCount > 0) {
                Time.sleep(0.25);
            }
        }
        if (status != 0 && status != -1) {
            if (status == 0) {
                this.state = 0;
            } else if (status == -2) {
                this.state = -2;
            } else if (status == 11) {
                this.state = -2;
            } else if (status == 12) {
                this.state = 2;
            } else if (status == 10) {
                this.state = -3;
            } else if (status == 7) {
                this.state = 7;
                status = this.restart();
                if (status == 9) {
                    this.setState = 9;
                } else {
                    this.state = status == 10 ? -3 : 2;
                }
            } else if (status == 5) {
                if (this.queue != null && this.isPiped && this.M.pipeMode == 4) {
                    this.queue.clear();
                }
                this.state = 1;
                this.initSwitches();
                status = this.open();
                this.openSwitches();
                if (status == 9) {
                    this.setState = 9;
                } else {
                    this.state = status == 10 ? -3 : 2;
                }
            } else if (status == 6 && this.state != 0) {
                this.state = 7;
                this.close();
                this.state = 0;
            } else if (status == 9 && this.setState == 0) {
                if (this.state != 0) {
                    this.state = 3;
                    this.close();
                }
                this.state = 4;
            }
        }
        return status;
    }

    protected void runExit() {
        if ((this.M.verify & 0x10) != 0) {
            Shell.beep();
        }
        if (this.M.timer > 0L) {
            double time = 0.001 * (double)(System.currentTimeMillis() - this.M.timer);
            this.M.println("Command took " + time + " seconds");
        }
        if (this.putInRegistry()) {
            this.M.registry.remove(this.id);
        }
        if (this.cmdParent != null) {
            this.cmdParent.runExit(this);
        }
        if (this.gpw != null) {
            try {
                GPROGRESS_CLOSE.invoke(this.gpw, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LogUtilities.log(Level.WARNING, "Caught an exception closing GProgress", e);
            }
        }
    }

    public void verify() {
        if (this.M.verify == 0) {
            return;
        }
        if (this.M.pipeMode == 4 ? (this.M.verify & 8) == 0 : (this.M.verify & 1) == 0) {
            return;
        }
        this.M.println(this.MA.toString());
    }

    public static String stateToString(int state) {
        return Parser.get("Exit,Suspend,Wait,Init,Open,Process,Close,Done,Start,Stop,Restart,Sleep,Finish,Abort,Pause,Resume", state, -4);
    }

    public void setState(int value) {
        if (value >= 5) {
            this.setState = value;
        } else {
            this.M.warning("Cannot set state to " + Command.stateToString(value));
        }
    }

    public void setState(String value) {
        this.setState(Parser.find("Exit,Suspend,Wait,Init,Open,Process,Close,Done,Start,Stop,Restart,Sleep,Finish,Abort,Pause,Resume", value, 0, -4));
    }

    public final boolean isStateChanged() {
        return this.setState != 0;
    }

    public int restart() {
        this.state = 7;
        this.close();
        this.initSwitches();
        return this.open();
    }

    public String toString() {
        return this.MA.toString();
    }

    public boolean isPipable() {
        return false;
    }

    public boolean thisIsMe() {
        return Thread.currentThread() == this.thread;
    }

    @InternalUseOnly(value="since 3.5.4, this has always been meant for internal use only")
    public void whoIsThis(String text) {
        System.out.println(text + " " + Thread.currentThread().getName());
    }

    public void setPollTime(double seconds) {
        this.pollTime = seconds;
    }

    public double getPollTime() {
        return this.pollTime;
    }

    public Args getArgs() {
        return this.MA;
    }

    public String getState() {
        return Parser.get("Exit,Suspend,Wait,Init,Open,Process,Close,Done,Start,Stop,Restart,Sleep,Finish,Abort,Pause,Resume", this.state, -4);
    }

    @Override
    public String getID() {
        return this.id;
    }

    protected Properties getProperties() {
        Properties props;
        block4: {
            props = this.properties;
            if (props == null) {
                props = this.properties = new Properties();
            }
            try {
                String fname = this.M.io.name("CFG", this.name, "PROPERTIES", this.option);
                if (this.M.io.exists(fname)) {
                    FileInputStream in = new FileInputStream(fname);
                    props.load(in);
                    in.close();
                }
            }
            catch (Exception e) {
                if (this.M == null) break block4;
                this.M.printStackTrace("Unable to get/load properties file for command", e, false, 1);
            }
        }
        return (Properties)props.clone();
    }

    protected Object getProperty(String name) {
        Properties props = this.properties;
        if (props == null) {
            props = this.getProperties();
        }
        if (props == null) {
            return null;
        }
        return props.get(name);
    }

    public MessageQueue getMQ() {
        if (this.queue != this.MQ) {
            Shell.warning("ERROR: Command.MQ and Command.queue are out of synch.");
        }
        return this.MQ;
    }

    public CommandParent getCmdParent() {
        return this.cmdParent;
    }

    public void setCmdParent(CommandParent cmdParent) {
        this.cmdParent = cmdParent;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getName() {
        return this.name;
    }

    void setCmdProcEngine(Object engine, Thread thread) {
        this.engine = engine;
        this.thread = thread;
    }

    Object getCmdProcEngine() {
        return this.engine;
    }

    public int processReady() {
        return -1;
    }

    private boolean putInRegistry() {
        return this.support == 'P' || this.support == 'H' || this.support == 'M';
    }

    public boolean getInterrupt() {
        return this.M.terminal.getInterrupt() != 0 || this.isPiped && this.M.pipeMode == 0;
    }

    public boolean finishing() {
        return this.setState == 9 || this.setState == 4 || this.setState == 10 || this.state == 9 || this.state == 4 || this.state == 10;
    }

    public void setProgressFeed(DataFile df, String text) {
        this.progressDF = df;
        this.progressText = text;
    }

    public double getProgress() {
        DataFile df = this.progressDF;
        if (df == null) {
            return -2.0;
        }
        double prog = this.progressMax * (df.seek() / df.getSize());
        return prog;
    }

    public void addProgressFeed(DataFile df) {
        if (this.progressDF == null) {
            this.progressDF = df;
        }
    }

    @Override
    public Midas getMidas() {
        return this.M;
    }

    public String getStatus() {
        return this.getState();
    }

    public static String[] getMenuCommands(Midas midas, String names, String supports, String options, boolean showOption, boolean showSupport) {
        ArrayList<String> commands = new ArrayList<String>();
        names = names == null ? "*" : names.toUpperCase();
        supports = supports == null ? "*" : supports.toUpperCase();
        String string = options = options == null ? "*" : options.toUpperCase();
        if (names.equals("ALL")) {
            names = "*";
        }
        if (supports.equals("ALL")) {
            supports = "*";
        }
        if (options.equals("ALL")) {
            options = "*";
        }
        supports = supports.substring(0, 1);
        for (int i = 0; i < midas.dictionary.getSize(); ++i) {
            Parser command = new Parser(midas.dictionary.get(i));
            String name = command.get(1);
            int lname = name.indexOf(59);
            int lendName = name.indexOf(58);
            if (lendName < 0) {
                lendName = name.length();
            }
            String option = name.substring(lname + 1, lendName);
            name = name.substring(0, lname);
            String support = command.get(2);
            if (!supports.equals("*") && !StringUtil.containsCommonCharacter(supports, support) || !options.equals("*") && !options.equals(option) || !StringUtil.isWildcardMatch(names + "*", name)) continue;
            String cmd = name;
            if (!option.equalsIgnoreCase("SYS") && showOption) {
                cmd = cmd + ";" + option;
            }
            if (showSupport) {
                cmd = cmd + "-" + support;
            }
            commands.add(cmd);
        }
        return commands.toArray(new String[commands.size()]);
    }

    static {
        Method close;
        Method setProgress;
        Method setLabel;
        Constructor<?> cons;
        Class<?> gprogressClass;
        flagsList = "Open,Process,Close,Checkin,Checkout,ProcessException,ProcessMessage,RunEnter,RunSingle,RunExit";
        try {
            gprogressClass = Class.forName("nxm.sys.libg.GProgress");
            Class<?> gwidgetClass = Class.forName("nxm.sys.libg.GWidget");
            cons = gprogressClass.getConstructor(Object.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, MessageHandler.class);
            setLabel = gwidgetClass.getDeclaredMethod("setLabel", String.class);
            setProgress = gprogressClass.getDeclaredMethod("setProgress", Double.TYPE);
            close = gwidgetClass.getDeclaredMethod("close", new Class[0]);
        }
        catch (Exception e) {
            gprogressClass = null;
            cons = null;
            setLabel = null;
            setProgress = null;
            close = null;
        }
        GPROGRESS_CLASS = gprogressClass;
        GPROGRESS_CONST = cons;
        GPROGRESS_SET_LABEL = setLabel;
        GPROGRESS_SET_PROGRESS = setProgress;
        GPROGRESS_CLOSE = close;
    }

    private static final class ErrorMessage
    extends Message {
        ErrorMessage(String name, int info, Object data, Object to, Object from) {
            super(name, info, data, to, from);
        }
    }
}

