/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.net.URL;
import java.util.HashMap;
import nxm.sys.inc.IOResourceFactory;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class ClassPathResource
implements IOResourceFactory {
    static final ClassPathResource INSTANCE = new ClassPathResource();
    private static final String classpathStr = System.getProperty("java.class.path");
    private static boolean moduleInfoFix = false;

    @Override
    public IOResource getResourceFor(Midas M, int type, String urlstr, int dir, Table quals) {
        String suffix;
        if (!urlstr.startsWith("classpath:")) {
            throw new MidasException("Invalid URL for ClassPathResource: " + urlstr);
        }
        int i = urlstr.indexOf(33);
        String filePath = i < 0 ? urlstr.substring(10) : urlstr.substring(10, i);
        String string = suffix = i < 0 ? "" : urlstr.substring(i);
        if (moduleInfoFix && filePath.equals("/")) {
            return null;
        }
        URL fileURL = this.getResource(filePath);
        if (fileURL != null) {
            return IOResource.getInstance(M, 0, fileURL + suffix, dir, quals);
        }
        return null;
    }

    @InternalUseOnly
    private URL getResource(String pathName) {
        URL url;
        if ((pathName = pathName.replace('\\', '/').replaceAll("/+", "/")).startsWith("/")) {
            pathName = pathName.substring(1);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(pathName)) != null) {
            return url;
        }
        url = Shell.class.getClassLoader().getResource(pathName);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(pathName);
        if (url != null) {
            return url;
        }
        return null;
    }

    static {
        if (Shell.getJavaMajorVersion() > 8) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bcel", "6.8.0");
            map.put("commons-lang3", "3.14.0");
            map.put("commons-net", "3.10.0");
            map.put("commons-compress", "1.23.0");
            map.put("jackson-core", "2.13.0");
            map.put("jackson-databind", "2.13.0");
            map.put("kotlin-stdlib", "1.4.0");
            for (String depJarName : map.keySet()) {
                if (!classpathStr.contains(depJarName + "-")) continue;
                int depJarNameIdx = classpathStr.indexOf(depJarName);
                int depJarVerIdx = classpathStr.indexOf(":", depJarNameIdx);
                String depJarFullName = depJarVerIdx != -1 ? classpathStr.substring(depJarNameIdx, depJarVerIdx) : classpathStr.substring(depJarNameIdx);
                String depJarActVer = depJarFullName.substring(0, depJarFullName.indexOf(".jar")).split(depJarName + "-")[1];
                String depJarMinVer = (String)map.get(depJarName);
                String[] depJarActVerArr = depJarActVer.split("\\.");
                String[] depJarMinVerArr = depJarMinVer.split("\\.");
                int depJarActVerMajorVer = Integer.parseInt(depJarActVerArr[0]);
                int depJarMinVerMajorVer = Integer.parseInt(depJarMinVerArr[0]);
                int depJarActVerMinorVer = Integer.parseInt(depJarActVerArr[1]);
                int depJarMinVerMinorVer = Integer.parseInt(depJarMinVerArr[1]);
                if (depJarActVerMajorVer <= depJarMinVerMajorVer && (depJarActVerMajorVer != depJarMinVerMajorVer || depJarActVerMinorVer < depJarMinVerMinorVer)) continue;
                moduleInfoFix = true;
                break;
            }
        }
    }
}

