/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.lib;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import nxm.sys.inc.AsciiMap;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyObjectNames;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CoreIO;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Registry;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.Util;
import nxm.sys.libm.Tolerance;

public class BaseFile
implements AsciiMap,
DataTypes,
Closeable {
    public static int BUFFER_SIZE = 32768;
    public static final String propertyList = "Name,Size,Comment,Qualifiers";
    public static final int BASE = 0;
    public static final int DATA = 1;
    public static final int TEXT = 2;
    public static final int IMAGE = 3;
    public static final int SHAPE = 4;
    public static final int DBF = 5;
    public static final int ZIP = 6;
    public static final int TAR = 7;
    public static final int JAR = 8;
    public static final String flagsList = "Input,Output,Wrap,Append,Flush,NoAbort,Optional,Native,ReOpen,Wait,HeaderOnly,Truncate,MkDir,ForceAbort,AlwaysReOpen,NoOpen,PktHdr,WarnEmpty,EmbeddedLF,MaintainCase,DoNotAddExtension";
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int WRAP = 4;
    public static final int APPEND = 8;
    public static final int FLUSH = 16;
    public static final int NOABORT = 32;
    public static final int OPTIONAL = 64;
    public static final int NATIVE = 128;
    public static final int REOPEN = 256;
    public static final int WAIT = 512;
    public static final int HEADERONLY = 1024;
    public static final int TRUNCATE = 2048;
    public static final int MKDIR = 4096;
    public static final int FORCEABORT = 8192;
    public static final int ALWAYSREOPEN = 16384;
    public static final int NOOPEN = 32768;
    public static final int PKTHDR = 65536;
    public static final int WARNEMPTY = 131072;
    public static final int EMBEDDEDLF = 262144;
    public static final int MAINTAINCASE = 524288;
    public static final int DONOTADDEXTENSION = 0x100000;
    public static final int INOUT = 3;
    public static final int DEF_FLAGS = 2048;
    public static final int EQ_BIN = 1;
    public static final int EQ_SIZE = 2;
    public static final int EQ_HDR = 4;
    public static final int EQ_DATA = 8;
    public static final int EQ_KEY = 16;
    public static final int EQ_TOL = 32;
    static final int EQ_MAG = 64;
    static final int EQ_CS = 128;
    static final int EQ_VEQ = 256;
    static final int EQ_ABSTOL = 512;
    public static final int EQ_LENLIM = 1024;
    public static final int EQ_DEF = 32768;
    public static final int RADIX_10 = 0;
    public static final int RADIX_16 = 1;
    public static final int RADIX_2 = 2;
    public static final int RADIX_8 = 4;
    private static final int MAX_BUF_SIZE = 32678;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public double size = 0.0;
    protected double offset = 0.0;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public String filename;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public String tag;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public String aux;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public String comment;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public boolean isOpen = false;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public boolean isFound = false;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public boolean isInput = false;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    @KeyObjectNames(value={"isOutput"})
    public boolean isOutput = false;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public int flags = 2048;
    @InternalUseOnly(value="Since NeXtMidas 3.7.1")
    public boolean hasLinefeed = false;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, this has always been meant for read-only use by callers")
    public Midas M;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1, this has always been meant for read-only use by callers")
    public Command cmd;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public FileName fn;
    @InternalUseOnly(value="Since NeXtMidas 3.5.1")
    public IOResource io;
    @Deprecated
    public double tolerance = 0.0;
    private double absTolerance = 0.0;

    public BaseFile() {
    }

    public BaseFile(String filename) {
        this(null, (Object)filename);
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0 use BaseFile(MidasReference, Object)")
    public BaseFile(Object ref, Object filename) {
        this();
        this.init(Convert.ref2MidasReference(ref), filename);
    }

    public BaseFile(MidasReference ref, Object filename) {
        this();
        this.init(ref, filename);
    }

    @InternalUseOnly(value="deprecated Since NeXtMidas 3.5.0 use init(MidasReference, Object)")
    public void init(Object ref, Object filename) {
        this.init(Convert.ref2MidasReference(ref), filename);
    }

    public void init(MidasReference ref, Object filename) {
        this.M = Convert.ref2Midas(ref);
        if (ref != null && this.M != null && this.M.isJavaBehavior()) {
            this.flags |= 0x80000;
        }
        this.init(ref, this.M, filename);
    }

    void init(MidasReference ref, Midas M, Object filename) {
        this.M = M;
        this.cmd = ref instanceof Command ? (Command)ref : null;
        if (this.cmd != null && this.cmd.args.find("/AUX")) {
            this.aux = this.cmd.args.getS("/AUX");
        }
        this.setName(filename);
    }

    public boolean find(int dir) {
        IOResource oldio = this.io;
        this.io = this.findResource(dir);
        if (oldio != null) {
            oldio.close();
        }
        return this.io.exists() && !this.io.isContainer();
    }

    IOResource findResource(int dir) {
        return this.M.io.findResource(this.fn, dir, "", this.aux);
    }

    public final boolean exists() {
        return this.find(-1);
    }

    public boolean open(int flag) {
        this.setFlags(flag);
        return this.open();
    }

    int getDir(boolean isInput, boolean isOutput, boolean isFound) {
        if (isInput && isOutput && isFound) {
            return 0;
        }
        if (isInput) {
            return (this.flags & 0x800) != 0 ? -2 : -1;
        }
        return (this.flags & 0x800) != 0 ? 2 : 1;
    }

    public boolean open() {
        block17: {
            this.isOpen = false;
            if ((this.flags & 3) == 0) {
                this.flags |= 1;
            }
            if (this.tag.length() == 0 && this.filename.length() == 0) {
                if ((this.flags & 0x40) != 0) {
                    return this.isOpen;
                }
                throw new MidasException("BaseFile: No FileName specified");
            }
            if ((this.flags & 0x40000) != 0) {
                this.hasLinefeed = true;
            }
            if ((this.flags & 8) != 0) {
                this.isInput = (this.flags & 1) != 0 || this.exists();
                this.isOutput = true;
            } else {
                this.isInput = (this.flags & 1) != 0;
                this.isOutput = (this.flags & 2) != 0;
            }
            int dir = this.getDir(this.isInput, this.isOutput, false);
            this.isFound = this.find(dir);
            if ((this.M.debug & 1) != 0) {
                this.M.info("OpenBF tag=" + this.tag + " Path=" + this.getURL());
            }
            if (this.isInput && !this.isFound && this.cmd != null && this.cmd.isPiped && (this.flags & 0x200) != 0) {
                this.waitForFile();
                if (!this.isFound && (this.flags & 0x20) == 0) {
                    this.close();
                    return this.isOpen;
                }
            }
            dir = this.getDir(this.isInput, this.isOutput, this.isFound);
            try {
                if (this.isInput && !this.isFound) {
                    if ((this.flags & 0x20) != 0) {
                        return this.isOpen;
                    }
                    throw new CouldNotFindException();
                }
                this.isOpen = this.io.open(dir);
                if (!this.isOpen) {
                    throw new MidasException("Could not open");
                }
                this.setInternals();
                Table qualifiers = this.fn.getQualifierTable();
                if (KeyObject.setKeys(this, qualifiers, this.M, 1) > 0) {
                    this.setInternals();
                }
                if ((this.flags & 8) != 0) {
                    this.seek(this.getSize());
                }
            }
            catch (MidasException e) {
                this.io.close();
                this.isOpen = false;
                if ((this.flags & 0x20) == 0) {
                    throw new MidasException("Could not open " + this.getName() + ": " + e.getMessage(), "flags=" + this.getFlagsString(), e);
                }
                if ((this.M.debug & 1) == 0) break block17;
                this.M.printStackTrace(e);
            }
        }
        return this.isOpen;
    }

    protected void waitForFile() {
        if ((this.M.debug & 1) != 0) {
            this.M.info("Waiting for file: " + this.tag);
        }
        int oldState = 0;
        if (this.cmd != null) {
            oldState = this.cmd.state;
            this.cmd.state = -1;
        }
        while (!this.cmd.getInterrupt() && !this.cmd.finishing() && this.M.isPiped() && !this.isFound) {
            Time.sleep(0.1);
            this.isFound = this.find(-1);
        }
        if (this.isFound && this.cmd != null) {
            this.cmd.state = oldState;
        }
    }

    public void setFlags(String flags) {
        this.setFlags(Parser.mask(flagsList, flags, 0));
    }

    public void setFlags(int flag) {
        this.flags |= flag;
        if ((this.flags & 0x80) != 0) {
            this.setQualifier("USENATIVE", "Y");
        }
        if ((this.flags & 0x1000) != 0) {
            this.setQualifier("MKDIR", "Y");
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public String getFlagsString() {
        return Parser.mask2s(flagsList, this.getFlags());
    }

    @InternalUseOnly
    public static String getFlagsString(int flags) {
        return Parser.mask2s(flagsList, flags);
    }

    public void update() {
    }

    public void flush() {
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            return;
        }
        if ((this.M.debug & 1) != 0) {
            this.M.info("CloseBF tag=" + this.tag);
        }
        if (this.isOutput) {
            this.update();
        }
        if (this.io != null) {
            this.io.close();
        }
        this.isOpen = false;
    }

    public int erase(boolean force) {
        if (!this.find(-1)) {
            return 0;
        }
        if (!this.io.delete()) {
            return -1;
        }
        return 1;
    }

    @ProvisionalUseOnly(value="API may be removed at a later date")
    public void setName(MidasReference ref, Object filename) {
        this.M = Convert.ref2Midas(ref);
        if (ref != null && this.M != null && this.M.isJavaBehavior()) {
            this.flags |= 0x80000;
        }
        this.setName(filename);
    }

    public void setName(Object filename) {
        if (Midas.isJavaVsMidasDebug()) {
            this.M.info("#JvsM BaseFile.setName filename:" + filename + " flags:" + BaseFile.getFlagsString(this.flags) + " is FileName:" + (filename instanceof FileName));
        }
        this.fn = filename instanceof FileName ? (FileName)filename : BaseFile.getFileNameFor(this.M, Convert.o2s(filename), this.flags);
        if (this.fn.hasQualifiers()) {
            this.setAux(Convert.o2s(this.fn.getQualifier("AUX", this.aux), this.M));
            this.setTag(Convert.o2s(this.fn.getQualifier("TAG", this.tag), this.M));
            this.setFlags(Convert.o2s(this.fn.getQualifier("FLAGS", this.getFlagsString()), this.M));
        }
        if (this.tag == null || this.tag.length() == 0) {
            this.tag = this.fn.getTag();
        }
        this.filename = this.fn.getFullName();
    }

    public FileName getName() {
        return this.fn;
    }

    public FileName getFileName() {
        return this.fn;
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public static String getMimeType(Object ref, Object filename) {
        BaseFile bf = BaseFile.getInstanceFor(ref, filename);
        return bf.getMimeType();
    }

    protected void setInternals() {
        this.size = this.io.getLength();
    }

    public int write(byte[] buf, int boff, int bytes) {
        int status;
        if ((this.M.debug & 1) != 0) {
            this.M.info("WriteBF " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.io.write(buf, boff, bytes)) > 0) {
            this.offset += (double)status;
        }
        return status;
    }

    public int read(byte[] buf, int boff, int bytes) {
        int status;
        if ((this.M.debug & 1) != 0) {
            this.M.info("ReadBF " + this.tag + " bytes=" + bytes);
        }
        if ((status = this.io.read(buf, boff, bytes)) > 0) {
            this.offset += (double)status;
        } else if (status == -2 && this.cmd != null) {
            this.cmd.setState(7);
        }
        return status;
    }

    public void setFeqTolerance() {
        this.tolerance = this.cmd != null && this.cmd.args.find("/TOL") ? this.cmd.args.getD("/TOL") : Tolerance.getTolerance();
    }

    public void setFeqTolerance(double tol) {
        this.tolerance = tol;
    }

    public double getFeqTolerance() {
        return this.tolerance;
    }

    void setFeqAbsTolerance() {
        this.absTolerance = this.cmd != null && this.cmd.args.find("/DELTA") ? this.cmd.args.getD("/DELTA") : 0.0;
    }

    void setFeqAbsTolerance(double tol) {
        this.absTolerance = tol;
    }

    double getFeqAbsTolerance() {
        return this.absTolerance;
    }

    public byte readByte() {
        byte[] buf = new byte[1];
        this.read(buf, 0, 1);
        return buf[0];
    }

    public int seek(double off) {
        this.offset = off;
        if (this.io != null) {
            this.io.seek((long)off);
        }
        return 0;
    }

    public double seek() {
        return this.io.seek();
    }

    public double avail() {
        return this.io.avail();
    }

    public boolean isReady(double numElements) {
        int numBytes = (int)Math.ceil(numElements);
        return this.io.isReady(numBytes);
    }

    public String status() {
        return this.toString() + "\n" + this.listHeader();
    }

    public String toString() {
        String str = "Basic Resource=" + (this.io != null ? this.io.getTypeString() : " ") + " Name=" + (this.fn != null ? this.fn.getBasename() : "");
        return str;
    }

    public String listHeader() {
        String list3 = "FileName    :  " + this.getURL() + "\nSize        :  " + this.getSize() + "\nComment     :  " + this.getComment() + "\n";
        return list3;
    }

    public String listKeywords() {
        return "No keywords defined for " + Util.getClassName(this) + " class\n";
    }

    public String listElements(double start, int elements, String format, int flags) {
        String next;
        if (format != null) {
            int radix = this.flagsToRadix(flags);
            Data data = new Data(format, elements);
            this.seek(start * (double)data.bpe);
            elements = this.read(data.buf, 0, elements * data.bpe) / data.bpe;
            if (elements <= 0) {
                return null;
            }
            return data.toString(0, elements * data.spa, radix) + "\n";
        }
        int num = elements > 16 ? 16 : elements;
        Data data = new Data("SB", num);
        this.seek(start * (double)data.bpe);
        num = this.read(data.buf, 0, num);
        if (num <= 0) {
            return null;
        }
        StringBuilder hex = new StringBuilder();
        StringBuilder ascii = new StringBuilder();
        StringBuilder tail = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if (i == 8) {
                hex.append(' ');
            }
            hex.append(' ');
            if (i < num) {
                byte b = data.buf[i];
                hex.append(Integer.toHexString(b >> 4 & 0xF));
                hex.append(Integer.toHexString(b & 0xF));
                if (b < 32) {
                    ascii.append('.');
                    continue;
                }
                if (b == 127) {
                    ascii.append('.');
                    continue;
                }
                ascii.append((char)b);
                continue;
            }
            hex.append("  ");
            tail.append(" ");
        }
        hex.append("  |").append((CharSequence)ascii).append("|").append((CharSequence)tail).append('\n');
        if (elements > 16 && (next = this.listElements(start + (double)num, elements - num, format, flags)) != null) {
            hex.append(next);
        }
        return hex.toString();
    }

    protected int flagsToRadix(int flags) {
        int radix = 10;
        if ((flags & 1) != 0) {
            radix = 16;
        }
        if ((flags & 4) != 0) {
            radix = 8;
        }
        if ((flags & 2) != 0) {
            radix = 1;
        }
        return radix;
    }

    public int listElementsPerLine(int lineWidth, String format, int flags) {
        return format != null ? lineWidth / 4 : 16;
    }

    public double getSize() {
        return this.size;
    }

    public double getOffset() {
        return this.offset;
    }

    public String getAux() {
        return this.aux;
    }

    public String getTag() {
        return this.tag;
    }

    public String getComment() {
        return this.comment;
    }

    public String getURL() {
        if (this.io == null) {
            return this.fn.getFullName();
        }
        return this.io.getURL();
    }

    public Table getQualifiers() {
        return this.fn.getQualifierTable();
    }

    public Object getQualifier(String key) {
        return this.fn.getQualifier(key);
    }

    public void setQualifier(String key, Object value) {
        this.fn.setQualifier(key, value);
    }

    public boolean setDefaultQualifier(String key, Object value) {
        return this.getQualifiers().addIfNotPresent(key, value);
    }

    public boolean setDefaultQualifiers(Map<String, Object> defQualsMap) {
        return this.getQualifiers().addIfNotPresent(defQualsMap);
    }

    public IOResource getResource() {
        return this.io;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isStream() {
        return this.io.isStream();
    }

    public boolean isStreaming() {
        return this.io.isStreaming();
    }

    public boolean isDir() {
        if (!FileUtil.isLocalFileName(this.filename)) {
            return this.exists();
        }
        CoreIO io = this.M != null ? this.M.io : new CoreIO();
        return io.dexists(this.fn.getFullName());
    }

    public void setSize(double value) {
        this.size = value;
    }

    public void setAux(String value) {
        if (value != null && Shell.getAuxPath(value) == null) {
            throw new MidasException("Can not set AUX to '" + value + "' for " + this.getName() + " unknown AUX.");
        }
        this.aux = value;
    }

    public void setTag(String value) {
        this.tag = value;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public void setExt(String ext) {
        this.fn.setExt(ext);
    }

    public void setExtDefault(String ext) {
        if (this.fn.getExt().length() == 0) {
            this.fn.setExt(ext);
        }
    }

    public void setAux(int value) {
        this.setAux(Integer.toString(value));
    }

    public boolean setOutput(boolean value) {
        this.isOutput = value && (this.flags & 2) != 0;
        return this.isOutput;
    }

    public int rename(String newUrl) {
        if (!this.find(-1)) {
            return 0;
        }
        boolean ok = CoreIO.rename(this.getURL(), newUrl);
        return ok ? 1 : -1;
    }

    @Deprecated
    public static FileName getFileNameFor(Object ref, String filename) {
        return BaseFile.getFileNameFor(Convert.ref2MidasReference(ref), filename);
    }

    public static FileName getFileNameFor(MidasReference ref, String filename) {
        Midas refM = Convert.ref2Midas(ref);
        if (refM != null && refM.isJavaBehavior()) {
            return BaseFile.getFileNameFor(ref, filename, 524288);
        }
        return BaseFile.getFileNameFor(ref, filename, 0);
    }

    public static FileName getFileNameFor(MidasReference ref, String filename, int flags) {
        if (filename == null || filename.length() == 0) {
            return new FileName("");
        }
        if (filename.charAt(0) == '\"') {
            return new FileName(filename);
        }
        String tag = null;
        int ls = filename.length();
        int lr = Results.validNameLength(filename, 0);
        if (lr > 0 && filename.charAt(lr - 1) == ')') {
            int lp = filename.indexOf(40);
            if (filename.indexOf(58, lp) > 0) {
                lr = lp;
            }
            if (filename.indexOf(61, lp) > 0) {
                lr = lp;
            }
        }
        if (lr != 0) {
            if (lr == ls) {
                tag = filename;
            } else if (filename.charAt(lr) == '{') {
                tag = filename.substring(0, lr);
            } else if (filename.charAt(lr) == '(') {
                tag = filename.substring(0, lr);
            }
        }
        Results rt = Convert.ref2Results(ref);
        if (tag != null && rt != null) {
            Object value = rt.get(tag = tag.toUpperCase());
            if (value instanceof String || value instanceof Data && ((Data)value).isString()) {
                filename = lr == ls ? value.toString() : value.toString() + filename.substring(lr);
            } else {
                if (value instanceof FileName) {
                    FileName fn = ((FileName)value).cloneOf();
                    if (lr < ls) {
                        fn.append(filename.substring(lr));
                    }
                    return fn;
                }
                tag = null;
            }
        }
        if (Midas.isJavaVsMidasDebug()) {
            Midas.log("#JvsM BaseFile.getFileNameFor " + filename + " flags:" + BaseFile.getFlagsString(flags), 0);
        }
        FileName.FNCase fnCase = (flags & 0x80000) != 0 ? FileName.FNCase.KeepCase : FileName.getDefaultFNCase();
        FileName fn = new FileName(filename, fnCase);
        if (tag != null) {
            fn.setTag(tag);
        }
        return fn;
    }

    @Deprecated
    public static BaseFile getInstanceFor(Object ref, Object filename) {
        return BaseFile.getInstanceFor(Convert.ref2MidasReference(ref), filename);
    }

    public static BaseFile getInstanceFor(MidasReference ref, Object filename) {
        String ext;
        BaseFile file = null;
        FileName fn = filename instanceof FileName ? (FileName)filename : BaseFile.getFileNameFor(ref, Convert.o2s(filename));
        String fg = Convert.o2s(fn.getQualifier("FG"));
        String string = ext = fg == null ? fn.getExt() : fg;
        if (ext.length() == 0 && fn.getRoot().length() > 0) {
            return new DataFile(ref, filename);
        }
        String className = fg != null && fg.indexOf(46) > 0 ? fg : Registry.getHandlerName("FILE." + ext.toUpperCase());
        if (className == null) {
            file = new BaseFile(ref, filename);
        } else {
            file = (BaseFile)Shell.getInstanceForClassName(className);
            file.init(ref, filename);
        }
        if (file instanceof TextFile) {
            file.setFlags(8192);
        }
        return file;
    }

    public static int parseFileTestFlag(String feqString) {
        int iSlash = feqString.indexOf("/");
        if (iSlash < 0) {
            return 32768;
        }
        String str = feqString.substring(iSlash + 1).replace('/', '|');
        return Parser.mask("B,S,H,D,K,T,,,,,L", str, 0);
    }

    public int hashCode() {
        return (int)this.getSize();
    }

    public boolean equals(Object inobj) {
        return this.equals(inobj, 32768);
    }

    public boolean equals(Object inobj, int flags) {
        return this.equalsBF(inobj, flags);
    }

    public boolean equalsBF(Object inobj, int flags) {
        if (this == inobj) {
            return true;
        }
        if (inobj == null) {
            return false;
        }
        boolean theSame = false;
        if (inobj.getClass() == this.getClass()) {
            BaseFile bf1 = this;
            BaseFile bf2 = (BaseFile)inobj;
            bf1.open();
            bf2.open();
            if (flags == 32768) {
                flags = 3;
            }
            boolean sameSize = true;
            if ((flags & 2) != 0) {
                sameSize = bf1.getSize() == bf2.getSize();
            }
            boolean sameBinary = true;
            if (theSame && (flags & 1) != 0 || (flags & 0x400) != 0) {
                if (bf1.getSize() != 0.0 && bf2.getSize() != 0.0) {
                    double size;
                    sameBinary = (flags & 0x400) != 0 ? BaseFile.compare(bf1, bf2, 0.0, size = Math.min(bf1.getSize(), bf2.getSize())) == 0 : (bf1.getSize() == bf2.getSize() ? BaseFile.compare(bf1, bf2, 0.0, bf1.getSize()) == 0 : false);
                } else if (bf1.getSize() != 0.0 || bf2.getSize() != 0.0) {
                    sameBinary = false;
                }
            }
            theSame = sameSize && sameBinary;
            bf1.close();
            bf2.close();
        }
        return theSame;
    }

    public static int compare(BaseFile bf1, BaseFile bf2, double offset, double size) {
        int bytes;
        int bytesPer = (int)Math.min((double)BUFFER_SIZE, size);
        byte[] buf1 = new byte[bytesPer];
        byte[] buf2 = new byte[bytesPer];
        bf1.seek(offset);
        bf2.seek(offset);
        for (double off = 0.0; off < size; off += (double)bytes) {
            bytes = (int)Math.min((double)bytesPer, size - off);
            if (BaseFile.readBytes(buf1, bf1, bytes) < 0) {
                return 1;
            }
            if (BaseFile.readBytes(buf2, bf2, bytes) < 0) {
                return 1;
            }
            if (Arrays.equals(buf1, buf2)) continue;
            return 1;
        }
        return 0;
    }

    public Object[] getEntries() {
        return null;
    }

    private static int readBytes(byte[] buf, BaseFile bf, int bytes) {
        boolean eof = false;
        int read = 0;
        int toRead = bytes;
        while (toRead > 0 && !eof) {
            read = bf.read(buf, bytes - toRead, toRead);
            if (read < 0) {
                eof = true;
                continue;
            }
            if (read == 0) {
                Time.sleep(Shell.getSharedMidasContext().pause);
                continue;
            }
            toRead -= read;
        }
        return eof ? -(bytes - toRead) : bytes;
    }

    @Deprecated
    public static int copy(BaseFile bf1, BaseFile bf2) {
        byte[] buf = new byte[BUFFER_SIZE];
        boolean done = false;
        while (!done) {
            int bytesRead = bf1.read(buf, 0, buf.length);
            if (bytesRead == 0) {
                Time.sleep(Shell.getSharedMidasContext().pause);
                continue;
            }
            if (bytesRead < 0) {
                done = true;
                continue;
            }
            bf2.write(buf, 0, bytesRead);
        }
        return 0;
    }

    public static int delete(String path) {
        int ndel = 0;
        File file = new File(path);
        if (file.isDirectory()) {
            String[] list3 = file.list();
            for (int i = 0; i < list3.length; ++i) {
                ndel += BaseFile.delete("" + new File(path, list3[i]));
            }
            if (file.delete()) {
                ++ndel;
            }
        } else if (file.delete()) {
            ++ndel;
        }
        return ndel;
    }

    @InternalUseOnly(value="Since NeXtMidas 3.5.4, this will probably be removed in a future beta series")
    void warning(CharSequence msg) {
        Midas midas = Convert.ref2Midas(this.M);
        midas.warning(msg);
    }

    protected void insertBytes(long off, long num) {
        if (off > this.io.getLength()) {
            this.io.setLength(off + num);
        } else {
            long oldLength = this.io.getLength();
            long newLength = oldLength + num;
            byte[] buf = new byte[32678];
            long pos = oldLength;
            this.io.setLength(newLength);
            while (pos > off) {
                int toRead = (int)Math.min(pos - off, (long)buf.length);
                int numRead = this.io.read(buf, 0, toRead, pos - (long)toRead);
                if (numRead != toRead) {
                    throw new MidasException("Error while trying to insert content into " + this.getName());
                }
                this.io.write(buf, 0, numRead, (pos -= (long)numRead) + num);
            }
        }
    }

    protected void removeBytes(long off, long num) {
        if (off <= this.io.getLength()) {
            if (off + num > this.io.getLength()) {
                this.io.setLength(off);
            } else {
                int numRead;
                long oldLength = this.io.getLength();
                long newLength = oldLength - num;
                byte[] buf = new byte[32678];
                for (long pos = off + num; pos < oldLength; pos += (long)numRead) {
                    int toRead = (int)Math.min(oldLength - pos, (long)buf.length);
                    numRead = this.io.read(buf, 0, toRead, pos);
                    if (numRead != toRead) {
                        throw new MidasException("Error while trying to remove content from " + this.getName());
                    }
                    this.io.write(buf, 0, numRead, pos - num);
                }
                this.io.write(new byte[32678], 0, (int)num, newLength);
                this.io.setLength(newLength);
            }
        }
    }

    static class CouldNotFindException
    extends MidasException {
        private static final long serialVersionUID = 100271L;

        public CouldNotFindException() {
            super("Could not find");
        }
    }
}

