/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.SSLUtilities;

public class Sslconfigure
extends Intrinsic {
    @Override
    public int open() {
        String propsFile = this.MA.getCS("PROPSFILE", null);
        String privKeyFile = this.MA.getCS("PRIVKEYFILE", null);
        String passwd = this.MA.getCS("PASSWORD", null);
        String passwdFile = this.MA.getCS("PASSWORDFILE", null);
        SSLUtilities.setNssLibsDir(this.MA.getCS("NSSLIBSDIR", null));
        String label = this.MA.getU("LABEL", null);
        boolean insecure = this.MA.getState("/INSECURE", this.MA.find("/INSECURE"));
        boolean noHostNameVerification = this.MA.getState("/ANYHOSTNAME", this.MA.find("/ANYHOSTNAME"));
        String userDN = null;
        boolean enlargeJdkTlsMaxs = this.MA.getState("/BIGTLSMAX", this.MA.find("/BIGTLSMAX"));
        if (enlargeJdkTlsMaxs) {
            System.setProperty("jdk.tls.maxHandshakeMessageSize", "60000");
            System.setProperty("jdk.tls.maxCertificateChainLength", "70");
        }
        if (insecure) {
            boolean propsForUser = this.MA.getState("/PROPSFORUSER", this.MA.find("/PROPSFORUSER"));
            userDN = !propsForUser && propsFile == null ? SSLUtilities.initInsecureSSL(this.M, privKeyFile, passwd, passwdFile) : SSLUtilities.initInsecureSSL(this.M, privKeyFile, passwd, passwdFile, propsFile, true);
        } else if (noHostNameVerification) {
            userDN = SSLUtilities.initAnyHostNameSSL(this.M, null, propsFile, privKeyFile, passwd, passwdFile, null, null);
        } else {
            if (this.MA.find("PWDFILE")) {
                this.M.deprecate("Use of PWDFILE= is deprecated, use PASSWORDFILE=");
            }
            userDN = SSLUtilities.initSSLContext(this.M, null, propsFile, privKeyFile, passwd, passwdFile, null, null);
        }
        if (label != null && !label.isEmpty()) {
            this.MR.put(label, (Object)userDN);
        }
        if (this.verbose) {
            this.M.info("SSLCONFIGURE: Configuration complete for " + userDN);
        }
        return 9;
    }
}

