/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.util.Arrays;
import java.util.Map;
import nxm.sys.inc.Keyable;
import nxm.sys.intr.Message;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class Results
extends Intrinsic {
    public static char SHOW_DELIM = (char)34;
    public static final String DEF_FILENAME = "results.tmp";
    String label;
    String value;
    String outRes;
    FileName inFile;
    FileName outFile;
    boolean all;
    boolean isSet;
    nxm.sys.lib.Results rt;
    String[] restrictedSets = new String[]{"AUX", "ENV", "OPT", "RAM", "REG"};

    @Override
    public int open() {
        this.rt = this.MR;
        this.label = this.MA.getU("LABEL");
        this.value = this.MA.getUQ("VALUE");
        this.all = this.MA.getZ("/ALL");
        this.outRes = this.MA.getU("/RES", null);
        this.isSet = this.value != null;
        int len = this.MA.getLength("/LOAD");
        if (len >= 0) {
            this.inFile = len == 0 ? new FileName(DEF_FILENAME) : this.MA.getFileName("/LOAD");
            BaseFile bf = BaseFile.getInstanceFor(this, (Object)this.inFile);
            if (bf instanceof TextFile) {
                this.loadFromTextFile(bf);
            } else if (bf instanceof DataFile) {
                this.loadFromDataFile(bf);
            }
            return 9;
        }
        len = this.MA.getLength("/SAVE");
        if (len >= 0) {
            BaseFile bf;
            FileName fileName = this.outFile = len == 0 ? new FileName(DEF_FILENAME) : this.MA.getFileName("/SAVE");
            if (this.rt.get(this.label) != null) {
                this.outRes = this.rt.get(this.label).toString();
            }
            if ((bf = BaseFile.getInstanceFor(this, (Object)this.outFile)) instanceof TextFile) {
                this.saveToTextFile(bf, this.outRes);
            } else if (bf instanceof DataFile) {
                this.saveToDataFile(bf, this.outRes);
            } else {
                throw new MidasException("Unsupported file type " + bf.getClass());
            }
            return 9;
        }
        return 0;
    }

    @Override
    public int process() {
        this.rt = this.MR;
        boolean sp = this.MA.getState("/PARENT");
        boolean sg = this.MA.getState("/GLOBAL");
        if (sp && sg) {
            this.M.warning("/PARENT and /GLOBAL switches both present. Using /GLOBAL.");
        }
        if (sg) {
            this.rt = (nxm.sys.lib.Results)this.MR.getRoot();
        } else if (sp) {
            this.rt = (nxm.sys.lib.Results)this.MR.getPrevious();
        }
        if (this.isSet) {
            int attr = 0;
            if (this.value == null && this.label.indexOf(40) < 0) {
                this.M.error("No value specified for " + this.label);
            }
            if (this.MA.getState("/FORCE")) {
                attr |= 0x10;
            }
            if (this.MA.getState("/ADDROOT")) {
                attr |= 0x20;
            }
            if (this.isRestricted(this.label)) {
                this.M.error("Forbidden to overwrite result: " + this.label);
            }
            if (this.label.length() < 2 || this.label.charAt(1) != ':') {
                this.label = "_:" + this.label;
            }
            this.rt.put(this.label, this.value, attr, this.args);
            return 9;
        }
        int radix = -1;
        if (this.MA.getState("/HEX")) {
            radix = 16;
        }
        if (this.MA.getState("/OCT")) {
            radix = 8;
        }
        if (this.MA.getState("/BIN")) {
            radix = 2;
        }
        radix = this.MA.getL("/RADIX", radix);
        int count = 0;
        boolean doCount = false;
        String countID = this.MA.get("/COUNT");
        if (countID != null) {
            countID = countID.toUpperCase();
            doCount = true;
        }
        if (this.outRes != null) {
            Object val = Data.toRadix(radix, this.rt.get(this.label));
            if (val == null) {
                this.M.println("Result [" + this.label + "] not found");
            }
            this.MR.put(this.outRes, val);
        } else {
            count = this.label.length() == 0 ? Results.listMultipleResult(this.M, this.rt, this.label, 0, this.all, radix, doCount, this.verbose) : (StringUtil.isWildcardString(this.label) ? Results.listMultipleResult(this.M, this.rt, this.label, 0, this.all, radix, doCount, this.verbose) : Results.listSingleResult(this.M, this.rt, this.label, 0, this.all, radix, doCount, this.verbose));
        }
        if (doCount) {
            this.MR.put(countID, count);
            doCount = false;
            count = 0;
            Results.listSingleResult(this.M, this.rt, countID, 0, this.all, radix, true, true);
        }
        return 9;
    }

    private void saveToTextFile(BaseFile bf, String myRes) {
        TextFile tf = (TextFile)bf;
        tf.open(8194);
        if (this.label.equals("*") || this.label.equals("")) {
            tf.write(this.rt.toString());
        } else if (myRes != null) {
            String outString = this.label + "=" + myRes;
            tf.write(outString);
        } else {
            this.M.warning("Results " + this.label + " not found");
        }
        tf.close();
    }

    private void saveToDataFile(BaseFile bf, String myRes) {
        DataFile df = (DataFile)bf;
        df.open(2);
        df.setType(1000);
        df.setFormat("TA");
        Keywords kw = df.getKeywordsObject();
        kw.add("RESULTS_DUMP", "START");
        if (this.label.equals("*") || this.label.equals("")) {
            String[] keys;
            for (String key : keys = this.rt.getKeys()) {
                if (!(this.rt.get(key) instanceof Data) && !(this.rt.get(key) instanceof Table) && !(this.rt.get(key) instanceof String)) continue;
                kw.add(key, this.rt.get(key));
            }
        } else if (myRes != null) {
            kw.add(this.label, myRes);
        } else {
            this.M.warning("Results " + this.label + " not found");
        }
        kw.add("RESULTS_DUMP", "END");
        df.close();
    }

    private void loadFromTextFile(BaseFile bf) {
        Table myInput = new Table((TextFile)bf);
        this.loadFromTable(myInput);
    }

    private void loadFromDataFile(BaseFile bf) {
        DataFile df = (DataFile)bf;
        df.open(8193);
        Keywords myKeys = df.getKeywordsObject();
        Keywords.Iterator kwi = myKeys.iterator();
        Keywords.Key key = null;
        boolean loadIt = false;
        Table myRes = new Table();
        while (kwi.hasNext()) {
            key = kwi.next();
            if (key.name.equals("RESULTS_DUMP") && key.value.toString().equals("START")) {
                loadIt = true;
            } else if (key.name.equals("RESULTS_DUMP") && key.value.toString().equals("END")) {
                loadIt = false;
            }
            if (loadIt && !key.name.equals("RESULTS_DUMP") && !this.isRestricted(key.name)) {
                Object myObj = Convert.s2o(key.value.toString(), null);
                myRes.put(key.name, myObj);
                continue;
            }
            if (!this.isRestricted(key.name)) continue;
            this.M.warning("Forbidden to overwrite " + key.name);
        }
        this.loadFromTable(myRes);
        df.close();
    }

    private void loadFromTable(Table myRes) {
        String[] keys;
        for (String key : keys = myRes.getKeys()) {
            if (this.isRestricted(key)) {
                this.M.warning("Forbidden to overwrite " + key);
                continue;
            }
            this.rt.put(key, myRes.get(key));
        }
    }

    private boolean isRestricted(String key) {
        return Arrays.binarySearch(this.restrictedSets, key) >= 0;
    }

    static void listSingleResult(Midas M, Map<?, ?> map, String key, int level, boolean recurse) {
        Results.listSingleResult(M, map, key, level, recurse, -1, false, false);
    }

    private static int listSingleResult(Midas M, Map<?, ?> map, String key, int level, boolean recurse, int radix, boolean doCount, boolean verbose) {
        int count = 0;
        Object result = map.get(key);
        if (result == null) {
            M.println("Result [" + key + "] not found");
        } else {
            count = Results.doMultiple(M, key, result, "*", level, recurse, level, radix, doCount, verbose);
        }
        return count;
    }

    static void listMultipleResult(Midas M, Map<?, ?> map, String match, int level, boolean recurse) {
        Results.listMultipleResult(M, map, match, level, recurse, -1, false, false);
    }

    private static int listMultipleResult(Midas M, Map<?, ?> map, String match, int level, boolean recurse, int radix, boolean doCount, boolean verbose) {
        if (level > 0) {
            match = "*";
        }
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object value;
            String key = entry.getKey().toString();
            if (key == null || (value = entry.getValue()) == null) continue;
            count += Results.doMultiple(M, key, value, match, level, recurse, -1, radix, doCount, verbose);
        }
        return count;
    }

    public static void listMultiple(Midas M, Map<?, ?> map, String match, int level, boolean recurse) {
        Results.listMultipleResult(M, map, match, level, recurse);
    }

    private static void listMultipleKeyable(Midas M, Keyable keyable, String match, int level, boolean recurse, int radix) {
        String[] keys;
        for (String key : keys = keyable.getKeys()) {
            if (key == null) continue;
            Object value = keyable.getKey(key);
            Results.doMultiple(M, key, value, match, level, recurse, -1, radix, false, false);
        }
    }

    private static void listMultipleKeyVector(Midas M, KeyVector kv, String match, int level, boolean recurse, int radix) {
        for (int i = 0; i < kv.size(); ++i) {
            String key = kv.getKey(i);
            Object value = kv.get(i);
            Results.doMultiple(M, key, value, match, level, recurse, -1, radix, false, false);
        }
    }

    static int doMultiple(Midas M, String key, Object result, String match, int level, boolean recurse, int rlevel, int radix, boolean doCount, boolean verbose) {
        int count = 0;
        if (match == null || match.length() == 0 || StringUtil.isWildcardMatch(match, key)) {
            ++count;
            if (!doCount || verbose) {
                M.println(Results.formatEntry(key, result, level, radix));
            }
        } else {
            return count;
        }
        if (result instanceof nxm.sys.lib.Results) {
            M.println(Results.formatEntry(key, result, level, radix));
        } else if (recurse || level == rlevel) {
            if (result instanceof Map) {
                count += Results.listMultipleResult(M, (Map)result, match, level + 1, recurse, radix, doCount, verbose);
            } else if (result instanceof KeyVector) {
                Results.listMultipleKeyVector(M, (KeyVector)result, match, level + 1, recurse, radix);
            } else if (result instanceof Keyable && !(result instanceof Command)) {
                Results.listMultipleKeyable(M, (Keyable)result, match, level + 1, recurse, radix);
            }
        }
        return count;
    }

    private static String showEntry(String key, Object object, int level) {
        return Results.formatEntry(key, object, level, -1);
    }

    static String formatEntry(String key, Object object, int level, int radix) {
        String obj;
        int i;
        String spec;
        if (object instanceof Data) {
            spec = ((Data)object).getSpecs();
        } else {
            char type = Data.getDataTypeLetter(object);
            int mult = Data.getMultiplier(object);
            spec = mult < 0 ? String.valueOf(type) : String.valueOf(mult) + String.valueOf(type);
        }
        object = Data.toRadix(radix, object);
        if (object instanceof Map) {
            String name = object.getClass().getName();
            i = name.lastIndexOf(36);
            if (i < 0) {
                i = name.lastIndexOf(46);
            }
            obj = name.substring(i + 1) + " of " + ((Map)object).size() + " entries";
        } else if (object instanceof Message) {
            obj = "A " + ((Message)object).name + " message";
        } else if (object instanceof Keyable && !(object instanceof Command)) {
            String name = object.getClass().getName();
            i = name.lastIndexOf(36);
            if (i < 0) {
                i = name.lastIndexOf(46);
            }
            obj = name.substring(i + 1) + " with " + ((Keyable)object).getKeys().length + " keys";
        } else if (object instanceof String[]) {
            obj = "Array of " + ((String[])object).length + " strings";
        } else if (object instanceof String) {
            obj = object.toString();
            String str = obj;
            if (str.startsWith(" ") || str.endsWith(" ") || str.equals("")) {
                obj = SHOW_DELIM + str + SHOW_DELIM;
            }
        } else {
            obj = object == null ? "null" : object.toString();
        }
        return Results.format(key, obj, spec, level);
    }

    private static String format(String key, String obj, String spec, int level) {
        int i;
        StringBuilder str = new StringBuilder();
        for (i = spec.length(); i < 3; ++i) {
            str.append(' ');
        }
        str.append(spec).append(": ");
        for (i = 0; i < level; ++i) {
            str.append(' ');
        }
        str.append(key);
        for (i = str.length(); i < 20; ++i) {
            str.append(' ');
        }
        str.append(" = ").append(obj);
        return str.toString();
    }

    @Override
    public String getStatus() {
        Object obj = this.rt.get(this.label);
        return obj == null ? "NULL" : obj.toString();
    }
}

