/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import java.awt.Color;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import nxm.sys.inc.Installation;
import nxm.sys.inc.MessageHandler;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GCalendar;
import nxm.sys.libg.GDialog;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GLabel;
import nxm.sys.libg.GLine;
import nxm.sys.libg.GList;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPanel;
import nxm.sys.libg.GPipeMonitor;
import nxm.sys.libg.GProgress;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GQuery;
import nxm.sys.libg.GSText;
import nxm.sys.libg.GText;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MColor;
import nxm.sys.libg.WidgetPanel;
import nxm.sys.prim.list;
import nxm.sys.prim.panel;

public class Gcontrol
extends Intrinsic {
    private String type;
    private String name;
    private GWidget widget;
    private Object parent;
    private MessageHandler owner;
    private boolean oneshot;
    private boolean defMsg;
    private int flags;
    private GMenu menu;
    private Table setTable = null;

    @Override
    public int open() {
        String value;
        Table gcdt;
        Object themeObj;
        GDialog gd;
        String handle;
        block85: {
            String winString;
            this.type = this.MA.getU("TYPE");
            this.name = this.MA.getU("NAME");
            String panel2 = this.MA.getU("/PANEL", "PANEL");
            handle = this.MA.getU("/HANDLE");
            this.parent = this.M.registry.get(panel2);
            if (this.parent == null) {
                this.parent = this;
            }
            boolean bl = this.oneshot = this.parent == this;
            if (this.MA.find("/WIN") && ((winString = this.MA.getS("/WIN")) == null || winString.equals(""))) {
                this.parent = this;
            }
            if (this.MA.getState("/WAIT")) {
                this.oneshot = true;
            }
            this.setTable = this.MA.getTable("TABLE");
            gd = this.parent instanceof GDialog ? (GDialog)this.parent : null;
            this.defMsg = gd == null;
            this.flags = 0;
            if (this.oneshot) {
                this.owner = this;
            } else {
                this.owner = this.M.macro;
                if (!this.MA.getState("/TEMP")) {
                    this.flags |= 1;
                }
            }
            if (this.MA.getState("/HEADLESS", Shell.isHeadless())) {
                this.flags |= Integer.MIN_VALUE;
            }
            if (this.parent instanceof panel && (this.flags & 1) == 0) {
                this.parent = ((panel)this.parent).MW;
            }
            if (this.parent instanceof list) {
                this.parent = ((list)this.parent).MW;
            }
            if (this.type.startsWith("MENU")) {
                String title = this.MA.getU("TITLE", "Menu");
                String list3 = this.MA.getCS("P1", "Item 1,Item 2,Item 3,Item 4");
                this.flags = this.getFlags(GMenu.flagsList, this.flags | 0x4000000);
                this.menu = new GMenu(null, title, list3, 0, this.flags, this.owner);
                this.menu.setColumns(this.MA.getL("/NC", 0));
            } else if (this.type.startsWith("CHOI")) {
                String title = this.MA.getU("TITLE", "Choice");
                String list4 = this.MA.getCS("P1", "Item 1,Item 2,Item 3,Item 4");
                this.flags = this.getFlags(GMenu.flagsList, this.flags | 0x100);
                int nc = this.MA.getL("/NC", 0);
                if (nc == 0) {
                    this.flags |= 0x20000;
                }
                if (title.length() == 0) {
                    this.flags |= 0x10000;
                }
                this.menu = new GMenu(null, title, list4, 0, this.flags, this.owner);
                this.menu.setColumns(nc);
            } else if (this.type.startsWith("BUTT")) {
                String title = this.MA.getU("TITLE", "");
                String list5 = this.MA.getCS("P1", "Button 1,Button 2,Button 3");
                this.flags = this.getFlags(GMenu.flagsList, this.flags | 0x200 | 0x4000000);
                int nc = this.MA.getL("/NC", 0);
                if (nc == 0) {
                    this.flags |= 0x20000;
                }
                if (title.length() == 0) {
                    this.flags |= 0x10000;
                }
                this.menu = new GMenu(null, title, list5, 0, this.flags, this.owner);
                this.menu.setColumns(nc);
            } else if (this.type.indexOf("VAL") == 1) {
                char dt = this.type.charAt(0);
                String title = this.MA.getU("TITLE", "Value");
                double defMax = 1.0;
                double defMin = 0.0;
                double defVal = 0.5;
                if (dt == 'T') {
                    defMax = -1.0;
                    defVal = 0.0;
                }
                double v = this.MA.getD("P1", this.MA.getD("DEF", defVal));
                double v1 = this.MA.getD("P2", this.MA.getD("MIN", defMin));
                double v2 = this.MA.getD("P3", this.MA.getD("MAX", defMax));
                double defInc = (v2 - v1) / 20.0;
                if (dt == 'T') {
                    defInc = 1.0;
                }
                double vd = this.MA.getD("P4", this.MA.getD("INC", defInc));
                if (!this.MA.find("/MSGONDRAG") && !this.MA.find("/NOMSGONDRAG")) {
                    this.flags |= 0x20000;
                }
                this.flags = this.getFlags(GValue.flagsList, this.flags);
                this.widget = new GValue(null, title, v, v1, v2, vd, dt, this.flags, this.owner);
                ((GValue)this.widget).setFormat(this.MA.getU("/FMT"), this.MA.getO("/MULT", null));
            } else if (this.type.startsWith("PROMPT")) {
                String title = this.MA.getU("TITLE", "Input");
                String seed = this.MA.getCS("P1", this.MA.getCS("DEF", "default"));
                int digits = this.MA.getL("P2", this.MA.getL("LEN", 10));
                this.flags = this.getFlags(GPrompt.flagsList, this.flags);
                this.widget = new GPrompt(null, title, seed, digits, this.flags, this.owner);
            } else if (this.type.startsWith("TEXT")) {
                String title = this.MA.getU("TITLE", "Message");
                String text = this.MA.getCS("P1", "");
                int cols = this.MA.getL("P2", 24);
                int rows = this.MA.getL("P3", 1);
                this.flags = this.getFlags(GText.flagsList, this.flags);
                this.widget = new GText(null, title, text, cols, rows, this.flags, this.owner);
            } else if (this.type.startsWith("LIST")) {
                String title = this.MA.getU("TITLE", "Title");
                String text = this.MA.getCS("P1", "");
                int cols = this.MA.getL("P2", 24);
                int rows = this.MA.getL("P3", 1);
                this.flags = this.getFlags(GList.flagsList, this.flags);
                this.widget = new GList(null, title, text, cols, rows, this.flags, this.owner);
            } else if (this.type.startsWith("FILE")) {
                String title = this.MA.getU("TITLE", "FileName");
                String seed = this.MA.getCS("P1", "");
                String filt = this.MA.getCS("P2", "*.tmp|prm");
                String raux = this.MA.getCS("P3", this.MR.getS("AUX.WRITE"));
                int cols = this.MA.getL("P4", 50);
                int rows = this.MA.getL("P5", 15);
                this.flags = this.getFlags(GFiles.flagsList, this.flags);
                this.widget = (this.flags & 1) != 0 ? new GPrompt(null, title, seed, filt, raux, this.M, cols, rows, this.flags, this.owner) : new GFiles(null, title, seed, filt, raux, this.M, cols, rows, this.flags, this.owner);
            } else if (this.type.startsWith("PROG")) {
                String title = this.MA.getU("TITLE", "Message");
                String list6 = this.MA.getCS("P1", "Run,Pause,Exit");
                String text = this.MA.getCS("P2", "Job Completion Status");
                int cols = this.MA.getL("P3", 0);
                int rows = this.MA.getL("P4", 0);
                this.flags = this.getFlags(GProgress.flagsList, this.flags);
                this.widget = new GProgress(null, title, list6, text, cols, rows, this.flags, this.owner);
            } else if (this.type.startsWith("LABEL")) {
                this.defMsg = false;
                String title = this.MA.getCS("TITLE", "Section Title");
                String active = this.MA.getS("P1", "Open");
                this.flags = this.getFlags(GLabel.flagsList, this.flags);
                this.widget = new GLabel((Object)null, title, active, this.flags, this.owner);
            } else if (this.type.startsWith("LINE")) {
                Color c = MColor.getColor(this.MA.getS("P1", MColor.toString(GLine.DEF_COLOR)));
                int thickness = this.MA.getL("P2", 4);
                int percent = this.MA.getL("P3", 100);
                int linePos = GLine.getLinePosValue(this.MA.getS("P4", "LEFT"));
                this.flags = this.getFlags(GLine.flagsList, this.flags);
                this.widget = new GLine(null, this.name, c, thickness, percent, linePos, this.flags, this.owner);
            } else if (this.type.startsWith("ALERT")) {
                String title = this.MA.getU("TITLE", "Alert");
                String text = this.MA.getCS("P1", "Message Text");
                String list7 = this.MA.getCS("P2", "OK");
                int def = this.MA.getL("P3", 1);
                int timeout = this.MA.getL("/TIMEOUT", -1);
                this.flags = this.getFlags(GAlert.flagsList, this.flags);
                this.widget = new GAlert(null, title, text, list7, def, this.flags, this.owner, timeout);
            } else if (this.type.startsWith("PANEL")) {
                String title = this.MA.getCS("TITLE", "Panel");
                int pw = this.MA.getL("P1", this.MA.getL("WIDTH", 200));
                int ph = this.MA.getL("P2", this.MA.getL("HEIGHT", 200));
                this.flags = this.getFlags(GPanel.flagsList, this.flags);
                this.widget = new GPanel(null, title, pw, ph, this.flags, this.owner);
            } else if (this.type.startsWith("DIALOG")) {
                String title = this.MA.getCS("TITLE", "Dialog");
                int pw = this.MA.getL("P1", 200);
                int ph = this.MA.getL("P2", 200);
                this.flags = this.getFlags(GDialog.flagsList, this.flags);
                String buttonsList = this.MA.getCS("P3", "Submit,Cancel");
                String noCloseList = this.MA.getCS("P4", null);
                this.widget = new GDialog(null, title, pw, ph, buttonsList, noCloseList, this.flags, this.owner);
                if (handle.length() > 0) {
                    this.M.registry.put(handle, this.widget);
                } else {
                    this.M.error("The use of DIALOG without the /HANDLE switch is no longer supported");
                }
            } else if (this.type.startsWith("TABLE")) {
                String title = this.MA.getCS("TITLE", "Table");
                Table table = this.MA.getTable("P1");
                Table config = this.MA.getTable("P2");
                this.flags = this.getFlags(GDialog.flagsList, this.flags);
                this.widget = new GDialog(null, title, table, config, this.flags, this.owner);
            } else if (this.type.startsWith("PIPE")) {
                String title = this.MA.getU("TITLE", "NOPIPE");
                this.flags = this.getFlags(GPipeMonitor.flagsList, this.flags | 0x100);
                this.widget = new GPipeMonitor(null, title, this.M, this.flags, this.owner);
                ((GPipeMonitor)this.widget).setFormat(this.MA.getU("/FMT"));
            } else if (this.type.startsWith("QUERY")) {
                String title = this.MA.getU("TITLE", "QUERY");
                Object obj = this.MA.getO("P1", this.MR);
                String list8 = this.MA.getS("P2");
                this.flags = this.getFlags(GQuery.flagsList, this.flags);
                this.widget = new GQuery(null, title, obj, list8, this.flags, this.owner);
            } else if (this.type.startsWith("CALENDAR")) {
                this.flags = this.getFlags(GCalendar.flagsList, this.flags);
                this.widget = new GCalendar(null, this.name, this.flags, this.owner);
            } else if (this.type.startsWith("STEXT")) {
                String title = this.MA.getU("TITLE", "Message");
                String stext = this.MA.getCS("P1", "");
                int cols = this.MA.getL("P2", 24);
                int rows = this.MA.getL("P3", 1);
                this.flags = this.getFlags(GSText.flagsList, this.flags);
                this.widget = new GSText(null, title, stext, cols, rows, this.flags, this.owner);
            } else if (this.type.equals("BEAN")) {
                this.flags = this.getFlags(GWidget.flagsList, this.flags);
                String className = this.MA.getCS("P1");
                try {
                    Class<?> clazz = Class.forName(className);
                    Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (obj instanceof GWidget) {
                        String title = this.MA.getCS("TITLE", "Bean");
                        this.widget = (GWidget)obj;
                        this.widget.setupBean(this.name, null, title, this.flags, this.owner, this.setTable);
                        break block85;
                    }
                    this.M.error("The class " + className + " must extend GWidget.");
                }
                catch (ClassNotFoundException e) {
                    this.M.error("The class for " + className + " could not be found.", e);
                }
                catch (InstantiationException e) {
                    this.M.error("Check that the class " + className + " has an empty constructor.", e);
                }
                catch (IllegalAccessException e) {
                    this.M.error("Check that the class " + className + " is public.", e);
                }
                catch (NoSuchMethodException e) {
                    this.M.error("Check that the class " + className + " has an empty constructor.", e);
                }
                catch (InvocationTargetException e) {
                    this.M.error("There is an issue with the constructor in the class " + className, e);
                }
            } else {
                this.M.warning("Unknown widget type: " + this.type);
                return 9;
            }
        }
        if (this.menu != null) {
            this.menu.setMidas(this.M);
            int idef = this.MA.getL("/IDEF");
            String sdef = this.MA.getCS("P2");
            if (idef > 0) {
                this.menu.setValue(idef);
            } else {
                this.menu.setValue(sdef);
            }
            this.widget = this.menu;
        }
        this.widget.setLabel(this.name);
        if (!Installation.ApplyBugFix.GCONTROL_WTHEME_OVERRIDES_THEME) {
            this.widget.setWidgetTheme(this.MA.getO("/WTHEME"));
        }
        if ((themeObj = this.MA.getO("/THEME")) != null) {
            this.widget.setTheme(themeObj);
        }
        if (Installation.ApplyBugFix.GCONTROL_WTHEME_OVERRIDES_THEME) {
            this.widget.setWidgetTheme(this.MA.getO("/WTHEME"));
        }
        this.widget.setMonitor(this.MA.getU("/MON"));
        this.widget.setGroup(this.MA.getU("/GRP"));
        this.widget.setUnits(this.MA.getCS("/UNITS"));
        this.widget.fixLineHeight(this.MA.getL("/LH", 0));
        this.widget.fixHeight(this.MA.getL("/WH", 0));
        this.widget.fixWidth(this.MA.getL("/WW", 0));
        this.widget.setFontSize(this.MA.getL("/WFS", 0));
        this.widget.setMidas(this.M);
        if (this.MA.isPresent("/TOOLTIP")) {
            String text = this.MA.getS("/TOOLTIP");
            this.widget.setToolTipText(text);
        }
        if (this.MA.isPresent("/NOALTTITLE")) {
            boolean val = this.MA.getState("/NOALTTITLE");
            this.widget.setNoAltTitle(val);
        }
        if (this.MA.isPresent("/EVENTFILTER")) {
            this.widget.eventFilter = this.MA.getOptionMask("/EVENTFILTER", "NoMouse,NoKeyBoard,NoIconify,NoMove,NoRefresh,NoPushPop,NoMiddleMouse", this.widget.eventFilter);
        }
        if ((gcdt = this.MA.getTable("/GC")) != null && (value = gcdt.getS(this.widget.label)) != null) {
            this.widget.setValue(value);
        }
        this.MR.put(handle, (Object)this.widget);
        if (this.oneshot) {
            this.widget.addTo(this.parent);
        } else if (WidgetPanel.isWidgetPanel(this.parent)) {
            if (gd != null && !this.MA.isPresent("/WTHEME")) {
                this.widget.setWidgetTheme(gd.getWidgetTheme());
            }
            if (EventQueue.isDispatchThread()) {
                WidgetPanel.addWidgetViaReflection(this.parent, this.widget);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            WidgetPanel.addWidgetViaReflection(Gcontrol.this.parent, Gcontrol.this.widget);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.widget.addTo(this.parent);
        }
        if (this.setTable != null && this.widget != null) {
            KeyObject.setKeys(this.widget, this.setTable, this.args, 0);
        }
        return 0;
    }

    @Override
    public int process() {
        if (this.oneshot && this.widget.status != -3) {
            return -1;
        }
        return 9;
    }

    @Override
    public int processMessage(Message msg) {
        if (msg.name.equals(this.name)) {
            this.MR.put(this.name, msg.data);
        } else {
            if (msg.name.equals("EXIT")) {
                return 9;
            }
            if (msg.name.equals("REFRESH")) {
                this.widget.refresh();
            } else if (msg.name.equals("SHOWN")) {
                this.widget.refresh();
            } else {
                this.M.info("Unhandled message: " + msg.name);
            }
        }
        return 0;
    }

    private int getFlags(String flagsList, int flags) {
        String vbox;
        if (!this.MA.getState("/MSG", this.defMsg)) {
            flags |= 0x10;
        }
        if ((vbox = this.MA.getU("/INPUTBORDER", this.MA.getU("/VBOX"))).equalsIgnoreCase("PERM")) {
            flags |= 0x40;
        } else if (vbox.equalsIgnoreCase("MO")) {
            flags |= 0x80;
        }
        KeyVector kv = this.MA.getKV();
        if (this.MA.nargs + 1 >= kv.size()) {
            return flags;
        }
        flags |= this.MA.getOptionMask("/FLAGS", flagsList, 0);
        Parser parser = new Parser(flagsList.toUpperCase());
        String[] list3 = parser.getArray(0);
        for (int i = this.MA.nargs + 1; i < kv.size(); ++i) {
            String key = kv.getKey(i);
            if (key.charAt(0) != '/') continue;
            String ykey = key.substring(1);
            String nkey = "NO" + ykey;
            int mask = 1;
            int j = 0;
            while (j < list3.length) {
                if (ykey.equals(list3[j]) && this.MA.getState(key)) {
                    flags |= mask;
                }
                if (nkey.equals(list3[j]) && !this.MA.getState(key)) {
                    flags |= mask;
                }
                ++j;
                mask <<= 1;
            }
        }
        if (this.MA.getState("/TITLE")) {
            flags |= 0x10000000;
        }
        return flags;
    }
}

