/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.intr.Macrofunc;
import nxm.sys.lib.Intrinsic;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class Do
extends Intrinsic {
    static final String DO = "do";
    static final String LOOP = "loop";
    private final String type;
    public double start;
    public double end;
    public double inc;
    public String label;

    public Do() {
        this(DO);
    }

    Do(String type) {
        this.type = type;
    }

    @Override
    public int process() {
        if (this.M.macro == null) {
            String cmd = Macrofunc.enterIntrMacroText(this.M, "%" + this.type, this.MA.getRaw(), "end" + this.type);
            Shell.runCommand(this.M, cmd);
            return 9;
        }
        if (this.type == DO) {
            this.label = this.MA.getU("LABEL");
            this.start = this.MA.getD("START");
            this.end = this.MA.getD("END");
            this.inc = this.MA.getD("INC");
        } else if (this.type == LOOP) {
            this.label = this.MA.getU("LABEL");
            this.start = 1.0;
            this.end = this.MA.getL("COUNT");
            this.inc = 1.0;
            if (this.end <= 0.0) {
                this.start = 0.0;
                this.end = -1.0;
            }
        } else {
            throw new MidasException("Unknown loop type " + this.type);
        }
        if ((this.label.length() < 3 || this.label.charAt(1) != ':') && Math.rint(this.start) == this.start && Math.rint(this.end) == this.end && Math.rint(this.inc) == this.inc) {
            this.label = "L:" + this.label;
        }
        this.MR.put(this.label, this.start);
        if (this.inc > 0.0 && this.start > this.end || this.inc < 0.0 && this.start < this.end) {
            this.M.macro.nextIndex = this.nextIndex;
        }
        return 9;
    }
}

