/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.intr;

import nxm.sys.inc.DataTypes;
import nxm.sys.lib.Data;
import nxm.sys.lib.Intrinsic;
import nxm.sys.libm.ArgStack;
import nxm.sys.libm.Argument;
import nxm.sys.libm.Operator;
import nxm.sys.libm.Operators;

public class Calculator
extends Intrinsic
implements DataTypes {
    private ArgStack calc;
    private boolean useLabel;
    private boolean toScreen;
    private int radix = 10;
    private String formatString = null;

    @Override
    public int open() {
        int i;
        int narg = this.MA.numberOf();
        char type = 'D';
        this.radix = 10;
        if (this.MA.getState("/HEX")) {
            this.radix = 16;
            type = 'L';
        }
        if (this.MA.getState("/BIN")) {
            this.radix = 1;
            type = 'L';
        }
        type = this.MA.getU("/TYPE", "" + type).charAt(0);
        this.formatString = this.MA.getCS("/NFORM", this.formatString);
        if (this.calc == null || type != this.calc.type || !this.MA.getState("/REUSE", true)) {
            this.calc = new ArgStack(narg, narg, type, 1, 0);
            this.toScreen = this.verbose || this.M.macro == null;
            this.useLabel = true;
            for (i = 1; i <= narg; ++i) {
                if (!this.MA.getU(i).startsWith("=")) continue;
                this.useLabel = false;
            }
            if (this.useLabel && !Character.isLetter(this.MA.getU(1).charAt(0))) {
                this.M.error("Calculator results label must start with a letter");
            }
        } else {
            this.calc.clear();
        }
        for (i = 1; i <= narg; ++i) {
            if (this.useLabel && i == 1) continue;
            String s = this.MA.getU(i);
            Operator op = Operators.get(s);
            if (op != null) {
                this.calc.parseOperator(s, op);
                continue;
            }
            if (s.equals("PUSH")) {
                this.calc.parsePush();
                continue;
            }
            if (s.equals("POP")) {
                this.calc.parsePop();
                continue;
            }
            if (s.equals("<>")) {
                this.calc.parseSwap();
                continue;
            }
            if (s.startsWith("=")) {
                this.calc.parseStackOut(s.substring(1));
                continue;
            }
            this.calc.parseConstant(s, this);
        }
        if (this.useLabel) {
            this.calc.parseStackOut(this.MA.getU(1));
        }
        this.calc.parseDone();
        return 0;
    }

    @Override
    public int process() {
        switch (this.calc.type) {
            case 'D': {
                for (int i = 0; i < this.calc.nArgs; ++i) {
                    Argument arg = this.calc.args[i];
                    if (arg.kind == 12) {
                        this.output(arg.name, new Data(arg.dv[0]));
                        continue;
                    }
                    arg.op.process(arg.dv, arg.size, arg.mode);
                }
                break;
            }
            case 'F': {
                for (int i = 0; i < this.calc.nArgs; ++i) {
                    Argument arg = this.calc.args[i];
                    if (arg.kind == 12) {
                        this.output(arg.name, new Data(arg.fv[0]));
                        continue;
                    }
                    arg.op.process(arg.fv, arg.size, arg.mode);
                }
                break;
            }
            case 'L': {
                for (int i = 0; i < this.calc.nArgs; ++i) {
                    Argument arg = this.calc.args[i];
                    if (arg.kind == 12) {
                        this.output(arg.name, new Data(arg.lv[0]));
                        continue;
                    }
                    arg.op.process(arg.lv, arg.size, arg.mode);
                }
                break;
            }
        }
        return 9;
    }

    private void output(String name, Data data) {
        data.resetMode();
        Object value = data;
        if (this.radix != 10) {
            value = data.toString(0, 1, this.radix);
        } else if (this.formatString != null) {
            value = data.toString(this.formatString);
        }
        value = this.M.results.setKey(name, value);
        if (this.toScreen) {
            this.M.println("Calc: " + name + " = " + value);
        }
    }
}

