/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.inc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MapKBT;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Time;

public interface KeyableByType
extends Keyable {
    default public byte getB(String name) {
        return this.getB(name, (byte)0);
    }

    default public byte getB(String name, byte defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2b(val);
    }

    @InternalUseOnly
    default public Byte getB(String name, Byte defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2b(val);
    }

    default public short getI(String name) {
        return this.getI(name, (short)0);
    }

    default public short getI(String name, short defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2i(val);
    }

    @InternalUseOnly
    default public Short getI(String name, Short defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2i(val);
    }

    default public int getL(String name) {
        return this.getL(name, 0);
    }

    default public int getL(String name, int defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2l(val);
    }

    @InternalUseOnly
    default public Integer getL(String name, Integer defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2l(val);
    }

    default public long getX(String name) {
        return this.getX(name, 0L);
    }

    default public long getX(String name, long defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2x(val);
    }

    @InternalUseOnly
    default public Long getX(String name, Long defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2x(val);
    }

    default public float getF(String name) {
        return this.getF(name, 0.0f);
    }

    default public float getF(String name, float defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2f(val);
    }

    @InternalUseOnly
    default public Float getF(String name, Float defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Float.valueOf(Convert.o2f(val));
    }

    default public double getD(String name) {
        return this.getD(name, 0.0);
    }

    default public double getD(String name, double defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2d(val);
    }

    @InternalUseOnly
    default public Double getD(String name, Double defValue) {
        Object val = this.getO(name);
        if (val == null) {
            return defValue;
        }
        return Convert.o2d(val);
    }

    @InternalUseOnly
    default public Number getN(String name) {
        return this.getN(name, 0);
    }

    @InternalUseOnly
    default public Number getN(String name, Number defValue) {
        Object val = this.getO(name);
        return val == null ? (Number)defValue : (Number)Convert.o2n(val);
    }

    default public String getS(String name) {
        return this.getS(name, null);
    }

    default public String getS(String name, String defValue) {
        Object val = this.getO(name);
        return val == null ? defValue : val.toString();
    }

    @InternalUseOnly
    default public boolean getZ(String name) {
        return this.getState(name, false);
    }

    @InternalUseOnly
    default public boolean getZ(String name, boolean defValue) {
        return this.getState(name, defValue);
    }

    @InternalUseOnly
    default public Boolean getZ(String name, Boolean defValue) {
        return this.getState(name, defValue);
    }

    default public boolean getState(String name) {
        return this.getState(name, false);
    }

    default public boolean getState(String name, boolean defValue) {
        String str = this.getS(name, null);
        if (str == null) {
            return defValue;
        }
        if (StringUtil.isTrue(str)) {
            return true;
        }
        if (StringUtil.isFalse(str)) {
            return false;
        }
        return this.getD(name) > 0.0;
    }

    default public Boolean getState(String name, Boolean defValue) {
        Object obj = this.getO(name);
        if (obj == null) {
            return defValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() > 0.0;
        }
        String str = obj.toString();
        if (StringUtil.isEmpty(str)) {
            return defValue;
        }
        if (StringUtil.isTrue(str)) {
            return Boolean.TRUE;
        }
        if (StringUtil.isFalse(str)) {
            return Boolean.FALSE;
        }
        double dblValue = defValue != false ? this.getD(name, 1.0) : this.getD(name, 0.0);
        return dblValue > 0.0;
    }

    default public boolean getNoState(String name) {
        return this.getNoState(name, false);
    }

    default public boolean getNoState(String name, boolean defValue) {
        return !this.getState(name, !defValue);
    }

    default public Object getO(String name) {
        return this.getO(name, null);
    }

    public Object getO(String var1, Object var2);

    default public <T> List<T> getList(String key) {
        return this.getList(key, null);
    }

    @InternalUseOnly
    default public <T> List<T> getList(String key, List<T> defValue) {
        return this.getList(key, defValue, null);
    }

    @InternalUseOnly
    default public <T> List<T> getList(String key, List<T> defValue, Set<ConvertFlags> flags) {
        Collection<T> c = this.getCollection(key, defValue, 1, flags);
        return c == null || c instanceof List ? (List<Object>)c : new ArrayList<T>(c);
    }

    @InternalUseOnly
    default public <T> Collection<T> getCollection(String key) {
        return this.getCollection(key, null);
    }

    @InternalUseOnly
    default public <T> Collection<T> getCollection(String key, Collection<T> defValue) {
        return this.getCollection(key, defValue, 0, null);
    }

    @InternalUseOnly
    default public <T> Set<T> getSet(String key) {
        return this.getSet(key, null);
    }

    @InternalUseOnly
    default public <T> Set<T> getSet(String key, Set<T> defValue) {
        return this.getSet(key, defValue, null);
    }

    @InternalUseOnly
    default public <T> Set<T> getSet(String key, Set<T> defValue, Set<ConvertFlags> flags) {
        Collection<T> c = this.getCollection(key, defValue, -1, flags);
        return c == null || c instanceof Set ? (Set<Object>)c : new HashSet<T>(c);
    }

    @InternalUseOnly
    default public <T> SortedSet<T> getSortedSet(String key) {
        return this.getSortedSet(key, null);
    }

    @InternalUseOnly
    default public <T> SortedSet<T> getSortedSet(String key, SortedSet<T> defValue) {
        return this.getSortedSet(key, defValue, null);
    }

    @InternalUseOnly
    default public <T> SortedSet<T> getSortedSet(String key, SortedSet<T> defValue, Set<ConvertFlags> flags) {
        Collection<T> c = this.getCollection(key, defValue, -2, flags);
        return c == null || c instanceof SortedSet ? (SortedSet<Object>)c : new TreeSet<T>(c);
    }

    @InternalUseOnly
    default public <T> Collection<T> getCollection(String key, Collection<T> defValue, int listOrSet, Set<ConvertFlags> flags) {
        Object val = this.getO(key);
        if (val == null) {
            return defValue;
        }
        if (val instanceof Collection) {
            return (Collection)val;
        }
        if (val instanceof Data) {
            return ((Data)val).toVector();
        }
        if (val instanceof Object[]) {
            return Arrays.asList((Object[])val);
        }
        if (flags == null) {
            throw new RuntimeException("Could not convert " + val.getClass() + " to Collection: " + val);
        }
        if (flags.contains((Object)ConvertFlags.SplitString)) {
            String str = val.toString().trim();
            if (str.isEmpty()) {
                return listOrSet > 0 ? Collections.emptyList() : Collections.emptySortedSet();
            }
            String[] vals = StringUtil.split(str);
            if (listOrSet >= 0) {
                return Arrays.asList(vals);
            }
            TreeSet set = new TreeSet();
            Collections.addAll(set, vals);
            return set;
        }
        if (flags.contains((Object)ConvertFlags.SingletonToCollection)) {
            return listOrSet >= 0 ? Collections.singletonList(val) : Collections.singleton(val);
        }
        throw new RuntimeException("Could not convert " + val.getClass() + " to Collection: " + val);
    }

    @InternalUseOnly
    default public <K, V> Map<K, V> getMap(String key) {
        return this.getMap(key, null);
    }

    @InternalUseOnly
    default public <K, V> Map<K, V> getMap(String key, Map<K, V> defValue) {
        Object val = this.getO(key);
        if (val == null) {
            return defValue;
        }
        return val instanceof Map ? (Map)val : Convert.o2t(val);
    }

    @InternalUseOnly
    default public MapKBT getMapKBT(String key) {
        return this.getMapKBT(key, null);
    }

    @InternalUseOnly
    default public MapKBT getMapKBT(String key, Map<String, Object> defValue) {
        return MapKBT.wrapMap(this.getMap(key, defValue));
    }

    @InternalUseOnly
    default public Time getTime(String key) {
        return this.getTime(key, null);
    }

    @InternalUseOnly
    default public Time getTime(String key, Time defValue) {
        Object val = this.getO(key);
        return val == null ? defValue : Time.toTime(val);
    }

    @InternalUseOnly
    public static enum ConvertFlags {
        SingletonToCollection,
        SplitString;

    }
}

