/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.inc;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.KeyValuePair;
import nxm.sys.inc.KeyValuePairSwapBCEL;
import nxm.sys.inc.MapKBT;
import nxm.sys.lib.Table;

@InternalUseOnly(value="This should only be used by KeyValuePair.")
final class KeyValuePairSupport
implements KeyValuePairSwapBCEL {
    private static final boolean FALLBACK = false;
    private static final WeakHashMap<KeyValuePair<?>, Map.Entry<String, ?>> cache = new WeakHashMap(128);

    public static void main(String ... argv) {
        System.out.println(">>> " + KeyValuePairSupport.toMapEntry(ABC -> 123));
    }

    private KeyValuePairSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <V> Map.Entry<String, V> toMapEntry(KeyValuePair<V> p) {
        Map.Entry<String, ?> e = cache.get(p);
        if (e != null) {
            return e;
        }
        String[] params = KeyValuePairSupport.getLambdaParameterNames(p);
        String key = params[params.length - 1];
        WeakHashMap<KeyValuePair<?>, Map.Entry<String, ?>> weakHashMap = cache;
        synchronized (weakHashMap) {
            e = cache.get(p);
            if (e != null) {
                return e;
            }
            V val = p.value(null);
            e = new AbstractMap.SimpleImmutableEntry(key, val);
            cache.put(p, e);
            return e;
        }
    }

    static MapKBT toMap(KeyValuePair<?> ... kvPairs) {
        MapKBT map = MapKBT.newMap();
        for (KeyValuePair<?> p : kvPairs) {
            Map.Entry<String, ?> e = p.toMapEntry();
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    static MapKBT toMap(Iterable<KeyValuePair<?>> kvPairs) {
        MapKBT map = MapKBT.newMap();
        for (KeyValuePair<?> p : kvPairs) {
            Map.Entry<String, ?> e = p.toMapEntry();
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    static Table toTable(KeyValuePair<?> ... kvPairs) {
        Table tbl = new Table();
        for (KeyValuePair<?> p : kvPairs) {
            Map.Entry<String, ?> e = p.toMapEntry();
            tbl.put(e.getKey().toUpperCase(), e.getValue());
        }
        return tbl;
    }

    static Table toTable(Iterable<KeyValuePair<?>> kvPairs) {
        Table tbl = new Table();
        for (KeyValuePair<?> p : kvPairs) {
            Map.Entry<String, ?> e = p.toMapEntry();
            tbl.put(e.getKey().toUpperCase(), e.getValue());
        }
        return tbl;
    }

    private static String[] findLambdaParams(Method m, byte[] classAsBytes) {
        byte[] methodNameBytes;
        String methodName = m.getName();
        try {
            methodNameBytes = methodName.getBytes("UTF8");
        }
        catch (Exception e) {
            System.out.println("Exception ......:" + e);
            return null;
        }
        int argsLoc = KeyValuePairSupport.findLocation(classAsBytes, methodNameBytes);
        if (argsLoc == -1) {
            return null;
        }
        int charToPrint = argsLoc;
        do {
            byte thisByte = classAsBytes[charToPrint++];
            System.out.println("arg byte:" + thisByte);
            if (thisByte <= 32 || thisByte >= 126) continue;
            System.out.println("arg char:" + (char)thisByte);
        } while (charToPrint < classAsBytes.length && charToPrint < argsLoc + 80);
        int stackTableLoc = KeyValuePairSupport.findLocation(classAsBytes, "StackMapTable".getBytes());
        if (stackTableLoc == -1) {
            return null;
        }
        charToPrint = stackTableLoc;
        do {
            byte thisByte;
            if ((thisByte = classAsBytes[charToPrint++]) <= 32 || thisByte >= 126) continue;
            System.out.println("arg char:" + (char)thisByte);
        } while (charToPrint < classAsBytes.length && charToPrint < stackTableLoc + 80);
        return null;
    }

    private static int findLocation(byte[] in, byte[] find) {
        boolean done = false;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] != find[0]) continue;
            for (int ii = 1; ii < find.length && in[i + ii] == find[ii]; ++ii) {
                if (ii != find.length - 1) continue;
                done = true;
            }
            if (!done) continue;
            return i - 1;
        }
        return -1;
    }

    private static String[] getLambdaParameterNames(KeyValuePair<?> obj) {
        if (!(obj instanceof Serializable)) {
            throw new AssertionError((Object)("Object not serializable: " + obj));
        }
        try {
            Method wr = obj.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            wr.setAccessible(true);
            SerializedLambda sl = (SerializedLambda)wr.invoke(obj, new Object[0]);
            String sig = sl.getImplMethodSignature();
            int end = sig.lastIndexOf(41);
            ArrayList types = new ArrayList(8);
            int i = 1;
            block14: while (i < end) {
                char t = sig.charAt(i++);
                switch (t) {
                    case 'B': {
                        types.add(Byte.TYPE);
                        continue block14;
                    }
                    case 'S': {
                        types.add(Short.TYPE);
                        continue block14;
                    }
                    case 'I': {
                        types.add(Integer.TYPE);
                        continue block14;
                    }
                    case 'J': {
                        types.add(Long.TYPE);
                        continue block14;
                    }
                    case 'F': {
                        types.add(Float.TYPE);
                        continue block14;
                    }
                    case 'D': {
                        types.add(Double.TYPE);
                        continue block14;
                    }
                    case 'C': {
                        types.add(Character.TYPE);
                        continue block14;
                    }
                    case 'Z': {
                        types.add(Boolean.TYPE);
                        continue block14;
                    }
                    case 'L': {
                        int semi = sig.indexOf(59, i);
                        String clazz = sig.substring(i, semi).replace('/', '.');
                        types.add(Class.forName(clazz));
                        i = semi + 1;
                        continue block14;
                    }
                    case '[': {
                        int semi;
                        String clazz = "[";
                        t = sig.charAt(i++);
                        while (t == '[') {
                            t = sig.charAt(i++);
                            clazz = clazz + "[";
                        }
                        if (t == 'L') {
                            semi = sig.indexOf(59, i);
                            clazz = clazz + sig.substring(i, semi);
                            types.add(Class.forName(clazz));
                            i = semi + 1;
                            continue block14;
                        }
                        clazz = clazz + t;
                        types.add(Class.forName(clazz));
                        continue block14;
                    }
                }
                throw new AssertionError((Object)("Invald type: " + t + " in " + sig));
            }
            String fullPathClassFile = sl.getImplClass() + ".class";
            String className = sl.getImplClass().replace('/', '.');
            Class[] typeArray = types.toArray(new Class[types.size()]);
            Class<?> cls = Class.forName(className);
            Method m = cls.getDeclaredMethod(sl.getImplMethodName(), typeArray);
            return KeyValuePairSwapBCEL.getParamNames(cls, m, className + ".class", fullPathClassFile);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Object not serializable: " + obj, e);
        }
    }

    static String[] getParamNamesBasic(Class<?> c, Method m) throws ReflectiveOperationException {
        Parameter[] params = m.getParameters();
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        return names;
    }
}

