/*
 * Decompiled with CFR 0.152.
 */
package nxm.hwc.prim;

import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Results;
import nxm.sys.lib.TcpResource;
import nxm.sys.lib.Time;

public class hwdriver
extends Primitive {
    private DataFile hwf;
    private HwArg[] hwa;
    private HwDev hwd;
    private char chan = (char)48;
    private int np;
    private String drn;
    private String drf;
    private StringBuffer form = new StringBuffer();

    public int open() {
        String func = this.MA.getU(1);
        this.verbose = this.MA.getState("/VERBOSE");
        this.drn = this.MA.getU("/DRN");
        this.drf = this.MA.getU("/DRF");
        String hwfn = this.MA.getCS("/HWF", "ENV.HWFILE");
        this.hwf = new DataFile((MidasReference)this.M, (Object)hwfn);
        this.hwf.open();
        this.hwf.close();
        if (func.equals("CONTROL") || func.equals("SET") || func.equals("GET")) {
            this.hw_open(this.MA.getS(2));
            this.np = this.MA.numberOf() - 2;
            this.hwa = new HwArg[this.np];
            for (int i = 0; i < this.np; ++i) {
                this.hwa[i] = new HwArg();
                this.hwa[i].name = this.MA.getKey(3 + i);
                this.hwa[i].cmd = (String)this.hwf.keywords.get(this.hwa[i].name);
                this.hwa[i].data = this.MA.getO(this.hwa[i].name);
                if (this.hwa[i].cmd == null) {
                    this.M.error("Command " + this.hwa[i].name + " not found for device " + this.hwd.name);
                }
                String rn = this.MA.getU(this.hwa[i].name);
                this.hwa[i].resname = rn.length() != 0 && Results.validNameLength((String)rn, (int)0) == rn.length() ? rn : this.drn;
            }
        } else if (func.equals("CON") || func.equals("C")) {
            this.hw_open("SWITCH");
            this.np = (this.MA.numberOf() - 1) / 2;
            this.hwa = new HwArg[this.np];
            for (int i = 0; i < this.np; ++i) {
                this.hwa[i] = new HwArg();
                this.hwa[i].name = "CON";
                this.hwa[i].cmd = (String)this.hwf.keywords.get(this.hwa[i].name);
                this.hwa[i].data = this.MA.getS(i * 2 + 2);
                this.hwa[i].datax = this.MA.getS(i * 2 + 3);
            }
        } else if (func.equals("DIS")) {
            this.hw_open("SWITCH");
            this.np = this.MA.numberOf() - 1;
            this.hwa = new HwArg[this.np];
            for (int i = 0; i < this.np; ++i) {
                this.hwa[i] = new HwArg();
                this.hwa[i].name = "DIS";
                this.hwa[i].cmd = (String)this.hwf.keywords.get(this.hwa[i].name);
                this.hwa[i].data = this.MA.getS(i + 2);
            }
        } else {
            this.M.error("Unsupported function: " + func);
        }
        return 0;
    }

    public int process() {
        for (int i = 0; i < this.np; ++i) {
            this.hw_send(this.hwa[i]);
        }
        return 9;
    }

    public int close() {
        this.hw_close();
        return 0;
    }

    private void hwd_open(HwDev hwd, String devName) {
        if (devName.startsWith("SOCKET:")) {
            hwd.tcp = new TcpResource();
            hwd.tcp.setContext(this.M);
            String dev = devName.substring(7);
            dev = dev.replace("_", ":");
            hwd.tcp.setURL(dev);
            boolean isOpen = hwd.tcp.open();
            if (!isOpen) {
                this.M.error("Device not opened");
            }
            hwd.fd = 1;
        } else {
            hwd.fd = Native.fopen((String)devName, (int)2);
        }
    }

    private void hwd_close(HwDev hwd) {
        if (hwd.tcp != null) {
            hwd.tcp.close();
        } else {
            Native.fclose((int)hwd.fd);
        }
    }

    private int hwd_read(HwDev hwd, byte[] buffer, int off, int len) {
        int status;
        if (hwd.tcp != null) {
            int bcount = (int)hwd.tcp.avail();
            status = hwd.tcp.read(buffer, off, bcount);
        } else {
            status = Native.freadb((int)hwd.fd, (Object)buffer, (int)off, (int)len);
        }
        return status;
    }

    private int hwd_write(HwDev hwd, byte[] buffer, int off, int len) {
        int status = hwd.tcp != null ? hwd.tcp.write(buffer, off, len) : Native.fwriteb((int)hwd.fd, (Object)buffer, (int)off, (int)len);
        return status;
    }

    private void hw_open(String alias) {
        this.hwf.keywords.setScope("TAG=ALIAS");
        String aliasString = (String)this.hwf.keywords.get(alias);
        if (aliasString == null) {
            throw new MidasException("Alias " + alias + " not found in HW Config file");
        }
        if (this.verbose) {
            this.M.info((CharSequence)("HwOpen " + aliasString));
        }
        int i = aliasString.indexOf(44);
        int j = aliasString.indexOf(45);
        if (j > 0 && j < i) {
            i = j;
            this.chan = aliasString.charAt(j + 1);
        }
        String device = aliasString.substring(0, i);
        if (this.hwf.keywords.setScope("TAG=" + device) != 1) {
            this.M.error("Device " + device + " not found in HW Config file");
        }
        this.hwd = new HwDev();
        this.hwd.alias = alias;
        this.hwd.name = device;
        this.hwd.timeout = 2;
        this.hwd.term = "";
        if (aliasString.indexOf(",CRLF") > 0) {
            this.hwd.term = "\r\n";
        } else if (aliasString.indexOf(",CRCR") > 0) {
            this.hwd.term = "\r\r";
        } else if (aliasString.indexOf(",CR") > 0) {
            this.hwd.term = "\r";
        } else if (aliasString.indexOf(",LF") > 0) {
            this.hwd.term = "\n";
        }
        String devType = Parser.get((String)aliasString, (int)2);
        String devName = Parser.get((String)aliasString, (int)3);
        this.hwd_open(this.hwd, devName);
        if (this.hwd.fd <= 0) {
            this.M.error("Opening device Type=" + devType + " URL=" + devName);
        }
    }

    private void hw_close() {
        if (this.verbose) {
            this.M.info((CharSequence)("HwClose " + this.hwd.name + " on " + this.hwd.fd));
        }
        if (this.hwd.fd <= 0) {
            return;
        }
        this.hwd_close(this.hwd);
    }

    private void hw_write(HwArg ha) {
        String string = ha.formed;
        if (this.hwd.fd <= 0) {
            return;
        }
        string = string + this.hwd.term;
        byte[] buffer = string.getBytes();
        int status = this.hwd_write(this.hwd, buffer, 0, buffer.length);
    }

    private String hw_read(HwArg ha, int maxlen) {
        int i;
        int status;
        if (this.hwd.fd <= 0) {
            return null;
        }
        byte[] buffer = new byte[maxlen];
        int timeout = this.hwd.timeout * 100;
        byte term = ha.term != null ? (byte)ha.term.charAt(ha.term.length() - 1) : (byte)-1;
        int got = 0;
        while (got < maxlen && (status = this.hwd_read(this.hwd, buffer, got, maxlen - got)) >= 0 && --timeout >= 0 && (term <= 0 || status <= 0 || buffer[(got += status) - 1] != term)) {
            if (status != 0) continue;
            Time.sleep((double)0.01);
        }
        if (got <= 0) {
            return null;
        }
        String string = new String(buffer, 0, got);
        if (ha.term != null && (i = string.indexOf(ha.term)) >= 0) {
            string = string.substring(0, i);
        }
        if (this.verbose) {
            this.M.info((CharSequence)("HwRead=" + string));
        }
        return string;
    }

    private void hw_purge() {
        if (this.hwd.fd <= 0) {
            return;
        }
        byte[] buffer = new byte[8];
        while (this.hwd_read(this.hwd, buffer, 0, buffer.length) > 0) {
        }
    }

    private void hw_send(HwArg ha) {
        ha.lc = ha.cmd.indexOf("//");
        if (ha.lc < 0) {
            ha.lc = ha.cmd.length();
        }
        ha.ic = 0;
        while (ha.ic < ha.lc) {
            char c;
            if ((c = ha.cmd.charAt(ha.ic++)) == ',' || c == ' ') continue;
            if (c == 'F') {
                this.hw_form(ha);
                continue;
            }
            if (c == 'Q') {
                this.hw_queue(ha);
                continue;
            }
            if (c == 'W') {
                this.hw_write(ha);
                continue;
            }
            if (c == 'P') {
                this.hw_pause(ha);
                continue;
            }
            if (c == 'D') {
                this.hw_decode(ha);
                continue;
            }
            if (c == 'V') {
                this.hw_validate(ha);
                continue;
            }
            if (c == 'T') {
                this.hw_timeout(ha);
                continue;
            }
            if (c == '(') {
                this.hw_repeat(ha);
                continue;
            }
            this.M.error("Malformed HWD string: " + ha.cmd.substring(0, ha.lc));
        }
    }

    private void hw_form(HwArg ha) {
        char c;
        this.form.setLength(0);
        if (ha.cmd.charAt(ha.ic) != '{') {
            return;
        }
        ++ha.ic;
        while (ha.ic < ha.lc && (c = ha.cmd.charAt(ha.ic++)) != '}') {
            if (c == '^') {
                this.hw_formCaret(ha);
                continue;
            }
            if (c == '%') {
                this.hw_formPrintf(ha);
                continue;
            }
            if (c == '\\') {
                this.hw_formTerm(ha);
                continue;
            }
            this.form.append(c);
        }
        ha.formed = this.form.toString();
    }

    private void hw_queue(HwArg ha) {
        int n = this.hw_geti(ha);
        ha.term = null;
        while (ha.cmd.charAt(ha.ic) == 'e') {
            n += ha.formed.length();
            ++ha.ic;
        }
        if (ha.cmd.charAt(ha.ic) == 't') {
            ++ha.ic;
            ha.term = ha.dev.term;
            n += ha.term.length();
        }
        if (ha.cmd.charAt(ha.ic) == 's') {
            ++ha.ic;
            ha.term = "" + ha.cmd.charAt(ha.ic++);
            n += ha.term.length();
        }
        ha.qlen = n;
        this.hw_purge();
        if (this.verbose) {
            this.M.info((CharSequence)("Queue read of " + n + " bytes"));
        }
    }

    private void hw_pause(HwArg ha) {
        int d = this.hw_geti(ha);
        if (ha.cmd.charAt(ha.ic) == 'm') {
            ++ha.ic;
        } else {
            d *= 1000;
        }
        Time.usleep((int)(d * 1000));
    }

    private void hw_decode(HwArg ha) {
        String data = this.hw_read(ha, ha.qlen);
        if (ha.cmd.charAt(ha.ic) == '{') {
            char c;
            int id = 0;
            int loopStart = -1;
            int loopCount = 0;
            this.form.setLength(0);
            ++ha.ic;
            while (ha.ic < ha.lc && (c = ha.cmd.charAt(ha.ic++)) != '}') {
                if (c == 'y') {
                    id = this.hw_decodeYankSkip(ha, data, id, true);
                    continue;
                }
                if (c == 'x') {
                    id = this.hw_decodeYankSkip(ha, data, id, false);
                    continue;
                }
                if (c == 'i') {
                    this.form.append(ha.cmd.charAt(ha.ic++));
                    continue;
                }
                if (c == '(') {
                    loopStart = ha.ic;
                    loopCount = 0;
                    continue;
                }
                if (c == ')') {
                    if (this.hw_geti(ha) - ++loopCount <= 0) continue;
                    ha.ic = loopStart;
                    continue;
                }
                this.M.error("Malformed Decode command in: " + ha.cmd);
            }
            data = this.form.toString();
        }
        if (ha.resname.length() > 0) {
            this.MR.getPrevious().put(ha.resname, (Object)data);
            this.M.info((CharSequence)data);
        } else {
            this.M.println((CharSequence)("HW Alias=" + this.hwd.alias + " " + ha.name + "=" + data));
        }
    }

    private int hw_decodeYankSkip(HwArg ha, String data, int id, boolean yank) {
        int len = this.hw_geti(ha);
        int id1 = id;
        int id2 = data.length();
        if (len > 0) {
            id = id1 + len;
        } else {
            char e;
            char c;
            if ((c = ha.cmd.charAt(ha.ic++)) != 't' && c != 'T') {
                this.M.error("Malformed Yank/Skip in: " + ha.cmd);
            }
            if ((e = ha.cmd.charAt(ha.ic++)) == '#') {
                while (id < id2 && (data.charAt(id) < '0' || data.charAt(id) > '9')) {
                    ++id;
                }
            } else {
                while (id < id2 && data.charAt(id) != e) {
                    ++id;
                }
            }
            if (c == 'T') {
                ++id;
            }
        }
        if (yank) {
            this.form.append(data.substring(id1, id));
        }
        return id;
    }

    private void hw_validate(HwArg ha) {
        String data = this.hw_read(ha, ha.qlen);
        this.hw_form(ha);
    }

    private void hw_timeout(HwArg ha) {
        ha.dev.timeout = this.hw_geti(ha);
    }

    private void hw_repeat(HwArg ha) {
        --ha.ic;
    }

    private int hw_geti(HwArg ha) {
        int value = 0;
        char c = ha.cmd.charAt(ha.ic);
        while (c >= '0' && c <= '9') {
            value = value * 10 + c - 48;
            c = ha.cmd.charAt(++ha.ic);
        }
        return value;
    }

    private void hw_formCaret(HwArg ha) {
        char c = ha.cmd.charAt(ha.ic++);
        switch (c) {
            case 'f': {
                this.form.append(Convert.o2f((Object)ha.data));
                break;
            }
            case 'd': {
                this.form.append(Convert.o2l((Object)ha.data));
                break;
            }
            case 's': {
                this.form.append(Convert.o2s((Object)ha.data));
                break;
            }
            case 'x': {
                this.form.append(Convert.l2x((int)Convert.o2l((Object)ha.data)));
                break;
            }
            case 'c': {
                this.form.append(this.chan);
                break;
            }
            case 'n': {
                this.form.append(0);
                break;
            }
            case 'e': {
                this.form.append(ha.formed);
                break;
            }
            case 't': {
                this.form.append(ha.dev.term);
                break;
            }
            case 'm': {
                this.form.append(Parser.get((String)Convert.o2s((Object)ha.datax), (int)Convert.o2l((Object)ha.data)));
                break;
            }
            case '*': {
                int n = this.hw_geti(ha);
                for (int i = 0; i < n || i == 0; ++i) {
                    this.form.append('*');
                }
                break;
            }
        }
    }

    private void hw_formPrintf(HwArg ha) {
        this.M.error("HWD printf format require JDK1.5 which is not standard yet");
    }

    private void hw_formTerm(HwArg ha) {
        char c = ha.cmd.charAt(ha.ic++);
        switch (c) {
            case 'r': {
                this.form.append('\r');
                break;
            }
            case 'n': {
                this.form.append('\n');
                break;
            }
            default: {
                this.M.error("Terminator code=" + c + " not recognized");
            }
        }
    }

    private class HwDev {
        String alias;
        String name;
        int timeout;
        String term;
        int fd;
        TcpResource tcp;

        private HwDev() {
        }
    }

    private class HwArg {
        String name;
        String cmd;
        String resname;
        Object data;
        Object datax;
        int ic;
        int lc;
        String formed;
        HwDev dev;
        int qlen;
        String term;

        private HwArg() {
            this.dev = hwdriver.this.hwd;
        }
    }
}

