/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.dsp.lib.FilterFIR;
import nxm.dsp.prim.sbtuner;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Tolerance;

public class tuner
extends Primitive {
    public static final String partialList = "None,All,Start";
    public static final int P_NONE = 1;
    public static final int P_ALL = 2;
    public static final int P_START = 3;
    private DataFile hin;
    private DataFile hout;
    private DataFile hdebug;
    private Data buf;
    private Data filter;
    private String outFormat;
    private String windowName;
    private Double inputIF;
    private Double outputIF;
    private Double bandwidth;
    private String resOutputIF;
    private double timeDelta;
    private boolean setTimeDelta;
    private double phasor_real;
    private double phasor_imag;
    private double dphasor_real;
    private double dphasor_imag;
    private int nfft;
    private int decimation;
    private int fftFlagsFwd;
    private int fftFlagsInv;
    private int nbad;
    private int partial;
    private boolean doTune;
    private boolean doFilter;
    private boolean extFilter;
    private boolean filterOut;
    private boolean complexIn;
    private boolean complexOut;
    private boolean complex;

    public int open() {
        this.nfft = this.MA.getL("/FFT", 8192);
        this.windowName = this.MA.getS("/WIND", "HANN");
        this.inputIF = this.MA.getD("CFREQ", this.MA.getD("INPUTIF", null));
        this.bandwidth = this.MA.getD("BW", this.MA.getD("BANDWIDTH", null));
        this.decimation = this.MA.getL("DECIMATION", 1);
        this.resOutputIF = this.MA.getU("ACTOUTPUTIF", null);
        this.setTimeDelta = this.MA.getZ("/SETDELAY", true);
        this.hin = this.MA.isPresent("INFILE") ? this.MA.getDataFile("INFILE") : this.MA.getDataFile("INPUT");
        this.partial = this.MA.getSelectionIndex("/PARTIAL", partialList, 1);
        this.buf = new Data("CF", this.nfft * 2);
        this.outputIF = null;
        this.extFilter = false;
        this.filterOut = false;
        this.doFilter = false;
        this.complex = false;
        this.doTune = false;
        this.timeDelta = 0.0;
        this.nbad = 0;
        this.fftFlagsFwd = 72;
        this.fftFlagsInv = 18;
        if (this.resOutputIF != null && this.resOutputIF.isEmpty()) {
            this.resOutputIF = null;
        }
        DataFile hfilter = null;
        double tolr = 1.0E-8;
        String kwdSBT = this.MA.getS("/SBT", "");
        KwdUpdate kwdUpdate = (KwdUpdate)this.MA.getSelection("/KWDUPDATE", (Enum)KwdUpdate.AUTO);
        int ntaps = this.MA.getL("/TAPS", this.MA.getL("/NTAP", this.nfft / 8));
        if (this instanceof sbtuner && this.MA.isPresent("BWIMPRESP") && this.bandwidth == null) {
            try {
                this.bandwidth = this.MA.getD("BWIMPRESP");
            }
            catch (MidasException e) {
                hfilter = this.MA.getDataFile("BWIMPRESP");
            }
        }
        if (this.MA.isPresent("IMPRESP")) {
            if (this.bandwidth != null) {
                this.M.warning((CharSequence)"Don't specify both <BANDWIDTH> (or <BW>) and <IMPRESP>, <IMPRESP> overrides");
            }
            if (hfilter != null) {
                this.M.warning((CharSequence)"Don't specify both <BANDWIDTH> (or <BW>) and <IMPRESP>, <IMPRESP> overrides");
            }
            if (this.MA.isPresent("FILTOUT")) {
                this.M.warning((CharSequence)"Don't specify both <IMPRESP> and <FILTOUT>, <IMPRESP> overrides");
            }
            hfilter = this.MA.getDataFile("IMPRESP");
        }
        if (this.MA.isPresent("INFILE")) {
            this.M.deprecate((CharSequence)"Since 2.9.1, use of 'INFILE=' is deprecated. Please use 'INPUT='");
        }
        if (this.MA.isPresent("OUTFILE")) {
            this.M.deprecate((CharSequence)"Since 2.9.1, use of 'OUTFILE=' is deprecated. Please use 'OUTPUT='");
        }
        if (this.MA.isPresent("IMP_RESPONSE")) {
            throw new MidasException("Use of IMP_RESPONSE= was deprecated in NeXtMidas 2.9.1 and has been removed, use IMPRESP=");
        }
        if (this.MA.isPresent("/PH")) {
            throw new MidasException("Use of /PH= is not currently supported.");
        }
        if (!this.setTimeDelta) {
            this.M.deprecate((CharSequence)"Since 3.3.1, use of '/SETDELAY=FALSE' is deprecated.");
        }
        this.hin.open();
        if (this.hin.spa == 2) {
            this.fftFlagsFwd |= 2;
            this.complex = true;
            this.complexIn = true;
        } else {
            this.fftFlagsFwd |= 1;
            this.complexIn = false;
        }
        if (this.bandwidth != null || hfilter != null) {
            if (hfilter != null) {
                this.extFilter = true;
                hfilter.open();
            }
            this.doFilter = true;
            this.complex = true;
            if (!this.extFilter && this.MA.isPresent("FILTOUT")) {
                hfilter = this.MA.getDataFile("FILTOUT", this.hin, 2);
                hfilter.setFormat("CF");
                hfilter.open();
                this.filterOut = hfilter.isOpen();
            }
        }
        this.outFormat = this.MA.getS("OUTFORMAT", this.hin.getFormat());
        if (this.outFormat.equals("SD")) {
            this.outFormat = "SF";
        }
        if (this.outFormat.equals("CD")) {
            this.outFormat = "CF";
        }
        if (this.MA.isPresent("OUTPUT") || this.MA.isPresent("OUTFILE")) {
            this.hout = this.MA.isPresent("OUTFILE") ? this.MA.getDataFile("OUTFILE", this.hin, 2) : this.MA.getDataFile("OUTPUT", this.hin, 2);
            this.hout.setFormat(this.outFormat);
            this.hout.setXDelta(this.hin.getXDelta() * (double)this.decimation);
            this.hout.open();
            this.complexOut = this.hout.spa == 2;
        } else {
            this.hout = null;
            this.complexOut = false;
        }
        if (this.inputIF != null) {
            String outIF = this.MA.getS("OUTPUTIF", "");
            this.outputIF = outIF.isEmpty() ? this.inputIF.doubleValue() : this.MA.getD("OUTPUTIF");
            if (Tolerance.equalsWithTolerance((double)this.inputIF, (double)this.outputIF, (double)tolr)) {
                this.doTune = false;
                this.outputIF = this.inputIF;
            } else {
                if (Tolerance.equalsWithTolerance((double)this.outputIF, (double)-1.0, (double)tolr)) {
                    this.outputIF = this.complexOut ? 0.0 : 0.25 / this.hin.getXDelta();
                }
                double dphase = (this.outputIF - this.inputIF) * (Math.PI * 2) * this.hin.getXDelta() * (double)this.decimation;
                this.dphasor_real = Math.cos(dphase);
                this.dphasor_imag = Math.sin(dphase);
                this.phasor_real = 1.0;
                this.phasor_imag = 0.0;
                this.doTune = true;
            }
        }
        if (this.doFilter) {
            if (this.extFilter) {
                this.filter = hfilter.getDataBuffer(this.nfft * 2, (byte)70);
                ntaps = hfilter.read(this.filter);
                this.timeDelta = -(hfilter.getXStart() + this.hin.getXDelta()) * (this.hin.getXDelta() / hfilter.getXDelta());
            } else {
                FilterFIR f = FilterFIR.initBandPass(this.M, ntaps, this.inputIF, this.bandwidth, this.hin.getNyquist(), this.decimation, this.complexOut, true, true, this.windowName, 1.0);
                this.filter = new Data((Object)f.makeFilter(this.nfft * 2), 2);
                this.timeDelta = f.getDelay(this.hin.getXDelta());
                if (this.filterOut) {
                    if (this.setTimeDelta) {
                        hfilter.setXStart(-this.timeDelta - this.hin.getXDelta());
                    }
                    hfilter.setXDelta(this.hin.getXDelta());
                    hfilter.setXUnits(1);
                    hfilter.write(this.filter, ntaps);
                }
            }
            DataOp.mul((Data)this.filter, (Data)new Data(1.0 / (double)this.nfft), (Data)this.filter, (int)ntaps, (int)530);
            DataOp.fill((Data)this.filter, (int)ntaps, (double)0.0, (int)(this.nfft - ntaps));
            DataOp.fft((Data)this.filter, (int)this.nfft, (int)10);
            this.nbad = ntaps - 1;
            this.complex = true;
        }
        if (this.setTimeDelta && this.hout != null) {
            this.hout.setXStart(this.hout.getXStart() + this.timeDelta);
        }
        if (this.hout != null && this.doTune && kwdUpdate != KwdUpdate.IGNORE) {
            Keywords kwds;
            Double oldSBT;
            if (kwdUpdate == KwdUpdate.AUTO) {
                KwdUpdate kwdUpdate2 = kwdUpdate = kwdSBT.isEmpty() ? KwdUpdate.NONE : KwdUpdate.UPDATE;
            }
            if (kwdSBT.isEmpty()) {
                kwdSBT = "SBT";
            }
            boolean hasSBT = (oldSBT = (kwds = this.hout.getKeywordsObject()).getD(kwdSBT, null)) != null;
            double fsIn = 1.0 / this.hin.getXDelta();
            double fsOut = fsIn / (double)this.decimation;
            double fMinIn = this.complexIn ? -fsIn / 2.0 : 0.0;
            double fMinOut = this.complexOut ? -fsOut / 2.0 : 0.0;
            double fbwIn = fsIn / 2.0 - fMinIn;
            double fbwOut = fsOut / 2.0 - fMinOut;
            double ftune = this.outputIF - this.inputIF;
            double newSBT = oldSBT != null ? oldSBT + (fMinOut + fbwOut / 2.0) - (fMinIn + fbwIn / 2.0) - ftune : 0.0 + (fMinOut + fbwOut / 2.0) - (fMinIn + fbwIn / 2.0) - ftune;
            switch (kwdUpdate) {
                case INSERT: {
                    kwds.put(kwdSBT, (Object)new Data(newSBT));
                    break;
                }
                case UPDATE: {
                    if (!hasSBT) break;
                    kwds.put(kwdSBT, (Object)new Data(newSBT));
                    break;
                }
                case NONE: {
                    if (!hasSBT) break;
                    this.M.warning((CharSequence)("Skipping update for " + kwdSBT));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected KwdUpdate." + (Object)((Object)kwdUpdate)));
                }
            }
            if (kwds.find("SBT_OFFSET_CORRECT") != null) {
                this.M.warning((CharSequence)"Skipping update for (Platinum) SBT_* keywords.");
            }
        }
        this.hin.xferLength = this.nfft;
        this.hin.consLength = (this.hin.xferLength - this.nbad) / this.decimation * this.decimation;
        if (this.doTune && !this.doFilter && !this.complex) {
            throw new MidasException("You must filter a real input to tune it!");
        }
        if (this.resOutputIF != null) {
            this.MR.put(this.resOutputIF, (Object)this.outputIF);
        }
        if (hfilter != null) {
            hfilter.close();
        }
        return this.hout != null ? 0 : 9;
    }

    public int process() {
        int i;
        int nscalar;
        int ngot;
        int ngot_orig = ngot = this.hin.read(this.buf);
        if (ngot == 0) {
            return -1;
        }
        if (ngot < 0) {
            return 9;
        }
        if (this.doFilter) {
            DataOp.fill((Data)this.buf, (int)ngot, (double)0.0, (int)(this.nfft - ngot));
            DataOp.fft((Data)this.buf, (int)this.nfft, (int)this.fftFlagsFwd);
            if (!this.complexIn) {
                this.reflect(this.buf);
            }
            DataOp.mul((Data)this.buf, (Data)this.filter, (Data)this.buf, (int)this.nfft, (int)546);
            DataOp.fft((Data)this.buf, (int)this.nfft, (int)this.fftFlagsInv);
        }
        float[] fbuf = this.buf.castF(true);
        int nout = (ngot - this.nbad) / this.decimation;
        int n = nscalar = this.complexOut ? nout * 2 : nout;
        if (this.doTune) {
            i = this.nbad * 2;
            int j = 0;
            while (j < nscalar) {
                fbuf[j++] = (float)((double)fbuf[i] * this.phasor_real - (double)fbuf[i + 1] * this.phasor_imag);
                if (this.complexOut) {
                    fbuf[j++] = (float)((double)fbuf[i + 1] * this.phasor_real + (double)fbuf[i] * this.phasor_imag);
                }
                double rtemp = this.phasor_real * this.dphasor_real - this.phasor_imag * this.dphasor_imag;
                double itemp = this.phasor_imag * this.dphasor_real + this.phasor_real * this.dphasor_imag;
                this.phasor_real = rtemp;
                this.phasor_imag = itemp;
                i += 2;
                if (this.complex) {
                    i += 2 * (this.decimation - 1);
                    continue;
                }
                i += this.decimation - 1;
            }
        } else {
            i = this.nbad * 2;
            int j = 0;
            while (j < nscalar) {
                fbuf[j++] = fbuf[i++];
                if (this.complexOut) {
                    fbuf[j++] = fbuf[i];
                }
                if (this.complex) {
                    ++i;
                }
                if (this.complex) {
                    i += 2 * (this.decimation - 1);
                    continue;
                }
                i += this.decimation - 1;
            }
        }
        this.buf.uncast(fbuf, true);
        ngot -= this.nbad;
        if (nout < this.hin.consLength && (this.partial == 2 || this.partial == 3)) {
            DataOp.fill((Data)this.buf, (int)ngot_orig, (double)0.0, (int)(this.buf.size - ngot_orig));
            nout = this.hin.consLength;
        }
        if (this.partial == 3) {
            this.partial = 1;
        }
        if (nout > 0) {
            Object hdr = this.buf.getHeader();
            if (!this.setTimeDelta) {
                this.buf.setHeader(null);
            } else if (hdr instanceof Time) {
                this.buf.setHeader((Object)((Time)hdr).addSec(this.timeDelta));
            }
            this.hout.write(this.buf, nout);
        }
        return 0;
    }

    public int close() {
        this.hin.close();
        if (this.hout != null) {
            this.hout.close();
        }
        if (this.hdebug != null) {
            this.hdebug.close();
        }
        if (this.resOutputIF != null) {
            this.MR.put(this.resOutputIF, (Object)this.outputIF);
        }
        return 0;
    }

    private void reflect(Data buffer) {
        float[] fbuf = buffer.castF(true);
        for (int i = 1; i < this.nfft / 2; ++i) {
            int j1 = (this.nfft - i) * 2;
            int j2 = i * 2;
            fbuf[j1++] = fbuf[j2++];
            fbuf[j1] = -fbuf[j2];
        }
        buffer.uncast(fbuf, true);
    }

    @InternalUseOnly
    public static enum KwdUpdate {
        AUTO,
        INSERT,
        NONE,
        IGNORE,
        UPDATE;

    }
}

