/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.dsp.lib.Complex;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class tracksub
extends Primitive {
    private DataFile inputFile;
    private DataFile outputFile;
    private DataFile freqTrackOutputFile;
    private DataFile decPhaseFile;
    private Data inputData;
    private Data outputData;
    private Data freqTrackOutputData;
    private Data decPhaseData;
    private static final int L_BBUF = 262144;
    private static final int MAXLEN = 32768;
    private static final int LENGTH_MAX = 4219;
    private static final int NFILT_MAX = 512;
    private static final int LFILT_MAX = 127;
    private static final int NCOEF = 7;
    private static final float[] COEF = new float[]{0.0f, 1.087806f, 1.199617f, 0.461974f, 0.020253f, 0.001069f, -6.54E-4f, 2.32E-4f};
    private static final float TWOPI = (float)Math.PI * 2;
    private static final double DTWOPI = Math.PI * 2;
    private static final int REAL = 0;
    private static final int IMAG = 1;
    private boolean trakout;
    private boolean phaseout;
    private int ngot;
    private int start1 = 1;
    private int nleft1;
    private int nget;
    private int incr;
    private int length;
    private int numout;
    private int decfact;
    private float xout;
    private float[][] bpf;
    private float[][][] bpfbank;
    private int nleft2;
    private int istart;
    private float[][] decdata;
    private int lfilt;
    private int nfilt;
    private float[] gain;
    private float[] filtf;
    private int subfact;
    private float predict_phase;
    private float substep;
    private float phasestep;
    private float[] gain2;
    private float[] trakfreq;
    private float[] trakphase;
    private int lastout;
    private int leninv;
    private float[][] carrdec;
    private float[][] carrdecbuf;
    private int nleft3;
    private int pstart;
    private int subsamp;
    private int pstart1;
    private float[][] bpfinv;
    private int pstart2;
    private int nout;
    private float[][] carrier = new float[32768][2];
    float[][] c8buf1 = new float[32769][2];
    float[][] c8buf3 = new float[327][2];

    public int open() {
        int i;
        int i2;
        float phase;
        float beta;
        this.inputFile = this.MA.getDataFile("IN", "1000", "CF", 0);
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 0);
        float fc = (float)this.MA.getD("FC");
        float range = (float)this.MA.getD("RANGE");
        double bw = this.MA.getD("BW");
        this.subfact = (int)Math.round(this.MA.getD("SUBFACTOR"));
        this.subsamp = (int)Math.round(this.MA.getD("SAMPFACTOR"));
        this.substep = (float)Math.PI * 2 / (float)this.subfact;
        this.nfilt = Math.max((int)Math.round(4.0 * (double)range / bw), 1);
        if (this.nfilt > 512) {
            this.M.error("Range exceeds 128*bw");
        }
        this.inputFile.open();
        int type_code1 = this.inputFile.getType();
        int x_units1 = this.inputFile.getXUnits();
        double x_start1 = this.inputFile.getXStart();
        double x_delta1 = this.inputFile.getXDelta();
        double size1 = this.inputFile.getSize();
        int lhalf = (int)Math.round(2.107 / ((double)range * x_delta1));
        this.length = lhalf * 2 + 1;
        if (this.length > 4219) {
            this.length = 4219;
            this.decfact = Math.round(715.0847f);
        } else {
            this.decfact = (int)Math.round(1.0 / ((double)range * 1.4 * x_delta1));
        }
        this.decfact = this.decfact / 2 * 2;
        this.pstart = (this.length - 1) % this.decfact;
        this.pstart1 = this.pstart + 1;
        this.pstart2 = this.pstart + 2;
        this.predict_phase = 0.0f;
        this.phasestep = (float)(x_delta1 * (double)fc * (double)this.substep * (double)this.decfact % (Math.PI * 2));
        if (size1 < (double)this.length) {
            this.M.error("Data file too short for impulse response file");
        }
        this.xout = ((float)(32768 - this.length) + 1.0f) / (float)this.decfact;
        this.numout = (int)this.xout;
        this.incr = this.numout * this.decfact;
        this.ngot = this.nget = this.incr + this.length - 1;
        this.nleft1 = 0;
        double x_delta3 = x_delta1 * (double)this.decfact;
        float lowlim = fc - range / 2.0f;
        float hilim = fc + range / 2.0f;
        int ndelay = (int)Math.round(0.5935 / (x_delta3 * bw)) - 1;
        this.lfilt = ndelay * 2 + 1;
        if (this.lfilt > 127) {
            this.M.error("Bank filters too long");
        }
        float[] window2 = new float[this.lfilt + 1];
        for (int i3 = 1; i3 <= this.lfilt; ++i3) {
            window2[i3] = (float)Math.cos((double)(i3 - ndelay - 1) * Math.PI / (double)this.lfilt);
        }
        this.filtf = new float[this.nfilt + 1];
        int tempMax = Math.max(this.nfilt - 1, 1);
        int tempLim = this.lfilt - 1;
        float limDiff = hilim - lowlim;
        float tempProduct = (float)(6.2831854820251465 * x_delta3);
        Complex cnum1 = new Complex();
        Complex cnum2 = new Complex();
        this.bpfbank = new float[this.nfilt + 1][this.lfilt + 1][2];
        for (int i4 = 1; i4 <= this.nfilt; ++i4) {
            float filtfreq;
            this.filtf[i4] = filtfreq = lowlim + (float)(i4 - 1) * limDiff / (float)tempMax;
            beta = -filtfreq * tempProduct;
            for (int j = 0; j <= tempLim; ++j) {
                phase = (float)(j - ndelay) * beta;
                cnum1.real = (float)Math.cos(phase);
                cnum1.imag = (float)Math.sin(phase);
                Complex.mult(cnum1.real, cnum1.imag, window2[j + 1], cnum1);
                this.bpfbank[i4][j + 1][0] = cnum1.real;
                this.bpfbank[i4][j + 1][1] = cnum1.imag;
            }
        }
        this.nleft2 = 0;
        this.istart = 1;
        this.nleft3 = 0;
        this.outputFile.setXDelta(x_delta1 * (double)this.subsamp);
        int bias = this.length - 1 + ndelay * this.decfact - this.pstart;
        this.outputFile.setXStart(x_start1 + x_delta1 * (double)bias);
        this.outputFile.setSize((double)(((int)(size1 - (double)this.length + 1.0) / this.decfact + 1 - 2 * ndelay - (this.length - 1) / this.decfact) * this.decfact / this.subsamp));
        this.outputFile.open();
        String name3 = this.MA.getS("TRACKOUT");
        String name4 = this.MA.getS("DECPHASE");
        this.trakout = !name3.equals("");
        boolean bl = this.phaseout = !name4.equals("");
        if (this.trakout) {
            this.freqTrackOutputFile = this.MA.getDataFile("TRACKOUT", "1001", "SF", 0);
            this.freqTrackOutputFile.setXDelta(x_delta3);
            this.freqTrackOutputFile.setXStart(x_start1 - x_delta1 * (0.5 * (double)(this.length - 1) + (double)(ndelay * this.decfact)));
            this.freqTrackOutputFile.setXUnits(x_units1);
            this.freqTrackOutputFile.setSize((double)((int)((size1 + (double)this.pstart - (double)this.length + 1.0) / (double)this.decfact) - 2 * ndelay));
            this.freqTrackOutputFile.open();
            this.freqTrackOutputData = this.freqTrackOutputFile.getDataBuffer(4096);
        }
        if (this.phaseout) {
            this.decPhaseFile = this.MA.getDataFile("DECPHASE", "1001", "SF", 0);
            this.decPhaseFile.setXDelta(x_delta3);
            this.decPhaseFile.setXStart(x_start1 - x_delta1 * (0.5 * (double)(this.length - 1) + (double)(ndelay * this.decfact)));
            this.decPhaseFile.setXUnits(x_units1);
            this.decPhaseFile.setSize((double)((int)((size1 + (double)this.pstart - (double)this.length + 1.0) / (double)this.decfact) - 2 * ndelay));
            this.decPhaseFile.open();
            this.decPhaseData = this.decPhaseFile.getDataBuffer(4096);
        }
        float[] lpf = new float[this.length + 1];
        for (int k = 1; k <= this.length; ++k) {
            float tk = (float)k - (float)this.length / 2.0f - 0.5f;
            float sum = 0.0f;
            for (i2 = 1; i2 <= 7; ++i2) {
                sum = (float)((double)sum + (double)COEF[i2] * Math.cos(Math.PI * (double)(2 * i2 - 1) * (double)tk / (double)this.length));
            }
            lpf[k] = 2.0f * sum / (float)this.length;
        }
        this.bpf = new float[this.length + 1][2];
        beta = (float)((double)((float)Math.PI * 2 * fc) * x_delta1);
        for (int i5 = 1; i5 <= this.length; ++i5) {
            phase = (float)(i5 - 1) * beta;
            cnum1.real = (float)Math.cos(phase);
            cnum1.imag = (float)Math.sin(phase);
            Complex.mult(cnum1.real, cnum1.imag, lpf[i5], cnum2);
            this.bpf[i5][0] = cnum2.real;
            this.bpf[i5][1] = cnum2.imag;
        }
        this.gain = new float[this.nfilt + 1];
        Complex cnumsum = new Complex();
        for (i2 = 1; i2 <= this.nfilt; ++i2) {
            beta = (float)((double)(this.filtf[i2] * ((float)Math.PI * 2)) * x_delta1);
            cnumsum.real = 0.0f;
            cnumsum.imag = 0.0f;
            for (int j = 1; j <= this.length; ++j) {
                phase = (float)(-(j - 1)) * beta;
                cnum1.real = (float)Math.cos(phase);
                cnum1.imag = (float)Math.sin(phase);
                Complex.mult(cnum1.real, cnum1.imag, this.bpf[j][0], this.bpf[j][1], cnum2);
                Complex.add(cnum2.real, cnum2.imag, cnumsum.real, cnumsum.imag, cnumsum);
            }
            this.gain[i2] = Complex.cabs(cnumsum.real, cnumsum.imag);
        }
        this.bpfinv = new float[this.length + 1][2];
        this.leninv = this.length;
        beta = (float)((double)((float)Math.PI * 2 * fc) * x_delta1 / (double)this.subfact);
        for (i = 1; i <= this.leninv; ++i) {
            phase = (float)(1 - i) * beta;
            int index = this.leninv - i + 1;
            cnum1.real = (float)Math.cos(phase);
            cnum1.imag = (float)Math.sin(phase);
            Complex.mult(cnum1.real, cnum1.imag, (float)this.decfact * lpf[i], cnum2);
            this.bpfinv[index][0] = cnum2.real;
            this.bpfinv[index][1] = cnum2.imag;
        }
        this.gain2 = new float[this.nfilt + 1];
        for (i = 1; i <= this.nfilt; ++i) {
            beta = (float)((double)(-this.filtf[i] * ((float)Math.PI * 2)) * x_delta1 / (double)this.subfact);
            cnumsum.real = 0.0f;
            cnumsum.imag = 0.0f;
            for (int j = 1; j <= this.length; ++j) {
                phase = (float)(j - 1) * beta;
                cnum1.real = (float)Math.cos(phase);
                cnum1.imag = (float)Math.sin(phase);
                Complex.mult(cnum1.real, cnum1.imag, this.bpfinv[j][0], this.bpfinv[j][1], cnum2);
                Complex.add(cnumsum.real, cnumsum.imag, cnum2.real, cnum2.imag, cnumsum);
            }
            this.gain2[i] = Complex.cabs(cnumsum.real, cnumsum.imag) / (float)this.decfact;
        }
        this.inputData = this.inputFile.getDataBuffer(this.nget, (byte)70);
        this.outputData = this.outputFile.getDataBuffer(32768);
        this.decdata = new float[4220][2];
        this.carrdec = new float[4220][2];
        this.carrdecbuf = new float[4220][2];
        return 0;
    }

    public int process() {
        int i;
        int count;
        this.ngot = this.inputFile.read(this.inputData, this.nget);
        if (this.ngot == 0) {
            return -1;
        }
        if (this.ngot < 0) {
            return 9;
        }
        this.calc();
        if (this.trakout) {
            this.freqTrackOutputData = this.freqTrackOutputFile.getDataBuffer(this.lastout);
            float[] trakbuf = this.freqTrackOutputData.castF(false);
            count = 1;
            for (i = 0; i < this.lastout; ++i) {
                trakbuf[i] = this.trakfreq[count++];
            }
            this.freqTrackOutputData.uncast(trakbuf, true);
            this.freqTrackOutputFile.write(this.freqTrackOutputData);
        }
        if (this.phaseout) {
            this.decPhaseData = this.decPhaseFile.getDataBuffer(this.lastout);
            float[] phasebuf = this.decPhaseData.castF(false);
            count = 1;
            for (i = 0; i < this.lastout; ++i) {
                phasebuf[i] = this.trakphase[count++];
            }
            this.decPhaseData.uncast(phasebuf, true);
            this.decPhaseFile.write(this.decPhaseData);
        }
        float[] outbuf = this.outputData.castF(false);
        count = 0;
        for (i = 1; i <= this.nout; ++i) {
            outbuf[count++] = this.carrier[i][0];
            outbuf[count++] = this.carrier[i][1];
        }
        this.outputData.uncast(outbuf, true);
        this.outputFile.write(this.outputData, this.nout);
        return 0;
    }

    public int close() {
        this.inputFile.close();
        this.outputFile.close();
        if (this.trakout) {
            this.freqTrackOutputFile.close();
        }
        if (this.phaseout) {
            this.decPhaseFile.close();
        }
        return 0;
    }

    private void calc() {
        int i;
        Complex cnum1 = new Complex();
        float[] inputWork = this.inputData.castF(true);
        int j = this.nleft1 + 1;
        try {
            for (int i2 = 0; i2 < this.ngot * 2; i2 += 2) {
                this.c8buf1[j][0] = inputWork[i2];
                this.c8buf1[j][1] = inputWork[i2 + 1];
                ++j;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("j = " + j + " nleft1 = " + this.nleft1);
            System.exit(0);
            return;
        }
        this.inputData.uncast(inputWork, false);
        this.nleft1 += this.ngot;
        if (this.start1 == 1) {
            this.start1 = this.incr + this.length;
            this.nget -= this.length - 1;
            this.ngot -= this.length - 1;
        } else {
            this.start1 += this.incr;
        }
        if (this.ngot != this.nget) {
            this.numout = (int)((float)this.ngot / (float)this.decfact);
            if (this.xout != (float)((int)this.xout)) {
                ++this.numout;
            }
        }
        int joff1 = 0;
        Complex cnumsum = new Complex();
        for (i = 1; i <= this.numout; ++i) {
            cnumsum.real = 0.0f;
            cnumsum.imag = 0.0f;
            for (j = 1; j <= this.length; ++j) {
                Complex.mult(this.c8buf1[joff1 + j][0], this.c8buf1[joff1 + j][1], this.bpf[this.length + 1 - j][0], this.bpf[this.length + 1 - j][1], cnum1);
                Complex.add(cnumsum.real, cnumsum.imag, cnum1.real, cnum1.imag, cnumsum);
            }
            joff1 += this.decfact;
            this.c8buf3[i][0] = cnumsum.real;
            this.c8buf3[i][1] = cnumsum.imag;
        }
        this.nleft1 = this.length - 1;
        for (i = 1; i <= this.nleft1; ++i) {
            this.c8buf1[i][0] = this.c8buf1[i + this.incr][0];
            this.c8buf1[i][1] = this.c8buf1[i + this.incr][1];
        }
        for (i = 1; i <= this.nleft2; ++i) {
            this.decdata[i][0] = this.decdata[i + this.istart - 1][0];
            this.decdata[i][1] = this.decdata[i + this.istart - 1][1];
        }
        this.istart = 1;
        for (i = 1; i <= this.numout; ++i) {
            this.decdata[this.nleft2 + i][0] = this.c8buf3[i][0];
            this.decdata[this.nleft2 + i][1] = this.c8buf3[i][1];
        }
        this.nleft2 += this.numout;
        int nextout = 1;
        float fsave = 0.0f;
        int imax = 0;
        Complex csave = new Complex();
        this.trakfreq = new float[4220];
        this.trakphase = new float[4220];
        while (this.nleft2 >= this.lfilt) {
            float cmax = 0.0f;
            for (int i3 = 1; i3 <= this.nfilt; ++i3) {
                cnumsum.real = 0.0f;
                cnumsum.imag = 0.0f;
                for (j = 0; j <= this.lfilt - 1; ++j) {
                    Complex.mult(this.decdata[this.istart + j][0], this.decdata[this.istart + j][1], this.bpfbank[i3][j + 1][0], this.bpfbank[i3][j + 1][1], cnum1);
                    Complex.add(cnumsum.real, cnumsum.imag, cnum1.real, cnum1.imag, cnumsum);
                }
                Complex.divide(cnumsum.real, cnumsum.imag, this.gain[i3], cnumsum);
                float cmag = Complex.cabs(cnumsum.real, cnumsum.imag);
                if (!(cmag > cmax)) continue;
                cmax = cmag;
                csave.real = cnumsum.real;
                csave.imag = cnumsum.imag;
                fsave = this.filtf[i3];
                imax = i3;
            }
            float crphase = (float)Math.atan2((double)csave.imag + 1.0E-30, csave.real) / (float)this.subfact;
            int iadjust = Math.round((crphase - this.predict_phase) / this.substep);
            this.predict_phase = ((crphase -= (float)iadjust * this.substep) + this.phasestep) % ((float)Math.PI * 2);
            if (this.gain2[imax] == 0.0f) {
                this.M.error("Zero gain");
            }
            cnum1.real = (float)Math.cos(crphase);
            cnum1.imag = (float)Math.sin(crphase);
            Complex.divide(cnum1.real, cnum1.imag, this.gain2[imax], cnum1);
            this.carrdec[nextout][0] = cnum1.real;
            this.carrdec[nextout][1] = cnum1.imag;
            if (this.trakout) {
                this.trakfreq[nextout] = fsave;
            }
            if (this.phaseout) {
                this.trakphase[nextout] = crphase / ((float)Math.PI * 2);
            }
            ++nextout;
            --this.nleft2;
            ++this.istart;
        }
        this.lastout = nextout - 1;
        int L = this.leninv;
        int ntaps = (this.length + this.decfact - 1) / this.decfact;
        for (int i4 = 1; i4 <= this.lastout; ++i4) {
            this.carrdecbuf[i4 + this.nleft3][0] = this.carrdec[i4][0];
            this.carrdecbuf[i4 + this.nleft3][1] = this.carrdec[i4][1];
        }
        this.nleft3 += this.lastout;
        int ndo = this.nleft3 - (ntaps - 1);
        if (ndo > 0) {
            for (int i5 = 1; i5 <= ndo * this.decfact + this.pstart; ++i5) {
                this.carrier[i5][0] = 0.0f;
                this.carrier[i5][1] = 0.0f;
            }
            for (int k = 1; k <= ndo; ++k) {
                int index;
                int jks;
                int i6;
                int kus = (k - 1) * this.decfact;
                int jstart = kus % this.subsamp + 1;
                for (i6 = 1; i6 <= ntaps; ++i6) {
                    jks = (jstart + kus - 1) / this.subsamp + 1;
                    for (j = jstart; j <= this.pstart1; j += this.subsamp) {
                        index = L - this.pstart1 + j - (i6 - 1) * this.decfact;
                        Complex.mult(this.carrdecbuf[i6 + (k - 1)][0], this.carrdecbuf[i6 + (k - 1)][1], this.bpfinv[index][0], this.bpfinv[index][1], cnum1);
                        Complex.add(this.carrier[jks][0], this.carrier[jks][1], cnum1.real, cnum1.imag, cnum1);
                        this.carrier[jks][0] = cnum1.real;
                        this.carrier[jks][1] = cnum1.imag;
                        ++jks;
                    }
                }
                jstart = this.pstart2 + (this.pstart2 + kus - 1) % this.subsamp;
                for (i6 = 2; i6 <= ntaps; ++i6) {
                    jks = (jstart + kus - 1) / this.subsamp + 1;
                    for (j = jstart; j <= this.decfact; j += this.subsamp) {
                        index = L - this.pstart1 + j - (i6 - 1) * this.decfact;
                        Complex.mult(this.carrdecbuf[i6 + (k - 1)][0], this.carrdecbuf[i6 + (k - 1)][1], this.bpfinv[index][0], this.bpfinv[index][1], cnum1);
                        Complex.add(this.carrier[jks][0], this.carrier[jks][1], cnum1.real, cnum1.imag, cnum1);
                        this.carrier[jks][0] = cnum1.real;
                        this.carrier[jks][1] = cnum1.imag;
                        ++jks;
                    }
                }
            }
            this.nout = (this.pstart + this.nleft3 * this.decfact - this.length) / this.subsamp + 1;
            this.nleft3 -= ndo;
            for (int i7 = 1; i7 <= this.nleft3; ++i7) {
                this.carrdecbuf[i7][0] = this.carrdecbuf[i7 + ndo][0];
                this.carrdecbuf[i7][1] = this.carrdecbuf[i7 + ndo][1];
            }
        }
    }
}

