/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;

public class newrate
extends Primitive {
    private static final int INBUFSIZE = 131072;
    private static final int OUTBUFSIZE = 131072;
    private static final int FILTBUFSIZE = 262144;
    private static final int NTAPS = 28;
    private static final int NFILTERS = 2048;
    private static final int PBUFSIZE_MAX = 16384;
    private double t_now = 0.0;
    private double tstep = 0.0;
    private int nstep = 0;
    private double bufstart = 0.0;
    private double x_start = 0.0;
    private double pstep_nominal = 0.0;
    private int npts = 0;
    private double p_start = 0.0;
    private double pp_delta = 0.0;
    private double pri = 0.0;
    private boolean nowrap = false;
    private int ncleft = 0;
    private boolean matchXM = false;
    private DataFile inputFile;
    private DataFile outputFile;
    private DataFile syncFile;
    private DataFile filterFile;
    private Data inputData;
    private Data outputData;
    private Data filterData;
    private Data syncData;
    private float[][] filterBuffer;
    private float[] inBuffer = new float[131072];
    private float[] outBuffer;
    private long inBase;
    private double inReadP;
    private double inReadPStart;
    private long inWriteP;
    private int inBufSamples;
    private long outBase;
    private long outWriteP;
    private int outBufSamples;
    private int phaseBufSamples;
    private boolean tuning;
    private boolean syncing;
    private boolean offsetting;
    private boolean cxFilter;
    private double newRate;
    private double phaseOffset = 0.0;
    private double rTune;
    private double qTune;
    private double rTuneTwiddle = 1.0;
    private double qTuneTwiddle = 0.0;
    private double round = 0.0;
    private double inStep;
    private int nTaps;
    private int nInterps;
    private int outRoomLeft;
    private int inFPS;
    private int outFPS;
    private int filterFPS;
    private long outCount = 0L;
    private int inHave;
    private static final double[][] HFILTER = new double[][]{{-1.723066E-13, 2.602363E-13, -4.423129E-13, 5.346834E-13, -6.608047E-13, 8.437695E-13, -9.716672E-13, 1.005418E-12, -1.13265E-12, 1.079137E-12, -1.073808E-12, 1.087463E-12, -1.034284E-12, 1.0, -1.008971E-12, 1.066258E-12, -1.106115E-12, 1.100453E-12, -1.066702E-12, 1.133982E-12, -9.734435E-13, 8.544276E-13, -6.910028E-13, 5.044853E-13, -4.209966E-13, 3.179679E-13, -1.270095E-13, 1.190159E-13}, {-4.104828E-4, 5.881413E-4, -8.470448E-4, 0.00118847, -0.00162668, 0.002186433, -0.002900885, 0.003831123, -0.00508204, 0.006867848, -0.009688202, 0.01503587, -0.03021841, 0.9986488, 0.0316667, -0.01503463, 0.009438746, -0.006555507, 0.004764554, -0.003532743, 0.002634133, -0.001954591, 0.00143321, -0.001028657, 7.162614E-4, -4.755949E-4, 2.884227E-4, -4.237333E-4}, {-7.187069E-4, 9.908061E-4, -0.001444174, 0.002060965, -0.002865905, 0.003907888, -0.005254533, 0.007026941, -0.009431731, 0.01288739, -0.01836151, 0.0287146, -0.05760054, 0.9933048, 0.06595361, -0.03120765, 0.0197587, -0.01388523, 0.01022675, -0.007694323, 0.00582936, -0.00440232, 0.003291889, -0.002416211, 0.001728239, -0.00118716, 7.531443E-4, -9.410921E-4}, {-9.825213E-4, 0.001322678, -0.001954004, 0.002824262, -0.003969249, 0.005462254, -0.007402023, 0.009968592, -0.01346557, 0.01850434, -0.02648273, 0.04149505, -0.08264041, 0.9845923, 0.1021276, -0.04779923, 0.030301, -0.02138262, 0.01583498, -0.01198874, 0.009144412, -0.006956737, 0.00524422, -0.003886144, 0.002811235, -0.001959618, 0.001271215, -0.001486347}, {-0.001229729, 0.001633989, -0.002442849, 0.003558575, -0.005028745, 0.006950616, -0.009456534, 0.01278278, -0.01731891, 0.02385583, -0.03418219, 0.05348989, -0.105482, 0.9727868, 0.1398093, -0.06444895, 0.04075991, -0.02877768, 0.02134885, -0.01620298, 0.01239382, -0.009460293, 0.007155922, -0.00532201, 0.00386749, -0.002714455, 0.001784308, -0.002023978}, {-0.001473194, 0.001938066, -0.002921977, 0.004275934, -0.006060412, 0.008396355, -0.01144337, 0.01548994, -0.02100578, 0.02894415, -0.04145028, 0.06467696, -0.1261328, 0.9580158, 0.1787723, -0.08094347, 0.05097277, -0.03594548, 0.02666636, -0.02024795, 0.01550026, -0.01184472, 0.008971456, -0.006684138, 0.004867971, -0.003428578, 0.002271249, -0.002533638}, {-0.001720918, 0.002237771, -0.003391272, 0.004974463, -0.007060205, 0.009790856, -0.0133494, 0.01807334, -0.02450471, 0.03373951, -0.04824132, 0.07499048, -0.1445622, 0.9403764, 0.2188271, -0.09711936, 0.06083014, -0.04280343, 0.03172203, -0.02407327, 0.01842601, -0.01408198, 0.01066863, -0.007953897, 0.005798256, -0.004090765, 0.002721652, -0.003000148}, {-0.001978698, 0.002539513, -0.003856772, 0.005658871, -0.008029593, 0.01113157, -0.01516861, 0.02052077, -0.02779895, 0.03822265, -0.05452402, 0.08438267, -0.1607647, 0.9199924, 0.2597637, -0.1128011, 0.07021537, -0.04926194, 0.03644509, -0.02762774, 0.02113172, -0.01613911, 0.01222079, -0.009108335, 0.00663819, -0.004684233, 0.003121979, -0.003410907}, {-0.002246133, 0.002837869, -0.004311746, 0.006319633, -0.008955512, 0.01240187, -0.01688161, 0.02280971, -0.03085708, 0.04234878, -0.0602423, 0.09279005, -0.1747232, 0.8969753, 0.3013911, -0.1278384, 0.0790395, -0.05526447, 0.04079632, -0.03087931, 0.02359173, -0.01799905, 0.01361728, -0.01014043, 0.00738285, -0.005205662, 0.003470977, -0.003759954}, {-0.00252182, 0.003126621, -0.004746639, 0.006946272, -0.009827083, 0.01358697, -0.01846842, 0.02491469, -0.03364485, 0.04607555, -0.06534874, 0.1001599, -0.1864318, 0.8714455, 0.3435165, -0.142085, 0.08721583, -0.06075507, 0.04474083, -0.03380381, 0.02578715, -0.01964824, 0.01484772, -0.01104254, 0.008029398, -0.005655342, 0.003768718, -0.004042819}, {-0.002800683, 0.00340085, -0.005156998, 0.007531353, -0.01063397, 0.01467525, -0.01991343, 0.02681384, -0.03613512, 0.0493698, -0.06980349, 0.1064519, -0.1959051, 0.8435427, 0.385936, -0.1553897, 0.09465915, -0.06568033, 0.048242, -0.03637554, 0.02769969, -0.02107188, 0.01590099, -0.01180826, 0.008573212, -0.006029339, 0.00401455, -0.004259268}, {-0.003079207, 0.003654434, -0.005534245, 0.008064164, -0.01136279, 0.01564901, -0.02119403, 0.0284818, -0.03830048, 0.05219878, -0.0735665, 0.1116262, -0.2031609, 0.8134087, 0.4284509, -0.1676149, 0.1012989, -0.06999786, 0.05127081, -0.03857515, 0.02931919, -0.02226568, 0.0167746, -0.01243608, 0.00901432, -0.006328789, 0.004209657, -0.004408102}, {-0.003351431, 0.003882369, -0.00587221, 0.008536462, -0.01200258, 0.01649466, -0.02229383, 0.02989854, -0.04011697, 0.05453512, -0.07660818, 0.1156579, -0.208235, 0.7812024, 0.4708541, -0.178622, 0.1070651, -0.07366632, 0.0538014, -0.04038628, 0.03063499, -0.02322282, 0.01746474, -0.01292418, 0.009351747, -0.006553452, 0.004354787, -0.004491215}, {-0.003610339, 0.004079527, -0.006164601, 0.008939894, -0.0125421, 0.0171987, -0.02319715, 0.03104514, -0.04156235, 0.05635464, -0.0789043, 0.1185305, -0.2111745, 0.7470909, 0.5129383, -0.1882789, 0.1118954, -0.07665114, 0.05581383, -0.04179769, 0.03164055, -0.02393967, 0.01797045, -0.01327314, 0.009586181, -0.006704286, 0.004451525, -0.004512248}, {-0.003850176, 0.004243306, -0.006407434, 0.009269213, -0.0129747, 0.01775285, -0.023894, 0.03190988, -0.04262333, 0.05764329, -0.0804427, 0.1202436, -0.2120453, 0.7112565, 0.5544899, -0.1964535, 0.1157289, -0.0789182, 0.05728737, -0.0427963, 0.03232756, -0.02441106, 0.01828864, -0.01348123, 0.009716844, -0.006781076, 0.004499688, -0.00447429}, {-0.004063686, 0.004370135, -0.006595247, 0.009517455, -0.01329186, 0.01814694, -0.02437261, 0.03247959, -0.04328584, 0.05838729, -0.08121328, 0.1208016, -0.2109199, 0.6738845, 0.5953013, -0.2030252, 0.1185167, -0.08044429, 0.05821074, -0.04337718, 0.0326947, -0.0246378, 0.01842126, -0.01355092, 0.009746339, -0.006786256, 0.004500832, -0.00438268}, {-0.004243565, 0.004456881, -0.006723019, 0.009678334, -0.01348607, 0.01837216, -0.02462313, 0.03274378, -0.04353938, 0.05857775, -0.08121268, 0.1202183, -0.2078819, 0.6351669, 0.6351669, -0.2078819, 0.1202183, -0.08121268, 0.05857775, -0.04353938, 0.03274378, -0.02462313, 0.01837216, -0.01348607, 0.009678334, -0.006723019, 0.004456881, -0.004243565}};

    public int open() {
        this.inputFile = this.MA.getDataFile("IN", "1000", "-#", 0);
        this.inputFile.open();
        this.inputData = this.inputFile.getDataBuffer(131072, (byte)70);
        if (this.inputFile.getFormatMode() == 67) {
            this.inFPS = 2;
        } else if (this.inputFile.getFormatMode() == 83) {
            this.inFPS = 1;
        } else {
            throw new MidasException("Input File Format must be C(omplex) or S(calar)");
        }
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 0);
        this.outputFile.open();
        this.outputData = this.outputFile.getDataBuffer(131072, (byte)70);
        this.outBuffer = this.outputData.castF(false);
        this.outBase = 0L;
        this.outWriteP = 0L;
        this.nowrap = this.MA.find("/NOWRAP");
        this.matchXM = this.MA.find("/XMTO");
        if (this.nowrap) {
            throw new MidasException("NOWRAP not yet implemented.");
        }
        this.setRate(this.MA.getD("RATE"));
        if (this.MA.find("FILTER")) {
            this.filterFile = this.MA.getDataFile("FILTER", "2000", "-#", 0);
            this.filterFile.open();
            if (this.filterFile.getFormatMode() == 67) {
                this.outputFile.setFormatMode((byte)67);
                this.cxFilter = true;
                this.filterFPS = 2;
            } else {
                if (this.filterFile.getFormatMode() != 83) {
                    throw new MidasException("Unsupported filter file format");
                }
                this.filterFPS = 1;
            }
            this.userFilter();
        } else {
            this.cxFilter = false;
            this.nInterps = 2048;
            this.defaultFilter();
        }
        this.outFPS = this.outputFile.getFormatMode() == 67 ? 2 : 1;
        this.tuning = this.MA.find("/TUNE");
        if (this.tuning) {
            this.setTune(this.MA.getD("/TUNE"));
        }
        this.offsetting = this.MA.find("/OFFSET");
        if (this.offsetting) {
            this.phaseOffset = this.MA.getD("/OFFSET");
            this.phaseOffset -= (double)((long)this.phaseOffset);
            if (this.phaseOffset < 0.0) {
                this.phaseOffset += 1.0;
            }
        }
        this.outputFile.setXStart(this.inputFile.getXStart() + ((double)this.nTaps / 2.0 - 1.0) * this.inputFile.getXDelta() + this.phaseOffset * this.outputFile.getXDelta());
        this.syncing = this.MA.find("SYNC");
        if (this.syncing) {
            this.syncFile = this.MA.getDataFile("SYNC", "1000", "S#", 0);
            this.syncFile.open();
            this.pri = 1.0 / this.newRate;
            this.phaseBufSamples = 16384;
            this.firstClock(this.outputFile.getXStart(), 0.0);
            this.ncleft = this.nstep;
            this.inReadP = (this.t_now + (double)this.outCount * this.outputFile.getXDelta() + this.p_start - this.outputFile.getXStart()) / this.inputFile.getXDelta();
            this.inStep = (this.tstep + this.outputFile.getXDelta()) / this.inputFile.getXDelta();
            this.inHave = 0;
        } else {
            this.inReadP = this.inStep * this.phaseOffset;
            this.inHave = 0;
        }
        this.inBufSamples = 131072 / this.inFPS;
        this.outRoomLeft = this.outBufSamples = 131072 / this.outFPS;
        this.inWriteP = 0L;
        return 0;
    }

    public int process() {
        int status = 0;
        int iters = 0;
        if (this.inWriteP - this.inBase == (long)this.inBufSamples) {
            int offset = (int)(this.inReadP - (double)this.inBase) * this.inFPS;
            int size = this.inHave * this.inFPS;
            for (int ii = 0; ii < size; ++ii) {
                this.inBuffer[ii] = this.inBuffer[ii + offset];
            }
            this.inBase = this.inWriteP - (long)this.inHave;
        }
        if (this.inWriteP - this.inBase < (long)this.inBufSamples && this.inHave <= this.nTaps) {
            long read = this.inHave < 0 ? (long)this.inBufSamples : (long)this.inBufSamples - (this.inWriteP - this.inBase);
            int inGot = this.inputFile.read(this.inputData, (int)read);
            if (inGot < 0 && this.inHave < this.nTaps) {
                status = 9;
            } else {
                int offset = (int)(this.inWriteP - this.inBase) * this.inFPS;
                int size = inGot * this.inFPS;
                float[] input = this.inputData.castF(true);
                int numSkip = 0;
                if (this.inHave < 0) {
                    numSkip = -this.inHave * this.inFPS;
                    size -= numSkip;
                    offset = 0;
                    this.inBase = (long)this.inReadP;
                }
                if (size > 0) {
                    System.arraycopy(input, numSkip, this.inBuffer, offset, size);
                }
                this.inputData.uncast(input, false);
                this.inWriteP += (long)inGot;
                this.inHave = (int)(this.inWriteP - (long)this.inReadP);
            }
        }
        if (this.inHave < this.nTaps && status == 0) {
            status = -1;
        }
        if (this.inHave >= this.nTaps) {
            double steps = ((double)this.inWriteP - this.inReadP - (double)this.nTaps + 0.999999) / this.inStep;
            iters = Math.min(this.outRoomLeft, (int)steps + 1);
            if (this.syncing) {
                iters = Math.min(iters, this.ncleft);
            }
            this.inReadPStart = this.inReadP;
            this.applyFilter(iters, this.inStep);
            this.outRoomLeft -= iters;
        }
        if (status == 9 || (double)(this.outWriteP - this.outBase) > (double)this.outBufSamples * 0.9) {
            this.outputData.uncast(this.outBuffer, true);
            this.outputFile.write(this.outputData, (int)(this.outWriteP - this.outBase));
            this.outBuffer = this.outputData.castF(false);
            this.outBase = this.outWriteP;
            this.outRoomLeft = this.outBufSamples;
        }
        this.inReadP = this.inReadPStart + (double)iters * this.inStep;
        this.outCount += (long)iters;
        this.inHave = (int)(this.inWriteP - (long)this.inReadP);
        if (this.syncing) {
            this.ncleft -= iters;
            if (this.ncleft < 1) {
                this.t_now += (double)this.nstep * this.tstep;
                this.nextClock();
                this.ncleft = this.nstep;
                this.inReadP = (this.t_now + (double)this.outCount * this.outputFile.getXDelta() + this.p_start - this.outputFile.getXStart()) / this.inputFile.getXDelta();
                this.inStep = (this.tstep + this.outputFile.getXDelta()) / this.inputFile.getXDelta();
            }
        }
        return status;
    }

    public int close() {
        this.inputFile.close();
        this.outputData.uncast(this.outBuffer, false);
        this.outputFile.close();
        if (this.syncFile != null) {
            this.syncFile.close();
        }
        if (this.filterFile != null) {
            this.filterFile.close();
        }
        return 0;
    }

    private void defaultFilter() {
        int ii;
        int HALFSIZE = 17;
        this.filterBuffer = new float[2049][28];
        for (ii = 0; ii < 17; ++ii) {
            for (int jj = 0; jj < 28; ++jj) {
                this.filterBuffer[ii * 64][jj] = (float)HFILTER[ii][jj];
                this.filterBuffer[(32 - ii) * 64][28 - jj - 1] = (float)HFILTER[ii][jj];
            }
        }
        for (ii = 0; ii < 32; ++ii) {
            for (int kk = 1; kk < 64; ++kk) {
                for (int jj = 0; jj < 28; ++jj) {
                    this.filterBuffer[kk + ii * 64][jj] = (float)(((64.0 - (double)kk) * (double)this.filterBuffer[ii * 64][jj] + (double)((float)kk * this.filterBuffer[(ii + 1) * 64][jj])) / 64.0);
                }
            }
        }
        this.nTaps = 28;
    }

    private void userFilter() {
        int nFilters = (int)this.filterFile.getSize();
        this.nTaps = this.filterFile.getFrameSize();
        int nElements = this.nTaps * nFilters;
        int nSpread = (262144 / this.filterFPS - this.nTaps) / (this.nTaps * (nFilters - 1));
        this.filterData = this.filterFile.getDataBuffer(nFilters);
        int nGot = this.filterFile.read(this.filterData, nFilters);
        if (nGot != nFilters) {
            throw new MidasException("Failed to read " + nFilters + " frames from filter file " + this.filterFile.getName());
        }
        float[] filters = this.filterData.castF(true);
        this.filterBuffer = new float[(nFilters - 1) * nSpread + 1][this.nTaps * this.filterFPS];
        for (int ii = 0; ii < nFilters; ++ii) {
            for (int jj = 0; jj < this.nTaps * this.filterFPS; ++jj) {
                this.filterBuffer[nSpread * ii][jj] = filters[this.nTaps * this.filterFPS * ii + jj];
            }
        }
        if (nSpread > 1) {
            for (int ii = 0; ii < nFilters - 1; ++ii) {
                for (int jj = 1; jj < nSpread; ++jj) {
                    float w1 = (float)(nSpread - jj) / (float)nSpread;
                    float w2 = (float)jj / (float)nSpread;
                    for (int kk = 0; kk < this.nTaps * this.filterFPS; ++kk) {
                        this.filterBuffer[nSpread * ii + jj][kk] = w1 * this.filterBuffer[nSpread * ii][kk] + w2 * this.filterBuffer[nSpread * (ii + 1)][kk];
                    }
                }
            }
            this.filterData.uncast(filters, false);
        }
        this.nInterps = (nFilters - 1) * nSpread;
        this.round = 0.5;
    }

    void firstClock(double time_start, double tce) {
        int nfix;
        this.phaseBufSamples = Math.min(Math.max(this.phaseBufSamples, 2), 16384);
        this.syncData = this.syncFile.getDataBuffer(this.phaseBufSamples, (byte)70);
        this.npts = this.syncFile.read(this.syncData, this.phaseBufSamples);
        if (this.syncData.getSize() < 1) {
            throw new MidasException("Empty sync file.");
        }
        this.bufstart = this.p_start = this.syncFile.getXStart() + tce;
        this.pp_delta = this.syncFile.getXDelta();
        this.pstep_nominal = this.pp_delta / this.pri;
        this.x_start = time_start;
        this.outCount = Math.round((this.x_start - this.p_start) / this.pri - 0.5);
        if (!this.matchXM) {
            nfix = 0;
            nfix = this.t_now + (double)this.outCount * this.pri + this.p_start < this.x_start ? (int)((this.x_start - (this.t_now + (double)this.outCount * this.pri + this.p_start)) / this.pri + 1.0) : -((int)((this.t_now + (double)this.outCount * this.pri + this.p_start - this.x_start) / this.pri));
            this.nstep -= nfix;
            this.outCount += (long)nfix;
        }
        this.nextClock();
        if (this.matchXM) {
            nfix = 0;
            nfix = this.t_now + (double)this.outCount * this.pri + this.p_start < this.x_start ? (int)((this.x_start - (this.t_now + (double)this.outCount * this.pri + this.p_start)) / this.pri + 1.0) : -((int)((this.t_now + (double)this.outCount * this.pri + this.p_start - this.x_start) / this.pri));
            this.nstep -= nfix;
            this.outCount += (long)nfix;
        }
    }

    void nextClock() {
        double t_last = this.t_now;
        double time_now = t_last + this.pri * (double)this.outCount + this.p_start;
        long bindex = (long)((time_now - this.bufstart) / this.pp_delta + 1.0) - 1L;
        if (bindex < 0L) {
            this.t_now = -((double)this.syncData.getF(0) % 1.0) * this.pri;
            this.syncData.getFormat();
            double ioff = Math.round((t_last - this.t_now) / this.pri);
            this.tstep = 0.0;
            this.t_now -= ioff * this.pri;
            this.nstep = (int)(1.0 - (double)this.outCount - (double)Math.round(this.t_now / this.pri + 0.5));
            return;
        }
        if (bindex >= (long)(this.npts - 1)) {
            if (this.npts < this.phaseBufSamples) {
                this.tstep = 0.0;
                this.nstep = Integer.MAX_VALUE;
                this.t_now = (double)(-this.syncData.getF(this.npts - 1)) * this.pri + this.bufstart - this.p_start + this.pp_delta * (double)(this.npts - 1);
                this.t_now += (double)Math.round((t_last - this.t_now) / this.pri) * this.pri;
                return;
            }
            double p_index = Math.round((time_now - this.p_start) / this.pp_delta + 0.5);
            this.bufstart = this.p_start + (p_index - 1.0) * this.pp_delta;
            this.npts = this.syncFile.read(this.syncData, this.phaseBufSamples);
            bindex = (long)((time_now - this.bufstart) / this.pp_delta);
        }
        double phase1 = this.syncData.getF((int)bindex);
        double time1 = this.bufstart + (double)bindex * this.pp_delta;
        double phase2 = this.syncData.getF((int)(bindex + 1L));
        double pdif = phase2 - phase1;
        pdif = this.nowrap ? (pdif += this.pstep_nominal) : (pdif += (double)Math.round(this.pstep_nominal - pdif));
        double phasint = phase1 + pdif * (time_now - time1) / this.pp_delta;
        this.t_now = t_last - (phasint - (double)Math.round(phasint)) * this.pri;
        double tleft = time1 + this.pp_delta - time_now;
        if (tleft < 0.0) {
            tleft += this.pp_delta;
        }
        this.tstep = this.pp_delta / pdif - this.pri;
        this.nstep = (int)(tleft / this.pri + 1.0);
    }

    private void applyFilter(int nReps, double inStep) {
        long lInBase = this.inBase;
        int outOff = (int)(this.outWriteP - this.outBase) * this.outFPS;
        for (int ii = 0; ii < nReps; ++ii) {
            int jj;
            double inReadPos = this.inReadP + inStep * (double)ii;
            long ltemp = (long)inReadPos;
            int inOff = (int)(ltemp - lInBase) * this.inFPS;
            float[] filter2 = this.filterBuffer[(int)((double)this.nInterps * (inReadPos - (double)ltemp) + this.round)];
            float rsum = 0.0f;
            float qsum = 0.0f;
            if (this.cxFilter) {
                if (this.inFPS == 2) {
                    for (jj = 0; jj < this.nTaps; ++jj) {
                        rsum += this.inBuffer[inOff + jj * 2] * filter2[jj * 2] - this.inBuffer[inOff + jj * 2 + 1] * filter2[jj * 2 + 1];
                        qsum += this.inBuffer[inOff + jj * 2] * filter2[jj * 2 + 1] + this.inBuffer[inOff + jj * 2 + 1] * filter2[jj * 2];
                    }
                } else {
                    for (jj = 0; jj < this.nTaps; ++jj) {
                        rsum += this.inBuffer[inOff + jj] * filter2[jj * 2];
                        qsum += this.inBuffer[inOff + jj] * filter2[jj * 2 + 1];
                    }
                }
            } else if (this.inFPS == 2) {
                for (jj = 0; jj < this.nTaps; ++jj) {
                    rsum += this.inBuffer[inOff + jj * 2] * filter2[jj];
                    qsum += this.inBuffer[inOff + jj * 2 + 1] * filter2[jj];
                }
            } else {
                for (jj = 0; jj < this.nTaps; ++jj) {
                    rsum += this.inBuffer[inOff + jj] * filter2[jj];
                }
            }
            if (this.tuning) {
                float temp1 = (float)((double)rsum * this.rTuneTwiddle - (double)qsum * this.qTuneTwiddle);
                qsum = (float)((double)rsum * this.qTuneTwiddle + (double)qsum * this.rTuneTwiddle);
                rsum = temp1;
                double temp2 = this.rTuneTwiddle * this.rTune - this.qTuneTwiddle * this.qTune;
                this.qTuneTwiddle = this.rTuneTwiddle * this.qTune + this.qTuneTwiddle * this.rTune;
                this.rTuneTwiddle = temp2;
            }
            this.outBuffer[outOff++] = rsum;
            if (this.outFPS != 2) continue;
            this.outBuffer[outOff++] = qsum;
        }
        this.outWriteP += (long)nReps;
    }

    public void setRate(double rate) {
        if (rate <= 0.0) {
            throw new MidasException("Invalid new rate [" + rate + "]");
        }
        this.newRate = rate;
        this.outputFile.setXDelta(1.0 / this.newRate);
        this.inStep = this.outputFile.getXDelta() / this.inputFile.getXDelta();
    }

    public void setTune(double tune) {
        if (this.outFPS != 2) {
            this.M.warning((CharSequence)"TUNE switch ignored for real output");
            this.tuning = false;
        } else {
            this.tuning = true;
            this.rTune = Math.cos(tune * this.outputFile.getXDelta() * (Math.PI * 2));
            this.qTune = Math.sin(tune * this.outputFile.getXDelta() * (Math.PI * 2));
        }
    }
}

