/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.dsp.lib.Morph;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class morph
extends Primitive {
    public static final String operList = "NOOP,MIN,MAX,MEAN,MEDIAN,MMIN,MMAX,OPEN,CLOSE,ANGOPEN,ANGCLOSE";
    private static final int O_NOOP = 0;
    private static final int O_MIN = 1;
    private static final int O_MAX = 2;
    private static final int O_MEAN = 3;
    private static final int O_MEDIAN = 4;
    private static final int O_MMIN = 5;
    private static final int O_MMAX = 6;
    private static final int O_OPEN = 7;
    private static final int O_CLOSE = 8;
    private static final int O_ANGOPEN = 9;
    private static final int O_ANGCLOSE = 10;
    DataFile hi;
    DataFile ho;
    Data dbi;
    Data dbo;
    int oper;
    int width1;
    int width2;
    int width;
    int hwidth;
    int cons;
    int boff;
    int iter;
    int ndata;
    double alpha;
    double[] vt;

    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000,2000", "S#", 0);
        this.hi.open();
        this.oper = this.MA.getSelectionIndex("OPER", operList, 0, -1);
        if (this.MA.getState("ADDR")) {
            double xd = this.hi.getXDelta();
            this.width1 = (int)Math.round(this.MA.getD("WIDTH1") / xd);
            this.width2 = (int)Math.round(this.MA.getD("WIDTH2", this.MA.getD("WIDTH1")) / xd);
        } else {
            this.width1 = this.MA.getL("WIDTH1");
            this.width2 = this.MA.getL("WIDTH2", this.width1);
        }
        this.iter = this.MA.getL("ITER");
        this.alpha = this.MA.getD("ALPHA");
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.open(66);
        if (this.hi.typeClass == 1) {
            this.ndata = (int)this.hi.getSize();
            this.xfer = this.MA.getL("/TL", Math.min(32768, this.ndata));
        } else {
            this.xfer = this.ndata = this.hi.getSubSize();
            this.hi.setDFS(0);
            this.ho.setDFS(0);
        }
        this.width = Math.max(this.width1, this.width2);
        this.hwidth = this.width / 2;
        this.cons = this.xfer < this.ndata ? this.xfer - this.width : -1;
        this.hi.setXferLength(this.xfer);
        this.hi.setConsLength(this.cons);
        this.dbi = this.hi.getDataBuffer(this.xfer, (byte)68);
        this.dbo = this.ho.getDataBuffer(this.xfer, (byte)68);
        this.vt = new double[this.xfer];
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dbi);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        if (this.oper == 0 || this.width1 == 0 && this.width2 == 0) {
            this.ho.write(this.dbi);
            return 0;
        }
        double[] vi = this.dbi.castD(true);
        double[] vo = this.dbo.castD(false);
        switch (this.oper) {
            case 1: {
                Morph.min(vi, vo, n, this.width1);
                break;
            }
            case 2: {
                Morph.max(vi, vo, n, this.width1);
                break;
            }
            case 3: {
                Morph.mean(vi, vo, n, this.width1);
                break;
            }
            case 4: {
                Morph.median(vi, vo, n, this.width1);
                break;
            }
            case 5: {
                Morph.mean(vi, this.vt, n, this.width1);
                Morph.min(this.vt, vo, n, this.width2);
                break;
            }
            case 6: {
                Morph.mean(vi, this.vt, n, this.width1);
                Morph.max(this.vt, vo, n, this.width2);
                break;
            }
            case 7: {
                Morph.min(vi, this.vt, n, this.width1);
                Morph.max(this.vt, vo, n, this.width2);
                break;
            }
            case 8: {
                Morph.max(vi, this.vt, n, this.width1);
                Morph.min(this.vt, vo, n, this.width2);
            }
        }
        this.dbi.uncast(vi, false);
        this.dbo.uncast(vo, true);
        if (this.cons > 0) {
            this.dbo.boff = this.boff * this.dbo.bpe;
            n -= this.boff;
            this.ndata -= this.cons;
            if (this.ndata > 0) {
                n -= this.hwidth;
            }
            this.ho.write(this.dbo, n);
            this.dbo.boff = 0;
            this.boff = this.hwidth;
        } else {
            this.ho.write(this.dbo);
        }
        return 0;
    }

    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }
}

