/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class kaiswind
extends Primitive {
    public static final String typeList = "LowPass,HighPass,BandPass";
    public static final int LOW = 1;
    public static final int HIGH = 2;
    public static final int BAND = 3;
    public static final int MAXTAPS = 131072;
    private DataFile ho;
    private DataFile hi;
    private Data dbw;
    private int type;
    private int ntap;
    private int intap;
    private int maxtaps = 131072;
    boolean debug;
    boolean inref;
    boolean cmplx;
    private double freq1;
    private double freq2;
    private double freq3;
    private double fold;
    private double attndb;
    private double tnbw;
    private double fcntr;
    private double fpass;
    private static final int REAL = 0;
    private static final int IMAG = 1;
    private String taprslt;

    public int open() {
        this.debug = this.MA.getState("/DEBUG");
        if (this.debug) {
            System.out.println("Running kaiswin with db=" + this.attndb + " and ntap=" + this.ntap);
        }
        this.cmplx = this.MA.getState("/CMPLX", false);
        this.intap = this.MA.getL("/NTAPS", this.maxtaps);
        if (this.intap > this.maxtaps) {
            this.M.warning((CharSequence)"Maximum number of taps exceeded. Using default maximum of 131072");
            this.intap = this.maxtaps;
        }
        this.taprslt = this.MA.getU("/TAPRSLT");
        this.type = this.MA.getSelectionIndex("TYPE", typeList, 1);
        if (this.type <= 0) {
            this.M.error("Unknown filter type: " + this.MA.getU("TYPE"));
        }
        this.freq1 = this.MA.getD("FREQ");
        this.freq2 = this.MA.getD("BW");
        this.freq3 = this.MA.getD("TRANS", -1.0);
        if (this.MA.getState("INPUTREF")) {
            this.hi = this.MA.getDataFile(this.MA.getU("INPUTREF"), "1000,2000", "S#,C#", 0);
            this.hi.open();
            this.fold = 0.5 * (1.0 / this.hi.getXDelta());
            this.hi.close();
        } else {
            this.fold = this.MA.getD("FOLD");
            if (this.fold <= 0.0) {
                this.M.error("Must specify folding frequency");
            }
        }
        this.attndb = this.MA.getD("ATTEN", 60.0);
        if (this.type == 3) {
            this.fcntr = this.freq1;
            this.fpass = 0.5 * this.freq2;
        } else {
            this.fcntr = 0.0;
            this.fpass = this.freq1;
        }
        this.tnbw = this.freq3 == -1.0 ? 0.01 * this.fold : this.freq3;
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        if (this.cmplx) {
            this.ho.setFormatMode((byte)67);
            this.dbw = new Data("CF", this.maxtaps);
        } else {
            this.dbw = new Data("SF", this.maxtaps);
        }
        this.ho.setXStart((double)(this.intap - 1) * (-0.25 / this.fold));
        this.ho.setXDelta(0.5 / this.fold);
        this.ho.setSize((double)this.intap);
        this.ho.open(2);
        this.ntap = this.intap != this.maxtaps ? -1 * this.intap : this.intap;
        if (this.debug) {
            System.out.println("intap: " + this.intap);
            System.out.println("ntap: " + this.ntap);
            System.out.println("type: " + this.type);
            System.out.println("freq1: " + this.freq1);
            System.out.println("freq2: " + this.freq2);
            System.out.println("freq3: " + this.freq3);
            System.out.println("attndb: " + this.attndb);
            System.out.println("fcntr: " + this.fcntr);
            System.out.println("fpass: " + this.fpass);
            System.out.println("tnbw: " + this.tnbw);
        }
        this.kaiswin(this.dbw, this.ntap);
        this.ho.setXStart((double)(this.ntap - 1) * (-0.25 / this.fold));
        this.ho.setXDelta(0.5 / this.fold);
        this.ho.setSize((double)this.ntap);
        this.ho.write(this.dbw, this.ntap);
        this.ho.close();
        this.MR.put(this.taprslt, this.ntap);
        return 9;
    }

    private void kaiswin(Data odata, int ntaps) {
        double wcut;
        double fcut;
        float[][] buf = new float[this.maxtaps][2];
        float[] outbuf = odata.castF(false);
        double fsamp = 2.0 * this.fold;
        int mtaps = ntaps;
        if (fsamp == 0.0 || this.tnbw == 0.0) {
            ntaps = 0;
        } else {
            float tmpr8 = (float)((this.attndb - 8.0) / (14.357078426905355 * this.tnbw / fsamp) + 0.5) + 1.0f;
            ntaps = (int)tmpr8;
            if (ntaps > mtaps) {
                ntaps = 0;
            } else if (tmpr8 > 2.1474836E9f) {
                this.M.error("Unreasonable input parameters given, please reconsider.");
            }
        }
        if (mtaps < 0) {
            ntaps = -1 * mtaps;
        }
        if (this.type == 2) {
            if (ntaps % 2 == 0) {
                ++ntaps;
            }
            if (mtaps < 0) {
                ntaps = -1 * mtaps;
            }
        }
        double beta = this.attndb > 50.0 ? 0.1102 * (this.attndb - 8.7) : (this.attndb >= 21.0 && this.attndb <= 50.0 ? 0.5842 * Math.pow(this.attndb - 21.0, 0.4) + 0.07886 * (this.attndb - 21.0) : 0.0);
        double dalpha = 0.5 * ((double)ntaps - 1.0);
        if (ntaps > 0) {
            fcut = this.type == 2 ? (this.fpass - 0.5 * this.tnbw) / fsamp : (this.fpass + 0.5 * this.tnbw) / fsamp;
            wcut = Math.PI * 2 * fcut;
        } else {
            fcut = 0.0;
            wcut = 0.0;
        }
        double bessio_of_beta = this.window_bessio_d(beta);
        if (bessio_of_beta <= 0.0) {
            bessio_of_beta = 1.0E-20;
        }
        if (this.type != 3) {
            this.fcntr = 0.0;
        }
        double strt = -0.5 * (double)(ntaps - 1) - 1.0;
        double lo = Math.PI * 2 * (this.fcntr / fsamp);
        if (this.debug) {
            System.out.println("fsamp: " + fsamp);
            System.out.println("beta: " + beta);
            System.out.println("dalpha: " + dalpha);
            System.out.println("fcut: " + fcut);
            System.out.println("wcut: " + wcut);
            System.out.println("bessio_of_beta: " + bessio_of_beta);
            System.out.println("strt: " + strt);
            System.out.println("lo: " + lo);
            System.out.println("ultimately ntaps: " + ntaps);
        }
        int jj = 0;
        for (int i = 0; i < ntaps; ++i) {
            double dpcos = Math.cos(lo * (strt + (double)(i + 1)));
            double dpsin = Math.sin(lo * (strt + (double)(i + 1)));
            double dresp = this.type == 2 ? this.firwindow_sinc(Math.PI * ((double)i - dalpha)) - 2.0 * fcut * this.firwindow_sinc(wcut * ((double)i - dalpha)) : 2.0 * fcut * this.firwindow_sinc(wcut * ((double)i - dalpha));
            double bess_arg_top = beta * Math.sqrt(1.0 - Math.pow(((double)i - dalpha) / dalpha, 2.0));
            double dwind = (float)(this.window_bessio_d(bess_arg_top) / bessio_of_beta);
            buf[i][0] = (float)(dwind * dresp * dpcos);
            buf[i][1] = (float)(dwind * dresp * dpsin);
            if (this.cmplx) {
                outbuf[jj++] = buf[i][0];
                outbuf[jj++] = buf[i][1];
                continue;
            }
            float scale = 1.0f;
            if (this.type == 3) {
                scale = 2.0f;
            }
            outbuf[i] = buf[i][0] * scale;
        }
        odata.uncast(outbuf, true);
        this.ntap = ntaps;
    }

    private double window_bessio_d(double x) {
        double xi;
        double sde;
        double t = 1.0E-12;
        double y = 0.5 * x;
        double e = 1.0;
        double de = 1.0;
        for (int i = 1; i < 26 && !((e += (sde = (de *= y / (xi = (double)i)) * de)) * t - sde > 0.0); ++i) {
        }
        return e;
    }

    private double firwindow_sinc(double darg) {
        double dnum = Math.sin(darg);
        double dsinc = darg < 1.0E-20 && darg > -1.0E-20 && dnum < 1.0E-20 && dnum > -1.0E-20 ? 1.0 : dnum / darg;
        return dsinc;
    }
}

