/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;

public class firkais
extends Primitive {
    public static final String typeList = "LowPass,HighPass,BandPass";
    public static final int LOW = 1;
    public static final int HIGH = 2;
    public static final int BAND = 3;
    private DataFile ho;
    private Data dbo;
    private int type;
    private int ntap;
    private double freq1;
    private double freq2;
    private double freq3;
    private double freqf;
    private double attn;
    private double delta;
    private float scale;
    private boolean cx;
    private boolean dbg;
    private int maxTaps = 32768;

    public int open() {
        this.type = this.MA.getSelectionIndex("TYPE", typeList, 0);
        this.freqf = this.MA.getD("FOLDING");
        this.freq1 = this.MA.getD("FREQUENCY") / this.freqf;
        this.freq2 = this.MA.getD("BANDWIDTH") / this.freqf;
        this.freq3 = this.MA.getD("TRANSITION", this.freqf * 0.01) / this.freqf;
        this.attn = this.MA.getD("ATTENUATION");
        this.ntap = this.MA.getL("NTAP");
        this.ntap = this.MA.getL("/NTAPS", this.ntap);
        this.cx = this.MA.getState("/CMPLX");
        this.dbg = this.MA.getState("/DEBUG");
        this.scale = this.MA.getF("/SCALE", 1.0f);
        this.delta = 0.5 / this.freqf;
        this.ho = this.MA.getDataFile("OUT", "1000", this.cx ? "CF" : "SF", 0);
        this.ho.setSize((double)this.ntap);
        this.ho.setXDelta(this.delta);
        this.ho.open(2);
        this.dbo = this.ho.getDataBuffer(this.maxTaps * 2, (byte)70);
        float[] fbo = this.dbo.castF(false);
        this.ntap = firkais.generate(this.type, this.freq1, this.freq2, this.freq3, this.attn, fbo, this.ntap, this.dbg);
        if (!this.cx && this.type == 3) {
            this.scale *= 2.0f;
        }
        if (this.cx) {
            int i = 0;
            while (i < this.ntap * 2) {
                int n = i++;
                fbo[n] = fbo[n] * this.scale;
            }
        } else {
            for (int i = 0; i < this.ntap; ++i) {
                fbo[i] = fbo[i + i] * this.scale;
            }
        }
        this.dbo.uncast(fbo, true);
        this.ho.write(this.dbo, this.ntap);
        this.ho.setXStart(-0.5 * (double)(this.ntap - 1) * this.delta);
        this.ho.close();
        this.MR.put(this.MA.getU("/TAPRSLT"), this.ntap);
        return 9;
    }

    public static int generate(int type, double f1, double f2, double f3, double attn, float[] filt, int ntap, boolean dbg) {
        double fcntr = f1;
        double fpass = type == 3 ? f2 * 0.5 : f1;
        double ftnbw = f3;
        double fsamp = 2.0;
        double mtap = (attn - 8.0) / (14.357078426905355 * ftnbw / fsamp);
        if (ntap <= 0) {
            ntap = (int)(mtap + 1.5);
        }
        if (ntap <= 0) {
            return 0;
        }
        double beta = attn > 50.0 ? 0.1102 * (attn - 8.7) : (attn >= 21.0 ? 0.5842 * Math.pow(attn - 21.0, 0.4) + 0.07886 * (attn - 21.0) : 0.0);
        double alpha = 0.5 * (double)(ntap - 1);
        double fcut = type == 2 ? fpass - 0.5 * ftnbw : fpass + 0.5 * ftnbw;
        double wcut = Math.PI * 2 * (fcut /= fsamp);
        double den = firkais.bessel_io(beta);
        if (type != 3) {
            fcntr = 0.0;
        }
        double strt = -0.5 * (double)(ntap - 1);
        double lo = Math.PI * 2 * fcntr / fsamp;
        if (dbg) {
            StringBuilder sb = new StringBuilder(300);
            sb.append("Type    : " + type + " (" + Parser.get((String)typeList, (int)type) + ")\n");
            sb.append("Ntap    : " + ntap + "\n");
            sb.append("Freq1   : " + f1 + "\n");
            sb.append("Freq2   : " + f2 + "\n");
            sb.append("Freq3   : " + f3 + "\n");
            sb.append("Ftnbw   : " + ftnbw + "\n");
            sb.append("Attn    : " + attn + "\n");
            sb.append("Fpass   : " + fpass + "\n");
            sb.append("Beta    : " + beta + "\n");
            sb.append("Alpha   : " + alpha + "\n");
            sb.append("Fcut    : " + fcut + "\n");
            sb.append("Wcut    : " + wcut + "\n");
            sb.append("Den     : " + den + "\n");
            sb.append("Strt    : " + strt + "\n");
            sb.append("Lo      : " + lo + "\n");
            System.out.print(sb);
        }
        for (int i = 0; i < ntap; ++i) {
            double pcos = Math.cos((strt + (double)i) * lo);
            double psin = Math.sin((strt + (double)i) * lo);
            double resp = 2.0 * fcut * firkais.sinc(wcut * ((double)i - alpha));
            if (type == 2) {
                resp = firkais.sinc(Math.PI * ((double)i - alpha)) - resp;
            }
            double factor = Math.sqrt(1.0 - Math.pow(((double)i - alpha) / alpha, 2.0));
            double wind = firkais.bessel_io(beta * factor) / den;
            filt[i + i + 0] = (float)(wind * resp * pcos);
            filt[i + i + 1] = (float)(wind * resp * psin);
        }
        return ntap;
    }

    private static double sinc(double arg) {
        double num = Math.sin(arg);
        if (Math.abs(arg) < 1.0E-20 && Math.abs(num) < 1.0E-20) {
            return 1.0;
        }
        return num / arg;
    }

    private static double bessel_io(double x) {
        double ds = 1.0;
        double d = 0.0;
        double s = 1.0;
        while (!((ds = ds * x * x / ((d += 2.0) * d)) - (s += ds) * 2.0E-9 < 0.0)) {
        }
        return s;
    }
}

