/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.lib;

import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.libm.Fft;

@InternalUseOnly(value="since initial version")
public class FilterFIR {
    private final Midas midas;
    private FilterType type;
    private int ntaps;
    private double freq1;
    private double freq2;
    private double freqF;
    private boolean complex;
    private boolean symmetric;
    private String windowName;
    private double scaleFact;

    public FilterFIR(Midas midas, FilterType type, int ntaps, double freq1, double freq2, double freqF, boolean complex, boolean symmetric, String windowName, double scaleFact) {
        this.midas = midas != null ? midas : Shell.getSharedMidasContext();
        this.type = type;
        this.ntaps = ntaps;
        this.freq1 = freq1;
        this.freq2 = freq2;
        this.freqF = freqF;
        this.complex = complex;
        this.symmetric = symmetric;
        this.windowName = windowName == null ? "NONE" : windowName;
        this.scaleFact = scaleFact;
        this.validate();
    }

    private void validate() {
        if (this.type == null) {
            throw new MidasException("Unknown filter type: null");
        }
        if (this.complex) {
            if (this.freq1 < -this.freqF) {
                throw new MidasException("Transition criteria (freq1 >= -freqF) not met, given freq1=" + this.freq1 + ", freqF=" + this.freqF);
            }
            if (this.freq1 > this.freqF) {
                throw new MidasException("Transition criteria (freq1 <= +freqF) not met, given freq1=" + this.freq1 + ", freqF=" + this.freqF);
            }
        } else {
            if (this.freq1 < 0.0) {
                throw new MidasException("Transition criteria (freq1 >= 0.0) not met, given freq1=" + this.freq1);
            }
            if (this.freq1 > this.freqF) {
                throw new MidasException("Transition criteria (freq1 <= freqF) not met, given freq1=" + this.freq1 + ", freqF=" + this.freqF);
            }
        }
        if (this.type == FilterType.BandPass || this.type == FilterType.StopBand) {
            if (this.freq2 < this.freq1) {
                throw new MidasException("Transition criteria (freq2 >= freq1) not met, given freq1=" + this.freq1 + ", freq2=" + this.freq2);
            }
            if (this.freq2 > this.freqF) {
                throw new MidasException("Transition criteria (freq1 <= freqF) not met, given freq2=" + this.freq2 + ", freqF=" + this.freqF);
            }
        }
    }

    @InternalUseOnly
    public static FilterFIR initBandPass(Midas midas, int ntaps, double cfreq, double bw, double nyquist, int dec, boolean complexOut, boolean complex, boolean symmetric, String windowName, double scaleFact) {
        double fmin;
        double fmax;
        double maxBW;
        if (midas == null) {
            midas = Shell.getSharedMidasContext();
        }
        if (bw > (maxBW = (fmax = nyquist) - (fmin = complexOut ? -nyquist : 0.0)) / (double)dec) {
            midas.warning((CharSequence)"Bandwidth limited to output bandwidth");
            bw = maxBW / (double)dec;
        }
        double freq1 = cfreq - bw / 2.0;
        double freq2 = cfreq + bw / 2.0;
        double freqF = nyquist;
        if (freq1 < fmin) {
            freq1 = fmin;
            freq2 = fmin + bw;
            midas.warning((CharSequence)("Filter adjusted to fit in available input bandwidth " + freq1 + " to " + freq2));
        }
        if (freq2 > fmax) {
            freq1 = fmax - bw;
            freq2 = fmax;
            midas.warning((CharSequence)("Filter adjusted to fit in available input bandwidth " + freq1 + " to " + freq2));
        }
        return new FilterFIR(midas, FilterType.BandPass, ntaps, freq1, freq2, freqF, complex, symmetric, windowName, scaleFact);
    }

    public String toString() {
        return "FilterFIR: FilterType=" + (Object)((Object)this.type) + " NTaps=" + this.ntaps + " Freq1=" + this.freq1 + " Hz Freq2=" + this.freq2 + " Hz FoldingFreq=" + this.freqF + " Hz Complex=" + this.complex + " Symmetric=" + this.symmetric + " WindowName=" + this.windowName + " ScaleFactor=" + this.scaleFact;
    }

    public float[] makeFilter() {
        return this.makeFilter(0);
    }

    public float[] makeFilter(int minLen) {
        int j;
        int i;
        int flags;
        float[] filt;
        int len;
        float[] wind;
        Data dbw;
        block39: {
            int i2;
            int n;
            int bin2;
            int bin1;
            block38: {
                dbw = DataOp.getWindow((String)this.windowName, (int)this.ntaps, (double)(this.scaleFact / (double)this.ntaps), (Midas)this.midas);
                wind = dbw.castF(true);
                int off = this.symmetric ? -2 : 0;
                len = this.symmetric ? this.ntaps * 2 : (this.ntaps + 1) * 2;
                filt = new float[Math.max(minLen, len)];
                double f1 = this.freq1 / this.freqF;
                double f2 = this.freq2 / this.freqF;
                bin1 = ((int)(0.5 * (double)this.ntaps * f1) + 1) * 2;
                if (this.type == FilterType.BandPass || this.type == FilterType.StopBand) {
                    if (f2 == 0.0) {
                        f2 = 1.0;
                    }
                    bin2 = ((int)(0.5 * (double)this.ntaps * f2) + 1) * 2;
                } else {
                    bin2 = this.ntaps + 2;
                }
                bin1 += off;
                bin2 += off;
                while (this.complex && bin1 < 0) {
                    int _bin1 = bin1;
                    int _bin2 = bin2;
                    switch (this.type) {
                        case LowPass: {
                            bin1 = len - _bin1;
                            this.type = FilterType.HighPass;
                            break;
                        }
                        case HighPass: {
                            bin1 = len - _bin1;
                            this.type = FilterType.LowPass;
                            break;
                        }
                        case BandPass: {
                            bin1 = _bin2;
                            bin2 = this.ntaps * 2 + _bin1;
                            this.type = FilterType.StopBand;
                            break;
                        }
                        case StopBand: {
                            bin1 = _bin2;
                            bin2 = this.ntaps * 2 + _bin1;
                            this.type = FilterType.BandPass;
                        }
                    }
                }
                if (bin1 < 0 || bin1 > bin2 || bin2 > len) {
                    throw new MidasException("Can not create " + (Object)((Object)this.type) + " filter for freq1=" + this.freq1 + " Hz freq2=" + this.freq2 + " Hz freqF=" + this.freqF + " Hz.");
                }
                if (!this.complex) break block38;
                flags = 18;
                n = this.ntaps * 2;
                switch (this.type) {
                    case LowPass: {
                        for (i2 = 0; i2 < bin1; i2 += 2) {
                            filt[i2] = 1.0f;
                            filt[n - i2] = 1.0f;
                        }
                        break block39;
                    }
                    case HighPass: {
                        for (i2 = bin1; i2 < bin2; i2 += 2) {
                            filt[i2] = 1.0f;
                            filt[n - i2] = 1.0f;
                        }
                        break block39;
                    }
                    case BandPass: {
                        for (i2 = bin1; i2 < bin2; i2 += 2) {
                            filt[i2] = 1.0f;
                        }
                        break block39;
                    }
                    case StopBand: {
                        for (i2 = 0; i2 < bin1; i2 += 2) {
                            filt[i2] = 1.0f;
                        }
                        for (i2 = bin2; i2 < n; i2 += 2) {
                            filt[i2] = 1.0f;
                        }
                        break;
                    }
                }
                break block39;
            }
            flags = 81;
            n = this.ntaps + 1;
            switch (this.type) {
                case LowPass: {
                    for (i2 = 0; i2 < bin1; i2 += 2) {
                        filt[i2] = 1.0f;
                    }
                    break;
                }
                case HighPass: {
                    for (i2 = bin1; i2 < bin2; i2 += 2) {
                        filt[i2] = 1.0f;
                    }
                    break;
                }
                case BandPass: {
                    for (i2 = bin1; i2 < bin2; i2 += 2) {
                        filt[i2] = 1.0f;
                    }
                    break;
                }
                case StopBand: {
                    for (i2 = 0; i2 < bin1; i2 += 2) {
                        filt[i2] = 1.0f;
                    }
                    for (i2 = bin2; i2 < n; i2 += 2) {
                        filt[i2] = 1.0f;
                    }
                    break;
                }
            }
        }
        for (i = 2; i < len; i += 4) {
            filt[i] = -filt[i];
        }
        Fft.process((Object)filt, (int)this.ntaps, (int)flags);
        if (this.complex) {
            j = 0;
            for (i = 0; i < this.ntaps; ++i) {
                int n = j++;
                filt[n] = filt[n] * wind[i];
                int n2 = j++;
                filt[n2] = filt[n2] * wind[i];
            }
        } else {
            j = 0;
            for (i = 0; i < this.ntaps; ++i) {
                int n = j++;
                filt[n] = filt[n] * wind[i];
            }
        }
        dbw.uncast(wind, false);
        return filt;
    }

    public FilterType getFilterType() {
        return this.type;
    }

    public int getNTaps() {
        return this.ntaps;
    }

    public double getFreq1() {
        return this.freq1;
    }

    public double getFreq2() {
        return this.freq2;
    }

    public double getFoldingFreq() {
        return this.freqF;
    }

    public boolean getComplex() {
        return this.complex;
    }

    public boolean getSymmetric() {
        return this.symmetric;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public double getScaleFactor() {
        return this.scaleFact;
    }

    public void setFilterType(FilterType t) {
        this.type = t;
    }

    public void setNTaps(int n) {
        this.ntaps = n;
    }

    public void setFreq1(double f) {
        this.freq1 = f;
    }

    public void setFreq2(double f) {
        this.freq2 = f;
    }

    public void setFoldingFreq(double f) {
        this.freqF = f;
    }

    public void setComplex(boolean cx) {
        this.complex = cx;
    }

    public void setSymmetric(boolean s) {
        this.symmetric = s;
    }

    public void setWindowName(String wn) {
        this.windowName = wn == null ? "NONE" : wn;
    }

    public void setScaleFactor(double sf) {
        this.scaleFact = sf;
    }

    public double getBandwidth() {
        switch (this.type) {
            case LowPass: {
                return Double.NaN;
            }
            case HighPass: {
                return Double.NaN;
            }
            case BandPass: {
                return (this.freq2 - this.freq1) / 2.0;
            }
            case StopBand: {
                return (this.freq2 - this.freq1) / 2.0;
            }
        }
        throw new AssertionError((Object)("Unknown type " + (Object)((Object)this.type)));
    }

    public double getCenterFreq() {
        return (this.freq1 + this.freq2) / 2.0;
    }

    public double getDelay(double xdelta) {
        return (double)(this.ntaps - 2) / 2.0 * xdelta;
    }

    public void setFreq(double freq1, double freq2, double freqF) {
        this.freq1 = freq1;
        this.freq2 = freq2;
        this.freqF = freqF;
        this.validate();
    }

    public static enum FilterType {
        LowPass,
        HighPass,
        BandPass,
        StopBand;

    }
}

