/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.lib;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.MPULib;

public class Demod
extends MPULib {
    private int mode;
    private int alg;
    private int pass;
    private double fullScale;
    private boolean lut;
    private boolean diff;
    private boolean quad;
    public static final String modeList = "AM,FM,PM,LSB,USB,CW,PSK,QPSK";
    public static final int AM = 1;
    public static final int FM = 2;
    public static final int PM = 3;
    public static final int LSB = 4;
    public static final int USB = 5;
    public static final int CW = 6;
    public static final int PSK = 7;
    public static final int QPSK = 8;
    public static final String algList = "STD,LUT";
    public static final int STD = 1;
    public static final int LUT = 2;
    public static final String keyList = "L:MODULATION,L:ALGORITHM,D:FULLSCALE";
    private float valueLast;
    private static final int DB = 16;
    private static final int QB = 5;
    private static final int TB = 6;
    private static final int LB = 10;
    private static final int QW = 32;
    private static final int TW = 64;
    private static final int LW = 1024;
    private static final int tmask = 63;
    private static final int lmask = 1023;
    private static final int umask = 64512;
    private int[] lut0;
    private int[] lut1;
    private int[] lut2;
    private int[] lut3;
    private int valueLastLUT = 0;
    private short[] iut0;
    private short[] iut1;
    private short[] iut2;
    private short[] iut3;
    private int valueLastFPGA = 0;
    private static final double scaleAMP = 2.147483648E9;
    private static final double scaleLUT = 1.073741824E9;

    public void set(String key, Data value) {
        if (key.equals("MODULATION")) {
            this.mode = value.toL();
            this.diff = this.mode == 2;
            boolean bl = this.quad = this.mode == 2 || this.mode == 3;
            if (this.lut) {
                this.initLUT();
            }
        } else if (key.equals("FULLSCALE")) {
            this.fullScale = value.toD();
        } else if (key.equals("ALGORITHM")) {
            this.alg = value.toL();
            boolean bl = this.lut = this.alg == 2;
            if (this.lut) {
                this.initLUT();
            }
        } else {
            super.set(key, value);
        }
    }

    public Data get(String key, byte type) {
        if (key.equals("KEYS")) {
            return new Data(keyList);
        }
        if (key.equals("MODULATION")) {
            return new Data(this.mode);
        }
        if (key.equals("MODULATIONS")) {
            return new Data(modeList);
        }
        if (key.equals("FULLSCALE")) {
            return new Data(this.fullScale);
        }
        if (key.equals("ALGORITHM")) {
            return new Data(this.alg);
        }
        if (key.equals("ALGORITHMS")) {
            return new Data(algList);
        }
        return super.get(key, type);
    }

    public int process(byte[] a, int n, byte[] b, int nb) {
        if (this.lut) {
            short[] ai = Convert.castI((byte[])a, (boolean)true);
            short[] bi = Convert.castI((byte[])b, (boolean)false);
            n = this.processLUT(ai, bi, n);
            Convert.uncast((short[])ai, (byte[])a, (boolean)false);
            Convert.uncast((short[])bi, (byte[])b, (boolean)true);
        } else {
            float[] af = Convert.castF((byte[])a, (boolean)true);
            float[] bf = Convert.castF((byte[])b, (boolean)false);
            n = this.processSTD(af, bf, n);
            Convert.uncast((float[])af, (byte[])a, (boolean)false);
            Convert.uncast((float[])bf, (byte[])b, (boolean)true);
        }
        ++this.pass;
        return n;
    }

    public int processSTD(float[] a, float[] b, int n) {
        switch (this.mode) {
            case 1: {
                this.processAM(a, b, n);
                break;
            }
            case 2: {
                this.processFM(a, b, n);
                break;
            }
            case 3: {
                this.processPM(a, b, n);
                break;
            }
            case 7: {
                this.processPSK(a, b, n);
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    private void processAM(float[] fbi, float[] fbo, int n) {
        int i = 0;
        int j = 0;
        while (i < n) {
            float fr = fbi[j++];
            float fi = fbi[j++];
            fbo[i++] = (float)Math.sqrt(fr * fr + fi * fi);
        }
    }

    private void processFM(float[] fbi, float[] fbo, int n) {
        float scale = (float)(this.fullScale / (Math.PI * 2));
        float bound2 = (float)Math.PI * 2;
        float bound = bound2 / 2.0f;
        int i = 0;
        int j = 0;
        while (i < n) {
            float fr = fbi[j++];
            int n2 = j++;
            float fi = fbi[n2];
            float value = this.getPhase(fr, fi);
            float fp = value - this.valueLast;
            if (fp >= bound) {
                fp -= bound2;
            } else if (fp < -bound) {
                fp += bound2;
            }
            fbo[i++] = fp * scale;
            this.valueLast = value;
        }
        if (this.pass == 0) {
            fbo[0] = fbo[1];
        }
    }

    private void processPM(float[] fbi, float[] fbo, int n) {
        float scale = (float)(this.fullScale / (Math.PI * 2));
        int i = 0;
        int j = 0;
        while (i < n) {
            float fr = fbi[j++];
            float fi = fbi[j++];
            fbo[i++] = scale * this.getPhase(fr, fi);
        }
    }

    private void processPSK(float[] fbi, float[] fbo, int n) {
    }

    private float getPhase(float dr, float di) {
        return (float)Math.atan2(di, dr);
    }

    public int getLUTframe() {
        return 64;
    }

    public int processLUT(short[] ibi, short[] ibo, int n) {
        int j = 0;
        int i = 0;
        while (i < n) {
            short ar = ibi[j++];
            short ai = ibi[j++];
            int k = (ai & 0xFC00) >> 4 | (ar & 0xFC00) >> 10;
            int dr = ar & 0x3FF;
            int di = ai & 0x3FF;
            int v = this.lut0[k] + dr * this.lut1[k] + di * this.lut2[k];
            ibo[i++] = (short)(this.diff ? v - this.valueLastLUT : (v >>= 15));
            this.valueLastLUT = v;
        }
        if (this.diff && this.pass == 0) {
            ibo[0] = ibo[1];
        }
        return n;
    }

    private void initLUT() {
        int k = 0;
        double h = 0.5;
        this.lut0 = new int[4096];
        this.lut1 = new int[4096];
        this.lut2 = new int[4096];
        this.lut3 = new int[4096];
        for (int j = -32; j < 32; ++j) {
            for (int i = -32; i < 32; ++i) {
                k = i & 0x3F | (j & 0x3F) << 6;
                this.lut0[k] = this.lutval((double)j + h, (double)i + h);
                this.lut1[k] = this.lutval((double)j + h, i + 1) - this.lutval((double)j + h, i + 0);
                this.lut2[k] = this.lutval(j + 1, (double)i + h) - this.lutval(j + 0, (double)i + h);
                int n = k;
                this.lut1[n] = this.lut1[n] << 1;
                int n2 = k;
                this.lut1[n2] = this.lut1[n2] >> 1;
                int n3 = k;
                this.lut2[n3] = this.lut2[n3] << 1;
                int n4 = k;
                this.lut2[n4] = this.lut2[n4] >> 1;
                this.lut3[k] = this.lut0[k];
                int n5 = k;
                this.lut0[n5] = this.lut0[n5] - (this.lut1[k] / 2 + this.lut2[k] / 2);
                int n6 = k;
                this.lut1[n6] = this.lut1[n6] >> 10;
                int n7 = k;
                this.lut2[n7] = this.lut2[n7] >> 10;
            }
        }
    }

    public int processFPGA(short[] ibi, short[] ibo, int n) {
        int j = 0;
        int i = 0;
        while (i < n) {
            int qa;
            short bi;
            short br;
            short ar = ibi[j++];
            short ai = ibi[j++];
            if (ar > 0) {
                if (ai > 0) {
                    br = ar;
                    bi = ai;
                    qa = 0;
                } else {
                    br = -ai;
                    bi = ar;
                    qa = 49152;
                }
            } else if (ai > 0) {
                br = ai;
                bi = -ar;
                qa = 16384;
            } else {
                br = -ar;
                bi = -ai;
                qa = 32768;
            }
            int k = (bi & 0xFC00) >> 5 | (br & 0xFC00) >> 10;
            int dr = br & 0x3FF;
            int di = bi & 0x3FF;
            int v = this.iut0[k] + (dr * this.iut1[k] >> 10) + (di * this.iut2[k] >> 10);
            v = this.quad ? qa | v >> 1 : (v <<= 1);
            int vv = v;
            if (this.diff) {
                vv -= this.valueLastFPGA;
            }
            ibo[i++] = (short)vv;
            this.valueLastFPGA = v;
        }
        if (this.diff && this.pass == 0) {
            ibo[0] = ibo[1];
        }
        return n;
    }

    private void initFPGA() {
        double h = 0.5;
        this.iut0 = new short[1024];
        this.iut1 = new short[1024];
        this.iut2 = new short[1024];
        this.iut3 = new short[1024];
        for (int j = 0; j < 32; ++j) {
            for (int i = 0; i < 32; ++i) {
                int k = i & 0x3F | (j & 0x3F) << 5;
                int i0 = this.lutval((double)j + h, (double)i + h);
                int i1 = this.lutval((double)j + h, i + 1) - this.lutval((double)j + h, i + 0);
                int i2 = this.lutval(j + 1, (double)i + h) - this.lutval(j + 0, (double)i + h);
                int i3 = this.lutamp((double)j + h, (double)i + h);
                i1 <<= 1;
                i2 <<= 1;
                int s = this.quad ? 14 : 16;
                this.iut0[k] = (short)((i0 -= (i1 >>= 1) / 2 + (i2 >>= 1) / 2) >> s);
                this.iut1[k] = (short)(i1 >> s);
                this.iut2[k] = (short)(i2 >> s);
                this.iut3[k] = (short)(i3 >> 16);
            }
        }
    }

    private int lutval(double imag, double real) {
        double value = 0.0;
        if (imag == 0.0 && real == 0.0) {
            return 0;
        }
        switch (this.mode) {
            case 1: {
                double ai = imag / 32.0;
                double ar = real / 32.0;
                value = Math.sqrt(ar * ar + ai * ai);
                break;
            }
            case 2: 
            case 3: {
                double p = Math.atan2(imag, real);
                value = p / Math.PI;
            }
        }
        return (int)(value * 1.073741824E9);
    }

    private int lutamp(double imag, double real) {
        double ai = imag / 32.0;
        double ar = real / 32.0;
        double value = Math.sqrt(ar * ar + ai * ai);
        return (int)Math.min(2.147483647E9, value * 2.147483648E9);
    }

    public short getLUTentry(int tn, int index) {
        short[] tab = tn == 1 ? this.iut1 : (tn == 2 ? this.iut2 : (tn == 3 ? this.iut3 : this.iut0));
        return tab[index];
    }

    public boolean isDiff() {
        return this.diff;
    }

    public boolean isQuad() {
        return this.quad;
    }
}

