/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ArchSFN;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.VRTPacket;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class sinkice
extends Primitive {
    private Data data;
    private DataFile hi;
    private DataFile ho;
    private PacketHandler pkh;
    private ICEPacket opkh;
    private ICEPacket ipkh;
    private VRTPacket vpkh;
    private SDDSPacket spkh;
    private NetIO nio = new NetIO(true);
    private ArchSFN asfn;
    private DevIce.DmaMap map;
    private MDevIce pic;
    private boolean rt;
    private boolean wrap;
    private boolean skip;
    private boolean net;
    private boolean ram;
    private boolean inputIsICE;
    private boolean fromHdr;
    private boolean swap2;
    private boolean swap4;
    private boolean needContext;
    private double tdelta;
    private double tstart;
    private double dout;
    private double osize;
    private double maxout;
    private double outRTF;
    private double timeRTF;
    private double tcur;
    private double flush;
    private double tflush;
    private int sock = 0;
    private int sink;
    private int bxfer;
    private int hxfer;
    private int cxfer;
    private int pt;
    private int sid;
    private int archsf;
    private int preoff;
    private int tc;
    private int ctx;
    private long pdata = 0L;
    private long offset = 0L;
    private Time time;
    private String drep;
    private byte[] prenet;
    public static String ptList = "NONE,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    private static int ICE = 1;
    private static int SDDS = 2;
    private static int VRT = 3;
    private static int VRTL = 4;
    private static int VRTW = 5;
    private static int VRTX = 6;
    private static int VRTD = 7;
    public static String pkthdrList = "Strip,Copy,Attach,Detach";
    private static int STRIP = 1;
    private static int COPY = 2;
    private static int ATTACH = 3;
    private static int DETACH = 4;
    public static String sinkList = "Net,File,RtFile,DevIce,PktFile,UdpFile,EthFile";
    private static int NET = 1;
    private static int FILE = 2;
    private static int RTFILE = 3;
    private static int DEVICE = 4;
    private static int PKTF = 5;
    private static int UDPF = 6;
    private static int ETHF = 7;
    public static String tcList = "Off,CPU";
    private static int TC_OFF = 1;
    private static int TC_CPU = 2;
    private int lossy;
    private int loss;
    private int lcnt;

    public int open() {
        int n;
        this.sid = this.MA.getL("/SID", 0);
        this.lossy = this.MA.getL("/LOSSY");
        this.wrap = this.MA.getState("/WRAP");
        this.rt = this.MA.getState("/RT");
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.maxout = this.MA.getD("/MAXOUT");
        this.flush = this.MA.getD("/FLUSH");
        boolean bl = this.MA.getS("IN").startsWith("_");
        if (bl) {
            this.wrap = false;
            this.archsf = 0;
        }
        if (this.archsf != 0) {
            if (this.archsf == 1) {
                this.archsf = -1;
            }
            String string = this.MA.getCS("IN");
            this.asfn = new ArchSFN((Object)this, string, this.archsf);
            this.asfn.setTL(this.MA.getL("/ARCHTL", 262144));
            this.asfn.setTop(this.MA.getD("/ARCHTOP"));
            this.asfn.setDur(this.MA.getD("/ARCHDUR"));
            this.openNextFile(true);
            this.osize = this.MA.getD("/ARCHDUR") / this.hi.getXDelta();
            if (this.osize <= 0.0) {
                this.osize = this.hi.getSize();
            }
        } else {
            this.hi = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
            this.hi.open();
            this.osize = this.hi.getSize();
        }
        this.opkh = (ICEPacket)this.hi.getPacketHandler();
        this.fromHdr = this.inputIsICE = this.opkh != null;
        this.time = this.hi.getTime();
        if (this.time.getWSec() == 0.0) {
            this.time.fromCurrent();
        }
        double d = this.time.getWSec();
        double d2 = this.time.getFSec();
        this.pt = this.MA.getState("/SDDS") ? SDDS : ICE;
        this.pt = this.MA.getChoice("/PT", ptList, this.pt + 1) - 1;
        this.drep = this.MA.getS("/REP", this.hi.getDataRep());
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setDataRep(this.drep);
        this.ram = this.ho.getURL().startsWith("ramd:");
        this.net = this.ho.getURL().startsWith("udp:");
        this.sink = this.MA.getSelectionIndex("/SINK", sinkList, this.net ? NET : FILE);
        this.bxfer = this.MA.getL("/PKTLEN", 1024);
        if (this.net) {
            this.bxfer = Math.min(this.bxfer, 8192);
        }
        this.xfer = this.MA.getL("/TL", (int)((double)this.bxfer / this.hi.dbpe));
        this.bxfer = (int)((double)this.xfer * this.hi.dbpe);
        this.ctx = this.MA.getL("CTX", 1);
        if (this.pt == ICE) {
            this.ipkh = new ICEPacket();
            this.pkh = this.ipkh;
            this.ipkh.setFormat(this.hi.getFormat());
            this.ipkh.setSize(this.xfer);
            this.ipkh.setTC(1, 1, 0.0, d, d2);
            this.hxfer = 64;
        } else if (this.pt == SDDS) {
            this.spkh = new SDDSPacket();
            this.pkh = this.spkh;
            this.spkh.setFormat(this.hi.getFormat());
            this.spkh.setTC(1, 0.0, d, d2);
            this.swap2 = this.hi.bps == 2;
            this.hxfer = 56;
            this.bxfer = 1024;
        } else if (this.pt >= VRT && this.pt <= VRTD) {
            this.vpkh = new VRTPacket(this.hi.getFormat(), this.MA.getS("/PT"));
            this.pkh = this.vpkh;
            this.vpkh.setSID(this.sid);
            this.vpkh.setBytes(this.bxfer);
            this.vpkh.setTC(d, d2);
            this.hxfer = this.vpkh.getHeaderLength();
            n = (int)(1.0 / this.hi.getDelta());
            int n2 = this.MA.getL("/FREQ", 0);
            int n3 = this.MA.getL("/GAIN", 0);
            this.vpkh.createContextFor(this.ctx, n, n2, n3);
            this.needContext = this.ctx > 0;
        }
        this.cxfer = this.bxfer;
        n = this.MA.getL("/BITS", 0);
        if (this.vpkh != null && n > 0) {
            this.vpkh.setBits(n);
            this.cxfer = this.bxfer / this.hi.bps * n / 8;
            this.vpkh.setBytes(this.cxfer);
        }
        if (this.sink == NET) {
            this.sock = this.nio.nioOpen(this.ho.getURL(), 0, NetIO.OUTPUT | NetIO.UDP);
            if (this.sock <= 0) {
                this.M.error("Could not open ICE formatted network stream URL=" + this.ho.getURL());
            }
            this.pdata = this.nio.nioAlloc(this.bxfer + 64);
        } else if (this.sink >= PKTF) {
            this.genprenet();
            this.pdata = this.nio.nioAlloc(this.bxfer + 64);
            this.ho.setSize(this.osize);
            this.ho.open();
        } else if (this.sink == RTFILE && this.ram) {
            this.ho.open(3);
            this.osize = this.ho.getSize();
            this.ho.setOutput(false);
            this.pic = new MDevIce(this.MA, "ICEPIC,DEVNO=0,IOM=NONE,PM=NONE");
            if (this.pic.open() <= 0) {
                this.M.error("Problem opening PIC device");
            }
            this.map = this.pic.mapFile(this.ho);
            if (this.map == null) {
                this.M.error("Problem mapping DMA memory");
            }
        } else {
            this.ho.setSize(this.osize);
            if (this.pt == ICE && this.inputIsICE) {
                this.ipkh = this.opkh;
                this.pkh = this.ipkh;
            } else if (this.pt > 0) {
                this.ho.setPacketHandler(this.pkh);
            }
            this.ho.open();
        }
        this.data = this.hi.getDataBuffer(this.xfer);
        this.tdelta = this.hi.getDelta();
        this.dout = 0.0;
        this.tstart = 0.0;
        if (this.rt && this.tdelta >= 0.1) {
            this.M.warning((CharSequence)"Realtime with dt>0.1 ?");
        }
        this.tcur = Time.current();
        if (this.sink == RTFILE) {
            this.updateRTF(0);
        }
        return 0;
    }

    public int process() {
        int n;
        if (this.rt || this.flush > 0.0) {
            this.tcur = Time.current();
        }
        if (this.rt) {
            if (this.tstart == 0.0 && this.hi.avail() < (double)this.xfer) {
                return -1;
            }
            if (this.tstart == 0.0) {
                this.tstart = this.tcur;
            }
            if (this.tcur < this.tstart + this.dout * this.tdelta) {
                return -1;
            }
        }
        if (this.needContext) {
            n = this.vpkh.ctx2pkt(this.pdata);
            if (this.sink == NET) {
                this.nio.nioSend(this.sock, 0, this.pdata, n, 0);
            }
            if (this.sink == PKTF) {
                this.ho.write(this.pdata, 0, n);
            }
            this.needContext = false;
        }
        n = this.hi.read(this.data);
        int n2 = (int)((double)n * this.ho.dbpe);
        if (n == this.xfer) {
            if (this.pt == ICE && this.fromHdr) {
                this.ipkh.setTC(this.opkh);
            }
            if (this.pt == ICE && !this.fromHdr) {
                this.ipkh.setTC(0, 0, 0.0, this.time.getWSec(), this.time.getFSec());
            }
            if (this.pt >= VRT && this.pt <= VRTD) {
                this.vpkh.setTC(this.time.getWSec(), this.time.getFSec());
            }
            if (this.swap2) {
                Convert.swap2((byte[])this.data.buf, (int)0, (int)(n2 >> 1));
            }
            if (this.lossy <= 0 || !this.simdrop()) {
                if (this.sink == NET) {
                    for (int i = 0; i < n2; i += this.bxfer) {
                        if (this.pt == ICE) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.pdata, (int)0, (int)this.hxfer);
                            Native.ja2p((Object)this.data.buf, (int)i, (long)this.pdata, (int)this.hxfer, (int)this.bxfer);
                            this.nio.nioSend(this.sock, 0, this.pdata, this.hxfer + this.bxfer, 0);
                            this.ipkh.upCount();
                            continue;
                        }
                        if (this.pt == SDDS) {
                            Native.ja2p((Object)this.spkh.buf, (int)8, (long)this.pdata, (int)0, (int)this.hxfer);
                            Native.ja2p((Object)this.data.buf, (int)i, (long)this.pdata, (int)this.hxfer, (int)this.bxfer);
                            this.nio.nioSend(this.sock, 0, this.pdata, this.hxfer + this.bxfer, 0);
                            this.spkh.upCount();
                            continue;
                        }
                        if (this.pt < VRT || this.pt > VRTD) continue;
                        int n3 = this.vpkh.buf2pkt(this.data.buf, i, this.pdata, this.bxfer);
                        this.nio.nioSend(this.sock, 0, this.pdata, n3, 0);
                        this.vpkh.upCount();
                    }
                } else if (this.sink >= PKTF) {
                    for (int i = 0; i < n2; i += this.bxfer) {
                        this.ho.write(this.prenet, this.preoff, 48 - this.preoff);
                        if (this.pt == ICE) {
                            this.ho.write(this.ipkh.buf, 0, this.hxfer);
                            this.ho.write(this.data.buf, i, this.bxfer);
                            this.ipkh.upCount();
                            continue;
                        }
                        if (this.pt == SDDS) {
                            this.ho.write(this.spkh.buf, 8, this.hxfer);
                            this.ho.write(this.data.buf, i, this.bxfer);
                            this.spkh.upCount();
                            continue;
                        }
                        if (this.pt < VRT || this.pt > VRTD) continue;
                        int n4 = this.vpkh.buf2pkt(this.data.buf, i, this.pdata, this.bxfer);
                        this.ho.write(this.pdata, 0, n4);
                        this.vpkh.upCount();
                    }
                } else if (this.sink == RTFILE && this.ram) {
                    long l = this.map.getVirtualAddress(this.offset, n2);
                    Native.ja2p((Object)this.data.buf, (int)0, (long)l, (int)0, (int)n2);
                    this.offset += (long)n2;
                    if (this.offset >= this.map.bytes) {
                        this.offset = 0L;
                    }
                } else {
                    this.ho.write(this.data);
                    if (this.sink == RTFILE) {
                        this.updateRTF(this.bxfer);
                    }
                }
            }
            if (this.sink != NET && this.sink < PKTF) {
                if (this.pt == ICE && !this.fromHdr) {
                    this.ipkh.upCount();
                }
                if (this.pt == SDDS) {
                    this.spkh.upCount();
                }
                if (this.pt == VRT) {
                    this.vpkh.upCount();
                }
            }
            if (this.maxout > 0.0 && this.ho.seek() >= this.maxout) {
                if (this.sink == RTFILE) {
                    this.ho.seek(0.0);
                } else {
                    return 9;
                }
            }
            this.time.addSec((double)this.xfer * this.tdelta);
            this.dout += (double)n;
        } else if (n > 0) {
            this.M.warning((CharSequence)("Partial packet of " + n + " elements not output"));
        } else {
            if (n == 0) {
                return -1;
            }
            if (this.archsf == 0 || !this.openNextFile(false)) {
                if (this.wrap && this.hi.isFile()) {
                    this.hi.seek(0.0);
                } else {
                    return 9;
                }
            }
        }
        if (this.flush > 0.0 && this.tcur - this.tflush > this.flush) {
            this.ho.flush();
            this.tflush = this.tcur;
        }
        return 0;
    }

    public int close() {
        if (this.net) {
            this.nio.nioClose(this.sock);
        }
        if (this.pdata != 0L) {
            this.nio.nioFree(this.pdata);
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.hi.close();
        this.ho.close();
        return 0;
    }

    private boolean simdrop() {
        if (this.lossy <= 0) {
            return false;
        }
        if (++this.lcnt > 100) {
            if (++this.loss > this.lossy) {
                this.loss = 1;
            }
            this.lcnt = 1;
        }
        return this.lcnt <= this.loss;
    }

    public void setArchTop(double d) {
        if (this.archsf != 0 && d >= 0.0) {
            this.asfn.setTop(d);
            this.openNextFile(true);
        }
    }

    public void setArchDur(double d) {
        if (this.archsf != 0 && d >= 0.0) {
            this.asfn.setDur(d);
        }
    }

    private boolean openNextFile(boolean bl) {
        if (this.hi != null && this.hi.isOpen()) {
            this.hi.close();
        }
        int n = bl ? this.asfn.getIndex() : this.asfn.nextIndex();
        String string = this.asfn.getSFN(n);
        this.hi = new DataFile((MidasReference)this, (Object)string, "", "", 0);
        this.hi.open(128);
        if (!this.hi.isOpen) {
            return false;
        }
        return !this.asfn.isTop();
    }

    private void updateRTF(int n) {
        boolean bl;
        boolean bl2 = bl = n == 0;
        if (bl) {
            this.timeRTF = this.tcur;
        } else if (this.tcur - this.timeRTF < 0.05) {
            return;
        }
        this.timeRTF = this.tcur;
        this.outRTF += (double)n;
        this.ho.setInByte(this.outRTF);
        if (bl) {
            this.ho.setSize(this.maxout);
        }
        this.ho.update();
    }

    private void genprenet() {
        this.prenet = new byte[48];
        int n = this.MA.getL("/SRCPORT", 7000);
        int n2 = this.MA.getL("/DSTPORT", 7000);
        int n3 = this.MA.getL("/SRCADDR", -1062731775);
        int n4 = this.MA.getL("/DSTADDR", -536870911);
        int n5 = 8 + this.hxfer + this.cxfer;
        int n6 = 0;
        int n7 = 20 + n5;
        int n8 = 0;
        long l = 0x1CE000000000L | (long)n3 & 0xFFFFFFFFL;
        long l2 = 0x1005E000000L | (long)n4 & 0x7FFFFFL;
        Convert.packX((byte[])this.prenet, (int)0, (long)0xD55555555555L);
        Convert.packX((byte[])this.prenet, (int)6, (long)(l2 << 16), (byte)73);
        Convert.packX((byte[])this.prenet, (int)12, (long)(l << 16), (byte)73);
        Convert.packI((byte[])this.prenet, (int)18, (short)8);
        Convert.packL((byte[])this.prenet, (int)20, (int)(0x45000000 | n7), (byte)73);
        Convert.packL((byte[])this.prenet, (int)24, (int)32768, (byte)73);
        Convert.packL((byte[])this.prenet, (int)28, (int)(0x20110000 | n8), (byte)73);
        Convert.packL((byte[])this.prenet, (int)32, (int)n3, (byte)73);
        Convert.packL((byte[])this.prenet, (int)36, (int)n4, (byte)73);
        Convert.packL((byte[])this.prenet, (int)40, (int)(n2 << 16 | n), (byte)73);
        Convert.packL((byte[])this.prenet, (int)44, (int)(n5 << 16 | n6), (byte)73);
        this.preoff = this.sink == ETHF ? 4 : (this.sink == UDPF ? 40 : 48);
    }
}

