/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.dsp.lib.FilterFIR;
import nxm.dsp.prim.firkais;
import nxm.ice.lib.FileIO;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Waveform;

public final class icewave
extends Primitive {
    private int shape;
    private int throttle;
    private int cur = 0;
    private int tcur = 0;
    private int olut = 0;
    private int nlut = 0;
    private int hlut = 0;
    private int mode;
    private int wmode;
    private int spb = 1;
    private int lrs;
    private int lrsx;
    private int lrsy;
    private int seed = 123456;
    private int seedx = 123456;
    private int seedy = 654321;
    private int lrsp;
    private int ntap = 0;
    private int nfft = 0;
    private int fb = 0;
    private int nbins = 0;
    private int nrpt;
    private int nper;
    private int mper;
    private int ndone = 0;
    private int ovsr = 1;
    private int itag = 0;
    private double size;
    private double amp;
    private double freq;
    private double dfreq;
    private double freq1;
    private double freq2;
    private double chirp;
    private double poff;
    private double var;
    private double sdev;
    private double delta;
    private double tstart;
    private double rate;
    private double gain;
    private double baud;
    private double phase;
    private double phase1;
    private double phase2;
    private double timer;
    private double sweep = 0.0;
    private String form;
    private DataFile ho;
    private DataFile hf;
    private float[] tbuf;
    private float[] rtap;
    private byte[] bbuf;
    private boolean wrap;
    private boolean filter;
    private boolean lut;
    private boolean dfs;
    private boolean stats;
    private boolean iqoff;
    private boolean fsk;
    private boolean fram;
    private boolean scrambler;
    private byte type;
    private float midx = 1.0f;
    private float stag;
    static final byte _JINT = 74;
    static final int LRSPM = 0x2000023;
    public static final String shapeList = "Sine,Cosine,Square,Triangle,SawTooth,Pulse,Constant,Zero,White,LRS,Ramp,TRamp,Notch,TwoTone,MixLS,MuxLS,MixNS,NFloor,CW,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,8PSK,16PSK,16APSK,32APSK,64APSK,16CQAM,64CQAM,256CQAM,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM";
    public static final int SIN = 1;
    public static final int COS = 2;
    public static final int SQU = 3;
    public static final int TRI = 4;
    public static final int SAW = 5;
    public static final int PUL = 6;
    public static final int CON = 7;
    public static final int ZER = 8;
    public static final int WHI = 9;
    public static final int LRS = 10;
    public static final int RAMP = 11;
    public static final int TRAM = 12;
    public static final int NOTCH = 13;
    public static final int TTONE = 14;
    public static final int MIXLS = 15;
    public static final int MUXLS = 16;
    public static final int MIXNS = 17;
    public static final int NFLR = 18;
    public static final int CW = 19;
    public static final int FSK = 20;
    public static final int FSK4 = 21;
    public static final int BPSK = 22;
    public static final int QPSK = 23;
    public static final int OQPSK = 24;
    public static final int QPSK14 = 25;
    public static final int QPSK34 = 26;
    public static final int PSK8 = 27;
    public static final int PSK16 = 28;
    public static final int APSK16 = 29;
    public static final int APSK32 = 30;
    public static final int APSK64 = 31;
    public static final int CQAM16 = 32;
    public static final int CQAM64 = 33;
    public static final int CQAM256 = 34;
    public static final int QAM8 = 35;
    public static final int QAM16 = 36;
    public static final int QAM32 = 37;
    public static final int QAM64 = 38;
    public static final int QAM128 = 39;
    public static final int QAM256 = 40;
    public static final int QAM512 = 41;
    public static final int QAM1024 = 42;
    public static final String throttleList = "RealTime,Full,Block";
    private static final int REALTIME = 1;
    private static final int FULL = 2;
    private static final int BLOCK = 3;
    private Fft fft;
    private Fft ifft;
    private float[] filt;
    private float[] save;
    private float[] loop;
    private float[] work;
    private long iloop;
    private long qloop;
    float[] ilut;
    float[] qlut;
    float[] idat;
    float[] qdat;
    float[] idat0;
    float[] qdat0;
    static final int MLUT = 1024;
    int[] scram;
    int[] lrsbuf;
    int nr = 0;
    int n;
    float sar = 0.0f;
    float[] rings;
    int iscram;
    static final int NSCRAM = 1024;
    static final int MSCRAM = 1023;
    float fskp = 0.0f;

    public int open() {
        this.shape = this.MA.getChoice("SHAPE", shapeList, 0);
        this.form = this.MA.getFormat("FORM", "S#,C#");
        this.size = this.MA.getD("ELEM");
        this.rate = this.MA.getD("RATE");
        this.gain = this.MA.getD("GAIN");
        if (this.shape == 25 || this.shape == 26) {
            this.shape = 27;
        }
        if (this.shape == 9) {
            this.gain -= 6.0;
        }
        if (this.shape == 10 || this.shape == 13 || this.shape == 17) {
            this.gain -= 3.0;
        }
        if (this.shape == 13 || this.shape == 17) {
            this.filter = true;
            this.gain -= 1.0;
        }
        if (this.shape >= 20) {
            this.lut = true;
            this.gain -= 3.0;
        }
        if (this.shape >= 22) {
            this.gain -= 3.0;
        }
        if (this.shape == 14) {
            this.dfs = true;
        }
        if (this.shape == 24) {
            this.spb = 2;
            this.iqoff = true;
        }
        this.freq = this.MA.getD("FREQ", this.lut ? 0.0 : this.rate / 10.0);
        this.baud = this.MA.getD("BAUD", this.lut ? this.rate / 4.0 : 0.0);
        this.type = (byte)this.form.charAt(1);
        this.fsk = this.shape == 20 || this.shape == 21;
        boolean bl = this.fram = this.shape == 11 && this.type == 76;
        this.amp = this.type == 76 ? 2.0E9 : (this.type == 73 || this.type == 74 ? 30720.0 : (this.type == 66 ? 120.0 : (this.type == 78 ? 7.0 : 1.0)));
        this.amp = this.MA.getD("/AMP", this.amp);
        this.amp *= Math.pow(2.0, this.gain / 6.0);
        int n = this.ntap = this.shape >= 41 ? 9 : 7;
        this.ntap = this.lut ? this.ntap : (this.filter ? 512 : 0);
        this.poff = this.MA.getD("/PHASE", 0.0);
        this.chirp = this.MA.getD("/CHIRP", 0.0);
        this.var = this.MA.getD("/VARIANCE", Math.pow(this.amp / 2.3025850929940455, 2.0));
        this.sdev = this.MA.getD("/SDEV", Math.sqrt(this.var));
        this.dfreq = this.MA.getD("/DFREQ", this.baud > 0.0 ? this.baud : this.rate / 50.0);
        this.ntap = this.MA.getL("/NTAP", this.ntap);
        this.nrpt = this.MA.getL("/NRPT", 16384);
        this.lrsp = this.MA.getL("/LRSP", 0);
        this.fb = this.MA.getL("/FB", 0);
        this.midx = this.MA.getF("/MIDX", this.midx);
        this.ovsr = this.MA.getL("/OVSR", this.ovsr);
        this.stag = this.MA.getF("/STAG");
        this.itag = this.MA.getL("/STAGOFF", 0);
        this.delta = 1.0 / this.rate;
        this.freq1 = this.freq - this.dfreq;
        this.freq2 = this.freq + this.dfreq;
        if (this.lut) {
            this.freq1 = this.baud;
        }
        this.hf = this.MA.getDataFile("/FIR", "1000", "SF", 0);
        this.hf.open(64);
        if (this.hf.isOpen) {
            this.ntap = (int)this.hf.getSize();
            Data data = this.hf.getDataBuffer(this.ntap, (byte)70);
            this.hf.read(data);
            this.hf.close();
            this.rtap = new float[this.ntap];
            data.toArray((Object)this.rtap);
            if (this.lut) {
                this.ntap /= this.nrpt;
            }
        } else if (this.lut) {
            double d = this.MA.getD("/FWIDTH", 1.0);
            if (this.fsk) {
                this.ntap = 256;
                this.nrpt = 1;
                this.filter = true;
                d *= 2.0 * this.baud * (double)this.midx / this.rate;
                if (this.shape == 21) {
                    d *= 2.0;
                }
            }
            int n2 = this.ntap * this.nrpt;
            this.rtap = new float[n2 + 1];
            float[] fArray = new float[n2 * 2];
            if (this.fsk) {
                firkais.generate((int)1, (double)d, (double)0.0, (double)(d / 20.0), (double)80.0, (float[])fArray, (int)n2, (boolean)false);
            } else {
                firkais.generate((int)1, (double)(d / (double)this.nrpt / (double)this.ovsr), (double)0.0, (double)(0.05 / (double)this.nrpt), (double)80.0, (float[])fArray, (int)n2, (boolean)false);
            }
            for (int i = 0; i < n2; ++i) {
                this.rtap[i] = fArray[i + i] * (float)this.nrpt;
            }
            this.rtap[n2] = this.rtap[0];
        }
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.ho.setFormat(this.form);
        this.ho.setXDelta(this.delta);
        this.ho.setXUnits(1);
        this.ho.setSize(this.size);
        this.ho.open(130);
        this.throttle = this.MA.getState("/RT") ? 1 : 2;
        this.throttle = this.MA.getChoice("/THROTTLE", throttleList, this.throttle);
        if (this.throttle == 1) {
            this.ho.setTimeAt(Time.current());
        }
        this.wrap = this.MA.getState("/WRAP");
        if (this.wrap) {
            double d = this.size * this.delta;
            this.freq = (double)Math.round(this.freq * d) / d;
            this.freq1 = (double)Math.round(this.freq1 * d) / d;
            this.freq2 = (double)Math.round(this.freq2 * d) / d;
        }
        this.mode = this.ho.spa;
        this.wmode = this.shape >= 20 ? 2 : this.mode;
        this.xfer = (int)(8192.0 / this.ho.dbpe);
        this.nbins = this.xfer = this.MA.getL("/TL", this.xfer);
        if (this.filter) {
            this.nfft = this.xfer;
            this.xfer -= this.ntap;
            this.filterPrep(this.fsk ? this.rtap : this.getNotchFilter());
        }
        int n3 = 4 * Math.max(this.xfer * this.wmode, this.nbins * 2);
        byte[] byArray = this.bbuf = this.fb > 0 ? FileIO.allocBuffer(n3) : new byte[n3];
        if (this.fb > 1) {
            this.ho.seek(this.size);
            this.ho.seek(0.0);
        }
        this.todo(this.size);
        this.seed = this.MA.getL("/SEED", this.seed);
        Waveform.setSeed((int)this.seed);
        this.lrs = ~this.seed;
        this.lrsx = ~this.seedx;
        this.lrsy = ~this.seedy;
        this.tbuf = new float[this.xfer * this.wmode];
        if (this.lut) {
            this.preplut();
        }
        this.stats = this.MA.getState("/STATS");
        this.timer = Time.current();
        return 0;
    }

    public int process() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.throttle > 0) {
            if (this.throttle == 1) {
                if (this.tstart == 0.0) {
                    this.tstart = Time.current() - this.ho.seek() * this.delta;
                }
                if (Time.current() < this.tstart + this.ho.seek() * this.delta) {
                    return -1;
                }
            } else {
                this.tstart = 0.0;
            }
            if (this.throttle == 3) {
                return -1;
            }
        }
        if ((n = this.todo()) == 0) {
            return 9;
        }
        if (this.fram) {
            int[] nArray = Native.castL((byte[])this.bbuf);
            this.cur = this.fastramp(nArray, this.type, n, this.mode, this.cur);
            Native.uncastL((Object)nArray);
            this.ho.write(this.bbuf, 0, (int)((double)n * this.ho.dbpe));
            if (this.fb == 2) {
                this.fb = 3;
            }
            return 0;
        }
        if (this.fb > 2) {
            this.ho.write(this.bbuf, 0, (int)((double)n * this.ho.dbpe));
            return 0;
        }
        if (this.fb == 2) {
            this.fb = 3;
        }
        double d5 = this.phase + this.poff;
        double d6 = this.freq * this.delta;
        if (this.mode == 1 && this.wmode == 2) {
            d6 += 0.25;
        }
        if (this.poff != 0.0) {
            d5 -= Math.floor(d5);
        }
        if (d6 < 0.0 && this.shape != 1 && this.shape != 2 && this.shape != 19 && !this.lut) {
            d6 = -d6;
        }
        if (this.shape == 19) {
            d6 += this.sweep * this.baud * this.delta;
            this.sweep += (double)((float)n * this.midx) * this.delta;
            if (this.sweep > 0.5) {
                this.sweep -= 1.0;
            }
        }
        if (this.dfs || this.lut) {
            d = this.phase1 + this.poff;
            d2 = this.freq1 * this.delta;
            d3 = this.phase2 + this.poff;
            d4 = this.freq2 * this.delta;
        }
        float[] fArray = Native.castF((byte[])this.bbuf);
        if (this.shape == 16 && this.mode == 1) {
            this.shape = 15;
        }
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: 
            case 19: {
                Waveform.sincos((float[])fArray, (double)this.amp, (double)d5, (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 2: {
                Waveform.sincos((float[])fArray, (double)this.amp, (double)(d5 + 0.25), (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 3: {
                Waveform.square((float[])fArray, (double)this.amp, (double)d5, (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 4: {
                Waveform.triangle((float[])fArray, (double)this.amp, (double)d5, (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 5: {
                Waveform.sawtooth((float[])fArray, (double)this.amp, (double)d5, (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 6: {
                Waveform.pulse((float[])fArray, (double)this.amp, (double)d5, (double)d6, (int)n, (int)this.mode);
                break;
            }
            case 7: {
                Waveform.constant((float[])fArray, (double)this.amp, (int)n, (int)this.mode);
                break;
            }
            case 8: {
                Waveform.constant((float[])fArray, (double)0.0, (int)n, (int)this.mode);
                break;
            }
            case 9: {
                Waveform.whitenoise((float[])fArray, (double)this.sdev, (int)n, (int)this.mode);
                break;
            }
            case 10: {
                this.lrs = Waveform.lrs((float[])fArray, (double)this.amp, (int)n, (int)this.mode, (int)this.lrs);
                break;
            }
            case 11: {
                this.cur = Waveform.ramp((float[])fArray, (double)this.amp, (int)n, (int)this.mode, (int)this.cur);
                break;
            }
            case 12: {
                this.tcur = this.testramp(fArray, this.type, n, this.mode, this.tcur);
                break;
            }
            case 18: {
                this.lrs(fArray, this.amp, n, this.mode);
                this.rotate(fArray, n, this.mode);
                break;
            }
            case 13: {
                this.lrs = Waveform.lrs((float[])fArray, (double)this.amp, (int)n, (int)this.mode, (int)this.lrs);
                this.rotate(fArray, n, this.mode);
                this.filter(fArray, n, this.mode);
                break;
            }
            case 14: {
                Waveform.sincos((float[])fArray, (double)(this.amp / 2.0), (double)d, (double)d2, (int)n, (int)this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp / 2.0), (double)d3, (double)d4, (int)n, (int)this.mode);
                Add.SSS((float[])fArray, (float[])this.tbuf, (float[])fArray, (int)(n * this.mode));
                break;
            }
            case 15: {
                this.lrs = Waveform.lrs((float[])fArray, (double)(this.amp / 2.0), (int)n, (int)this.mode, (int)this.lrs);
                this.rotate(fArray, n, this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp / 2.0), (double)d5, (double)d6, (int)n, (int)this.mode);
                Add.SSS((float[])fArray, (float[])this.tbuf, (float[])fArray, (int)(n * this.mode));
                break;
            }
            case 16: {
                this.lrs = Waveform.lrs((float[])fArray, (double)this.amp, (int)n, (int)1, (int)this.lrs);
                Waveform.sincos((float[])this.tbuf, (double)this.amp, (double)d5, (double)d6, (int)n, (int)1);
                this.mux(fArray, this.tbuf, n);
                this.rotate(fArray, n, this.mode);
                break;
            }
            case 17: {
                this.lrs = Waveform.lrs((float[])fArray, (double)(this.amp * 15.0 / 16.0), (int)n, (int)this.mode, (int)this.lrs);
                this.rotate(fArray, n, this.mode);
                this.filter(fArray, n, this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp * 1.0 / 16.0), (double)d5, (double)d6, (int)n, (int)this.mode);
                Add.SSS((float[])fArray, (float[])this.tbuf, (float[])fArray, (int)(n * this.mode));
                break;
            }
            default: {
                if (this.fsk) {
                    this.resfsk(fArray, d, d2, n);
                } else {
                    this.reslut(fArray, d, d2, n);
                }
                if (this.fsk) {
                    this.filter(fArray, n, this.wmode);
                }
                if (d6 != 0.0) {
                    this.rotlut(fArray, d5, d6, n);
                }
                if (this.mode != 1) break;
                this.cx2r(fArray, n);
            }
        }
        if ((double)this.stag >= 0.0) {
            for (int i = this.itag * this.mode; i < n * this.mode; ++i) {
                fArray[i] = fArray[i] * this.stag;
            }
            this.stag = -1.0f;
        }
        Native.uncastF((Object)fArray);
        if (this.type != 70) {
            Convert.type((byte[])this.bbuf, (int)0, (byte)70, (byte[])this.bbuf, (int)0, (byte)this.type, (int)(n * this.mode));
        }
        this.ho.write(this.bbuf, 0, (int)((double)n * this.ho.dbpe));
        this.phase += d6 * (double)n;
        this.ndone = (int)this.phase;
        this.phase -= (double)this.ndone;
        if (this.chirp != 0.0) {
            this.freq += this.chirp * this.delta * (double)n;
        }
        if (this.dfs || this.lut) {
            this.phase1 += d2 * (double)n;
            this.ndone = (int)this.phase1;
            this.phase1 -= (double)this.ndone;
            if (this.lut) {
                this.genlut(this.ndone, this.mper);
            }
            this.phase2 += d4 * (double)n;
            this.ndone = (int)this.phase2;
            this.phase2 -= (double)this.ndone;
        }
        return 0;
    }

    public int close() {
        if (this.stats) {
            float f = (float)(Time.current() - this.timer);
            float f2 = (float)(this.ho.getDataSize() / 1048576.0);
            float f3 = f2 / (float)Math.max(0.001, (double)f);
            this.M.info((CharSequence)("Size=" + f2 + " Mby, Time=" + f + " sec, Rate=" + f3 + " Mby/s"));
        }
        if (this.fb > 0) {
            FileIO.freeBuffer(this.bbuf);
        }
        this.ho.close();
        return 0;
    }

    public int restart() {
        this.ho.close();
        this.ho = this.MA.getDataFile("OUT", this.ho, 0);
        this.ho.setFormat(this.form);
        this.ho.setSize(this.todo);
        this.ho.open();
        this.tstart = 0.0;
        return 0;
    }

    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        return this.ho.processReady(this.xfer);
    }

    public double getProgress() {
        return this.ho.getOffset() / this.ho.getSize();
    }

    public void setShape(String string) {
        this.shape = Parser.find((String)shapeList, (String)string, (int)this.shape, (int)0, (int)1);
    }

    public void setGain(double d) {
        this.gain = d;
    }

    public void setFrequency(double d) {
        this.freq = d;
    }

    public void setChirp(double d) {
        this.chirp = d;
    }

    public void setPhase(double d) {
        this.phase = d;
    }

    public void setThrottle(String string) {
        this.throttle = Parser.find((String)throttleList, (String)string, (int)this.throttle, (int)0, (int)1);
    }

    public void setFormat(String string) {
        if (this.form.equals(string)) {
            return;
        }
        this.form = string;
        this.setState(7);
    }

    public String getShape() {
        return Parser.get((String)shapeList, (int)this.shape);
    }

    public double getGain() {
        return this.gain;
    }

    public double getAmplitude() {
        return this.amp;
    }

    public double getFrequency() {
        return this.freq;
    }

    public double getChirp() {
        return this.chirp;
    }

    public double getPhase() {
        return this.phase;
    }

    public String getThrottle() {
        return Parser.get((String)throttleList, (int)this.throttle);
    }

    public String getFormat() {
        return this.form;
    }

    private float[] getNotchFilter() {
        double d = this.rate / 2.0;
        double d2 = Math.max(Math.min(this.freq, d - this.dfreq), this.dfreq);
        FilterFIR filterFIR = new FilterFIR(this.M, FilterFIR.FilterType.StopBand, this.ntap, d2 - this.dfreq, d2 + this.dfreq, d, false, false, "BH92", 1.0);
        return filterFIR.makeFilter(this.ntap);
    }

    private void filterPrep(float[] fArray) {
        int n;
        int n2 = this.wmode == 2 ? 2 : 65;
        this.fft = new Fft(this.nfft, n2 | 8);
        this.ifft = new Fft(this.nfft, n2 | 0x10);
        this.nbins = this.wmode == 2 ? this.nfft : this.nfft / 2 + 1;
        int n3 = this.nbins * 2;
        float f = (float)(1.0 / (double)(this.wmode == 2 ? this.nfft : this.nfft * 4));
        this.filt = new float[n3];
        for (n = 0; n < n3; ++n) {
            this.filt[n] = 0.0f;
        }
        for (n = 0; n < this.ntap; ++n) {
            this.filt[(n + this.xfer) * this.wmode] = fArray[n] * f;
        }
        this.fft.work((Object)this.filt);
        this.save = new float[this.ntap * this.wmode];
        this.lrs = Waveform.lrs((float[])this.save, (double)this.amp, (int)this.ntap, (int)this.wmode, (int)this.lrs);
        this.loop = new float[this.ntap * this.wmode];
        System.arraycopy(this.save, 0, this.loop, 0, this.ntap * this.wmode);
        this.iloop = -((long)(this.size - (double)this.ntap));
        this.work = new float[n3];
    }

    private void filter(float[] fArray, int n, int n2) {
        System.arraycopy(this.save, 0, this.work, 0, this.ntap * n2);
        System.arraycopy(fArray, 0, this.work, this.ntap * n2, n * n2);
        if (this.wrap) {
            this.iloop += (long)this.xfer;
            if (this.iloop > 0L) {
                System.arraycopy(this.loop, 0, this.work, (this.nfft - (int)this.iloop) * n2, Math.min(this.ntap, (int)this.iloop) * n2);
            }
        }
        System.arraycopy(fArray, (this.xfer - this.ntap) * n2, this.save, 0, this.ntap * n2);
        this.fft.work((Object)this.work);
        Multiply.CCC((float[])this.work, (float[])this.filt, (float[])fArray, (int)this.nbins);
        this.ifft.work((Object)fArray);
    }

    private void preplut() {
        this.ilut = new float[1024];
        this.qlut = new float[1024];
        float f = (float)this.amp;
        int n = 0;
        int n2 = 1;
        boolean bl = true;
        boolean bl2 = this.MA.getState("/MAP");
        if (this.shape == 22) {
            this.olut = 1;
            float f2 = f * 1.414f / 2.0f;
            for (int i = 0; i < 2; ++i) {
                this.ilut[n] = (float)n2 * f2;
                this.qlut[n] = 0.0f;
                ++n;
                n2 = -n2;
            }
        } else if (this.shape == 20) {
            this.olut = 1;
            for (int i = 0; i < 2; ++i) {
                this.ilut[n] = (float)n2 * 0.5f * this.midx;
                this.qlut[n] = 0.0f;
                ++n;
                n2 = -n2;
            }
        } else if (this.shape == 21) {
            int n3;
            this.olut = 2;
            for (n3 = 0; n3 < 2; ++n3) {
                this.ilut[n] = (float)n2 * 0.5f * this.midx;
                this.qlut[n] = 0.0f;
                ++n;
                n2 = -n2;
            }
            for (n3 = 2; n3 < 4; ++n3) {
                this.ilut[n] = (float)n2 * 1.5f * this.midx;
                this.qlut[n] = 0.0f;
                ++n;
                n2 = -n2;
            }
        } else if (this.shape == 27) {
            this.olut = 3;
            float f3 = f * 1.414f / 2.0f;
            for (int i = 0; i < 8; ++i) {
                double d = Math.PI * 2 * ((double)i + 0.5) / 8.0;
                this.ilut[i] = f3 * (float)Math.sin(d);
                this.qlut[i] = f3 * (float)Math.cos(d);
            }
        } else if (this.shape == 28) {
            this.olut = 4;
            float f4 = f * 1.414f / 2.0f;
            for (int i = 0; i < 16; ++i) {
                double d = Math.PI * 2 * ((double)i + 0.5) / 16.0;
                this.ilut[i] = f4 * (float)Math.sin(d);
                this.qlut[i] = f4 * (float)Math.cos(d);
            }
        } else if (this.shape == 29) {
            double d;
            int n4;
            this.olut = 4;
            float f5 = f * 0.38910508f;
            float f6 = f;
            for (n4 = 0; n4 < 4; ++n4) {
                d = Math.PI * 2 * ((double)n4 + 0.5) / 4.0;
                this.ilut[n4 + 0] = f5 * (float)Math.sin(d);
                this.qlut[n4 + 0] = f5 * (float)Math.cos(d);
            }
            for (n4 = 0; n4 < 12; ++n4) {
                d = Math.PI * 2 * ((double)n4 + 0.5) / 12.0;
                this.ilut[n4 + 4] = f6 * (float)Math.sin(d);
                this.qlut[n4 + 4] = f6 * (float)Math.cos(d);
            }
        } else if (this.shape == 30) {
            double d;
            int n5;
            this.olut = 5;
            float f7 = f * 0.23255813f;
            float f8 = f * 0.58837205f;
            float f9 = f;
            for (n5 = 0; n5 < 4; ++n5) {
                d = Math.PI * 2 * ((double)n5 + 0.5) / 4.0;
                this.ilut[n5 + 0] = f7 * (float)Math.sin(d);
                this.qlut[n5 + 0] = f7 * (float)Math.cos(d);
            }
            for (n5 = 0; n5 < 12; ++n5) {
                d = Math.PI * 2 * ((double)n5 + 0.5) / 12.0;
                this.ilut[n5 + 4] = f8 * (float)Math.sin(d);
                this.qlut[n5 + 4] = f8 * (float)Math.cos(d);
            }
            for (n5 = 0; n5 < 16; ++n5) {
                d = Math.PI * 2 * ((double)n5 + 0.0) / 16.0;
                this.ilut[n5 + 16] = f9 * (float)Math.sin(d);
                this.qlut[n5 + 16] = f9 * (float)Math.cos(d);
            }
        } else if (this.shape == 31) {
            double d;
            int n6;
            this.olut = 6;
            float f10 = f * 0.18867923f;
            float f11 = f * 0.47735846f;
            float f12 = f * 0.75471693f;
            float f13 = f;
            for (n6 = 0; n6 < 4; ++n6) {
                d = Math.PI * 2 * ((double)n6 + 0.5) / 4.0;
                this.ilut[n6 + 0] = f10 * (float)Math.sin(d);
                this.qlut[n6 + 0] = f10 * (float)Math.cos(d);
            }
            for (n6 = 0; n6 < 12; ++n6) {
                d = Math.PI * 2 * ((double)n6 + 0.5) / 12.0;
                this.ilut[n6 + 4] = f11 * (float)Math.sin(d);
                this.qlut[n6 + 4] = f11 * (float)Math.cos(d);
            }
            for (n6 = 0; n6 < 20; ++n6) {
                d = Math.PI * 2 * ((double)n6 + 0.5) / 20.0;
                this.ilut[n6 + 16] = f12 * (float)Math.sin(d);
                this.qlut[n6 + 16] = f12 * (float)Math.cos(d);
            }
            for (n6 = 0; n6 < 28; ++n6) {
                d = Math.PI * 2 * ((double)n6 + 0.5) / 28.0;
                this.ilut[n6 + 36] = f13 * (float)Math.sin(d);
                this.qlut[n6 + 36] = f13 * (float)Math.cos(d);
            }
        } else if (this.shape == 35) {
            double d;
            int n7;
            this.olut = 3;
            float f14 = f * 0.41558442f;
            float f15 = f;
            for (n7 = 0; n7 < 4; ++n7) {
                d = Math.PI * 2 * ((double)n7 + 0.5) / 4.0;
                this.ilut[n7 + 0] = f14 * (float)Math.sin(d);
                this.qlut[n7 + 0] = f14 * (float)Math.cos(d);
            }
            for (n7 = 0; n7 < 4; ++n7) {
                d = Math.PI * 2 * ((double)n7 + 0.5) / 4.0;
                this.ilut[n7 + 4] = f15 * (float)Math.sin(d);
                this.qlut[n7 + 4] = f15 * (float)Math.cos(d);
            }
        } else {
            int n8 = 0;
            switch (this.shape) {
                case 23: {
                    this.olut = 2;
                    this.hlut = 2;
                    break;
                }
                case 24: {
                    this.olut = 2;
                    this.hlut = 2;
                    break;
                }
                case 36: {
                    this.olut = 4;
                    this.hlut = 4;
                    break;
                }
                case 32: {
                    this.olut = 4;
                    this.hlut = 4;
                    n8 = 2;
                    break;
                }
                case 37: {
                    this.olut = 5;
                    this.hlut = 6;
                    break;
                }
                case 38: {
                    this.olut = 6;
                    this.hlut = 8;
                    break;
                }
                case 33: {
                    this.olut = 6;
                    this.hlut = 8;
                    n8 = 4;
                    break;
                }
                case 39: {
                    this.olut = 7;
                    this.hlut = 12;
                    break;
                }
                case 40: {
                    this.olut = 8;
                    this.hlut = 16;
                    break;
                }
                case 34: {
                    this.olut = 8;
                    this.hlut = 16;
                    n8 = 8;
                    break;
                }
                case 41: {
                    this.olut = 9;
                    this.hlut = 24;
                    break;
                }
                case 42: {
                    this.olut = 10;
                    this.hlut = 32;
                }
            }
            if (bl2) {
                f = (float)this.hlut / (float)(this.hlut - 1);
            }
            float f16 = 2.0f * f / (float)this.hlut;
            float f17 = -f + f16 / 2.0f;
            for (int i = 0; i < this.hlut; ++i) {
                for (int j = 0; j < this.hlut; ++j) {
                    if (!((this.shape != 37 || i >= 1 && i <= 4 || j >= 1 && j <= 4) && (this.shape != 39 || i >= 2 && i <= 9 || j >= 2 && j <= 9) && (this.shape != 41 || i >= 4 && i <= 19 || j >= 4 && j <= 19))) continue;
                    this.ilut[n] = f17 + (float)i * f16;
                    this.qlut[n] = f17 + (float)j * f16;
                    if (n8 > 0) {
                        icewave.fixCQ(n8, f16, i, j, n, this.ilut, this.qlut);
                    }
                    if (bl2) {
                        this.addRing(this.ilut[n], this.qlut[n]);
                    }
                    ++n;
                }
            }
        }
        this.nlut = 1 << this.olut;
        this.nper = (int)((double)this.xfer * this.freq1 * this.delta + 1.0);
        this.mper = this.ntap + this.nper;
        this.idat = new float[this.mper + 1];
        this.idat0 = new float[this.mper];
        this.qdat = new float[this.mper + 1];
        this.qdat0 = new float[this.mper];
        this.lrsbuf = new int[this.mper];
        this.qloop = this.mper;
        this.genscram();
        this.genlut(this.mper, this.mper);
        System.arraycopy(this.idat, 0, this.idat0, 0, this.mper);
        System.arraycopy(this.qdat, 0, this.qdat0, 0, this.mper);
        this.qloop = -Math.round(this.size * this.delta * this.freq1);
        if (bl2) {
            this.printRings();
        }
    }

    public static void fixCQ(int n, float f, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        float f2 = fArray[n4];
        float f3 = fArray2[n4];
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        n2 = n2 < n ? n - 1 - n2 : n2 - n;
        n3 = n3 < n ? n - 1 - n3 : n3 - n;
        int n5 = Math.max(n2, n3);
        float f5 = n5 == 0 ? 0.8f : f * ((float)n5 + 0.5f) / f4;
        fArray[n4] = f2 * f5;
        fArray2[n4] = f3 * f5;
    }

    private void addRing(float f, float f2) {
        int n;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        this.sar += f3;
        if (this.rings == null) {
            this.rings = new float[1024];
        }
        for (n = 0; n < this.nr; ++n) {
            if ((double)Math.abs(f3 - this.rings[n]) < 1.0E-4) {
                return;
            }
            if (f3 < this.rings[n]) break;
        }
        for (int i = this.nr; i > n; --i) {
            this.rings[i] = this.rings[i - 1];
        }
        this.rings[n] = f3;
        ++this.nr;
    }

    private void printRings() {
        float f = (float)(this.hlut - 1) / (float)this.hlut;
        for (int i = 0; i < this.nr; ++i) {
            System.out.println("Ring i=" + i + " r=" + this.rings[i] + " rs=" + f * this.rings[i]);
        }
        float f2 = f * this.sar / (float)this.nlut;
        System.out.println("Average = " + f2);
    }

    private void genscram() {
        this.scram = new int[1024];
        int n = ~this.seed;
        for (int i = 0; i < 8192; ++i) {
            int n2 = ~(n ^ n >> 1 ^ n >> 5 ^ n >> 25) & 1;
            n = n << 1 | n2;
            this.scram[i >> 3] = n & 0x3FF;
        }
        this.iscram = 0;
    }

    private int onesN(int n) {
        int n2 = 1;
        for (int i = 0; i < 32; ++i) {
            n2 += n & 1;
            n >>= 1;
        }
        return n2;
    }

    private int genlrs(int[] nArray, int n, int n2) {
        float f = 5.5879354E-8f;
        if (this.lrsp != 0) {
            for (int i = 0; i < n; ++i) {
                n2 = n2 << 1 | this.onesN(n2 & this.lrsp) & 1;
                nArray[i] = n2 * 1023;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = ~(n2 ^ n2 >> 1 ^ n2 >> 5 ^ n2 >> 25) & 1;
                n2 = n2 << 1 | n3;
                int n4 = (int)(f * (float)n2);
                nArray[i] = n4 ^ this.scram[this.iscram++];
                this.iscram &= 0x3FF;
            }
        }
        return n2;
    }

    private void genlut(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.nlut - 1;
        int n7 = n2 - n;
        for (n5 = 0; n5 < n7; ++n5) {
            this.idat[n5] = this.idat[n5 + n];
            this.qdat[n5] = this.qdat[n5 + n];
        }
        this.lrs = this.genlrs(this.lrsbuf, n, this.lrs);
        if (this.shape == 20 || this.shape == 21) {
            n5 = n7;
            n4 = 0;
            while (n5 < n2) {
                float f;
                n3 = this.lrsbuf[n4] & n6;
                this.idat[n5] = f = this.ilut[n3];
                this.qdat[n5] = this.fskp;
                this.fskp += f;
                this.fskp -= (float)((int)this.fskp);
                ++n5;
                ++n4;
            }
        } else {
            n5 = n7;
            n4 = 0;
            while (n5 < n2) {
                n3 = this.lrsbuf[n4] & n6;
                this.idat[n5] = this.ilut[n3];
                this.qdat[n5] = this.qlut[n3];
                ++n5;
                ++n4;
            }
        }
        if (this.wrap && this.qloop != (long)n2) {
            this.qloop += (long)n;
            if (this.qloop + (long)n2 >= 0L) {
                n5 = -((int)this.qloop);
                n4 = 0;
                if (n5 < 0) {
                    n4 = -n5;
                    n5 = 0;
                }
                n3 = n2 - n5;
                System.arraycopy(this.idat0, n4, this.idat, n5, n3);
                System.arraycopy(this.qdat0, n4, this.qdat, n5, n3);
            }
        }
    }

    private void resfsk(float[] fArray, double d, double d2, int n) {
        float f = (float)this.amp;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n3 = (int)d;
            double d3 = ((d - (double)n3) * (double)this.idat[n3] + (double)this.qdat[n3]) * (Math.PI * 2);
            f2 = f * (float)Math.sin(d3);
            f3 = f * (float)Math.cos(d3);
            fArray[n2++] = f2;
            fArray[n2++] = f3;
            d += d2;
        }
    }

    private void reslut(float[] fArray, double d, double d2, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            float f = 0.0f;
            float f2 = 0.0f;
            int n4 = (int)d;
            int n5 = (int)((1.0 - (d - (double)n4)) * (double)this.nrpt);
            if (this.ntap == 1) {
                f = this.idat[n4];
                f2 = this.qdat[n4];
            } else if (this.iqoff) {
                double d3 = d + 0.5;
                int n6 = (int)d3;
                int n7 = (int)((1.0 - (d3 - (double)n6)) * (double)this.nrpt);
                n3 = 0;
                while (n3 < this.ntap) {
                    f += this.rtap[n5] * this.idat[n4];
                    f2 += this.rtap[n7] * this.qdat[n6];
                    ++n3;
                    n5 += this.nrpt;
                    ++n4;
                    n7 += this.nrpt;
                    ++n6;
                }
            } else {
                n3 = 0;
                while (n3 < this.ntap) {
                    f += this.rtap[n5] * this.idat[n4];
                    f2 += this.rtap[n5] * this.qdat[n4];
                    ++n3;
                    n5 += this.nrpt;
                    ++n4;
                }
            }
            fArray[n2++] = f;
            fArray[n2++] = f2;
            d += d2;
        }
    }

    private void rotlut(float[] fArray, double d, double d2, int n) {
        float f = (float)Math.sin(d * (Math.PI * 2));
        float f2 = (float)Math.cos(d * (Math.PI * 2));
        float f3 = (float)Math.sin(d2 * (Math.PI * 2));
        float f4 = (float)Math.cos(d2 * (Math.PI * 2));
        for (int i = 0; i < n * 2; i += 2) {
            float f5 = fArray[i + 0];
            float f6 = fArray[i + 1];
            fArray[i + 0] = f5 * f2 - f6 * f;
            fArray[i + 1] = f5 * f + f6 * f2;
            float f7 = f4 * f2 - f3 * f;
            f = f4 * f + f3 * f2;
            f2 = f7;
        }
    }

    private int fastramp(int[] nArray, int n, int n2, int n3, int n4) {
        if (n == 73 && n3 == 2) {
            int n5 = 1;
            int n6 = 0;
            while (n6 < n2) {
                nArray[n6] = n4;
                ++n6;
                n4 += n5;
            }
        } else {
            this.M.error("FastRamp for type=" + n + " and spa=" + n3 + " not supported");
        }
        return n4;
    }

    private int testramp(float[] fArray, int n, int n2, int n3, int n4) {
        int n5 = n == 66 ? 256 : 65536;
        int n6 = n5 >> 1;
        int n7 = n == 76 ? 50398210 : (n == 66 ? 3 : 256);
        int n8 = 0;
        for (int i = 0; i < n2; ++i) {
            if (n != 76 && (n4 += n7) >= n6) {
                n4 -= n5;
            }
            if (n == 73 && (n4 & 0xFF00) == 65280) {
                ++n4;
            }
            fArray[n8++] = n4;
            if (n3 <= 1) continue;
            fArray[n8++] = n4;
        }
        return n4;
    }

    private void mux(float[] fArray, float[] fArray2, int n) {
        int n2 = n * 2;
        for (int i = n - 1; i >= 0; --i) {
            fArray[--n2] = fArray[i];
            fArray[--n2] = fArray2[i];
        }
    }

    private void rotate(float[] fArray, int n, int n2) {
        if (n2 == 1) {
            for (int i = 0; i < n; i += 2) {
                fArray[i + 0] = -fArray[i + 0];
            }
        } else {
            for (int i = 0; i < n * 2; i += 4) {
                fArray[i + 0] = -fArray[i + 0];
                fArray[i + 1] = -fArray[i + 1];
            }
        }
    }

    private void cx2r(float[] fArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            fArray[n2] = fArray[n3];
            ++n2;
            n3 += 2;
        }
    }

    public void lrs(float[] fArray, double d, int n, int n2) {
        float f = (float)(d / 2.0 / 1.073741824E9);
        for (int i = 0; i < n * n2; ++i) {
            fArray[i] = f * (float)this.lrsx;
            int n3 = ~(this.lrsx ^ this.lrsx >> 1 ^ this.lrsx >> 5 ^ this.lrsx >> 25) & 1;
            this.lrsx <<= 1;
            this.lrsx |= n3;
            if (n2 == 1) continue;
            fArray[++i] = f * (float)this.lrsy;
            n3 = ~(this.lrsy ^ this.lrsy >> 1 ^ this.lrsy >> 5 ^ this.lrsy >> 25) & 1;
            this.lrsy <<= 1;
            this.lrsy |= n3;
        }
    }
}

