/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Core;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class icejvm
extends Primitive {
    Table refTab;
    Table lnTab;
    Table bcTab;
    Table foTab;
    ConstantPool[] jcp;
    OpCode[] joc;
    byte rep = (byte)73;
    int classPtr = 0;
    int memMode = 0;
    int cSlots = 1;
    int vSlots = 0;
    int rSlot = 0;
    int codeBase;
    int cpLen;
    int codeLen;
    int maxBytes;
    int maxPool;
    byte[] dbuf;
    byte[] mbuf;
    byte[] tbuf;
    boolean v1;
    boolean v2;
    boolean pre;
    boolean boot;
    Core core;
    private static final int A_PUBLIC = 1;
    private static final int A_PRIVATE = 2;
    private static final int A_PROTECTED = 4;
    private static final int A_STATIC = 8;
    private static final int A_FINAL = 16;
    private static final int A_VOLATILE = 32;
    private static final int A_TRANSIENT = 64;
    private static final int A_NATIVE = 128;
    private int methodStack;
    private int methodLocals;
    private int methodLength;
    private static int PSEUDO = 0x800010;

    public int open() {
        int n;
        String string;
        this.pre = this.MA.getState("/PRE");
        this.boot = this.MA.getState("/BOOT");
        int n2 = this.MA.getL("/VERBOSE");
        this.v1 = n2 >= 1;
        boolean bl = this.v2 = n2 >= 2;
        if (this.MA.isPresent("/CORE")) {
            return this.runjvmcore();
        }
        this.foTab = Convert.o2t((Object)"nxm.ice.dat.jvmfields.tbl", (Object)this.M);
        TextFile textFile = new TextFile((MidasReference)this.M, (Object)"nxm.ice.dat.jvmcodes.lst");
        textFile.open(1);
        this.bcTab = new Table();
        this.joc = new OpCode[256];
        while ((string = textFile.readProper()) != null) {
            new OpCode(string);
        }
        textFile.close();
        DataFile dataFile = new DataFile((MidasReference)this.M, (Object)"nxm.ice.dat.jvmcodes.prm", "1000", "SL", 0);
        dataFile.open(2);
        Data data = dataFile.getDataBuffer(512);
        for (int i = 0; i < 256; ++i) {
            if (this.joc[i] == null) continue;
            if (this.joc[i].code < 0 || this.joc[i].code > 255) {
                this.M.error("Bad Byte Code definition: " + this.joc[i]);
            }
            n = this.joc[i].code & 0xFF;
            data.setL(0 | n, this.joc[i].inst1);
            data.setL(0x100 | n, this.joc[i].inst2);
        }
        dataFile.write(data);
        dataFile.close();
        this.maxBytes = this.MA.getL("/MAXCODE", 16384);
        this.dbuf = new byte[this.maxBytes];
        this.mbuf = new byte[this.maxBytes];
        this.tbuf = new byte[2];
        this.tbuf[1] = 2;
        this.tbuf[0] = 0;
        this.codeBase = this.classPtr = 0;
        this.lnTab = new Table();
        this.refTab = new Table();
        this.maxPool = this.MA.getL("/MAXPOOL", 1024);
        this.jcf2m(this.MA.getCS("JCF"));
        DataFile dataFile2 = this.MA.getDataFile("JLF", "1000", "SI", 0, (double)this.codeLen, null);
        dataFile2.setComment("ICE JVM Load File");
        dataFile2.keywords.put("CODELEN", (Object)new Data(this.codeLen));
        dataFile2.setExt("prm");
        dataFile2.open(2);
        if (this.boot) {
            for (n = 0; n < 2048; ++n) {
                dataFile2.write(data.buf, n, 1);
                dataFile2.write(this.tbuf, 1, 1);
            }
        }
        for (n = 0; n < this.codeLen; ++n) {
            dataFile2.write(this.dbuf, n, 1);
            dataFile2.write(this.mbuf, n, 1);
        }
        dataFile2.close();
        return 9;
    }

    private void print(String string) {
        if (this.v1) {
            System.out.print(string);
        }
    }

    private void println(String string) {
        if (this.v1) {
            System.out.println(string);
        }
    }

    private void vprint(String string) {
        if (this.v2) {
            System.out.print(string);
        }
    }

    private void vprintln(String string) {
        if (this.v2) {
            System.out.println(string);
        }
    }

    private void jcf2m(String string) {
        this.println("Open classfile=" + string);
        BaseFile baseFile = new BaseFile((MidasReference)this.M, (Object)string);
        baseFile.setExt("class");
        baseFile.open(1);
        int n = (int)baseFile.getSize();
        byte[] byArray = new byte[n + 16];
        baseFile.read(byArray, 0, n);
        baseFile.close();
        this.jcp = new ConstantPool[this.maxPool];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Convert.unpackL((byte[])byArray, (int)n2, (byte)this.rep);
        short s = Convert.unpackI((byte[])byArray, (int)(n2 += 4), (byte)this.rep);
        short s2 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        this.println("Magic=" + Convert.l2x((int)n5) + " Minor=" + s + " Major=" + s2);
        int n6 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        n2 += 2;
        this.println("Constant Count=" + n6);
        for (n3 = 1; n3 < n6; n3 += this.jcp[n3].slots) {
            n2 = this.getConstant(n3, byArray, n2);
        }
        for (n3 = 1; n3 < n6; n3 += this.jcp[n3].slots) {
            this.setConstant(n3);
        }
        short s3 = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        short s4 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        short s5 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        String string2 = this.getC(this.getI(s4));
        String string3 = this.getC(this.getI(s5));
        this.println("Access=" + this.getAcc(s3) + " this=" + string2 + " super=" + string3);
        int n7 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        n2 += 2;
        this.println("Interfaces count=" + n7);
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = this.getInterface(n3, byArray, n2);
        }
        int n8 = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        n2 += 2;
        this.println("Field count=" + n8);
        for (n3 = 0; n3 < n8; ++n3) {
            n2 = this.getField(n3, byArray, n2);
        }
        this.codeLen = this.codeBase + this.cSlots * 4;
        if (!string3.equals("java/lang/Object")) {
            String string4 = StringUtil.replaceAll((String)string3, (String)"/", (String)".");
            ConstantPool[] constantPoolArray = this.jcp;
            this.jcf2m(string4);
            this.jcp = constantPoolArray;
        }
        this.cpLen = this.codeLen;
        int n9 = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        n2 += 2;
        this.println("Method count=" + n9);
        for (n3 = 0; n3 < n9; ++n3) {
            n2 = this.getMethod(n3, byArray, n2);
        }
        int n10 = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        n2 += 2;
        this.println("Attributes count=" + n10);
        for (n3 = 0; n3 < n10; ++n3) {
            n2 = this.getAttribute(n3, byArray, n2, false);
        }
        if (n2 != n) {
            this.println("Extra bytes=" + (n - n2));
        }
        this.println("Total Load cSlots=" + this.cSlots + " vSlots=" + this.vSlots + " bytes=" + this.codeLen);
        for (n4 = 0; n4 < this.classPtr + 4; ++n4) {
            this.dbuf[n4] = 0;
            this.mbuf[n4] = 0;
        }
        n4 = this.classPtr + 1;
        this.mbuf[n4] = 1;
        this.dbuf[n4] = -72;
        this.dbuf[n4 + 1] = (byte)this.rSlot;
        if (this.v2) {
            this.refTab.dump();
        }
        if (!this.pre) {
            this.getCode(this.dbuf, this.cpLen, this.codeLen - this.cpLen, this.mbuf);
        }
        this.println("Close classfile=" + string);
    }

    private int getConstant(int n, byte[] byArray, int n2) {
        ConstantPool constantPool;
        this.jcp[n] = constantPool = new ConstantPool(byArray, n2);
        return n2 + constantPool.size;
    }

    private void setConstant(int n) {
        ConstantPool constantPool = this.jcp[n];
        switch (constantPool.tag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                constantPool.slot = this.cSlots;
                this.cSlots += constantPool.slots;
                int n2 = constantPool.slots * 4;
                constantPool.offset = this.codeBase + constantPool.slot * 4;
                System.arraycopy(((Data)constantPool.value).buf, 0, this.dbuf, constantPool.offset, n2);
                break;
            }
            case 9: 
            case 10: {
                if (constantPool.tag == 10) {
                    constantPool.slot = this.cSlots++;
                }
                int n3 = constantPool.getI(0);
                int n4 = constantPool.getI(1);
                int n5 = this.jcp[n3].getI(0);
                int n6 = this.jcp[n4].getI(0);
                int n7 = this.jcp[n4].getI(1);
                String string = this.jcp[n5].getS();
                String string2 = this.jcp[n6].getS();
                String string3 = this.jcp[n7].getS();
                constantPool.name = string + "." + string2 + "<" + string3 + ">";
                if (constantPool.tag == 10) {
                    this.refTab.put(string2, constantPool.slot);
                }
                if (constantPool.tag != 10 || !string2.equals("run")) break;
                this.rSlot = constantPool.slot;
            }
        }
        this.println("Const#" + n + " " + constantPool);
    }

    private String getC(int n) {
        return this.jcp[n].value.toString();
    }

    private int getI(int n) {
        return Convert.o2l((Object)this.jcp[n].value);
    }

    private int getInterface(int n, byte[] byArray, int n2) {
        return n2 + 2;
    }

    private String getAcc(int n) {
        return Parser.mask2s((String)"Public,Priv,Prot,Static,Final,Volatile,Transient,X,Native", (int)n);
    }

    private int getField(int n, byte[] byArray, int n2) {
        short s = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        short s2 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        short s3 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        int n3 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        n2 += 2;
        String string = this.getC(s2);
        int n4 = 0;
        String string2 = "Field#" + n + " access=" + this.getAcc(s) + " attr=" + n3 + " desc=" + this.getC(s3) + " name=" + string;
        if ((s & 8) != 0) {
            if ((s & 0x10) == 0 && this.specialStatic(string) == 0) {
                n4 = this.cSlots++;
                this.refTab.put(string, n4);
            }
        } else {
            n4 = this.vSlots++;
        }
        this.println(string2 + " slot=" + n4);
        for (int i = 0; i < n3; ++i) {
            n2 = this.getAttribute(i, byArray, n2, false);
        }
        return n2;
    }

    private int getMethod(int n, byte[] byArray, int n2) {
        int n3;
        short s = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        short s2 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        String string = this.getC(s2);
        short s3 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        int n4 = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        n2 += 2;
        int n5 = this.classPtr >> 2 & 0xFFF;
        int n6 = this.codeLen & 0x3FFF;
        int n7 = this.getNArgs(this.getC(s3));
        int n8 = Convert.o2l((Object)this.refTab.get(string));
        if (this.classPtr > this.maxBytes) {
            this.M.error("Class pointer" + this.classPtr + " exceeded max=" + this.maxBytes);
        }
        if (this.codeLen > this.maxBytes) {
            this.M.error("Code length=" + this.codeLen + " exceeded max=" + this.maxBytes);
        }
        String string2 = "Method#" + n + " access=" + this.getAcc(s) + " attr=" + n4 + " desc=" + this.getC(s3) + " name=" + string + " slot=" + n8;
        this.lnTab.put("" + this.codeLen, (Object)string2);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.getAttribute(n3, byArray, n2, true);
        }
        n3 = this.methodLocals - n7 + 1;
        if (n7 > 15) {
            this.M.error("Too many args=" + n7);
        }
        if (n3 > 32) {
            this.M.error("Too many args+locals=" + n3);
        }
        int n9 = n3 > 12 ? 3 : (n3 > 4 ? 2 : (n3 > 1 ? 1 : 0));
        this.println(string2 + " Args=" + n7 + " Locals=" + this.methodLocals + " Stack=" + this.methodStack + " slot=" + n8);
        if (n8 > 0) {
            Convert.packL((byte[])this.dbuf, (int)(this.codeBase + n8 * 4), (int)(n6 << 0 | n9 << 14 | n5 << 16 | n7 << 28));
        }
        while ((this.codeLen & 3) != 0) {
            ++this.codeLen;
        }
        return n2;
    }

    private int getAttribute(int n, byte[] byArray, int n2, boolean bl) {
        short s = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
        int n3 = Convert.unpackL((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
        int n4 = (n2 += 4) + n3;
        this.vprint("Attribute#" + n + " name=" + this.getC(s) + " off=" + this.codeLen + " len=" + n3);
        if (bl) {
            this.methodStack = Convert.unpackI((byte[])byArray, (int)n2, (byte)this.rep);
            this.methodLocals = Convert.unpackI((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
            int n5 = Convert.unpackL((byte[])byArray, (int)(n2 += 2), (byte)this.rep);
            int n6 = n2 += 4;
            int n7 = this.codeLen + n5;
            this.vprint(" codeLen=" + n5);
            if (n7 > this.maxBytes) {
                this.M.error("Too large of code section=" + n7 + ", max=" + this.maxBytes);
            }
            System.arraycopy(byArray, n6, this.dbuf, this.codeLen, n5);
            this.codeLen = n7;
        }
        this.vprintln("");
        return n4;
    }

    private int getNArgs(String string) {
        char c;
        int n = 0;
        for (int i = 0; i < string.length() && (c = string.charAt(i)) != ')'; ++i) {
            ++n;
            if (c == '(') {
                n = 0;
            }
            if (c != 'L') continue;
            i = string.indexOf(59, i);
        }
        return n;
    }

    private void getCode(byte[] byArray, int n, int n2, byte[] byArray2) {
        OpCode opCode = null;
        int n3 = n;
        while (n3 < n + n2) {
            int n4;
            int n5;
            int n6;
            int n7 = byArray[n3] & 0xFF;
            OpCode opCode2 = this.joc[n7];
            if (opCode2 == null) {
                this.M.error("Unhandled Java Byte Code = " + n7);
            }
            if (opCode2.niy) {
                this.M.warning((CharSequence)("Uses unimplemented Java Byte Code " + n7 + " = " + opCode2.name));
            } else if (byArray2 != null && !opCode2.name.equals("nop")) {
                byArray2[n3] = 1;
            }
            OpCode opCode3 = (OpCode)this.bcTab.get(opCode2.name + "_quick");
            Object object = this.lnTab.get("" + n3);
            if (object != null) {
                this.vprintln(object.toString());
            }
            int n8 = n3;
            int n9 = n3 - n;
            String string = Convert.l2x((int)n3).substring(6);
            String string2 = Convert.l2x((int)n7).substring(8);
            this.vprint(" " + string + " " + n9 + " " + string2 + " " + opCode2.name);
            short s = Convert.unpackI((byte[])byArray, (int)(++n3), (byte)this.rep);
            if (opCode2.args == 2) {
                Convert.swap2((byte[])byArray, (int)n3, (int)1);
            }
            if (opCode2.args == 4) {
                Convert.swap4((byte[])byArray, (int)n3, (int)1);
            }
            if (opCode2.args > 0) {
                this.vprint(" " + Convert.bb2hex((byte[])byArray, (int)n3, (int)opCode2.args));
                n3 += opCode2.args;
            }
            if (opCode2.name.startsWith("goto") || opCode2.name.startsWith("if")) {
                this.vprint(" (line=" + (n9 + s) + ")");
                Convert.packI((byte[])byArray, (int)(n3 - 2), (short)((short)(n + n9 + s)));
            } else if (opCode2.name.startsWith("new")) {
                Data data = (Data)this.jcp[s].value;
                this.vprint(" (" + this.getC(data.getI(0)) + ")");
            } else if ((opCode2.inst1 & PSEUDO) == PSEUDO) {
                String string3 = "_" + opCode2.name;
                n6 = this.refTab.getL(string3);
                if (n6 == 0) {
                    this.M.warning((CharSequence)(" (Pseudo Method not found for " + string3 + " slot)"));
                }
                int n10 = n8;
                byArray2[n10] = (byte)(byArray2[n10] | 4);
                this.dbuf[n8] = (byte)n6;
            } else if (opCode2.name.startsWith("invoke") && s == 0) {
                this.vprint(" (Method not found at line=" + n3 + ")");
            } else if (opCode2.name.startsWith("invoke")) {
                Data data = (Data)this.jcp[s].value;
                Data data2 = (Data)this.jcp[data.getI((int)1)].value;
                String string4 = this.getC(data2.getI(0));
                String string5 = this.getC(data2.getI(1));
                n5 = this.refTab.getL(string4);
                this.vprint(" (" + string5 + " " + string4 + ") S:" + n5);
                if (string4.equals("getObjectAt") && string5.equals("(I)Ljava/lang/Object;")) {
                    byArray[n3 - 1] = 0;
                    byArray[n3 - 2] = 0;
                    byArray[n3 - 3] = 0;
                } else if (n5 <= 0) {
                    this.M.warning((CharSequence)("No Constant Pool entry for method=" + string4));
                } else if (s > 255) {
                    this.M.warning((CharSequence)("Method offset=" + s + " too large for method=" + string4));
                } else {
                    byArray[n3 - 2] = (byte)n5;
                }
            } else if (opCode2.name.startsWith("iinc")) {
                Convert.swap2((byte[])byArray, (int)(n3 - 2), (int)1);
            } else if (opCode2.name.startsWith("ldc")) {
                int n11 = this.b2l(byArray[n3 - 1]);
                if (n11 <= 0) {
                    this.M.error("No Constant Pool entry for constant=" + n11);
                }
                this.vprint(" (" + Convert.l2x((int)Convert.o2l((Object)this.jcp[n11].value)) + ")");
                byArray[n3 - 1] = (byte)this.jcp[n11].slot;
                byArray[n3 - 2] = opCode3.bc;
            } else if (opCode2.name.endsWith("load") || opCode2.name.endsWith("store")) {
                int n12 = this.b2l(byArray[n3 - 1]);
                if (n12 > 63) {
                    System.out.println(" ERR: load/store offset " + n12 + " out of range");
                }
            } else if (opCode2.name.startsWith("get") || opCode2.name.startsWith("put")) {
                int n13;
                Data data = (Data)this.jcp[s].value;
                Data data3 = (Data)this.jcp[data.getI((int)1)].value;
                Data data4 = (Data)this.jcp[data.getI((int)0)].value;
                String string6 = this.getC(data4.toL());
                String string7 = this.getC(data3.getI(0));
                String string8 = this.getC(data3.getI(1));
                n4 = string6.lastIndexOf("/");
                String string9 = string6.substring(n4 + 1) + "." + string7;
                boolean bl = opCode2.name.startsWith("get");
                int n14 = opCode3.bc;
                int n15 = 0;
                byte by = 0;
                if (opCode2.name.indexOf("static") > 0) {
                    int n16 = n13 = bl ? -2 : -1;
                    if (this.specialStatic(string7) > 0) {
                        if (string7.equals("ioadr")) {
                            n14 = n13;
                            n15 = 2;
                        }
                        if (string7.equals("saddr")) {
                            n14 = n13;
                            n15 = 2;
                        }
                        if (string7.equals("sdata")) {
                            n14 = n13;
                            int n17 = n15 = bl ? 8 : 4;
                        }
                        if (string7.equals("ioctl")) {
                            n14 = n13;
                            n15 = 16;
                        }
                        if (string7.equals("maddr")) {
                            n14 = n13;
                            n15 = 32;
                            this.memMode = 1;
                        }
                        if (string7.equals("mdata")) {
                            n14 = n13;
                            int n18 = n15 = bl ? -128 : 64;
                            if (this.memMode != 1) {
                                this.M.error("Cannot mix maddr access modes. Check mdata = class.field combo.");
                            }
                        }
                        this.vprint(" (" + string8 + " " + string9 + ")");
                    } else {
                        int n19 = this.refTab.getL(string7);
                        if (n19 > 0) {
                            n15 = (byte)n19;
                        } else {
                            this.M.warning((CharSequence)("No Constant Pool entry for static field=" + string7));
                        }
                        if (n19 > 255) {
                            this.M.error("Too many static variables=" + n19 + ". Max=256.");
                        }
                        this.vprint(" (" + string8 + " " + string9 + " off=" + n15 + ")");
                    }
                } else {
                    int n20 = n15 = bl ? -96 : 97;
                    if (this.foTab.get(string9.toUpperCase()) == null) {
                        this.M.warning((CharSequence)("Field=" + string9 + " not defined in jvmfields"));
                    }
                    n13 = this.foTab.getL(string9.toUpperCase());
                    this.vprint(" (" + string8 + " " + string9 + " off=" + n13 + ")");
                    by = (byte)(n13 >= 128 ? n13 - 256 : n13);
                    this.memMode = 0;
                }
                byArray[n3 - 3] = n14;
                byArray[n3 - 2] = n15;
                byArray[n3 - 1] = by;
            } else if (opCode2.name.startsWith("tableswitch")) {
                while ((n3 - n & 3) != 0) {
                    ++n3;
                }
                Convert.swap4((byte[])byArray, (int)n3, (int)3);
                int n21 = Convert.unpackL((byte[])byArray, (int)n3);
                n6 = Convert.unpackL((byte[])byArray, (int)(n3 += 4));
                int n22 = Convert.unpackL((byte[])byArray, (int)(n3 += 4));
                int n23 = n22 - n6 + 1;
                Convert.swap4((byte[])byArray, (int)(n3 += 4), (int)n23);
                for (n5 = n8 + 1; n5 < n3; ++n5) {
                    byArray[n5] = 0;
                }
                byArray[n8 + 1] = (byte)(n6 - 1);
                byArray[n8 + 2] = (byte)n23;
                Convert.packI((byte[])byArray, (int)(n8 + 3), (short)((short)(n3 - 4)));
                n3 -= 4;
                this.vprint(" (" + n21 + "," + n6 + "," + n22 + ")");
                if (n6 < 0 || n6 > 127) {
                    this.M.warning((CharSequence)("Table switch low index=" + n6 + " out of range (0<=N<128)"));
                }
                if (n22 < 0 || n22 > 127) {
                    this.M.warning((CharSequence)("Table switch high index=" + n22 + " out of range (0<=N<128)"));
                }
                for (n5 = -1; n5 < n23; ++n5) {
                    int n24 = n5 < 0 ? n21 : Convert.unpackL((byte[])byArray, (int)n3);
                    int n25 = n4 = n8 + n24;
                    this.vprint("\n      " + (n3 - n) + "  " + n5 + ": " + n24 + " (line=" + Convert.l2x((int)n25) + " @ " + Convert.l2x((int)n3));
                    Convert.packL((byte[])byArray, (int)n3, (int)n25);
                    n3 += 4;
                }
            } else if (opCode2.name.startsWith("lookupswitch")) {
                while ((n3 - n & 3) != 0) {
                    ++n3;
                }
                Convert.swap4((byte[])byArray, (int)n3, (int)2);
                int n26 = Convert.unpackL((byte[])byArray, (int)n3);
                n6 = Convert.unpackL((byte[])byArray, (int)(n3 += 4));
                this.vprint(" (" + n26 + "," + n6 + ")");
                Convert.swap4((byte[])byArray, (int)(n3 += 4), (int)(n6 * 2));
                for (int i = 0; i < n6; ++i) {
                    int n27 = Convert.unpackL((byte[])byArray, (int)n3);
                    n5 = Convert.unpackL((byte[])byArray, (int)(n3 + 4));
                    this.vprint("\n      " + (n3 - n) + "  " + n27 + ": " + n5 + " (line=" + (n9 + n5) + ")");
                    n3 += 8;
                }
            }
            opCode = opCode2;
            if (!this.v2) continue;
            this.vprintln("");
        }
    }

    private int specialStatic(String string) {
        if (string.equals("saddr") || string.equals("sdata")) {
            return 1;
        }
        if (string.equals("ioadr") || string.equals("ioctl")) {
            return 2;
        }
        if (string.equals("maddr") || string.equals("mdata")) {
            return 3;
        }
        return 0;
    }

    private int b2l(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    private int runjvmcore() {
        DataFile dataFile = this.MA.getDataFile("JLF", "1000", "SI", 0);
        dataFile.open(1);
        int n = (int)dataFile.getSize();
        Data data = dataFile.getDataBuffer(n);
        dataFile.read(data);
        dataFile.close();
        int n2 = this.MA.getL("/FLAGS");
        this.core = Core.forName("JVM", this.MA);
        this.core.set("FLAGS", n2);
        this.core.set("CODE", data);
        this.core.open();
        this.testop(1, "+", 456, 123, 579);
        this.testop(2, "-", 456, 123, 333);
        this.testop(3, "*", 456, 123, 56088);
        this.testop(4, "/", 45600, 123, 370);
        this.testop(5, "<<", 42405, 4, 678480);
        this.testop(6, ">>", 42405, 4, 2650);
        this.testop(7, "&", 42405, -252645376, 40960);
        this.testop(8, "|", 42405, -252645376, -252643931);
        this.testop(9, "^", 42405, -252645376, -252684891);
        this.testop(10, "++", 123, 456, 579);
        this.testop(11, "LS+", 123, 234, 357);
        this.testop(100, "?", 456, 123, 999);
        this.testop(512, "?", 456, 123, 999);
        if (this.MA.getState("/IO")) {
            this.testop(12, "IOr", 64, 256, 64);
            this.testop(12, "IOr", 32, 320, 32);
            this.testop(12, "IOr", 16, 384, 16);
            this.testop(12, "IOr", 4, 448, 4);
            this.testop(13, "IOw", 64, 256, 64);
            this.testop(13, "IOw", 32, 320, 32);
            this.testop(13, "IOw", 16, 384, 16);
            this.testop(13, "IOw", 4, 448, 4);
        }
        this.core.close();
        return 9;
    }

    private void testop(int n, String string, int n2, int n3, int n4) {
        boolean bl;
        this.core.set("DATA1", n2);
        this.core.set("DATA2", n3);
        this.core.set("OPCODE", n);
        while (this.core.getL("OPCODE") > 0) {
        }
        int n5 = this.core.getL("DATA3");
        boolean bl2 = bl = n >= 5 && n <= 9;
        if (bl) {
            this.MT.write((CharSequence)("Op " + n + " :  " + Convert.l2x((int)n2) + " " + string + " " + Convert.l2x((int)n3) + " = " + Convert.l2x((int)n5)));
        } else {
            this.MT.write((CharSequence)("Op " + n + " :  " + n2 + " " + string + " " + n3 + " = " + n5));
        }
        if (n5 == n4) {
            this.MT.writeln((CharSequence)"");
        } else if (bl) {
            this.MT.writeln((CharSequence)("   expect=" + Convert.l2x((int)n4)));
        } else {
            this.MT.writeln((CharSequence)("   expect=" + n4));
        }
    }

    private class OpCode {
        String name;
        int code;
        int args;
        int inst1;
        int inst2;
        boolean niy;
        byte bc;

        public OpCode(String string) {
            OpCode opCode;
            Parser parser = new Parser(string, true, false);
            this.code = Convert.s2l((String)parser.get(1)) & 0xFF;
            this.args = Convert.s2l((String)parser.get(3));
            this.name = parser.get(4);
            this.inst1 = this.parse(parser.get(5));
            this.inst2 = this.parse(parser.get(6));
            boolean bl = this.niy = parser.get(5).length() + parser.get(6).length() == 0;
            if (this.name.endsWith("_quick") && (opCode = (OpCode)icejvm.this.bcTab.get(this.name.substring(0, this.name.length() - 6))) != null) {
                this.inst1 = opCode.inst1;
                this.inst2 = opCode.inst2;
                this.bc = opCode.bc;
            }
            this.bc = (byte)(this.code >= 128 ? this.code - 256 : this.code);
            if (icejvm.this.joc[this.code] != null) {
                icejvm.this.M.error("Overwriting " + icejvm.this.joc[this.code] + " with " + this);
            }
            icejvm.this.joc[this.code] = this;
            icejvm.this.bcTab.put(this.name, (Object)this);
        }

        public String toString() {
            return "OpCode=" + this.code + " Name=" + this.name + " Args=" + this.args + " Inst=" + Convert.l2x((int)this.inst1);
        }

        private int parse(String string) {
            int n = 0;
            if (string == null) {
                return 0;
            }
            string = "|" + string + "|";
            int n2 = this.find(string, "PSET", 0);
            if (n2 > 0) {
                n |= 1;
            }
            if ((n2 = this.find(string, "SELX", 0)) > 0) {
                n |= 2;
            }
            if ((n2 = this.find(string, "DUAL", 0)) > 0) {
                n |= 4;
            }
            if ((n2 = this.find(string, "HOLD", 0)) > 0) {
                n |= 8;
            }
            if ((n2 = this.find(string, "MINV", 0)) > 0) {
                n |= 0x10;
            }
            if ((n2 = this.find(string, "MRET", 0)) > 0) {
                n |= 0x20;
            }
            if ((n2 = this.find(string, "TBSW", 0)) > 0) {
                n |= 0x40;
            }
            if ((n2 = this.find(string, "FRMAX", 0)) > 0) {
                n |= 0x700;
            } else {
                n2 = this.find(string, "FRMA", 9);
                if (n2 != 9) {
                    n |= (n2 & 0xF) << 8;
                } else {
                    n2 = this.find(string, "STKA", 1);
                    if (n2 != 0) {
                        n |= (-n2 & 0xF) << 8;
                    }
                }
            }
            n2 = this.find(string, "FRMBX", 0);
            if (n2 > 0) {
                n |= 0x7000;
            } else {
                n2 = this.find(string, "FRMB", 9);
                if (n2 != 9) {
                    n |= (n2 & 0xF) << 12;
                } else {
                    n2 = this.find(string, "STKB", 3);
                    if (n2 != 0) {
                        n |= (-n2 & 0xF) << 12;
                    }
                }
            }
            n2 = this.find(string, "STKI", 0);
            if (n2 != 0) {
                n |= (n2 & 3) << 16;
            }
            if ((n2 = this.find(string, "STKI", 0)) == 1) {
                n |= 0x1C0080;
            }
            if ((n2 = this.find(string, "STKU", 0)) == 1) {
                n |= 0x10000;
            }
            if ((n2 = this.find(string, "STKD", 0)) != 0) {
                n |= (-n2 & 3) << 16;
            }
            if ((n2 = this.find(string, "STKD", 0)) == 1) {
                n |= 0xC0000;
            }
            if ((n2 = this.find(string, "WSTKA", 0)) > 0) {
                n |= 0x40000;
            }
            if ((n2 = this.find(string, "WSTKB", 0)) > 0) {
                n |= 0x80000;
            }
            if ((n2 = this.find(string, "WRAMA", 0)) > 0) {
                n |= 0x100000;
            }
            if ((n2 = this.find(string, "WRAMB", 0)) > 0) {
                n |= 0x200000;
            }
            if ((n2 = this.find(string, "WRAMC", 0)) > 0) {
                n |= 0x400000;
            }
            if ((n2 = this.find(string, "ALT", 0)) > 0) {
                n |= 0x800000;
            }
            if ((n2 = this.find(string, "SELB", "RAMB,STKA")) == 1) {
                n |= 0x80;
            }
            if ((n2 = this.find(string, "SELA", "RAMA,RAMB,RAMC,RAMX,STKB,PUSH,RSHF,LSHF,TBD,AND,ROR,XOR,NEG,SUB,ADD,MUL")) >= 0) {
                n |= n2 << 24;
            }
            if ((n2 = this.find(string, "OPTS", 0)) > 0) {
                n |= n2 << 28;
            }
            if ((n2 = this.find(string, "COND", "H,L,EQ,EQZ,LT,LTZ,GT,GTZ,NH,NL,NE,NEZ,GE,GEZ,LE,LEZ")) >= 0) {
                n |= n2 << 28;
            }
            if ((n2 = this.find(string, "CVT", "I2L,I2F,I2D,L2I,L2F,L2D,F2I,F2L,F2D,D2I,D2L,D2F,I2B,I2C,I2S")) >= 0) {
                n |= n2 << 28;
            }
            return n;
        }

        private int find(String string, String string2, int n) {
            string2 = "|" + string2;
            int n2 = string2.length();
            int n3 = string.indexOf(string2);
            if (n3 < 0) {
                return n;
            }
            int n4 = string.indexOf("|", n3 + 1);
            if (n3 + n2 + 1 >= n4) {
                return 1;
            }
            return Convert.s2l((String)string.substring(n3 + n2 + 1, n4));
        }

        private int find(String string, String string2, String string3) {
            string2 = "|" + string2;
            int n = string2.length();
            int n2 = string.indexOf(string2);
            if (n2 < 0) {
                return -1;
            }
            int n3 = string.indexOf("|", n2 + 1);
            if (n2 + n + 1 == n3) {
                return -1;
            }
            return Parser.find((String)string3, (String)string.substring(n2 + n + 1, n3), (int)0, (int)-1);
        }
    }

    private class ConstantPool {
        byte tag;
        int len;
        int size;
        int slot = 0;
        int slots = 1;
        int offset;
        String type;
        Object value;
        String name;

        public ConstantPool(byte[] byArray, int n) {
            int n2 = n;
            this.tag = byArray[n++];
            switch (this.tag) {
                case 1: {
                    this.type = "Utf8  ";
                    this.len = Convert.unpackI((byte[])byArray, (int)n, (byte)icejvm.this.rep);
                    this.value = new String(byArray, n += 2, this.len);
                    break;
                }
                case 3: {
                    this.type = "Int   ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SL");
                    break;
                }
                case 4: {
                    this.type = "Float ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SF");
                    break;
                }
                case 5: {
                    this.type = "Long  ";
                    this.len = 8;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SX");
                    this.slots = 2;
                    break;
                }
                case 6: {
                    this.type = "Double";
                    this.len = 8;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SD");
                    this.slots = 2;
                    break;
                }
                case 7: {
                    this.type = "Class ";
                    this.len = 2;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SI");
                    break;
                }
                case 8: {
                    this.type = "String";
                    this.len = 2;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)1, (String)"SI");
                    break;
                }
                case 9: {
                    this.type = "Field ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)2, (String)"SI");
                    break;
                }
                case 10: {
                    this.type = "Method";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)2, (String)"SI");
                    break;
                }
                case 11: {
                    this.type = "InterF";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)2, (String)"SI");
                    break;
                }
                case 12: {
                    this.type = "NaType";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])byArray, (byte)icejvm.this.rep, (int)n, (int)2, (String)"SI");
                    break;
                }
                default: {
                    System.out.println("Unknown tag=" + this.tag);
                    this.len = -1;
                }
            }
            this.size = n + this.len - n2;
        }

        public int getI(int n) {
            return ((Data)this.value).getI(n);
        }

        public String getS() {
            return this.value.toString();
        }

        public String toString() {
            String string = " type=" + this.type + " value=" + this.value;
            if (this.name != null) {
                string = string + " name=" + this.name;
            }
            if (this.slot != 0) {
                string = string + " slot=" + this.slot;
            }
            return string;
        }
    }
}

