/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import nxm.ice.lib.IceSys;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class HSystem
extends HSource {
    private Midas M;

    public HSystem(String string, Midas midas) {
        this.M = midas;
        this.name = string + "/";
    }

    @Override
    public void handleRequest(String string, HPage hPage) {
        String string2 = string.substring(this.name.length() + 1);
        if (string2.startsWith("Get?")) {
            this.getPage(string2.substring(4), hPage);
        } else if (string2.startsWith("Set?")) {
            this.setPage(string2.substring(4), hPage);
        } else if (string2.startsWith("Cmd?")) {
            this.cmdPage("Cmd", string2.substring(4), hPage);
        } else if (string2.startsWith("Top")) {
            this.cmdPage("Top", "top -n 1 -b", hPage);
        } else if (string2.startsWith("Log")) {
            int n = string2.endsWith("Tail") ? 512 : 8100;
            this.cmdPage("Log", "dmesg -s " + n, hPage);
        } else if (string2.startsWith("Disks")) {
            this.diskPage("ALL", hPage);
        } else if (string2.startsWith("DiskStats/")) {
            String string3 = string2.substring(10);
            this.diskPage(string3, hPage);
        } else if (string2.startsWith("Ice-Driver")) {
            this.cmdPage(string2, "cat /proc/driver/icepic", hPage);
        } else if (string2.startsWith("Ice-Version")) {
            this.cmdPage(string2, "/opt/ice/pkg/icexxx/jre/ice version", hPage);
        } else if (string2.startsWith("Ice-Health")) {
            this.cmdPage(string2, "cat /var/log/icehealth.log", hPage);
        } else if (string2.startsWith("Ice-PICs")) {
            this.tablePage(string2, IceSys.getPICs(), hPage);
        } else if (string2.startsWith("Ice-NICs")) {
            this.tablePage(string2, IceSys.getNICs(), hPage);
        } else if (string2.startsWith("Ice-Disks")) {
            this.tablePage(string2, IceSys.getDisks(), hPage);
        } else {
            this.optPage(hPage);
        }
    }

    public void getPage(String string, HPage hPage) {
        Object object = this.M.results.get(string);
        hPage.open();
        hPage.writeln(string + "=" + object);
        hPage.close();
    }

    public void setPage(String string, HPage hPage) {
        int n = string.indexOf("=");
        if (n > 0) {
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            this.M.results.setKey(string, (Object)string2);
        }
        this.getPage(string, hPage);
    }

    public void cmdPage(String string, String string2, HPage hPage) {
        byte[] byArray = new byte[8192];
        string2 = StringUtil.replaceAll((String)string2, (String)"%20", (String)" ");
        string2 = StringUtil.replaceAll((String)string2, (String)"%22", (String)"\"");
        string2 = StringUtil.replaceAll((String)string2, (String)"%27", (String)"'");
        int n = IceSys.runCommand(string2, 0, byArray);
        boolean bl = string.endsWith(".tbl");
        if (bl) {
            hPage.open();
            Table table = this.textToTable(byArray, n);
            hPage.write(table.toString());
            hPage.close();
        } else {
            hPage.openToBody("HSystem Cmd Page");
            hPage.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Cmd=" + string + "</a></h3>");
            hPage.writeln("<br><pre>");
            hPage.write(byArray, 0, n);
            hPage.writeln("</pre>");
            hPage.closeFromBody();
        }
    }

    private String trim(String string) {
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private Table textToTable(byte[] byArray, int n) {
        Table table = new Table();
        String string = new String(byArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string2;
            String string3;
            int n3 = string.indexOf("\n", n2);
            if (n3 < 0) {
                n3 = n;
            }
            String string4 = string.substring(n2, n3);
            int n4 = string4.indexOf("=");
            Parser parser = new Parser(string4, ',', true);
            String string5 = parser.get(1);
            String string6 = parser.get(2);
            if (string6.equals(":")) {
                string3 = this.trim(parser.get(1));
                string2 = this.trim(parser.get(3));
                object = null;
                if (string2.indexOf(61) < 0) {
                    object = Convert.s2o((String)string2, (String)"_", (Object)this.M);
                } else {
                    String string7 = string2;
                    for (int i = 4; i <= parser.elements(); ++i) {
                        string2 = parser.get(i);
                        int n5 = string2.indexOf(61);
                        if (n5 <= 0) continue;
                        string7 = string7 + "," + string2;
                    }
                    object = new Table("{" + string7 + "}");
                }
                table.put(string3, object);
            } else if (string5.endsWith(":")) {
                string5 = string5.substring(0, string5.length() - 1);
                string3 = this.trim(string5);
                string2 = this.trim(string6);
                object = Convert.s2o((String)string2, (String)"_", (Object)this.M);
                table.put(string3, object);
            } else if (n4 > 0) {
                string3 = this.trim(string4.substring(0, n4));
                string2 = this.trim(string4.substring(n4 + 1));
                table.put(string3, (Object)string2);
            }
            n2 = n3 + 1;
        }
        return table;
    }

    public void tablePage(String string, Table table, HPage hPage) {
        boolean bl = string.endsWith(".tbl");
        if (bl) {
            hPage.open();
            hPage.write(table.toString());
            hPage.close();
        } else {
            hPage.openToBody("HSystem " + string + " Page");
            hPage.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">" + string + "</a></h3>");
            hPage.writeln("<br><pre>");
            for (String string2 : table) {
                Object object = table.get(string2);
                hPage.writeln(string2 + "=" + object);
            }
            hPage.writeln("</pre>");
            hPage.closeFromBody();
        }
    }

    public void diskPage(String string, HPage hPage) {
        hPage.openToBody("HSystem Disk Page");
        hPage.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Aux=" + string + " Disk Stats</a></h3>");
        String string2 = string;
        if (string.equals("ALL")) {
            string2 = this.M.results.getS("AUX.READ");
        }
        String[] stringArray = StringUtil.cleanSplit((String)string2, (String)"|");
        hPage.writeln("<table border='1' cellpadding='2' cellspacing='2' align='left'>");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            String string3 = this.M.io.getAuxPath(string);
            Table table = OS.getStatFS((String)string3);
            hPage.writeln("<tr>");
            hPage.writeln("<td>Aux   = " + string + "</td>");
            hPage.writeln("<td>Path  = " + string3 + "</td>");
            if (table != null) {
                hPage.writeln("<td>Files = " + table.getL("FILES") + "</td>");
                hPage.writeln("<td>Total = " + table.getL("TMBY") + " Mby</td>");
                hPage.writeln("<td>Free  = " + table.getL("FMBY") + " Mby</td>");
                hPage.writeln("<td>Used  = " + table.getL("USED") + "%</td>");
            }
            hPage.writeln("</tr>");
        }
        hPage.closeFromBody();
    }

    public void optPage(HPage hPage) {
        hPage.openToBody("HSystem Options Page");
        hPage.writeln("<center><h2>NeXtMidas System Information</h2></center>");
        hPage.writeln("<ul>");
        hPage.writeln("<li><a href='/nmroot/index.html'>JavaDocs</a> - System tree documentation</li>");
        hPage.writeln("<li><a href='LogTop'>System Log</a> - Top of System Log File</li>");
        hPage.writeln("<li><a href='LogTail'>System Log</a> - Tail of System Log File</li>");
        hPage.writeln("<li><a href='LogAll'>System Log</a> - All of System Log File</li>");
        hPage.writeln("<li><a href='TopCPU'>Top CPU/Mem</a> - List of Top CPU/Memory Processes on Server</li>");
        hPage.writeln("<li><a href='Disks'>Disk Aux=ALL</a> - All Disks Statistics</li>");
        hPage.writeln("<li><a href='Ice-Version'>Ice-Version</a> - ICE Software Version</li>");
        hPage.writeln("<li><a href='Ice-Driver'>Ice-Driver</a> - ICE Driver Statistics</li>");
        hPage.writeln("<li><a href='Ice-Health'>Ice-Health</a> - ICE Block Health and Status</li>");
        hPage.writeln("<li><a href='Ice-Disks'>Ice-Disks</a> - ICE Disk Statistics</li>");
        hPage.writeln("<li><a href='Ice-PICs'>Ice-PICs</a> - ICE PIC Card Statistics</li>");
        hPage.writeln("<li><a href='Ice-NICs'>Ice-NICs</a> - ICE Network Card Statistics</li>");
        hPage.writeln("</ul>");
        hPage.closeFromBody();
    }
}

