/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipEntry;
import nxm.ice.net.HFile;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.HttpResource;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TarFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.ZipFile;

public class HFiles
extends HSource {
    private String dirpath;
    private Midas M;
    private Parser auxes;
    private Date startDate;
    private static boolean debug = false;

    public HFiles(String string, String string2) {
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + '/';
        }
        this.name = string;
        this.dirpath = string2;
        this.startDate = new Date();
        if (debug) {
            Shell.writeln((CharSequence)("HFiles() name=" + string + " dirpath=" + string2 + " startDate=" + this.startDate));
        }
    }

    public HFiles(String string, Midas midas, String string2) {
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        this.name = string;
        this.M = midas;
        this.startDate = new Date();
        if (string2 == null || string2.length() == 0 || string2.equals("*")) {
            string2 = midas.results.getString("AUX.READ");
        }
        this.auxes = new Parser(string2, '|');
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean isDebug() {
        return debug;
    }

    @Override
    public boolean handleHeadRequest() {
        return true;
    }

    @Override
    public void handleRequest(String string, HPage hPage) {
        Object object;
        String string2 = this.getName();
        String string3 = string.substring(string2.length());
        File file = null;
        if (debug) {
            Shell.writeln((CharSequence)("HFiles.handleRequest() " + hPage.getMethod() + " uri=" + string + " path=" + string3));
        }
        String string4 = null;
        int n = string3.indexOf(63);
        if (n > 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if (this.dirpath != null) {
            if (string3.equals("") || string3.endsWith("/")) {
                string3 = string3 + "index.html";
            }
            if (!((File)(object = new File(string3 = this.dirpath + string3))).exists()) {
                file = ((File)object).getParentFile();
            }
        } else {
            if (string3.equals("")) {
                this.framesPage(hPage);
                return;
            }
            if (string3.startsWith("auxesPage.html")) {
                this.auxesPage(hPage);
                return;
            }
            if (string3.startsWith("filesPage.html")) {
                if (string4 == null) {
                    this.dummyPage(hPage);
                } else {
                    this.filesPage(hPage, string4);
                }
                return;
            }
            if (string3.startsWith("fdataPage.html")) {
                if (string4 == null) {
                    this.dummyPage(hPage);
                } else {
                    this.fdataPage(hPage, string4);
                }
                return;
            }
            n = string3.indexOf(47);
            string2 = string3.substring(n + 1);
            if (n > 0) {
                object = string3.substring(0, n).toUpperCase();
                string3 = this.M.io.getAuxPath((String)object) + string2;
                if (((String)object).equals("*")) {
                    string3 = string2;
                }
            } else {
                string3 = string2;
            }
            if (string3.endsWith("/")) {
                file = new File(string3);
            }
        }
        if (file != null) {
            object = string3.substring(0, string3.indexOf(58) + 1).toLowerCase();
            if (((String)object).equals("jar:") || ((String)object).equals("tar:") || ((String)object).equals("zip:")) {
                this.containerIndexPage(hPage, string3, string);
            } else if (((String)object).equals("http:")) {
                this.webIndexPage(hPage, string3, string);
            } else {
                this.indexPage(hPage, file, string);
            }
        } else if (string3.startsWith("ram:_")) {
            int n2 = string3.indexOf(46);
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            DataFile dataFile = new DataFile((MidasReference)this.M, (Object)string3);
            HFile.handlePipe(dataFile, hPage);
        } else {
            int n3;
            if (string3.startsWith("ram:") && (n3 = string3.indexOf(46)) > 0) {
                string3 = string3.substring(0, n3);
            }
            if (string4 != null) {
                this.execArgs(string4);
            }
            BaseFile baseFile = new BaseFile((MidasReference)this.M, (Object)string3);
            HFile.handle(baseFile, hPage, string4);
        }
    }

    private void execArgs(String string) {
        if (this.server == null) {
            return;
        }
        Midas midas = this.server.getMidas();
        if (midas == null) {
            return;
        }
        int n = string.indexOf(61);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = string2.indexOf(46);
        if (n2 < 0 && midas.macro != null && midas.macro.controls.get(string2) != null) {
            midas.macro.controls.put(string2 + ".ACTION", (Object)string3);
        } else {
            midas.results.put(string2, (Object)string3);
        }
    }

    private void containerIndexPage(HPage hPage, String string, String string2) {
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        String string3 = "";
        int n = string.indexOf(58) + 1;
        String string4 = string.substring(0, n).toLowerCase();
        int n2 = string.indexOf(33);
        string3 = n2 > 0 ? string.substring(n, n2) : string.substring(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = string4.equals("tar:");
        String string5 = string.substring(string.indexOf(33) + 1);
        if (string5 == null) {
            string5 = "";
        }
        while (string5.length() > 0 && string5.charAt(0) == '/') {
            string5 = string5.substring(1);
        }
        TarFile tarFile = bl ? new TarFile((MidasReference)this.M, (Object)string3) : new ZipFile((MidasReference)this.M, (Object)string3);
        tarFile.open();
        Object[] objectArray = tarFile.getEntries();
        tarFile.close();
        if (objectArray != null) {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
            String string6 = "";
            String string7 = "0";
            MFormat mFormat = MFormat.getByteFormat();
            for (Object object : objectArray) {
                ZipEntry zipEntry;
                if (object instanceof ZipEntry) {
                    zipEntry = (ZipEntry)object;
                    string6 = this.scrubEntryName(zipEntry.getName(), string5);
                    if (string6.equals("")) continue;
                    string7 = mFormat.format((Object)zipEntry.getSize());
                    date.setTime(zipEntry.getTime());
                } else {
                    if (!(object instanceof TarFile.TarEntry) || (string6 = this.scrubEntryName((zipEntry = (TarFile.TarEntry)object).getName(), string5)).equals("")) continue;
                    string7 = mFormat.format((Object)zipEntry.getSize());
                    date.setTime(zipEntry.getTime1970() * 1000L);
                }
                arrayList.add("<a href='" + string6 + "'>" + string6 + "</a>" + StringUtil.padRight((String)"", (int)(30 - string6.length())) + " " + simpleDateFormat.format(date) + StringUtil.padLeft((String)string7, (int)4));
            }
        }
        this.writeIndexPage(hPage, arrayList, string2);
    }

    private void webIndexPage(HPage hPage, String string, String string2) {
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.M.io.listFiles((Object)string, null);
        HttpResource httpResource = (HttpResource)this.M.io.findResource((Object)string, -1);
        if (stringArray != null && httpResource != null) {
            String string3 = "0";
            MFormat mFormat = MFormat.getByteFormat();
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
            for (String string4 : stringArray) {
                IOResource iOResource = this.M.io.findResource((Object)(string + string4), -1);
                if (iOResource == null) continue;
                iOResource.open();
                date.setTime(iOResource.lastModified());
                string3 = mFormat.format((Object)iOResource.getLength());
                arrayList.add("<a href='" + string4 + "'>" + string4 + "</a>" + StringUtil.padRight((String)"", (int)(30 - string4.length())) + " " + simpleDateFormat.format(date) + StringUtil.padLeft((String)string3, (int)4));
                iOResource.close();
            }
        }
        this.writeIndexPage(hPage, arrayList, string2);
    }

    private String scrubEntryName(String string, String string2) {
        if (string.startsWith(string2)) {
            if ((string = string.substring(string2.length())).length() == 0 || string.equals("")) {
                return "";
            }
            if (string.indexOf(47) != -1 && string.indexOf(47) != string.length() - 1) {
                return "";
            }
            return string;
        }
        return "";
    }

    private void writeIndexPage(HPage hPage, ArrayList<String> arrayList, String string) {
        if (arrayList.size() == 0) {
            hPage.openToBody("File Not Found");
            hPage.writeln("  <h1>File Not Found: " + string + "</h1>");
            hPage.closeFromBody();
            return;
        }
        Collections.sort(arrayList);
        hPage.openToBody("Index of " + string);
        hPage.writeln("  <h1>Index of " + string + "</h1>");
        hPage.writeln("  <pre>");
        for (int i = 0; i < arrayList.size(); ++i) {
            hPage.writeln(arrayList.get(i));
        }
        hPage.writeln("  </pre>");
        hPage.closeFromBody();
    }

    public void framesPage(HPage hPage) {
        hPage.setLastModified(this.startDate);
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        hPage.open();
        hPage.writeln("<html>");
        hPage.writeln("<head>");
        hPage.writeln("<title>HFiles Frame</title>");
        hPage.writeln("</head>");
        hPage.writeln("<frameset cols='25%,75%'>");
        hPage.writeln("<frameset rows='30%,70%'>");
        hPage.writeln("<frame src='auxesPage.html' name='auxesFrame'>");
        hPage.writeln("<frame src='filesPage.html' name='filesFrame'>");
        hPage.writeln("</frameset>");
        hPage.writeln("<frame src='fdataPage.html' name='fdataFrame'>");
        hPage.writeln("</frameset>");
        hPage.writeln("</html>");
        hPage.close();
    }

    public void auxesPage(HPage hPage) {
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        hPage.openToBody("HFiles Aux List");
        hPage.writeln("<center><h3>Midas Aux List</h3></center>");
        hPage.writeln("<table border='0' width='100%'>");
        this.auxes.reset();
        while (this.auxes.more()) {
            String string = this.auxes.next();
            String string2 = this.M.io.getAuxPath(string);
            hPage.writeln("<tr><td nowrap><a href='filesPage.html?Aux" + string + "' target='filesFrame'>" + string + "</a></td>");
            hPage.writeln("<td nowrap>" + string2 + "</td></tr>");
        }
        hPage.writeln("</table>");
        hPage.closeFromBody();
    }

    public void filesPage(HPage hPage, String string) {
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        String string2 = string.substring(3);
        String string3 = this.M.io.getAuxPath(string2);
        String[] stringArray = this.M.io.listFiles((Object)string3, "*", "*");
        int n = stringArray != null ? stringArray.length : 0;
        hPage.openToBody("HFiles Aux File List");
        hPage.writeln("<center><b>Aux = " + string2 + "</b></center><br>");
        hPage.writeln("<table border='0' width='100%'><tr><td nowrap>");
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray[i];
            hPage.writeln("<a href='fdataPage.html?" + string2 + "/" + string4 + "&Text' target='fdataFrame'>" + string4 + "</a><br>");
        }
        hPage.writeln("</td></tr></table>");
        hPage.closeFromBody();
    }

    private void indexPage(HPage hPage, File file, String string) {
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            MFormat mFormat = MFormat.getByteFormat();
            Time time = new Time();
            hPage.openToBody("Index of " + string);
            hPage.writeln("  <h1>Index of " + string + "</h1>");
            hPage.writeln("  <pre>");
            for (int i = 0; i < fileArray.length; ++i) {
                time.fromJ1970((double)fileArray[i].lastModified() / 1000.0);
                String string2 = fileArray[i].getName();
                String string3 = mFormat.format((Object)fileArray[i].length());
                String string4 = time.toString("VAX", 0);
                String string5 = string + string2;
                if (fileArray[i].isDirectory()) {
                    string2 = string2 + "/";
                    string5 = string5 + "/";
                }
                if (fileArray[i].isHidden()) continue;
                hPage.writeln("<a href='" + string5 + "'>" + string2 + "</a>" + StringUtil.padRight((String)"", (int)(30 - string2.length())) + " " + string4 + " " + StringUtil.padLeft((String)string3, (int)4));
            }
            hPage.writeln("  </pre>");
            hPage.closeFromBody();
        } else {
            hPage.openToBody("File Not Found");
            hPage.writeln("  <h1>File Not Found: " + string + "</h1>");
            hPage.closeFromBody();
        }
    }

    public void fdataPage(HPage hPage, String string) {
        String string2;
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        int n = string.lastIndexOf(47);
        int n2 = string.indexOf(38, n + 1);
        String string3 = string2 = string.substring(n + 1, n2);
        String string4 = "*";
        if (string.charAt(0) == '/') {
            string4 = string.substring(0, n);
            string3 = string.substring(0, n2);
        } else if (n > 0) {
            string4 = string.substring(0, n).toUpperCase();
            string3 = this.M.io.getAuxPath(string4) + string2;
            if (string4.equals("*")) {
                string3 = string2;
            }
        }
        String string5 = string.substring(n2 + 1);
        FileName fileName = BaseFile.getFileNameFor((MidasReference)this.M, (String)string3);
        BaseFile baseFile = BaseFile.getInstanceFor((MidasReference)this.M, (Object)fileName);
        DataFile dataFile = null;
        baseFile.open();
        if (baseFile instanceof DataFile) {
            dataFile = (DataFile)baseFile;
        }
        hPage.openToBody("HFiles File Data Page");
        hPage.writeln("Aux=<b>" + string4 + "</b>&nbsp;&nbsp; File=<b>" + string2 + "</b>&nbsp;&nbsp; Display=");
        hPage.writeln("<a href='fdataPage.html?" + string4 + "/" + string2 + "&Text'>Text</a>");
        hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&Tail'>Tail</a>");
        if (baseFile instanceof PlotFile) {
            hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&Auto'>Plot</a>");
        }
        if (dataFile != null && dataFile.getType() / 1000 == 1 && dataFile.getFormatType() != 65) {
            hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&FFT'>FFT</a>");
        }
        if (dataFile != null && dataFile.getType() / 1000 == 2) {
            hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&Line'>Line</a>");
            hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&Last'>LastFrame</a>");
        }
        if (dataFile != null && dataFile.getType() / 1000 > 2) {
            hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&Table'>Table</a>");
        }
        hPage.writeln(" - <a href='" + string4 + "/" + string2 + "'>DownLoad</a>");
        hPage.writeln(" - <a href='fdataPage.html?" + string4 + "/" + string2 + "&" + string5 + "'>Refresh</a>");
        hPage.writeln("<br>");
        if (!string5.equals("Load")) {
            if (string5.equals("Text") || string5.equals("Tail")) {
                String string6;
                double d = 0.0;
                PacketHandler packetHandler = null;
                int n3 = 1;
                int n4 = 50;
                int n5 = 80;
                int n6 = 0;
                hPage.writeln("<pre>");
                hPage.writeln(baseFile.listHeader());
                if (dataFile != null) {
                    packetHandler = dataFile.getPacketHandler();
                }
                if (dataFile != null && dataFile.typeClass >= 2) {
                    n5 = 160;
                }
                if (dataFile != null && string5.equals("Tail")) {
                    d = Math.max(0.0, dataFile.getSize() - 20.0);
                }
                n3 = Math.max(1, baseFile.listElementsPerLine(n5, null, n6));
                int n7 = 0;
                while (n7 < n4 && (string6 = baseFile.listElements(d, n3, null, n6)) != null) {
                    if (packetHandler != null && packetHandler.hasHeader()) {
                        hPage.writeln(packetHandler.listHeader());
                    }
                    hPage.write(string6);
                    ++n7;
                    d += (double)n3;
                }
                hPage.writeln("</pre>");
            } else if (string5.equals("Table")) {
                hPage.writeln("<center><table border='2' cellpadding='2' cellspacing='0'>");
                for (double d = 0.0; d < Math.min(100.0, dataFile.size); d += 1.0) {
                    Table table = dataFile.getDataTable(d);
                    Table.Iterator iterator = table.iterator();
                    if (d % 20.0 == 0.0) {
                        hPage.writeln("<tr>");
                        for (n = 0; n < iterator.size; ++n) {
                            hPage.writeln("<td><b>" + iterator.keys[n] + "</b></td>");
                        }
                        hPage.writeln("</tr>");
                    }
                    if (!(d >= 0.0)) continue;
                    hPage.writeln("<tr>");
                    for (n = 0; n < iterator.size; ++n) {
                        hPage.writeln("<td>" + iterator.values[n] + "</td>");
                    }
                    hPage.writeln("</tr>");
                }
                hPage.writeln("</table></center>");
            } else {
                hPage.writeln("<applet codebase='/nmroot' code='nxm.sys.libg.MApplet.class' name='Plot' width='100%' height='96%'>");
                hPage.writeln("<param name='WIN' value='HFILES'>");
                if (string5.equals("Auto")) {
                    hPage.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + string4 + "/" + string2 + "'>");
                }
                if (string5.equals("Line")) {
                    hPage.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + string4 + "/" + string2 + ",TYPE=LINE'>");
                }
                if (string5.equals("Last")) {
                    hPage.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + string4 + "/" + string2 + "(-1:),TYPE=LINE'>");
                }
                if (string5.equals("FFT")) {
                    hPage.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + string4 + "/" + string2 + ",/FFT=4K'>");
                }
                hPage.writeln("</applet>");
            }
        }
        hPage.closeFromBody();
        baseFile.close();
    }

    public void dummyPage(HPage hPage) {
        hPage.setLastModified(this.startDate);
        if (hPage.getMethod().equals("HEAD")) {
            return;
        }
        hPage.openToBody("HFiles Dummy Page<");
        hPage.closeFromBody();
    }
}

