/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.NetIO;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Native;
import nxm.sys.lib.Time;

public class VRTPacket
implements PacketHandler,
Cloneable {
    private int O_HDR = 0;
    private int O_SID = 4;
    private int O_OUID = 8;
    private int O_CID = 12;
    private int O_TSIS = 16;
    private int O_TSFS = 20;
    private int O_TAIL = 28;
    public static int OUID_ICE = 1068407;
    public static int OUID_DIFI = 6971934;
    public static int TSI_NONE = 0;
    public static int TSI_UTC = 1;
    public static int TSI_GPS = 2;
    public static int TSI_POSIX = 3;
    public static int TSF_NONE = 0;
    public static int TSF_CNT = 1;
    public static int TSF_PSEC = 2;
    public static int TSF_FRC = 3;
    public static String flagsList = "TRIM,BIGE,NOID,CTX,NOSID,DIFI";
    public static int FLG_NONE = 0;
    public static int FLG_TRIM = 1;
    public static int FLG_BIGE = 2;
    public static int FLG_NOUID = 4;
    public static int FLG_CTX = 8;
    public static int FLG_NOSID = 16;
    public static int FLG_DIFI = 32;
    public byte[] buf = new byte[32];
    public byte[] cbuf;
    private int headerOffset = 0;
    private int headerLength = 32;
    private int trailerOffset = 28;
    private int trailerLength = 4;
    private int fixedBytes = 1440;
    private int hdr;
    private int sid;
    private int ouid;
    private int cid;
    private int ctx;
    private int chdr;
    private int size;
    private int bits;
    private int fbits;
    private int fb;
    private int tb;
    private int count;
    private int ipoff;
    private int rhdrs;
    private int whdrs;
    private int flags;
    private int dataLength;
    private int totalLength;
    private int fdataLength;
    private String format;
    byte hrep = (byte)73;
    byte drep = (byte)69;
    private boolean isInput = false;
    private boolean needsContext = false;
    private double npktoff;

    public VRTPacket() {
        this("SB", 0, null);
    }

    public VRTPacket(String string, String string2) {
        this(string, 0, string2);
    }

    public VRTPacket(String string, int n) {
        this(string, n, null);
    }

    public VRTPacket(String string, int n, String string2) {
        if (string2 != null) {
            if (string2.equals("VRT")) {
                n |= 0;
            } else if (string2.equals("VRTL")) {
                n |= FLG_NOSID | FLG_TRIM;
            } else if (string2.equals("VRTW")) {
                n |= FLG_NOSID | FLG_TRIM | FLG_BIGE;
            } else if (string2.equals("VRTX")) {
                n |= FLG_NOUID | FLG_CTX | FLG_BIGE;
            } else if (string2.equals("VRTD")) {
                n |= FLG_DIFI | FLG_TRIM | FLG_BIGE;
            } else {
                System.out.println("Unknown VRT variant: " + string2);
            }
        }
        this.flags = n;
        this.formHeaderBlock();
        this.setFormat(string);
        this.setCount(0);
        this.setSID(1);
        this.setOUID((n & FLG_DIFI) != 0 ? OUID_DIFI : OUID_ICE);
        this.setTC(0.0, 0.0);
        this.setSize(1024);
    }

    private void packL(int n, int n2) {
        if (n < 0) {
            return;
        }
        Convert.packL((byte[])this.buf, (int)n, (int)n2, (byte)this.hrep);
    }

    private void packX(int n, long l) {
        if (n < 0) {
            return;
        }
        Convert.packX((byte[])this.buf, (int)n, (long)l, (byte)this.hrep);
    }

    private int unpackL(int n) {
        if (n < 0) {
            return 0;
        }
        return Convert.unpackL((byte[])this.buf, (int)n, (byte)this.hrep);
    }

    private long unpackX(int n) {
        if (n < 0) {
            return 0L;
        }
        return Convert.unpackX((byte[])this.buf, (int)n, (byte)this.hrep);
    }

    private void formHeaderBlock() {
        int n = 0;
        this.O_TAIL = -1;
        this.O_TSFS = -1;
        this.O_TSIS = -1;
        this.O_CID = -1;
        this.O_OUID = -1;
        this.O_SID = -1;
        this.hdr = 0x600000;
        this.O_HDR = n;
        n += 4;
        if ((this.flags & FLG_NOSID) == 0) {
            this.hdr |= 0x10000000;
            this.O_SID = n;
            n += 4;
        }
        if ((this.flags & FLG_NOUID) == 0) {
            this.hdr |= 0x8000000;
            this.O_OUID = n;
            this.O_CID = n += 4;
            n += 4;
        }
        this.O_TSIS = n;
        this.O_TSFS = n += 4;
        n += 8;
        if ((this.flags & FLG_TRIM) == 0) {
            this.hdr |= 0x4000000;
            this.O_TAIL = n;
            n += 4;
            this.trailerLength = 4;
            this.setTrailer(-469368832);
        } else {
            this.trailerLength = 0;
        }
        Convert.packL((byte[])this.buf, (int)0, (int)this.hdr, (byte)this.hrep);
        this.headerLength = n;
    }

    public VRTPacket(String string, int n, int n2) {
        this(string, n2);
        this.setSize(n);
    }

    private void initFrom(DataFile dataFile) {
        this.setRep((byte)dataFile.getDataRep().charAt(0));
        if (dataFile.hp != null) {
            dataFile.hp.seek((double)((long)dataFile.getDataStart()));
            dataFile.hp.read(this.buf, this.headerOffset, this.headerLength);
            dataFile.hp.seek((double)((long)dataFile.getDataStart()));
        } else {
            dataFile.io.seek((long)dataFile.getDataStart());
            dataFile.io.read(this.buf, this.headerOffset, this.headerLength);
            dataFile.io.seek((long)dataFile.getDataStart());
        }
        this.setInternals();
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    private void setInternals() {
        this.hdr = Convert.unpackL((byte[])this.buf, (int)this.O_HDR, (byte)this.hrep);
        this.headerLength = 4;
        this.trailerLength = 0;
        this.O_TAIL = -1;
        this.O_TSFS = -1;
        this.O_TSIS = -1;
        this.O_CID = -1;
        this.O_OUID = -1;
        this.O_SID = -1;
        if ((this.hdr & 0x10000000) != 0) {
            this.O_SID = this.headerLength;
            this.headerLength += 4;
        }
        if ((this.hdr & 0x8000000) != 0) {
            this.O_OUID = this.headerLength;
            this.headerLength += 4;
            this.O_CID = this.headerLength;
            this.headerLength += 4;
            this.cid = Convert.unpackL((byte[])this.buf, (int)this.O_CID, (byte)this.hrep);
            this.bits = (this.cid & 0x3F) + 1;
            if ((this.cid & 0x2000) != 0) {
                this.bits *= 2;
            }
        }
        if ((this.hdr & 0xF00000) != 0) {
            this.O_TSIS = this.headerLength;
            this.headerLength += 4;
            this.O_TSFS = this.headerLength;
            this.headerLength += 8;
        }
        if ((this.hdr & 0x4000000) != 0) {
            this.O_TAIL = this.headerLength;
            this.headerLength += 4;
            this.trailerLength = 4;
        }
        this.trailerOffset = this.headerLength - this.trailerLength;
        this.totalLength = (this.hdr & 0xFFFF) << 2;
        this.dataLength = this.totalLength - this.headerLength;
        this.fdataLength = this.fbits * this.dataLength / this.bits;
        this.size = this.dataLength * 8 / this.bits;
    }

    public void createContextFor(int n, int n2, int n3, int n4) {
        int n5 = 0;
        this.cbuf = new byte[256];
        long l = (long)n2 << 20;
        long l2 = (long)n3 << 20;
        int n6 = n4 << 7;
        int n7 = 536871887;
        if (n == 0) {
            return;
        }
        if (n == 1) {
            n = (this.flags & FLG_NOUID) != 0 ? 16844178 : 1299;
        }
        int n8 = CoreCommon.brev4(n & 0xFFFFC);
        this.chdr = 1096810502;
        Convert.packL((byte[])this.cbuf, (int)(n5 * 4), (int)this.chdr, (byte)this.hrep);
        Convert.packL((byte[])this.cbuf, (int)(++n5 * 4), (int)this.sid, (byte)this.hrep);
        ++n5;
        if ((n >> 23 & 1) == 0) {
            this.chdr = 1231028232;
            Convert.packL((byte[])this.cbuf, (int)(n5 * 4), (int)this.ouid, (byte)this.hrep);
            Convert.packL((byte[])this.cbuf, (int)(++n5 * 4), (int)0, (byte)this.hrep);
            ++n5;
        }
        Convert.packL((byte[])this.cbuf, (int)((n5 += 3) * 4), (int)n8, (byte)this.hrep);
        ++n5;
        if ((n >> 4 & 1) == 1) {
            Convert.packX((byte[])this.cbuf, (int)(n5 * 4), (long)l2, (byte)this.hrep);
            n5 += 2;
        }
        if ((n >> 8 & 1) == 1) {
            Convert.packL((byte[])this.cbuf, (int)(n5 * 4), (int)n6, (byte)this.hrep);
            ++n5;
        }
        if ((n >> 10 & 1) == 1) {
            Convert.packX((byte[])this.cbuf, (int)(n5 * 4), (long)l, (byte)this.hrep);
            n5 += 2;
        }
        if ((n >> 16 & 1) == 1) {
            Convert.packL((byte[])this.cbuf, (int)(n5 * 4), (int)n7, (byte)this.hrep);
            Convert.packL((byte[])this.cbuf, (int)(++n5 * 4), (int)0, (byte)this.hrep);
            ++n5;
        }
        this.chdr = (this.chdr & 0xFFFFFF00) + n5;
        Convert.packL((byte[])this.cbuf, (int)0, (int)this.chdr, (byte)this.hrep);
        this.ctx = n;
    }

    public int getNextContext() {
        int n = this.chdr & 0xFF;
        Convert.packL((byte[])this.cbuf, (int)0, (int)this.chdr, (byte)this.hrep);
        System.arraycopy(this.buf, this.O_TSIS, this.cbuf, (this.ctx >> 20 & 1) != 0 ? 8 : 16, 12);
        int n2 = this.chdr >> 16 & 0xF;
        this.chdr = this.chdr & 0xFFF0FFFF | (++n2 & 0xF) << 16;
        return n << 2;
    }

    public void setRep(byte by) {
        this.drep = by;
    }

    public byte getRep() {
        return this.drep;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getTrailerLength() {
        return this.trailerLength;
    }

    public void setSize(int n) {
        this.size = n;
        this.setBytes(n * this.bits / 8);
    }

    public int getSize() {
        return this.size;
    }

    public void setBytes(int n) {
        this.size = n * 8 / this.bits;
        this.dataLength = n;
        this.fdataLength = this.fbits * this.dataLength / this.bits;
        this.totalLength = this.headerLength + this.dataLength;
        int n2 = this.totalLength + 3 >> 2;
        this.hdr = this.hdr & 0xFFFF0000 | n2;
        this.packL(this.O_HDR, this.hdr);
    }

    public int getBytes() {
        return this.dataLength;
    }

    public void setTrailer(int n) {
        this.packL(this.O_TAIL, n);
    }

    public void setSID(int n) {
        if (this.O_SID > 0) {
            this.packL(this.O_SID, n);
        } else if (this.O_CID > 0) {
            this.cid = this.cid & 0xFFFF | n << 16;
            this.packL(this.O_CID, this.cid);
        }
        this.sid = n;
    }

    public int getSID() {
        if (this.O_SID > 0) {
            return this.unpackL(this.O_SID);
        }
        if (this.O_CID > 0) {
            return this.unpackL(this.O_CID) >> 16;
        }
        return 0;
    }

    public void setOUID(int n) {
        this.packL(this.O_OUID, n);
        this.ouid = n;
    }

    public int getOUID() {
        return this.unpackL(this.O_OUID);
    }

    public void setICID(int n) {
        this.setCID(this.cid & 0xFFFF | n << 16);
    }

    public int getICID() {
        return this.cid >> 16 & 0xFFFF;
    }

    public void setCID(int n) {
        this.cid = n;
        this.packL(this.O_CID, n);
    }

    public int getCID() {
        return this.cid;
    }

    public void setCount(int n) {
        this.count = n;
        this.hdr = this.hdr & 0xFFF0FFFF | (n & 0xF) << 16;
        this.packL(this.O_HDR, this.hdr);
    }

    public int getCount() {
        if (this.isInput) {
            int n = this.unpackL(this.O_HDR);
            this.count = n >> 16 & 0xF;
        }
        return this.count;
    }

    public void upCount() {
        ++this.count;
        this.setCount(this.count);
    }

    public void setFormat(String string) {
        if (string.equals(this.format)) {
            return;
        }
        this.format = string;
        if (!DataFile.checkFormat((String)string, (String)"S#,C#")) {
            System.out.println("Unallowed format=" + string);
        }
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n = Data.getBPS((char)c2);
        this.bits = n < 0 ? -n : n * 8;
        this.fbits = this.bits;
        this.fb = this.bits - 1;
        this.tb = 128;
        this.tb |= c == 'C' ? 16 : 0;
        this.tb = c2 == 'F' ? (this.tb |= 0xE) : (c2 == 'D' ? (this.tb |= 0xF) : (this.tb |= 0));
        if ((this.flags & FLG_BIGE) != 0) {
            this.tb |= 0x40;
        }
        this.cid = this.cid & 0xFFFF0000 | this.tb << 8 | this.fb;
        this.packL(this.O_CID, this.cid);
    }

    public String getFormat() {
        return this.format;
    }

    public void setBits(int n) {
        this.bits = n;
        int n2 = n - 1;
        this.cid = this.cid & 0xFFFFFF00 | n2 & 0x3F;
        this.packL(this.O_CID, this.cid);
    }

    public int getBits() {
        return this.bits;
    }

    public void setTC(double d, double d2) {
        int n = (int)(d + -6.31152E8);
        long l = (long)(d2 * 1.0E12 + 0.5);
        if (l < 0L) {
            --n;
            l = (long)((double)l + 1.0E12);
        }
        if (this.O_TSIS > 0) {
            this.packL(this.O_TSIS, n);
        }
        if (this.O_TSFS > 0) {
            this.packX(this.O_TSFS, l);
        }
        this.hdr = this.hdr & 0xFF0FFFFF | TSI_UTC << 22 | TSF_PSEC << 20;
        this.packL(this.O_HDR, this.hdr);
    }

    public Time getTC() {
        int n = this.O_TSIS < 0 ? 0 : Convert.unpackL((byte[])this.buf, (int)this.O_TSIS, (byte)this.hrep);
        long l = this.O_TSFS < 0 ? 0L : Convert.unpackX((byte[])this.buf, (int)this.O_TSFS, (byte)this.hrep);
        double d = n;
        double d2 = (double)l * 1.0E-12;
        return new Time(d += 6.31152E8, d2);
    }

    private void pack(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 - n4;
        if (this.drep == 73) {
            for (int i = 0; i < n2; ++i) {
                int n8 = 0;
                n5 = i * n3;
                n6 = i * n4;
                while (n8 < n4) {
                    int n9 = n5 >> 3;
                    int n10 = ~n5 & 7;
                    int n11 = n6 >> 3;
                    int n12 = ~n6 & 7;
                    if ((byArray[n9] & 1 << n10) == 0) {
                        int n13 = n11;
                        byArray[n13] = (byte)(byArray[n13] & ~(1 << n12));
                    } else {
                        int n14 = n11;
                        byArray[n14] = (byte)(byArray[n14] | 1 << n12);
                    }
                    ++n8;
                    ++n5;
                    ++n6;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n15 = 0;
                n5 = i * n3 + n7;
                n6 = i * n4;
                while (n15 < n4) {
                    int n16 = n5 >> 3;
                    int n17 = n5 & 7;
                    int n18 = n6 >> 3;
                    int n19 = n6 & 7;
                    if ((byArray[n16] & 1 << n17) == 0) {
                        int n20 = n18;
                        byArray[n20] = (byte)(byArray[n20] & ~(1 << n19));
                    } else {
                        int n21 = n18;
                        byArray[n21] = (byte)(byArray[n21] | 1 << n19);
                    }
                    ++n15;
                    ++n5;
                    ++n6;
                }
            }
        }
    }

    private void unpack(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n3 - n4;
        if (this.drep == 73) {
            for (int i = n2; i > 0; --i) {
                int n6 = 0;
                int n7 = i * n3 - 1 - n5;
                int n8 = i * n4 - 1;
                while (n6 < n4) {
                    int n9 = n7 >> 3;
                    int n10 = ~n7 & 7;
                    int n11 = n8 >> 3;
                    int n12 = ~n8 & 7;
                    if (n6 + n5 < 0 || (byArray[n9] & 1 << n10) == 0) {
                        int n13 = n11;
                        byArray[n13] = (byte)(byArray[n13] & ~(1 << n12));
                    } else {
                        int n14 = n11;
                        byArray[n14] = (byte)(byArray[n14] | 1 << n12);
                    }
                    ++n6;
                    --n7;
                    --n8;
                }
            }
        } else {
            for (int i = n2; i > 0; --i) {
                int n15 = n4 - 1;
                int n16 = i * n3 - 1;
                int n17 = i * n4 - 1;
                while (n15 >= 0) {
                    int n18 = n16 >> 3;
                    int n19 = n16 & 7;
                    int n20 = n17 >> 3;
                    int n21 = n17 & 7;
                    if (n15 + n5 < 0 || (byArray[n18] & 1 << n19) == 0) {
                        int n22 = n20;
                        byArray[n22] = (byte)(byArray[n22] & ~(1 << n21));
                    } else {
                        int n23 = n20;
                        byArray[n23] = (byte)(byArray[n23] | 1 << n21);
                    }
                    --n15;
                    --n16;
                    --n17;
                }
            }
        }
    }

    public int ctx2pkt(long l) {
        int n = this.getNextContext();
        Native.ja2p((Object)this.cbuf, (int)0, (long)l, (int)0, (int)n);
        return n;
    }

    public int buf2pkt(byte[] byArray, int n, long l, int n2) {
        int n3 = this.headerLength - this.trailerLength;
        Native.ja2p((Object)this.buf, (int)0, (long)l, (int)0, (int)n3);
        Native.ja2p((Object)byArray, (int)n, (long)l, (int)n3, (int)n2);
        if (this.bits == 16 && (this.flags & FLG_BIGE) != 0) {
            NetIO.swap2(l + (long)n3, l + (long)n3, n2);
        }
        if (this.bits == 12) {
            NetIO.cvt16to12(l + (long)n3, l + (long)n3, n2);
            n2 = n2 / 4 * 3;
        }
        Native.ja2p((Object)this.buf, (int)n3, (long)l, (int)(n3 + n2), (int)this.trailerLength);
        return this.headerLength + n2;
    }

    public String getConfiguration(DataFile dataFile) {
        String string = "VRT";
        if (dataFile.hp != null) {
            string = string + "/DET";
            if (dataFile.hp.aux != null && dataFile.hp.aux.length() > 0) {
                string = string + "=" + dataFile.hp.aux;
            }
        }
        return string;
    }

    public void setFileName(DataFile dataFile, FileName fileName) {
        DataFile dataFile2 = new DataFile();
        dataFile2.init(null, (Object)fileName, "3000", "NH", dataFile.getPacketHandlerFlags());
        String string = "HDR|SL,SID|SL,OUID|SL,PIC|SL,TCIS|SL,TCFS|SX,TLR|SL";
        dataFile2.setSubRecords(string);
        if (this.hrep == 73) {
            dataFile2.setDataRep("IEEE");
        }
        if (this.hrep == 69) {
            dataFile2.setDataRep("EEEI");
        }
        dataFile.hp = dataFile2;
    }

    public double naturalDataOffset(DataFile dataFile, double d) {
        int n = this.fdataLength;
        double d2 = Math.floor(d / (double)n);
        return d2 * (double)n;
    }

    public double dataToPacketOffset(DataFile dataFile, double d) {
        double d2 = Math.floor(d / (double)this.fdataLength);
        double d3 = d2 * (double)this.headerLength;
        if (this.bits != this.fbits) {
            d = d * (double)this.bits / (double)this.fbits;
        }
        this.ipoff = (int)(d - d2 * (double)this.dataLength);
        if (dataFile.hp == null) {
            d += d3;
            if (this.ipoff > 0) {
                d += (double)(this.headerLength - this.trailerLength);
            }
        } else {
            if (this.ipoff > 0) {
                d2 += 1.0;
            }
            this.npktoff = d2;
        }
        return d;
    }

    public double packetToDataOffset(DataFile dataFile, double d) {
        int n = this.dataLength;
        if (dataFile.hp == null) {
            n += this.headerLength;
        }
        double d2 = Math.floor(d / (double)n);
        return d2 * (double)this.fdataLength;
    }

    public void open(DataFile dataFile) {
        this.isInput = dataFile.isInput;
        this.setFormat(dataFile.getFormat());
        if (dataFile.hp != null) {
            dataFile.hp.open();
        }
        if (this.isInput) {
            this.initFrom(dataFile);
        }
    }

    public void seek(DataFile dataFile, double d) {
        d = this.dataToPacketOffset(dataFile, d);
        if (dataFile.hp != null) {
            dataFile.hp.seek(this.npktoff);
        }
        if (dataFile.io != null) {
            dataFile.io.seek((long)(dataFile.getDataStart() + d));
        }
    }

    public int read(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        int n3;
        int n4 = this.getBytes();
        int n5 = n;
        int n6 = n2 * 8 / this.fbits;
        this.rhdrs = 0;
        for (int i = this.bits != this.fbits ? n2 * this.bits / this.fbits : n2; i > 0; i -= n3) {
            if (this.ipoff == 0) {
                if (dataFile.hp != null) {
                    dataFile.hp.read(this.buf, this.headerOffset, this.headerLength);
                } else {
                    dataFile.io.read(this.buf, this.headerOffset, this.headerLength - this.trailerLength);
                }
                ++this.rhdrs;
            }
            n3 = Math.min(i, n4 - this.ipoff);
            n3 = byArray != null ? dataFile.io.read(byArray, n, n3) : dataFile.io.read(l, n, n3);
            if (n3 < 0) {
                return n3;
            }
            n += n3;
            this.ipoff += n3;
            if (this.ipoff == n4) {
                this.ipoff = 0;
            }
            if (this.ipoff != 0 || dataFile.hp != null) continue;
            dataFile.io.read(this.buf, this.trailerOffset, this.trailerLength);
        }
        if (this.bits != this.fbits) {
            this.unpack(byArray, n5, n6, this.bits, this.fbits);
        }
        return n2;
    }

    public int write(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        int n3 = this.getBytes();
        int n4 = this.bits != this.fbits ? n2 * this.bits / this.fbits : n2;
        int n5 = n2 * 8 / this.fbits;
        if (this.needsContext) {
            int n6 = this.getNextContext();
            dataFile.io.write(this.cbuf, 0, n6);
            this.needsContext = false;
        }
        if (this.bits != this.fbits) {
            this.pack(byArray, n, n5, this.fbits, this.bits);
        }
        if (this.bits == 16 && (this.flags & FLG_BIGE) != 0) {
            Convert.swap2((byte[])byArray, (int)n, (int)(n2 >> 1));
        }
        this.whdrs = 0;
        while (n4 > 0) {
            if (this.ipoff == 0) {
                if (dataFile.hp != null) {
                    dataFile.hp.write(this.buf, this.headerOffset, this.headerLength);
                } else {
                    dataFile.io.write(this.buf, this.headerOffset, this.headerLength - this.trailerLength);
                }
                ++this.whdrs;
            }
            int n7 = Math.min(n2, n3 - this.ipoff);
            n7 = byArray != null ? dataFile.io.write(byArray, n, n7) : dataFile.io.write(l, n, n7);
            if (n7 < 0) {
                return n7;
            }
            n += n7;
            this.ipoff += n7;
            if (this.ipoff == n3) {
                this.ipoff = 0;
            }
            if (this.ipoff == 0 && dataFile.hp == null) {
                dataFile.io.write(this.buf, this.trailerOffset, this.trailerLength);
            }
            n4 -= n7;
        }
        return n2;
    }

    public void close(DataFile dataFile) {
        if (dataFile.hp != null) {
            dataFile.hp.close();
        }
    }

    public boolean hasHeader() {
        return this.rhdrs > 0;
    }

    public String listHeader() {
        Time time = this.getTC();
        String string = time != null ? time.toString(12) : null;
        String string2 = "VRT-Packet OUID=" + Convert.l2x((int)this.getOUID()) + " Stream=" + this.getSID() + " Count=" + this.getCount() + " Size=" + this.getSize() + " Bits=" + this.getBits() + " TC=" + string;
        return string2;
    }

    public PacketHandler cloneOf() {
        PacketHandler packetHandler = null;
        try {
            packetHandler = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return packetHandler;
    }

    public void setBuffer(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.buf, this.headerOffset, this.headerLength);
    }

    public void getBuffer(byte[] byArray, int n) {
        System.arraycopy(this.buf, this.headerOffset, byArray, n, this.headerLength);
    }
}

