/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Native;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class SDDSPacket
implements PacketHandler,
Cloneable {
    public static final int UDP = 1;
    public static final int ICE = 2;
    public byte[] buf = new byte[64];
    private static final long ticsPerSecond = 4000000000L;
    private static final long ticsPerMilliSecond = 4000000L;
    private static final double secondsPerYear = 3.1536E7;
    private static final double SR2L = Math.pow(2.0, 63.0) / 1.25E8;
    private static final double DFDT2I = Math.pow(2.0, 31.0) / 2.0;
    private int headerOffset = 8;
    private int headerLength = 56;
    private int dataLength = 1024;
    private int totalLength = 1080;
    private int size;
    private int bytes;
    private int count;
    private int fixedSize = 1024;
    private int bpa = 1;
    private int ipoff;
    private int missed;
    private int flags;
    private boolean header = false;
    private boolean udp = false;
    private boolean ice = false;
    private boolean tc1ms = true;
    private double npktoff;
    private double yearInSeconds;
    private final byte TCS_1MSV = (byte)-128;
    private final byte TCS_TTV = (byte)64;
    private final byte TCS_SSC = (byte)32;
    private double sampleRate = 0.0;
    private static int leapSecSoY;
    private static int leapSecAdj;

    public SDDSPacket() {
        this("SB", 0);
    }

    public SDDSPacket(String string, int n) {
        this.flags = n;
        this.setCount(0);
        this.setFormat(string);
        this.setTC(0, 0.0, 0.0, 0.0);
        if ((n & 2) != 0) {
            this.setICE(true);
        } else if ((n & 1) != 0) {
            this.setUDP(true);
        }
        this.setKeys(43605);
        this.setPort(0);
        this.setAddress(0);
    }

    public void setUDP(boolean bl) {
        this.udp = bl;
        if (!this.udp) {
            this.ice = false;
        }
        if (this.udp) {
            this.headerOffset = 0;
            this.headerLength = 64;
        } else {
            this.headerOffset = 8;
            this.headerLength = 56;
        }
        this.totalLength = this.headerLength + this.dataLength;
    }

    public void setICE(boolean bl) {
        this.ice = bl;
        this.setUDP(bl);
    }

    public void setAddress(int n) {
        this.buf[4] = (byte)(n >> 24 & 0xFF);
        this.buf[5] = (byte)(n >> 16 & 0xFF);
        this.buf[6] = (byte)(n >> 8 & 0xFF);
        this.buf[7] = (byte)(n >> 0 & 0xFF);
    }

    public int getAddress() {
        return this.buf[4] << 24 | this.buf[5] << 16 | this.buf[6] << 8 | this.buf[7];
    }

    public String getAddrStr() {
        return this.getAddrStr(this.buf[4]) + "." + this.getAddrStr(this.buf[5]) + "." + this.getAddrStr(this.buf[6]) + "." + this.getAddrStr(this.buf[7]);
    }

    private String getAddrStr(byte n) {
        int n2 = n;
        return "" + (n2 &= 0xFF);
    }

    public void setPort(int n) {
        this.buf[2] = (byte)(n >> 8 & 0xFF);
        this.buf[3] = (byte)(n >> 0 & 0xFF);
    }

    public int getPort() {
        return this.buf[2] << 8 & 0xFF00 | this.buf[3] & 0xFF;
    }

    public void setKeys(int n) {
        this.buf[0] = (byte)(n >> 8 & 0xFF);
        this.buf[1] = (byte)(n >> 0 & 0xFF);
    }

    public void setBits(int n) {
        this.buf[9] = 0;
        if (n < 0) {
            this.buf[9] = -128;
            n = -n;
            this.bpa = 2 * n / 8;
        } else {
            this.bpa = n / 8;
        }
        this.buf[9] = (byte)(this.buf[9] | (byte)n);
        this.buf[8] = -128;
        if (n <= 4) {
            this.buf[8] = (byte)(this.buf[8] | 0);
        } else if (n <= 8) {
            this.buf[8] = (byte)(this.buf[8] | 1);
        } else if (n <= 16) {
            this.buf[8] = (byte)(this.buf[8] | 2);
        }
    }

    public int getBits() {
        int n = 0x1F & this.buf[9];
        if (this.buf[9] < 0) {
            n = -n;
        }
        return n;
    }

    public void setCount(int n) {
        this.count = n &= 0xFFFF;
        this.buf[10] = (byte)(n >> 8 & 0xFF);
        this.buf[11] = (byte)(n & 0xFF);
    }

    public void upCount() {
        if ((++this.count & 0x1F) == 31) {
            ++this.count;
        }
        this.setCount(this.count);
    }

    public void setFormat(String string) {
        int n = Data.getBPS((char)string.charAt(1));
        int n2 = n = n < 0 ? -n : 8 * n;
        if (string.charAt(0) == 'C') {
            n = -n;
        }
        this.setBits(n);
    }

    public void setSSC(double d, double d2) {
        long l = (long)(d * SR2L);
        int n = (int)(d2 * DFDT2I);
        Convert.packL((byte[])this.buf, (int)28, (int)n, (byte)73);
        Convert.packX((byte[])this.buf, (int)32, (long)l, (byte)73);
        this.buf[12] = d > 0.0 ? 32 : 0;
    }

    public void setDelta(double d) {
        this.sampleRate = d == 0.0 ? 0.0 : (double)Math.round(1.0 / d);
        double d2 = this.buf[9] < 0 ? this.sampleRate * 2.0 : this.sampleRate;
        this.setSSC(d2, 0.0);
    }

    public double getSSC() {
        long l = Convert.unpackX((byte[])this.buf, (int)32, (byte)73);
        double d = (double)l / SR2L;
        return d;
    }

    public void setTC(int n, double d, double d2, double d3) {
        int n2;
        if (d2 > 3.1536E7) {
            if (this.yearInSeconds == 0.0) {
                this.yearInSeconds = new Time(d2, d3).getYiS();
            }
            d2 -= this.yearInSeconds;
        }
        if (leapSecAdj != 0 && d2 > (double)leapSecSoY) {
            d2 += (double)leapSecAdj;
        }
        long l = (long)(d2 * 4.0E9) + (long)(d3 * 4.0E9);
        Convert.packX((byte[])this.buf, (int)16, (long)l, (byte)73);
        int n3 = n2 = this.sampleRate > 0.0 ? 32 : 0;
        if (d > 0.0) {
            int n4;
            int n5;
            n2 |= 0x40;
            if (this.tc1ms && (n5 = (int)(((double)(n4 = (int)(d3 * 1000.0) + 1) * 0.001 - d3) / d)) * this.bpa < 1024) {
                n2 |= 0xFFFFFF80;
            }
        }
        this.buf[12] = (byte)n2;
    }

    public Time getTC() {
        return SDDSPacket.getTC(this.buf, 0, 0L);
    }

    public static Time getTC(byte[] byArray, int n, long l) {
        long l2 = 0L;
        if (byArray == null && l != 0L) {
            byArray = new byte[24];
            Native.p2ja((long)l, (int)n, (Object)byArray, (int)0, (int)24);
            n = 0;
        }
        if (byArray != null) {
            if ((byArray[n + 12] & 0xC0) == 0) {
                return null;
            }
            l2 = Convert.unpackX((byte[])byArray, (int)(n + 16), (byte)73);
        }
        long l3 = l2 / 4000000000L;
        long l4 = l2 - l3 * 4000000000L;
        if (leapSecAdj != 0 && l3 > (long)leapSecSoY) {
            l3 -= (long)leapSecAdj;
        }
        return new Time((double)l3, (double)l4 * 2.5E-10);
    }

    public int getTCS() {
        return this.buf[12];
    }

    public int getTCO() {
        if ((this.buf[12] & 0x80) == 0) {
            return -1;
        }
        int n = this.buf[12] << 8 & 0x700 | this.buf[13] & 0xFF;
        return n;
    }

    public int getCount() {
        int n = this.buf[10] << 8 & 0xFF00 | this.buf[11] & 0xFF;
        return n;
    }

    public String getFormat() {
        if (this.bpa == 2) {
            return "SI";
        }
        return "SB";
    }

    public int getSize() {
        return this.fixedSize / this.bpa;
    }

    public int getBytes() {
        return this.fixedSize;
    }

    private void updateCount() {
        int n = this.getCount();
        if (this.count != 0) {
            if ((++this.count & 0x1F) == 31) {
                ++this.count;
            }
            if (n > this.count) {
                this.missed += n - this.count;
            }
        }
        this.count = n;
    }

    public String getConfiguration(DataFile dataFile) {
        String string = "SDDS";
        if (this.ice) {
            string = string + "/ICE";
        } else if (this.udp) {
            string = string + "/UDP";
        }
        if (dataFile.hp != null) {
            string = string + "/DET";
            if (dataFile.hp.aux != null && dataFile.hp.aux.length() > 0) {
                string = string + "=" + dataFile.hp.aux;
            }
        }
        return string;
    }

    public void setFileName(DataFile dataFile, FileName fileName) {
        DataFile dataFile2 = new DataFile();
        dataFile2.init(null, (Object)fileName, "3000", "NH", dataFile.getPacketHandlerFlags());
        String string = "FORM|SB,BPS|SB,FRAM|SI,SOFF|SI,OTIC|SI,YTIC|CL,PTIC|SL,SSC|6I,SSD|4B,AAD|5L";
        if (this.udp) {
            string = "KEY|2B,PORT|SI,ADDR|4B," + string;
        }
        dataFile2.setSubRecords(string);
        dataFile2.setDataRep("IEEE");
        dataFile.hp = dataFile2;
    }

    public double naturalDataOffset(DataFile dataFile, double d) {
        int n = this.fixedSize;
        if (n == 0) {
            n = this.getBytes();
        }
        double d2 = Math.floor(d / (double)n);
        return d2 * (double)n;
    }

    public double dataToPacketOffset(DataFile dataFile, double d) {
        int n = this.fixedSize;
        double d2 = Math.floor(d / (double)n);
        double d3 = d2 * (double)this.headerLength;
        this.ipoff = (int)(d - d2 * (double)n);
        if (dataFile.hp == null) {
            d += d3;
            if (this.ipoff > 0) {
                d += (double)this.headerLength;
            }
        } else {
            if (this.ipoff > 0) {
                d2 += 1.0;
            }
            this.npktoff = d2;
        }
        return d;
    }

    public double packetToDataOffset(DataFile dataFile, double d) {
        if (dataFile.hp != null) {
            return d;
        }
        int n = this.fixedSize;
        double d2 = Math.floor(d / (double)(n + this.headerLength));
        return d2 * (double)n;
    }

    public void seek(DataFile dataFile, double d) {
        d = this.dataToPacketOffset(dataFile, d);
        if (dataFile.hp != null) {
            dataFile.hp.seek(this.npktoff);
        }
        if (dataFile.io != null) {
            dataFile.io.seek((long)(dataFile.getDataStart() + d));
        }
    }

    public void open(DataFile dataFile) {
        this.setFormat(dataFile.getFormat());
        if (dataFile.hp != null) {
            dataFile.hp.open();
        }
        this.missed = 0;
    }

    public int read(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        boolean bl = this.header = this.ipoff == 0;
        if (this.header) {
            if (dataFile.hp != null) {
                dataFile.hp.read(this.buf, this.headerOffset, this.headerLength);
            } else {
                dataFile.io.read(this.buf, this.headerOffset, this.headerLength);
            }
        }
        if (this.header) {
            this.updateCount();
        }
        int n3 = this.getBytes();
        int n4 = Math.min(n2, n3 - this.ipoff);
        n4 = byArray != null ? dataFile.io.read(byArray, n, n4) : dataFile.io.read(l, n, n4);
        if (n4 < 0) {
            return n4;
        }
        this.ipoff += n4;
        if (this.ipoff == n3) {
            this.ipoff = 0;
        }
        if (n2 > n4) {
            n4 += this.read(dataFile, byArray, n + n4, n2 - n4, l);
        }
        return n4;
    }

    public int write(DataFile dataFile, byte[] byArray, int n, int n2, long l) {
        boolean bl = this.header = this.ipoff == 0;
        if (this.header) {
            if (dataFile.hp != null) {
                dataFile.hp.write(this.buf, this.headerOffset, this.headerLength);
            } else {
                dataFile.io.write(this.buf, this.headerOffset, this.headerLength);
            }
        }
        int n3 = this.getBytes();
        int n4 = Math.min(n2, n3 - this.ipoff);
        n4 = byArray != null ? dataFile.io.write(byArray, n, n4) : dataFile.io.write(l, n, n4);
        if (n4 < 0) {
            return n4;
        }
        this.ipoff += n4;
        if (this.ipoff == n3) {
            this.ipoff = 0;
        }
        if (n2 > n4) {
            n4 += this.write(dataFile, byArray, n + n4, n2 - n4, l);
        }
        return n4;
    }

    public void close(DataFile dataFile) {
        if (dataFile.hp != null) {
            dataFile.hp.close();
        }
        if (this.missed > 0) {
            Shell.warning((CharSequence)("Packet sequence inconsistency, missed " + this.missed + " packets"));
        }
    }

    public boolean hasHeader() {
        return this.header;
    }

    public String listHeader() {
        int n = this.getTCS();
        String string = "SDDS-Packet Addr=" + this.getAddrStr() + " Port=" + this.getPort() + " Count=" + this.getCount() + " Elem=" + this.getSize() + " Bits=" + this.getBits();
        if ((n & 0x20) != 0) {
            int n2 = (int)(this.getSSC() + 0.5);
            string = string + " SSC=" + n2;
        }
        if ((n & 0x40) != 0) {
            Time time = this.getTC();
            String string2 = time != null ? time.toString(12) : null;
            string = string + " TC=" + string2;
            if ((n & 0xFFFFFF80) != 0) {
                string = string + " 1MSV";
            }
        }
        return string;
    }

    public PacketHandler cloneOf() {
        PacketHandler packetHandler = null;
        try {
            packetHandler = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return packetHandler;
    }

    public void setBuffer(byte[] byArray, int n) {
        System.arraycopy(byArray, n, this.buf, 0, 64);
    }

    public void getBuffer(byte[] byArray, int n) {
        System.arraycopy(this.buf, 0, byArray, n, 64);
    }

    private static void getLeapSec() {
        Table table;
        int n = 0;
        int n2 = 0;
        TextFile textFile = new TextFile("nxm.ice.cfg.global_flags.cfg");
        if (textFile.exists() && (table = new Table(textFile)) != null) {
            if (table.containsKey("LEAPSECDOY")) {
                n = 86400 * table.getL("LEAPSECDOY");
                n2 = 1;
            }
            if (table.containsKey("LEAPSECSOY")) {
                n = table.getL("LEAPSECSOY");
                n2 = 1;
            }
            if (table.containsKey("LEAPSECADJ")) {
                n2 = table.getL("LEAPSECADJ");
            }
        }
        leapSecSoY = n;
        leapSecAdj = n2;
    }

    static {
        SDDSPacket.getLeapSec();
    }
}

