/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceHW;
import nxm.ice.lib.IceJVM;

public class IcePIC7
extends IceJVM {
    public static int runMode;
    public static int lastDir;
    public static int baddr;
    public static int dmaqp;
    public static int lastStkLoc;
    public static int lastStkOff;

    public static void run() {
        IcePIC7.reset();
        int n = 1;
        while (true) {
            int n2;
            if (((n2 = IcePIC7.arBus(33554504)) & 0x10000) != 0) {
                IcePIC7.processMsg();
            }
            if ((n2 = IcePIC7.arMem(-50331648)) >> 24 == 85) {
                IcePIC7.processMessages();
            }
            if ((n2 = IcePIC7.arMem(dmaqp)) != 0) {
                IcePIC7.processDMA(n2 << 2);
            } else {
                IcePIC7.awMem(-50201100, dmaqp - -50201088 >> 2);
                dmaqp = -50201088;
                IcePIC7.awBus(33554556, n);
            }
            IcePIC7.awMem(-50266116, n);
            ++n;
        }
    }

    public static int isBus(int n) {
        if ((n &= 0xFF000000) == -50331648) {
            return 0;
        }
        if (n != 0) {
            return 1;
        }
        return 0;
    }

    public static void resetFifo() {
        int n = IcePIC7.arBus(33554504);
        if ((n & 0x8000000) != 0) {
            return;
        }
        while ((n & 0x10) != 0) {
            n = IcePIC7.arBus(33554504);
        }
        IcePIC7.awBus(33554504, n | 4);
    }

    public static void processMsg() {
        int n = IcePIC7.arBus(0x2000060);
        int n2 = IcePIC7.arBus(33554532);
        int n3 = IcePIC7.arBus(33554536);
        int n4 = n2 << 2;
        int n5 = n3;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (IcePIC7.isBus(n4) != 0) {
                    IcePIC7.awBus(n4, n3);
                    break;
                }
                IcePIC7.awMem(n4, n3);
                break;
            }
            case 2: {
                n5 = IcePIC7.isBus(n4) != 0 ? IcePIC7.arBus(n4) : IcePIC7.arMem(n4);
                IcePIC7.wait4dma(16);
                break;
            }
            case 3: {
                int n6;
                n5 = IcePIC7.arMem(n4);
                n5 &= n;
                IcePIC7.awMem(n4, n5 |= (n3 &= n6));
                break;
            }
            case 4: {
                int n6;
                n5 = n3 & 0xFFFF;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, n5);
                if ((n6 & 4) != 0) {
                    IcePIC7.wfifo(n4, n5);
                } else {
                    IcePIC7.rfifo(n4, n5);
                }
                return;
            }
            case 7: {
                n5 = n3 | n2 << 28;
                IcePIC7.writemod(n5);
                break;
            }
            case 8: {
                int n6;
                int n7 = n6 & 0xFFFF0000;
                if (n6 <= 4) {
                    IcePIC7.awBus(n2, n3);
                    break;
                }
                if ((n6 &= 0xFFFF) > 4) {
                    IcePIC7.resetFifo();
                }
                IcePIC7.awBus(0x2000070, 0);
                if (n7 != 0) {
                    n5 = IcePIC7.adon_wrb(n2, n3, n6, n7);
                } else {
                    while (n6 > 0) {
                        IcePIC7.awBus(n2, IcePIC7.rafifo());
                        n6 -= 4;
                    }
                }
                return;
            }
            case 9: {
                if (n2 >= 0) {
                    IcePIC7.initMC();
                    runMode = 1;
                    break;
                }
                runMode = 0;
                break;
            }
            case 10: {
                int n6;
                n5 = IcePIC7.adon_tc(n4, n3, n6);
                break;
            }
            case 11: {
                n5 = IcePIC7.adon_mstat(n2);
                break;
            }
            case 12: {
                n5 = IcePIC7.adon_nstat(n2);
                break;
            }
            case 13: {
                IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n4);
                if (dMAStruct.todo != 0) {
                    dMAStruct.stat = -dMAStruct.stat;
                    n5 = dMAStruct.hxfer;
                    break;
                }
                n5 = 0;
                break;
            }
            case 14: 
            case 15: {
                n2 = (n2 & 0xC0) << 20 | 0x400000 | n2 & 0x3F;
                if (n == 14) {
                    IcePIC7.awBus(n2, n3);
                    break;
                }
                n5 = IcePIC7.arBus(n2);
                break;
            }
            case 16: {
                int n6;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, 0);
                n5 = IcePIC7.adon_rwiob(n2, n3, n6, false);
                return;
            }
            case 17: {
                int n6;
                n5 = IcePIC7.adon_rwiob(n2, n3, n6, true);
                break;
            }
            case 19: {
                IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n4);
                IcePIC7.awBus(33554552, dMAStruct.hcycle);
                IcePIC7.awBus(33554548, dMAStruct.hindex);
                n5 = dMAStruct.cindex - dMAStruct.caddr;
                if (n5 > 65535) {
                    n5 = 65535;
                }
                n5 |= dMAStruct.stat << 16;
                break;
            }
            case 20: {
                int n6;
                if (n2 == -10) {
                    IcePIC7.resetFifo();
                    IcePIC7.awBus(0x2000070, 0);
                    for (int i = 0; i < n3; ++i) {
                        IcePIC7.dojtagx(0, IcePIC7.rafifo(), n6 | 0xF);
                    }
                    return;
                }
                if (n2 == -11 || n2 == -12) {
                    int n8 = n6 & 0xFFFF;
                    int n9 = n6 & 0xFFFF0000;
                    n5 = IcePIC7.arMem(n3 << 2);
                    int n10 = 0;
                    while (n10 < n8) {
                        if (n2 == -11) {
                            IcePIC7.dojtag(0, IcePIC7.arMem(n3 << 2), n9 | 0xF);
                        }
                        if (n2 == -12) {
                            n5 = IcePIC7.dojtag(0, n5, n9 | 0xF0F);
                            IcePIC7.awMem(n3 << 2, n5);
                            n5 = 0;
                        }
                        ++n10;
                        ++n3;
                    }
                    break;
                }
                n5 = IcePIC7.dojtag(n2, n3, n6);
                break;
            }
            case 22: {
                int n6;
                n5 = IcePIC7.dompio(n2, n3, n6);
                break;
            }
            case 23: {
                IcePIC7.awBus(0x2000070, n5);
                IcePIC7.udelay(10000);
                IcePIC7.awBus(524288, n2);
                IcePIC7.awBus(524288, n3);
                return;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                int n11;
                int n6;
                n5 = n6;
                IcePIC7.wait4dma(16);
                if (n6 < 0) {
                    n5 = -n6;
                    IcePIC7.setupDMAi(1, n3 | 0x1F, n3 + n5);
                    IcePIC7.awBus(0x1008008, 0x2000000);
                    n11 = 48;
                } else {
                    IcePIC7.awBus(0x1008010, 0);
                    n11 = 4112;
                }
                IcePIC7.awBus(33554520, n2 << 6);
                if ((n2 >>= 26) > 0) {
                    n11 |= 0x800;
                }
                IcePIC7.awBus(0x2000044, n2);
                IcePIC7.awBus(33554524, n5);
                IcePIC7.awBus(33554504, n11);
                IcePIC7.wait4dma(256);
                if (n6 > 0) {
                    IcePIC7.setupDMAo(1, n3 | 0x1F, n3 + n5);
                    IcePIC7.awBus(0x1008008, 131072);
                }
                IcePIC7.wait4dma(16);
                break;
            }
            case 27: 
            case 28: {
                int n6;
                n5 = n == 27 ? 42405 : 53970;
                int n12 = n6 | 0xF;
                IcePIC7.dojtag(-2, n5, n12);
                IcePIC7.dojtag(-2, n2, n12);
                IcePIC7.dojtag(-2, 46260, n12);
                n5 = IcePIC7.dojtag(-2, n3, 0xF0F | n6);
                IcePIC7.dojtag(-2, -1, n12);
                IcePIC7.dojtag(-2, -1, 15);
                break;
            }
            case 29: {
                int n6;
                IcePIC7.resetFifo();
                IcePIC7.awBus(0x2000070, 0);
                n5 = IcePIC7.adon_wriop(n2, n3, n6);
                return;
            }
            case 30: {
                int n6;
                maddr = n4;
                for (n6 = IcePIC7.arBus(33554540); n6 > 0; --n6) {
                    IcePIC7.aBus(mdata);
                    IcePIC7.wBus(mdata);
                }
                break;
            }
            case 31: {
                int n6;
                IcePIC7.awBus(n3, 0);
                maddr = n4;
                IcePIC7.awBus(n6, mdata);
                n5 = IcePIC7.arBus(n3 + 11);
                IcePIC7.awBus(n6 += 4, mdata);
                IcePIC7.awBus(n6 += 4, mdata - n5);
                IcePIC7.awBus(n6 += 8, mdata);
                IcePIC7.awBus(n6 += 4, mdata);
                IcePIC7.awBus(n3, 1);
            }
        }
        IcePIC7.awBus(0x2000070, n5);
    }

    /*
     * Unable to fully structure code
     */
    public static void processDMA(int var0) {
        var19_1 = (IceHW.DMAStruct)IcePIC7.getObjectAt(var0);
        var20_2 = var19_1.dir;
        IcePIC7.dmaqp += 4;
        if (var19_1.todo == 0) {
            if (var19_1.stat > 0) {
                IcePIC7.portStop(var19_1);
            }
            return;
        }
        if (var19_1.stat == 0 && (var20_2 <= 0 || var19_1.todo == -1)) {
            IcePIC7.portStart(var19_1);
        }
        if (var19_1.todo == -1) {
            if (var19_1.master == -1 && var19_1.hind != 0) {
                var1_3 = IcePIC7.arBus(var19_1.hind << 2);
                if ((var1_3 & (var2_5 = -16777216)) == 0 && (var19_1.hindex & var2_5) != 0) {
                    ++var19_1.hcycle;
                }
                var19_1.hindex = var1_3;
            }
            return;
        }
        var1_4 = var20_2 == 3 ? var19_1.cind : var19_1.cindp;
        var3_7 = IcePIC7.arMemSync(var1_4 << 2);
        if (var20_2 == -2) {
            if (var3_7 < var19_1.hindex) {
                if (var3_7 <= 1) {
                    var3_7 = var19_1.haddr;
                }
                ++var19_1.hcycle;
                if (var19_1.todo > 0) {
                    --var19_1.todo;
                }
            }
            var19_1.hindex = var3_7;
            IcePIC7.updateHIP(var19_1, var3_7);
            return;
        }
        var9_8 = var19_1.haddr + var19_1.hsize;
        var6_9 = var9_8 - var19_1.hindex;
        var4_10 = 0x4000000 - (var19_1.hindex & 0x3FFFFFF);
        if (var6_9 > var4_10) {
            var6_9 = var4_10;
        }
        if (var19_1.frame != 0) {
            if (var19_1.appp == 0) {
                var19_1.appp = (var19_1.frame & 65535) << 3;
            }
            if ((var1_4 = var19_1.appp) < 0) {
                var1_4 = -var1_4;
            }
            if (var6_9 > var1_4) {
                var6_9 = var1_4;
            }
        }
        if (var6_9 > var19_1.hxfer) {
            var6_9 = var19_1.hxfer;
        }
        var7_11 = var6_9 << 4;
        var13_12 = var19_1.csize;
        var14_13 = var19_1.caddr + var13_12;
        var10_14 = var19_1.hindex + var6_9;
        if (var10_14 >= var9_8) {
            var10_14 = var19_1.haddr;
        }
        if ((var11_15 = var19_1.cindex + var7_11) >= var14_13) {
            var11_15 -= var13_12;
        }
        if ((var4_10 = (var17_16 = (var3_7 & 2147483584) >> 2) - var19_1.cindex) < 0 || var4_10 == 0 && var19_1.stat == 0 && var19_1.ccycle == 0 && var20_2 != 3) {
            var4_10 += var13_12;
        }
        var5_17 = var13_12 - var4_10;
        if (var20_2 < 0) {
            if (var4_10 < var7_11) {
                return;
            }
            if (var5_17 < var13_12 >> 2 && var19_1.frame == 0) {
                ++var19_1.miss;
            }
        } else if (var20_2 != 2) {
            if (var20_2 == 3) {
                if (var19_1.stat != 1) {
                    if (var19_1.stat == 0) {
                        var19_1.stat = 3;
                        IcePIC7.portStart(var19_1);
                    }
                    if (var4_10 < var13_12 >> 1) {
                        return;
                    }
                    IcePIC7.awBus(0x1008008, var19_1.enb);
                    var19_1.stat = 1;
                }
                var19_1.fcny = var4_10;
                if (var4_10 < var7_11) {
                    ++var19_1.miss;
                    IcePIC7.awBus(16809996, var19_1.enb);
                    var19_1.stat = 2;
                }
                if ((var4_10 = (IcePIC7.arMemSync(var19_1.cindp << 2) >> 2) - var19_1.cindex) >= 0 && var4_10 < var7_11) {
                    return;
                }
                var20_2 = -3;
            } else if (var19_1.todo == -17) {
                if (var19_1.appp == 0 && var17_16 != var19_1.cindex) {
                    IcePIC7.wait4route(131072);
                    IcePIC7.awMem(var19_1.cindp + 1 << 2, var19_1.cindex << 2);
                    if (var19_1.stat == 0) {
                        var19_1.stat = 2;
                        IcePIC7.portStart(var19_1);
                    } else {
                        IcePIC7.awBus(0x1008008, var19_1.enb);
                    }
                    var19_1.cind = var19_1.cindex;
                }
                var19_1.appp = IcePIC7.arBus(0x1008000) & var19_1.enb & 0xFF0000;
                if (var4_10 != 0 && var4_10 < var13_12 >> 2) {
                    return;
                }
                if (var0 == IcePIC7.lastStkLoc) {
                    var1_4 = IcePIC7.lastStkOff;
                } else {
                    var1_4 = var0 - -50216960 & 65535;
                    var1_4 = IcePIC7._idiv(var1_4, 48);
                    IcePIC7.lastStkLoc = var0;
                    IcePIC7.lastStkOff = var1_4;
                }
                var19_1.hind = IcePIC7.arBusSync(0x2000080 + var1_4);
                var1_4 = var19_1.hind - var19_1.hindex;
                if (var1_4 >= 0 && var1_4 < var19_1.hxfer) {
                    return;
                }
            } else if (var19_1.todo == -19) {
                if (var19_1.stat == 0 && var5_17 >= var13_12) {
                    IcePIC7.portStart(var19_1);
                }
                if (var4_10 < var7_11) {
                    return;
                }
                if (var19_1.hcycle > 0) {
                    var20_2 = 0;
                } else if (var11_15 == var19_1.caddr) {
                    var11_15 += var13_12;
                }
            } else {
                if (var19_1.stat == 0 && var5_17 >= var13_12 >> 1) {
                    IcePIC7.portStart(var19_1);
                }
                if (var4_10 < var7_11 + 256) {
                    return;
                }
                if (var19_1.stat != 0 && var5_17 < var13_12 >> 2) {
                    ++var19_1.miss;
                }
            }
        }
        if (var19_1.frame == 0) ** GOTO lbl130
        if (var19_1.appp <= 0) {
            var19_1.appp += var6_9;
            var10_14 = var19_1.hindex;
        } else {
            var19_1.appp -= var6_9;
            if (var19_1.appp == 0) {
                var19_1.appp = ((var19_1.frame & 65535) << 3) * (1 - (var19_1.frame >> 16));
            }
lbl130:
            // 4 sources

            if (var19_1.todo != -14) {
                var8_18 = var19_1.cindex << 2 | var3_7 & 31;
                var9_8 = var11_15 << 2;
                var12_19 = var19_1.hindex;
                if (var20_2 != IcePIC7.lastDir) {
                    if (IcePIC7.lastDir <= 0) {
                        IcePIC7.wait4dma(16);
                    } else {
                        IcePIC7.wait4route(131072);
                    }
                    IcePIC7.awBus(0x1008010, 0);
                }
                if (var20_2 != 0) {
                    if (var20_2 < 0) {
                        var2_6 = var6_9 & 31;
                        if (var2_6 != 0) {
                            var1_4 = 32 - var2_6;
                            var6_9 += var1_4;
                            var12_19 -= var1_4;
                            if ((var8_18 -= var1_4 << 6) < var19_1.caddr << 2) {
                                var8_18 += var13_12 << 2;
                            }
                        }
                        if (IcePIC7.wait4route(0x2000000) < 0) {
                            IcePIC7.unlockDMA(var19_1);
                            return;
                        }
                        IcePIC7.setupDMAi(1, var8_18, var9_8);
                        IcePIC7.wait4dma(16);
                        IcePIC7.awBus(0x1008008, 0x2000000);
                    } else if (var20_2 == 2) {
                        IcePIC7.wait4dma(16);
                    } else {
                        if (IcePIC7.wait4route(131072) < 0) {
                            IcePIC7.unlockDMA(var19_1);
                            return;
                        }
                        IcePIC7.awBus(0x1008010, 0);
                    }
                }
                if (var20_2 != 0) {
                    var15_20 = var19_1.mcsr;
                    IcePIC7.awBus(33554520, var12_19 << 6);
                    IcePIC7.awBus(0x2000044, var12_19 >> 26);
                    IcePIC7.awBus(33554524, var6_9 << 6);
                    IcePIC7.awBus(33554504, var15_20);
                    IcePIC7.wait4dma(256);
                }
                if (var20_2 == 1) {
                    IcePIC7.setupDMAo(1, var8_18, var9_8);
                    IcePIC7.awBus(0x1008008, 131072);
                }
                IcePIC7.updateHIP(var19_1, var19_1.hindex);
                IcePIC7.lastDir = var20_2;
            }
        }
        if (var11_15 < var19_1.cindex) {
            ++var19_1.ccycle;
        }
        var19_1.cindex = var11_15;
        if (var10_14 < var19_1.hindex) {
            ++var19_1.hcycle;
            if (var19_1.todo >= 1) {
                --var19_1.todo;
            }
            if (var19_1.todo == 0 && var19_1.chain != 0) {
                var1_4 = var19_1.chain << 2;
                var19_1.haddr = IcePIC7.arMem(var1_4);
                var19_1.hsize = IcePIC7.arMem(var1_4 += 4);
                var19_1.todo = IcePIC7.arMem(var1_4 += 4);
                var19_1.chain = IcePIC7.arMem(var1_4 += 4);
                var10_14 = var19_1.haddr;
            }
            if (((var3_7 = IcePIC7.readmod(var19_1.mcfg)) & 4) != 0) {
                var19_1.err = var3_7 >> 8 & 255;
                if (var19_1.err == 0) {
                    var19_1.err = 256;
                }
            }
        }
        var19_1.hindex = var10_14;
    }

    public static void portStart(IceHW.DMAStruct dMAStruct) {
        int n = IcePIC7.getside(dMAStruct);
        int n2 = dMAStruct.dir;
        int n3 = IcePIC7.arBus(0x1008000);
        int n4 = n3 | dMAStruct.enb;
        int n5 = IcePIC7.arMem(-50200652) & 0xFFFFFF1F;
        if ((dMAStruct.feed & 0xF) != 0) {
            if ((n4 & 0x40003A00) != 0 && (n3 & 0x40003A00) == 0) {
                IcePIC7.awBus(0x40000000, 1);
            }
            if ((n4 & 0x8000C500) != 0 && (n3 & 0x8000C500) == 0) {
                IcePIC7.awBus(Integer.MIN_VALUE, 1);
            }
            if ((n4 & 0x1200) != 0 && (n3 & 0x1200) == 0) {
                IcePIC7.awBus2z(0x40000010);
            }
            if ((n4 & 0x2800) != 0 && (n3 & 0x2800) == 0) {
                IcePIC7.awBus2z(0x40000014);
            }
            if ((n4 & 0x4100) != 0 && (n3 & 0x4100) == 0) {
                IcePIC7.awBus2z(-2147483632);
            }
            if ((n4 & 0x8400) != 0 && (n3 & 0x8400) == 0) {
                IcePIC7.awBus2z(-2147483628);
            }
        }
        if ((n4 & 0x4045153) != 0 != ((n4 & 0x808A8AC) != 0)) {
            n5 |= 0x20;
        }
        if ((n4 & 0x400000) == 0 || (n4 & 0x800000) == 0) {
            n5 |= 0x80;
        }
        if ((dMAStruct.mcfg & 0x200000) != 0) {
            n5 |= 0x20;
            if ((n4 & 0x99) != 0) {
                n5 |= 0x40;
            }
        }
        if ((dMAStruct.flags & Integer.MIN_VALUE) != 0) {
            if (n2 < 0) {
                n5 |= 0x2000000;
            } else if ((dMAStruct.flags & 0x100000) == 0) {
                n5 |= 0x1000000;
                IcePIC7.awBus(0x1008008, 65536);
            }
        }
        if (n2 == 2) {
            n5 |= 0x200000;
        }
        if (n2 == -2) {
            IcePIC7.awMem((dMAStruct.cindp ^ 0x10) << 2, dMAStruct.todo == 1 ? 0 : dMAStruct.haddr);
            n5 |= 0x100000;
        }
        IcePIC7.awMem(-50200652, n5);
        IcePIC7.awBus(16809988, n5);
        int n6 = n == 2 ? 0x8000004 : 0x4000004;
        int n7 = IcePIC7.arMem(-50200592);
        if (n7 != 0) {
            IcePIC7.awBus(n6 - 3, 0);
        }
        n4 = IcePIC7.arBusSync(n6);
        if (n == 3 && (dMAStruct.mcfg & Integer.MIN_VALUE) != 0) {
            n4 += IcePIC7.arBus(0x8000004);
        }
        if (dMAStruct.stat == 0) {
            IcePIC7.awBus(0x1008008, dMAStruct.enb);
        }
        IcePIC7.writemod(n7);
        IcePIC7.awMem(-50200600, n4);
        IcePIC7.awMem(-50200592, 0);
        if (dMAStruct.stat != 3) {
            dMAStruct.stat = 1;
        }
        if (n2 < 0) {
            IcePIC7.updateHIP(dMAStruct, 0);
        } else {
            if (dMAStruct.todo > 0 || dMAStruct.todo == -17) {
                dMAStruct.alg = 1;
            }
            if (dMAStruct.todo == -11) {
                dMAStruct.stat = -1;
                dMAStruct.todo = 1;
            }
        }
    }

    public static void portStop(IceHW.DMAStruct dMAStruct) {
        int n = dMAStruct.enb;
        int n2 = IcePIC7.getside(dMAStruct);
        int n3 = IcePIC7.arBus(0x1008000);
        if (dMAStruct.dir > 0 && dMAStruct.alg > 0 && dMAStruct.feed == 0) {
            if (dMAStruct.alg == 1) {
                dMAStruct.alg = 2;
                IcePIC7.awMem(dMAStruct.cindp + 1 << 2, dMAStruct.cindex << 2);
            }
            if ((n & IcePIC7.arBus(0x1008000)) != 0) {
                return;
            }
        }
        if (dMAStruct.dir > 0 && (n & 0xFF000000) != 0) {
            IcePIC7.awBus(16809996, n & 0xFF000000);
            IcePIC7.udelay(100);
        }
        dMAStruct.stat = 0;
        int n4 = IcePIC7.getenb();
        n &= n4 ^ n3;
        if ((n4 & 0x40003A00) == 0 && (n3 & 0x40003A00) != 0) {
            IcePIC7.awBus(0x40000000, 0);
        }
        if ((n4 & 0x8000C500) == 0 && (n3 & 0x8000C500) != 0) {
            IcePIC7.awBus(Integer.MIN_VALUE, 0);
        }
        IcePIC7.awBus(n2 == 2 ? 0x8000001 : 0x4000001, 0);
        IcePIC7.awBus(16809996, n);
        if (n2 == 3) {
            n2 = 1;
        }
        int n5 = IcePIC7.arMem(-50200592 + (n2 << 2));
        IcePIC7.writemod(n5);
        IcePIC7.updateHIP(dMAStruct, 0);
        if (n4 == 0) {
            n3 = IcePIC7.arMem(-50200652);
            IcePIC7.awMem(-50200652, n3 &= 0xFCCFFFFF);
        }
    }

    public static int getenb() {
        int n = 0;
        int n2 = -50201088;
        int n3;
        while ((n3 = IcePIC7.arMem(n2)) != 0) {
            IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n3 <<= 2);
            if (dMAStruct.stat != 0) {
                n |= dMAStruct.enb;
            }
            n2 += 4;
        }
        return n;
    }

    public static int getside(IceHW.DMAStruct dMAStruct) {
        int n = dMAStruct.mcfg >> 28 & 3;
        if (n == 0) {
            n = (dMAStruct.port & 1) != 0 ? 1 : 2;
        }
        return n;
    }

    public static void updateHIP(IceHW.DMAStruct dMAStruct, int n) {
        if (dMAStruct.hindp <= 163840) {
            return;
        }
        IcePIC7.awBus(dMAStruct.hindp << 2, n);
    }

    public static void unlockDMA(IceHW.DMAStruct dMAStruct) {
        int n = IcePIC7.arBus(33554504);
        if ((n & 0x10) != 0) {
            IcePIC7.awBus(33554504, n &= 0xFFFFFFEF);
        }
        ++dMAStruct.err;
    }

    public static int adon_mstat(int n) {
        int n2 = 0;
        int n3 = n << 28;
        int n4 = -50201088;
        int n5;
        while ((n5 = IcePIC7.arMem(n4)) != 0) {
            IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n5 <<= 2);
            if (dMAStruct.stat != 0 && (dMAStruct.mcfg & n3) != 0) {
                n2 |= dMAStruct.mcfg;
            }
            n4 += 4;
        }
        return n2;
    }

    public static int adon_nstat(int n) {
        int n2;
        int n3 = 0;
        int n4 = 159744 + (n - 1) * 48 << 2;
        int n5 = -50201088;
        while ((n2 = IcePIC7.arMem(n5)) != 0) {
            IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n2 <<= 2);
            if (n2 == n4) {
                n3 |= dMAStruct.dec - 1;
                if (dMAStruct.todo != 0) {
                    n3 |= 0x8000;
                }
            } else if (dMAStruct.master == n) {
                int n6 = dMAStruct.port - 1 >> 1 & 0xF;
                n3 |= 1 << 16 + n6;
            }
            n5 += 4;
        }
        return n3;
    }

    public static int wait4route(int n) {
        for (int i = 0; i < 65520; ++i) {
            if ((IcePIC7.arBus(0x1008000) & n) == 0) {
                return i;
            }
            if (i <= 4096) continue;
            IcePIC7.udelay(10);
        }
        IcePIC7.awBus(16809996, n);
        return -1;
    }

    public static int wait4dma(int n) {
        int n2 = 0;
        int n3;
        while (((n3 = IcePIC7.arBus(33554504)) & n) != 0) {
            if ((n3 & 0x80) != 0) {
                return n2;
            }
            if (n2 > 65520) {
                return -1;
            }
            if (n2 > 4096) {
                IcePIC7.udelay(10);
            }
            ++n2;
        }
        return n2;
    }

    public static void initMC() {
        IcePIC7.memz(0, 8191);
        IcePIC7.resetDMA();
    }

    public static void wfifo(int n, int n2) {
        int n3 = n & 0xFFF00000;
        int n4 = 64;
        maddr = n3 > 0 ? -50200768 : n;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = IcePIC7.arBusSync(33554504);
            if ((n6 & 0x10000000) != 0) continue;
            if (n3 > 0 && (n5 & 0xF) == 0) {
                maddr = -50200768;
                ioadr = n;
                ioctl = 65600;
                n += n4;
                maddr = -50200768;
            }
            int n7 = mdata;
            IcePIC7.awBus(0x2000000, n7);
            ++n5;
        }
    }

    public static int rafifo() {
        while ((IcePIC7.arBus(33554504) & 0x8000000) != 0) {
        }
        return IcePIC7.arBus(0x2000000);
    }

    public static void rfifo(int n, int n2) {
        int n3 = n & 0xFFF00000;
        int n4 = 64;
        maddr = n3 > 0 ? -50200768 : n;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7 = IcePIC7.arBusSync(33554504);
            if ((n7 & 0x8000000) != 0) continue;
            mdata = n6 = IcePIC7.arBus(0x2000000);
            if (n3 <= 0 || (++n5 & 0xF) != 0) continue;
            maddr = -50200768;
            ioadr = n;
            ioctl = 131136;
            n += n4;
            maddr = -50200768;
        }
    }

    protected static void writemod(int n) {
        if (n == 0) {
            return;
        }
        int n2 = (n >> 28 & 3) << 26 | 0x400000;
        IcePIC7.awBus(n2, n);
    }

    protected static int readmod(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = (n >> 28 & 3) << 26 | 0x400000;
        return IcePIC7.arBus(n2);
    }

    public static void dojtagx(int n, int n2, int n3) {
        IcePIC7.awBus(0x800000, n);
        while ((IcePIC7.arBus(0x80000C) & 1) != 0) {
        }
        IcePIC7.awBus(0x800004, n2);
        IcePIC7.awBus(0x800008, n3);
    }

    public static int dojtag(int n, int n2, int n3) {
        int n4 = n2;
        IcePIC7.awBus(0x800000, n);
        IcePIC7.awBus(0x800004, n2);
        IcePIC7.awBus(0x800008, n3);
        while ((IcePIC7.arBus(0x80000C) & 1) != 0) {
        }
        if ((n3 & 0xF00) != 0) {
            n4 = IcePIC7.arBus(0x800000);
        }
        return n4;
    }

    public static int dompio(int n, int n2, int n3) {
        int n4 = n >> 24 & 0xFF;
        int n5 = n >> 16 & 0xFE;
        IcePIC7.mpc_ssa(n4, 1);
        IcePIC7.mpc_dwr(n4, n5);
        if ((n & 0x8000) != 0) {
            IcePIC7.mpc_dwr(n4, n >> 8 & 0x7F);
        }
        IcePIC7.mpc_dwr(n4, n & 0xFF);
        if (n3 < 0) {
            n3 = -n3;
            n2 = 0;
            IcePIC7.mpc_ssa(n4, -1);
            IcePIC7.mpc_ssa(n4, 1);
            IcePIC7.mpc_dwr(n4, n5 | 1);
            for (int i = 0; i < n3; ++i) {
                int n6 = i == n3 - 1 ? 1 : 0;
                n2 |= IcePIC7.mpc_drd(n4, n6) << (i << 3);
            }
        } else if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                IcePIC7.mpc_dwr(n4, n2);
                n2 >>= 8;
            }
        }
        IcePIC7.mpc_ssa(n4, -1);
        return n2;
    }

    public static int mpc_acc(int n, int n2, int n3) {
        if (n3 > 0) {
            IcePIC7.awBus(0x80000C, n << 4 | n2);
        } else {
            n2 = IcePIC7.arBus(0x80000C) >> n + 8;
        }
        IcePIC7.udelay(3);
        return n2;
    }

    public static void mpc_ssa(int n, int n2) {
        if (n2 > 0) {
            IcePIC7.mpc_acc(n, 15, 1);
            IcePIC7.mpc_acc(n, 13, 1);
        } else if (n2 < 0) {
            IcePIC7.mpc_acc(n, 13, 1);
            IcePIC7.mpc_acc(n, 15, 1);
        } else {
            IcePIC7.mpc_acc(n, 5, 1);
        }
    }

    public static void mpc_dwr(int n, int n2) {
        IcePIC7.mpc_acc(n, 12, 1);
        for (int i = 0; i < 8; ++i) {
            int n3 = (n2 & 0x80) != 0 ? 2 : 0;
            IcePIC7.mpc_acc(n, 0xC | n3, 1);
            IcePIC7.mpc_acc(n, 0xD | n3, 1);
            IcePIC7.mpc_acc(n, 0xC | n3, 1);
            n2 <<= 1;
        }
        IcePIC7.mpc_acc(n, 4, 1);
        IcePIC7.mpc_acc(n, 5, 1);
        IcePIC7.mpc_acc(n, 12, 1);
    }

    public static int mpc_drd(int n, int n2) {
        int n3;
        int n4 = 0;
        for (int i = 0; i < 8; ++i) {
            IcePIC7.mpc_acc(n, 4, 1);
            IcePIC7.mpc_acc(n, 5, 1);
            n3 = IcePIC7.mpc_acc(n, 0, -1);
            if ((n3 & 2) == 0) continue;
            n4 |= 1 << 7 - i;
        }
        n3 = n2 != 0 ? 2 : 0;
        IcePIC7.mpc_acc(n, 4, 1);
        IcePIC7.mpc_acc(n, 0xC | n3, 1);
        IcePIC7.mpc_acc(n, 0xD | n3, 1);
        IcePIC7.mpc_acc(n, 0xC | n3, 1);
        IcePIC7.mpc_acc(n, 12, 1);
        return n4;
    }

    protected static int dmaSync(int n) {
        maddr = n;
        int n2 = mdata;
        return n2 -= mdata;
    }

    protected static void reset() {
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.awBus(0x1008010, 0);
        dmaqp = -50201088;
        IcePIC7.awMem(dmaqp, 0);
        IcePIC7.awMem(-50331648, 0);
        runMode = 0;
    }

    protected static void resetDMA() {
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.udelay(20);
        IcePIC7.awBus(0x1008000, -1);
        IcePIC7.memz(-41926912, 16);
        IcePIC7.memz(-41926848, 16);
        IcePIC7.memz(-41943040, 64);
        IcePIC7.memz(-41926784, 16);
        IcePIC7.memz(-41926720, 16);
        IcePIC7.awBus(16809988, 0);
    }

    static void setupDMAo(int n, int n2, int n3) {
        maddr = -41926848 + (n << 3);
        mdata = n2;
        mdata = n3;
    }

    static void setupDMAi(int n, int n2, int n3) {
        maddr = -41926912 + (n << 3);
        mdata = n2;
        mdata = n3;
    }

    static int getDMAi(int n) {
        maddr = -41926912 + (n << 3);
        return mdata;
    }

    static void setupDMAt(int n, int n2) {
        maddr = -41943040 + (n << 2);
        mdata = n2;
    }

    static void user2jcmd(int n) {
        int n2 = n >> 27 & 0xC;
        int n3 = 22 - n2;
        if (n2 == 12) {
            IcePIC7.dojtag(939524319, -265289473, n | 0xF);
        } else {
            IcePIC7.dojtag(939524319, 16323 << n3 | 0xFF, n | 0xF);
        }
    }

    public static void processMessages() {
        maddr = -50331644;
        int n = mdata;
        int n2 = mdata;
        int n3 = mdata;
        int n4 = n2 & 0x3F;
        int n5 = n2 >> 16 & 0xFFFF;
        int n6 = n5 >> 2;
        int n7 = -50331632;
        switch (n4) {
            case 1: {
                IcePIC7.busr(n3, n7, n6);
                break;
            }
            case 2: {
                IcePIC7.busw(n3, n7, n6);
                n5 = 0;
                break;
            }
            case 3: {
                IcePIC7.memr(n3, n7, n6);
                break;
            }
            case 4: {
                IcePIC7.memw(n3, n7, n6);
                n5 = 0;
                break;
            }
            case 6: {
                IcePIC7.initAlgorithm();
                break;
            }
            case 8: 
            case 9: {
                int n8 = n3 & 0xFFFF;
                int n9 = n3 >> 16;
                int n10 = mdata;
                if (n4 == 8) {
                    IcePIC7.openAlgorithm(n8, n9, n10);
                    break;
                }
                IcePIC7.closeAlgorithm(n8, n9, n10);
                break;
            }
            case 14: {
                IcePIC7.busrwm(n3, n7, n6);
                break;
            }
            case 15: {
                IcePIC7.memi(n7, n6);
                n5 = 0;
            }
        }
        maddr = -50331648;
        mdata = 0xAA0000AA | n5 << 8;
    }

    public static void initAlgorithm() {
        IcePIC7.resetDMA();
        runMode = 0;
    }

    public static void openAlgorithm(int n, int n2, int n3) {
        IcePIC7.awBus(0x1008008, n3);
    }

    public static void processAlgorithm() {
    }

    public static void closeAlgorithm(int n, int n2, int n3) {
        IcePIC7.awBus(16809996, n3);
        if (IcePIC7.arBus(0x1008000) == 0) {
            IcePIC7.resetDMA();
        }
    }

    public static void modifyAlgorithm(int n, int n2) {
    }

    protected static void awBus2z(int n) {
        saddr = n;
        sdata = 0;
        saddr = n + 8;
        sdata = 0;
    }

    public static int adon_tc(int n, int n2, int n3) {
        int n4;
        int n5;
        IceHW.DMAStruct dMAStruct = (IceHW.DMAStruct)IcePIC7.getObjectAt(n);
        int n6 = 0;
        if ((dMAStruct.mcfg & Integer.MIN_VALUE) != 0) {
            n5 = 0x4400000;
            n4 = IcePIC7.arBus(n5 + 0);
            if ((n4 & 0x80) == 0) {
                n5 = 0x8400000;
                n6 = 128;
            }
        } else {
            n5 = 0x400000 | ((n2 & 1) != 0 ? 0x4000000 : 0x8000000);
        }
        if (((n4 = IcePIC7.arBus(n5 + 0)) & 0x80) == 0) {
            return 0;
        }
        int n7 = dMAStruct.cindex;
        int n8 = dMAStruct.ccycle;
        int n9 = dMAStruct.hindex;
        int n10 = dMAStruct.hcycle;
        maddr = -50200640;
        mdata = n7;
        mdata = n8;
        mdata = n10;
        if (n3 == 7) {
            int n11 = n5 + 128 + 8;
            if ((n4 & 0x40) == 0) {
                n11 += 64;
            }
            int n12 = 3 & IcePIC7.arBus(n11);
            mdata = IcePIC7.arBus(n11 += 4);
            mdata = IcePIC7.arBus(n11 += 4);
            mdata = IcePIC7.arBus(n11 += 4);
            n6 += IcePIC7.arBus(n11 += 4);
            n6 = n12 == 0 ? (n6 <<= 3) : (n12 == 1 ? (n6 <<= 2) : (n6 <<= 1));
            mdata = n6;
        } else {
            int n13 = n5 + 32;
            if ((n4 & 0x40) == 0) {
                n13 += 16;
            }
            mdata = IcePIC7.arBus(n13);
            mdata = IcePIC7.arBus(n13 += 4);
            mdata = IcePIC7.arBus(n13 += 4);
            mdata = IcePIC7.arBus(n13 += 4);
            n13 += 4;
        }
        mdata = n9;
        return n4;
    }

    public static void user2done(int n) {
        IcePIC7.dojtag(255, -1, n | 1);
        IcePIC7.awBus(0x800008, 0);
    }

    public static int adon_rwiob(int n, int n2, int n3, boolean bl) {
        int n4 = bl ? 0 : n2;
        int n5 = n & 0xFFFF0000;
        n &= 0xFFFF;
        if ((n5 & 0x10000000) != 0) {
            if (bl) {
                if (n == 0) {
                    n4 = IcePIC7.arMem(baddr);
                    baddr += 4;
                }
            } else {
                for (int i = 0; i < n3; i += 4) {
                    if (n3 > 4) {
                        n2 = IcePIC7.rafifo();
                    }
                    if (n == 4 || n == 12) {
                        baddr = n2;
                        continue;
                    }
                    if (n != 0) continue;
                    IcePIC7.awMem(baddr, n2);
                    baddr += 4;
                }
            }
        } else {
            IcePIC7.user2jcmd(n5);
            int n6 = (bl ? 0xE000300 : 0x2000300) | n >> 8 | (n & 0xFF) << 16;
            if (bl) {
                IcePIC7.dojtag(0, n6, n5 | 0xF);
                int n7 = 0;
                do {
                    int n8 = n7 + 1 == n3 ? 1280 : 3072;
                    n8 = IcePIC7.dojtag(0, n8, n5 | 0x303);
                    n4 |= (n8 & 0xFF) << (n7 << 3);
                } while (++n7 < n3);
            } else {
                for (int i = 0; i < n3; ++i) {
                    if ((i & 3) == 0) {
                        IcePIC7.dojtag(0, n6, n5 | 0xF);
                        if (n3 > 4) {
                            n2 = IcePIC7.rafifo();
                        }
                    }
                    int n9 = 0x800 | n2 & 0xFF;
                    IcePIC7.dojtag(0, n9, n5 | 3);
                    n2 >>= 8;
                }
            }
            IcePIC7.user2done(n5);
        }
        return n4;
    }

    public static int adon_wriop(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n & 0xFFFF0000;
        IcePIC7.user2jcmd(n5);
        int n6 = 0x2000300 | (n &= 0xFFFF) >> 8 | (n & 0xFF) << 16;
        n3 <<= 1;
        for (int i = 0; i < n3; ++i) {
            if ((i & 3) == 0) {
                if ((i & 4) == 0) {
                    IcePIC7.dojtag(0, n6, n5 | 0xF);
                    n2 = IcePIC7.rafifo();
                } else {
                    n2 = n4;
                }
            }
            int n7 = 0x800 | n2 & 0xFF;
            IcePIC7.dojtag(0, n7, n5 | 3);
            n2 >>= 8;
        }
        IcePIC7.user2done(n5);
        return n4;
    }

    public static void prep_rwdata(int n, int n2, boolean bl) {
        int n3 = n | 0xF;
        IcePIC7.dojtag(0, 393282, n3);
        IcePIC7.dojtag(0, 0x80008 | n2 << 4, n3);
        IcePIC7.dojtag(0, bl ? 393474 : 393218, n3);
    }

    public static int adon_rddata(int n) {
        int n2 = 0;
        for (int i = 0; i < 32; i += 16) {
            int n3 = 851981;
            int n4 = IcePIC7.dojtag(0, n3, n | 0xF0F);
            n2 |= (n4 >> 8 & 0xFF | n4 >> 16 & 0xFF00) << i;
        }
        return n2;
    }

    public static void adon_wrdata(int n, int n2) {
        for (int i = 0; i < 2; ++i) {
            int n3 = 0xC000C | (n2 & 0xFF00) << 12 | (n2 & 0xFF) << 4;
            IcePIC7.dojtag(0, n3, n | 0xF);
            n2 >>= 16;
        }
    }

    public static int adon_wrb(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3;
        int n7 = 0x55000077 | n3 << 8;
        IcePIC7.user2jcmd(n4);
        IcePIC7.prep_rwdata(n4, 4, false);
        IcePIC7.adon_wrdata(n4, n);
        if (n3 <= 4) {
            IcePIC7.adon_wrdata(n4, n2);
        } else {
            while (n3 > 0) {
                IcePIC7.adon_wrdata(n4, IcePIC7.rafifo());
                n3 -= 4;
            }
        }
        IcePIC7.prep_rwdata(n4, 0, true);
        IcePIC7.adon_wrdata(n4, n7);
        for (int i = 0; i < 1000 && ((n5 = IcePIC7.adon_rddata(n4)) & 0xFF) != 170; ++i) {
            if (i <= 100) continue;
            n6 = -i;
        }
        IcePIC7.user2done(n4);
        return n6;
    }
}

