/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.inc.Constants;
import nxm.sys.inc.DataTypes;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Time;

public class CoreCommon
implements Constants,
DataTypes {
    public static final int FUNC = 0;
    public static final int FORM = 1;
    public static final int FLOW = 2;
    public static final int IMPL = 3;
    public static final int FLGS = 4;
    public static final int SCID = 5;
    public static final int MCID = 6;
    public static final int VBPR = 7;
    public static final int ARRAY = 0;
    public static final int STREAM = 1;
    public static final int BUFFER = 2;
    public static final int BUFSTR = 3;
    public static final int PACKET = 4;
    public static byte[] cvbb = new byte[8];

    public SxShort SxShort_stk() {
        return new SxShort();
    }

    public SxFloat SxFloat_stk() {
        return new SxFloat();
    }

    public SxDouble SxDouble_stk() {
        return new SxDouble();
    }

    public CxByte CxByte() {
        return new CxByte();
    }

    public CxShort CxShort_stk() {
        return new CxShort();
    }

    public CxFloat CxFloat_stk() {
        return new CxFloat();
    }

    public CxDouble CxDouble_stk() {
        return new CxDouble();
    }

    public VxShort VxShort_stk() {
        return new VxShort();
    }

    public VxFloat VxFloat_stk() {
        return new VxFloat();
    }

    public VxDouble VxDouble_stk() {
        return new VxDouble();
    }

    public static boolean getBit(int n, int n2) {
        return (n >> n2 & 1) != 0;
    }

    public static boolean getBit(long l, int n) {
        return (l >> n & 1L) != 0L;
    }

    public static int getBits(int n, int n2, int n3) {
        int n4 = (2 << n2 - n3) - 1;
        return n >> n3 & n4;
    }

    public static int getBits(long l, int n, int n2) {
        int n3 = (2 << n - n2) - 1;
        return (int)(l >> n2) & n3;
    }

    public static int getPBS(int n, int n2, int n3, int n4) {
        int n5 = n3 - n4 + 1;
        int n6 = (1 << n5) - 1;
        return n << n5 | n2 >> n4 & n6;
    }

    public static long getPBS(long l, long l2, int n, int n2) {
        int n3 = n - n2 + 1;
        long l3 = (1 << n3) - 1;
        return l << n3 | l2 >> n2 & l3;
    }

    public static int getPABS(int n, int n2, int n3) {
        int n4 = (1 << n3) - 1;
        return n << n3 | n2 & n4;
    }

    public static long getPABS(long l, long l2, int n) {
        long l3 = (1 << n) - 1;
        return l << n | l2 & l3;
    }

    public static int getPBBS(int n, boolean bl) {
        return n << 1 | (bl ? 1 : 0);
    }

    public static int gatherBits(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            n5 |= (n >> n2 & 1) << n6;
            ++n6;
            n2 += n3;
        }
        return n5;
    }

    public static int setBit(int n, int n2, boolean bl) {
        int n3 = 1 << n2;
        return bl ? n | n3 : n & ~n3;
    }

    public static long setBit(long l, int n, boolean bl) {
        long l2 = 1L << n;
        return bl ? l | l2 : l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte setBits(byte by, int n, int n2, int n3) {
        int n4 = (2 << n - n2) - 1;
        return (byte)(by & ~(n4 << n2) | (n3 & n4) << n2);
    }

    public static short setBits(short s, int n, int n2, int n3) {
        int n4 = (2 << n - n2) - 1;
        return (short)(s & ~(n4 << n2) | (n3 & n4) << n2);
    }

    public static int setBits(int n, int n2, int n3, int n4) {
        int n5 = (2 << n2 - n3) - 1;
        return n & ~(n5 << n3) | (n4 & n5) << n3;
    }

    public static long setBits(long l, int n, int n2, long l2) {
        long l3 = (2L << n - n2) - 1L;
        return l & (l3 << n2 ^ 0xFFFFFFFFFFFFFFFFL) | (l2 & l3) << n2;
    }

    public static double cpuTime() {
        return 0.001 * (double)System.currentTimeMillis();
    }

    public static String cpuDate() {
        return Time.currentTime().toString();
    }

    public static void cpuWait(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static int s2i(short s) {
        return s;
    }

    public static long s2l(short s) {
        return s;
    }

    public static short i2s(int n) {
        return (short)n;
    }

    public static float i2f(int n) {
        return n;
    }

    public static float d2f(double d) {
        return (float)d;
    }

    public static int d2i(double d) {
        return (int)d;
    }

    public static long d2l(double d) {
        return (long)d;
    }

    public static int f2i(float f) {
        return (int)f;
    }

    public static int l2i(long l) {
        return (int)l;
    }

    public static short l2s(long l) {
        return (short)l;
    }

    public static double f2d(float f) {
        return f;
    }

    public static double i2d(int n) {
        return n;
    }

    public static double l2d(long l) {
        return l;
    }

    public static long ii2l(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static int f2x(float f) {
        return (int)(f * 65536.0f);
    }

    public static long d2x(double d) {
        return (long)(d * 4.294967296E9);
    }

    public static int d2fi(double d) {
        return (int)(CoreCommon.d2x(d) & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int d2wi(double d) {
        return (int)(CoreCommon.d2x(d) >> 32);
    }

    public static double fi2d(int n) {
        return (double)n / 4.294967296E9;
    }

    public static float i2fp(int n) {
        return (float)n / 65536.0f;
    }

    public static int fp2i(float f) {
        return (int)(f * 65536.0f);
    }

    public static int f2fptx(float f) {
        return (int)(f * 65536.0f);
    }

    public static float fptx2f(int n) {
        return (float)n / 65536.0f;
    }

    public static long d2dptx(double d) {
        return (long)(d * 4.294967296E9);
    }

    public static double dptx2d(long l) {
        return (double)l / 4.294967296E9;
    }

    public static short F2I(float f) {
        return (short)(f * 32768.0f);
    }

    public static float I2F(short s) {
        return (float)s / 32768.0f;
    }

    public static float L2F(int n) {
        return (float)n / 2.1474836E9f;
    }

    public static float K2F(int n) {
        return (float)n / 65536.0f;
    }

    public static int F2K(float f) {
        return (int)(f * 65536.0f);
    }

    public static int CI2L(short s, short s2) {
        return s2 << 16 | s & 0xFFFF;
    }

    public static int CF2L(float f, float f2) {
        return CoreCommon.CI2L(CoreCommon.F2I(f), CoreCommon.F2I(f2));
    }

    public static void CF2CI(CxFloat cxFloat, CxShort cxShort) {
        cxShort.x = (short)(cxFloat.x * 32768.0f);
        cxShort.y = (short)(cxFloat.y * 32768.0f);
    }

    public static void CI2CF(CxShort cxShort, CxFloat cxFloat) {
        cxFloat.x = (float)cxShort.x / 32768.0f;
        cxFloat.y = (float)cxShort.y / 32768.0f;
    }

    public static float CI2Fx(int n) {
        return (float)(n <<= 16) / 2.1474836E9f;
    }

    public static float CI2Fy(int n) {
        return (float)(n &= 0xFFFF0000) / 2.1474836E9f;
    }

    public static int IN2P(int n) {
        return n >> 3 & 1 | n >> 6 & 2 | n >> 9 & 4 | n >> 12 & 8;
    }

    public static int LN2P(int n) {
        return n >> 3 & 1 | n >> 6 & 2 | n >> 9 & 4 | n >> 12 & 8 | n >> 15 & 0x10 | n >> 18 & 0x20 | n >> 21 & 0x40 | n >> 24 & 0x80;
    }

    public static int IO2P(int n) {
        return n >> 2 & 1 | n >> 4 & 2 | n >> 6 & 4 | n >> 8 & 8 | n >> 10 & 0x10;
    }

    public static int LO2P(int n) {
        return n >> 2 & 1 | n >> 4 & 2 | n >> 6 & 4 | n >> 8 & 8 | n >> 10 & 0x10 | n >> 12 & 0x20 | n >> 14 & 0x40 | n >> 16 & 0x80 | n >> 18 & 0x100 | n >> 20 & 0x200;
    }

    public static byte[] s2bb(short s) {
        Convert.packI((byte[])cvbb, (int)0, (short)s);
        return cvbb;
    }

    public static byte[] i2bb(int n) {
        Convert.packL((byte[])cvbb, (int)0, (int)n);
        return cvbb;
    }

    public static byte[] f2bb(float f) {
        Convert.packF((byte[])cvbb, (int)0, (float)f);
        return cvbb;
    }

    public static byte[] CF2bb(CxFloat cxFloat) {
        Convert.packF((byte[])cvbb, (int)0, (float)cxFloat.x);
        Convert.packF((byte[])cvbb, (int)4, (float)cxFloat.y);
        return cvbb;
    }

    public static int imin(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int imax(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static float fminf(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static float fmaxf(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static double fmin(double d, double d2) {
        return d < d2 ? d : d2;
    }

    public static double fmax(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static int iabs(int n) {
        return n < 0 ? -n : n;
    }

    public static long labs(long l) {
        return l < 0L ? -l : l;
    }

    public static float fabsf(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double fabs(double d) {
        return d < 0.0 ? -d : d;
    }

    public static float sinf(double d) {
        return (float)Math.sin(d);
    }

    public static float cosf(double d) {
        return (float)Math.cos(d);
    }

    public static float tanf(double d) {
        return (float)Math.tan(d);
    }

    public static float atan2f(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static float sincf(double d) {
        return (float)Math.sin(d * (Math.PI * 2));
    }

    public static float coscf(double d) {
        return (float)Math.cos(d * (Math.PI * 2));
    }

    public static float tancf(double d) {
        return (float)Math.tan(d * (Math.PI * 2));
    }

    public static float atan2cf(float f, float f2) {
        return (float)(Math.atan2(f, f2) / (Math.PI * 2));
    }

    public static float invf(float f) {
        return 1.0f / f;
    }

    public static float invfi(int n) {
        return 1.0f / (float)n;
    }

    public static float sqrtf(float f) {
        return (float)Math.sqrt(f);
    }

    public static float log10f(float f) {
        return (float)Math.log10(f);
    }

    public static float roundf(float f) {
        return Math.round(f);
    }

    public static float floorf(float f) {
        return (float)Math.floor(f);
    }

    public static float fracf(float f) {
        return f - (float)Math.floor(f);
    }

    public static float wrapf(float f) {
        return CoreCommon.fracf(f + 0.5f) - 0.5f;
    }

    public static float ceilf(float f) {
        return (float)Math.ceil(f);
    }

    public static float fmodf(float f, float f2) {
        return f % f2;
    }

    public static float powf(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static int fintf(float f) {
        return (int)f;
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double sinc(double d) {
        return Math.sin(d * (Math.PI * 2));
    }

    public static double cosc(double d) {
        return Math.cos(d * (Math.PI * 2));
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    public static double inv(double d) {
        return 1.0 / d;
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double log10(double d) {
        return Math.log10(d);
    }

    public static double log2(double d) {
        return Math.log(d) * 1.44269504088896;
    }

    public static double round(double d) {
        return Math.round(d);
    }

    public static double floor(double d) {
        return Math.floor(d);
    }

    public static double ceil(double d) {
        return Math.ceil(d);
    }

    public static double frac(double d) {
        return d - Math.floor(d);
    }

    public static double wrap(double d) {
        return CoreCommon.frac(d + 0.5) - 0.5;
    }

    public static double fmod(double d, double d2) {
        return d % d2;
    }

    public static double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static double divii(int n, int n2) {
        return (double)n / (double)n2;
    }

    public static double divdi(double d, int n) {
        return d / (double)n;
    }

    public static double divp2(double d, int n) {
        return d / (double)(1 << n);
    }

    public static double mulp2(double d, int n) {
        return d * (double)(1 << n);
    }

    public static float divf(float f, float f2) {
        return f / f2;
    }

    public static float divfi(float f, int n) {
        return f / (float)n;
    }

    public static float divfp2(float f, int n) {
        return f / (float)(1 << n);
    }

    public static float mulfp2(float f, int n) {
        return f * (float)(1 << n);
    }

    public static double muldf(double d, float f) {
        return d * (double)f;
    }

    public static double muldi(double d, int n) {
        return d * (double)n;
    }

    public static float mulfi(float f, int n) {
        return f * (float)n;
    }

    public static float mulff(float f, float f2) {
        return f * f2;
    }

    public static int mulif(int n, float f) {
        return (int)((float)n * f);
    }

    public static int fint(double d) {
        return (int)d;
    }

    public static void muxf(float f, float f2, CxFloat cxFloat) {
        cxFloat.x = f;
        cxFloat.y = f2;
    }

    public static float phaseditherf() {
        return 0.0f;
    }

    public static double clip(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static float clipf(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static int clipl(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static double sclip(double d, double d2) {
        return d < -d2 ? -d2 : (d > d2 ? d2 : d);
    }

    public static float sclipf(float f, float f2) {
        return f < -f2 ? -f2 : (f > f2 ? f2 : f);
    }

    public static int sclipl(int n, int n2) {
        return n < -n2 ? -n2 : (n > n2 ? n2 : n);
    }

    public static short bswap2(int n) {
        return (short)(n >> 8 & 0xFF | n << 8);
    }

    public static short bswap2(short s) {
        return (short)(s >> 8 & 0xFF | s << 8);
    }

    public static int bswap2s(int n) {
        return n >> 8 & 0xFF | n << 8 & 0xFF00 | n >> 8 & 0xFF0000 | n << 8 & 0xFF000000;
    }

    public static int bswap4(int n) {
        return n >> 24 & 0xFF | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    public static int brev4(int n) {
        int n2 = 0;
        if (n != 0) {
            for (int i = 0; i < 32; ++i) {
                if ((n >> i & 1) == 0) continue;
                n2 |= 1 << 31 - i;
            }
        }
        return n2;
    }

    public static int iLRS(int n) {
        return n << 1 | n >> 0 & 1 ^ n >> 1 & 1 ^ n >> 5 & 1 ^ n >> 25 & 1;
    }

    public static int iLRSP(int n, int n2) {
        return n << 1 | CoreCommon.ones(n & n2, 32) + 1 & 1;
    }

    public static int ones(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += n & 1;
            n >>= 1;
        }
        return n3;
    }

    public static int qwrap2z(CxFloat cxFloat) {
        float f;
        float f2 = f = cxFloat.x < 0.0f ? -cxFloat.x : cxFloat.x;
        return cxFloat.y > f ? 3 : (cxFloat.y < -f ? 1 : (cxFloat.x < 0.0f ? 2 : 0));
    }

    public static void qrotcc(CxFloat cxFloat, int n, CxFloat cxFloat2) {
        switch (n & 3) {
            case 0: {
                cxFloat2.x = cxFloat.x;
                cxFloat2.y = cxFloat.y;
                break;
            }
            case 1: {
                cxFloat2.x = -cxFloat.y;
                cxFloat2.y = cxFloat.x;
                break;
            }
            case 2: {
                cxFloat2.x = -cxFloat.x;
                cxFloat2.y = -cxFloat.y;
                break;
            }
            case 3: {
                cxFloat2.x = cxFloat.y;
                cxFloat2.y = -cxFloat.x;
            }
        }
    }

    public static void dupcc(CxFloat cxFloat, CxFloat cxFloat2) {
        cxFloat2.x = cxFloat.x;
        cxFloat2.y = cxFloat.y;
    }

    public static void sincoscf(float f, CxFloat cxFloat) {
        double d = (double)f * (Math.PI * 2);
        cxFloat.x = (float)Math.cos(d);
        cxFloat.y = (float)Math.sin(d);
    }

    public static void pol2recf(float f, float f2, CxFloat cxFloat) {
        double d = (double)f2 * (Math.PI * 2);
        cxFloat.x = f * (float)Math.cos(d);
        cxFloat.y = f * (float)Math.sin(d);
    }

    public static void addcc(CxFloat cxFloat, CxFloat cxFloat2, CxFloat cxFloat3) {
        cxFloat3.x = cxFloat.x + cxFloat2.x;
        cxFloat3.y = cxFloat.y + cxFloat2.y;
    }

    public static void mulfc(float f, CxFloat cxFloat, CxFloat cxFloat2) {
        cxFloat2.x = f * cxFloat.x;
        cxFloat2.y = f * cxFloat.y;
    }

    public static void mulcf(CxFloat cxFloat, float f, CxFloat cxFloat2) {
        cxFloat2.x = cxFloat.x * f;
        cxFloat2.y = cxFloat.y * f;
    }

    public static void mulcc(CxFloat cxFloat, CxFloat cxFloat2, CxFloat cxFloat3) {
        cxFloat3.x = cxFloat.x * cxFloat2.x - cxFloat.y * cxFloat2.y;
        cxFloat3.y = cxFloat.y * cxFloat2.x + cxFloat.x * cxFloat2.y;
    }

    public static void mulccj(CxFloat cxFloat, CxFloat cxFloat2, CxFloat cxFloat3) {
        cxFloat3.x = cxFloat.x * cxFloat2.x + cxFloat.y * cxFloat2.y;
        cxFloat3.y = cxFloat.y * cxFloat2.x - cxFloat.x * cxFloat2.y;
    }

    public static float mulffrnc(float f, float f2) {
        float f3 = f * f2;
        if (f3 > 1.0f) {
            f3 = 1.0f;
        } else if (f3 < -1.0f) {
            f3 = -1.0f;
        }
        return f3;
    }

    public static void mulfcrnc(float f, CxFloat cxFloat, CxFloat cxFloat2) {
        cxFloat2.x = CoreCommon.mulffrnc(f, cxFloat.x);
        cxFloat2.y = CoreCommon.mulffrnc(f, cxFloat.y);
    }

    public static void mulcfrnc(CxFloat cxFloat, float f, CxFloat cxFloat2) {
        cxFloat2.x = CoreCommon.mulffrnc(cxFloat.x, f);
        cxFloat2.y = CoreCommon.mulffrnc(cxFloat.y, f);
    }

    public static float mag2f(CxFloat cxFloat) {
        return cxFloat.x * cxFloat.x + cxFloat.y * cxFloat.y;
    }

    public static float log10cf(CxFloat cxFloat) {
        return (float)Math.log10(cxFloat.x * cxFloat.x + cxFloat.y * cxFloat.y);
    }

    public static void mulccA(CxFloat cxFloat, CxFloat[] cxFloatArray, CxFloat[] cxFloatArray2, int n) {
        for (int i = 0; i < n; ++i) {
            CoreCommon.mulcc(cxFloat, cxFloatArray[i], cxFloatArray2[i]);
        }
    }

    public static void mulcAc(CxFloat[] cxFloatArray, CxFloat cxFloat, CxFloat[] cxFloatArray2, int n) {
        for (int i = 0; i < n; ++i) {
            CoreCommon.mulcc(cxFloatArray[i], cxFloat, cxFloatArray2[i]);
        }
    }

    public static void mulcAcA(CxFloat[] cxFloatArray, CxFloat[] cxFloatArray2, CxFloat[] cxFloatArray3, int n) {
        for (int i = 0; i < n; ++i) {
            CoreCommon.mulcc(cxFloatArray[i], cxFloatArray2[i], cxFloatArray3[i]);
        }
    }

    public static int pow2ge(int n) {
        int n2 = 0;
        while (1 << n2 < n) {
            ++n2;
        }
        return n2;
    }

    public static int power2ge(int n) {
        int n2 = 0;
        while (1 << n2 < n) {
            ++n2;
        }
        return 1 << n2;
    }

    public static void msumf(float[] fArray, float[] fArray2, SxFloat sxFloat, int n) {
        sxFloat.x = 0.0f;
        for (int i = 0; i < n; ++i) {
            sxFloat.x += fArray[i] * fArray2[i];
        }
    }

    public static void msumcsf(float[] fArray, float[] fArray2, float[] fArray3, CxFloat cxFloat, int n) {
        cxFloat.x = 0.0f;
        cxFloat.y = 0.0f;
        for (int i = 0; i < n; ++i) {
            cxFloat.x += fArray[i] * fArray3[i];
            cxFloat.y += fArray2[i] * fArray3[i];
        }
    }

    public static void msumccf(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, CxFloat cxFloat, int n) {
        cxFloat.x = 0.0f;
        cxFloat.y = 0.0f;
        for (int i = 0; i < n; ++i) {
            cxFloat.x += fArray[i] * fArray3[i] - fArray2[i] * fArray4[i];
            cxFloat.y += fArray[i] * fArray4[i] + fArray2[i] * fArray3[i];
        }
    }

    public static int getListBase(String string) {
        if (string.startsWith("NONE,") || string.startsWith("OFF,")) {
            return 0;
        }
        if (string.startsWith("AUTO,") || string.startsWith("ALL,")) {
            return -1;
        }
        return 1;
    }

    public static int findListItem(String string, String string2, int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = string.length();
        int n5 = string2.length();
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        n3 = n == -2 ? CoreCommon.getListBase(string) : n;
        for (int i = 0; i <= n4; ++i) {
            if (i != n4 && string.charAt(i) != ',') continue;
            if (i >= n2 + n5 && string2.equals(string.substring(n2, n2 + n5))) {
                return n3;
            }
            n2 = i + 1;
            ++n3;
        }
        return -2;
    }

    public static String getListItem(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        int n5 = string.length();
        string = string.toUpperCase();
        n4 = n2 == -2 ? CoreCommon.getListBase(string) : n2;
        for (int i = 0; i <= n5; ++i) {
            if (i != n5 && string.charAt(i) != ',' && string.charAt(i) != '|') continue;
            if (n4 == n) {
                return string.substring(n3, i);
            }
            n3 = i + 1;
            ++n4;
        }
        return "Undefined";
    }

    public static class VxDouble {
        public double x;
        public double y;
        public double z;

        public static VxDouble stk() {
            return new VxDouble();
        }
    }

    public static class VxFloat {
        public float x;
        public float y;
        public float z;

        public static VxFloat stk() {
            return new VxFloat();
        }
    }

    public static class VxShort {
        public short x;
        public short y;
        public short z;

        public static VxShort stk() {
            return new VxShort();
        }
    }

    public static class CxDouble {
        public double x;
        public double y;

        public static CxDouble stk() {
            return new CxDouble();
        }
    }

    public static class CxFloat {
        public float x;
        public float y;

        public static CxFloat stk() {
            return new CxFloat();
        }

        public void set(CxFloat cxFloat) {
            this.x = cxFloat.x;
            this.y = cxFloat.y;
        }

        public void setxy(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public static CxFloat[] newArray(int n) {
            CxFloat[] cxFloatArray = new CxFloat[n];
            for (int i = 0; i < n; ++i) {
                cxFloatArray[i] = new CxFloat();
            }
            return cxFloatArray;
        }
    }

    public static class CxShort {
        public short x;
        public short y;

        public static CxShort stk() {
            return new CxShort();
        }
    }

    public static class CxByte {
        public byte x;
        public byte y;

        public static CxByte stk() {
            return new CxByte();
        }
    }

    public static class SxDouble {
        public double x;

        public static SxDouble stk() {
            return new SxDouble();
        }
    }

    public static class SxFloat {
        public float x;

        public static SxFloat stk() {
            return new SxFloat();
        }
    }

    public static class SxShort {
        public short x;

        public static SxShort stk() {
            return new SxShort();
        }
    }

    public static class TypeDef {
    }
}

