/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class UDAT
extends CoreFactory {
    public static final String pktList = "Auto,None,Noop,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    public static final int PT_AUTO = -1;
    public static final int PT_NONE = 0;
    public static final int PT_NOOP = 1;
    public static final int PT_ICE = 2;
    public static final int PT_SDDS = 3;
    public static final int PT_VRT = 4;
    public static final int PT_VRTL = 5;
    public static final int PT_VRTW = 6;
    public static final int PT_VRTX = 7;
    public static final int PT_VRTD = 8;
    public static final String flgList = "Fill,Time,OUID,DBG,FB3,AnySID,Bypass,CTXF,xSR,xIF,xRF,xGAIN";
    public static final int PF_FILL = 0;
    public static final int PF_TIME = 1;
    public static final int PF_OUID = 2;
    public static final int PF_DBG = 3;
    public static final int PF_FB3 = 4;
    public static final int PF_ANYSID = 5;
    public static final int PF_BYPASS = 6;
    public static final int PF_CTXF = 7;
    public static final int PF_XSR = 8;
    public static final int PF_XIF = 9;
    public static final int PF_XRF = 10;
    public static final int PF_XGAIN = 11;

    public static class CORE
    extends Core {
        public static final int FLOW = 3;
        public static final int SELFPACE = 1;
        public static final int IKR = 8;
        public static final int OKR = 4;
        public static final int OFMT = 5;
        public static final int BW = 32;
        public static final int OUID = 1068407;
        public static final int DIFI = 6971934;
        public double ctime;
        public double srate;
        public int bits;
        public int ptype;
        public int bpa;
        int pkty;
        int flags;
        int sid;
        int pinc;
        int cwsec;
        int nwsec;
        long cpsec;
        long npsec;
        long mpsec;
        int counts;
        int nseq;
        int swaps;
        int length;
        int ifix;
        int mfix;
        int nfix;
        int pad;
        int pstate;
        int npinc;
        int ouid;
        int pass;
        int vctx;
        int dbps;
        int maxfer;

        public void setTime(double d) {
            d = this.ctime > 60.0 ? this.ctime : (d += this.ctime);
            this.cwsec = CORE.d2i(CORE.floor(d));
            this.cpsec = CORE.d2l(CORE.frac(d) * 1.0E12);
            this.nwsec = 0;
            this.npsec = 0L;
            this.putVars("cwsec,cpsec,nwsec,npsec");
        }

        public void startup(double d) {
            this.setTime(d);
            this.poll();
            this.pkty = this.ptype;
            this.putVars("pkty");
        }

        public void setPhaseInc(double d) {
            double d2 = 1.0E12 / d / (double)this.bpa * 4.0;
            this.nfix = 0;
            this.mfix = 0;
            this.npinc = CORE.d2i(CORE.floor(d2 + 0.001));
            if (CORE.fabs(d2 - (double)this.npinc) > 0.001) {
                this.mfix = 1;
                while (this.mfix <= 16) {
                    this.nfix = CORE.d2i(CORE.round((double)this.mfix * (d2 - (double)this.npinc)));
                    double d3 = CORE.fabs((double)this.mfix * (d2 - (double)this.npinc) - (double)this.nfix);
                    if (d3 < 0.001) break;
                    ++this.mfix;
                }
                --this.mfix;
            }
            if (this.mfix == 16) {
                System.out.printf("Fixup for UDAT fractional pinc=%f at fs=%f not achievable\n", d2, d);
                this.nfix = 0;
                this.mfix = 0;
            } else if (this.mfix > 0) {
                System.out.printf("Fixup for UDAT fractional pinc=%f nfix=%d mfix=%d\n", d2, this.nfix, this.mfix);
            }
        }

        public boolean isAsync() {
            return this.ptype != 1 && CORE.getBit(this.flags, 1);
        }

        public double getRate() {
            return this.srate;
        }

        public boolean getCTXF() {
            return CORE.getBit(this.flags, 7);
        }

        @Override
        public int init() {
            this.pkty = 0;
            this.ptype = 1;
            this.flags = 0;
            this.sid = -1;
            this.ctime = 0.0;
            this.srate = -1.0;
            this.bits = -16;
            this.pad = 0;
            this.ouid = 0;
            this.maxfer = 256;
            return 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "S:PT")) {
                this.ptype = value.toItem(UDAT.pktList);
            } else if (this.isMatch(string, "L:PKTY")) {
                this.ptype = value.toL();
            } else if (this.isMatch(string, "L:SID")) {
                this.sid = value.toL();
            } else if (this.isMatch(string, "L:OUID")) {
                this.ouid = value.toL();
            } else if (this.isMatch(string, "L:BITS")) {
                this.bits = value.toL();
            } else if (this.isMatch(string, "L:PAD")) {
                this.pad = value.toL();
            } else if (this.isMatch(string, "D:CTIME")) {
                this.ctime = value.toD();
            } else if (this.isMatch(string, "D:SRATE")) {
                this.srate = value.toD();
            } else if (this.isMatch(string, "L:VCTX")) {
                this.vctx = value.toL();
            } else if (this.isMatch(string, "L:MAXFER")) {
                this.maxfer = value.toL();
            } else if (this.isMatch(string, "L:FLAGS")) {
                this.flags = value.toL();
            } else if (this.isMatch(string, "S:FLAGS")) {
                this.flags = value.toMask(UDAT.flgList);
            } else if (this.isMatch(string, "D:STARTUP")) {
                this.startup(value.toD());
            } else {
                return super.set(string, value);
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:PKTY")) {
                value.fromL(this.ptype);
            } else if (this.isMatch(string, "L:SID")) {
                value.fromL(this.sid);
            } else if (this.isMatch(string, "L:FLAGS")) {
                value.fromL(this.flags);
            } else if (this.isMatch(string, "D:STARTUP")) {
                value.fromD(this.ctime);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.sid &= 0xFFFF;
            this.bpa = this.bits < 0 ? -this.bits * 2 / 8 : this.bits / 8;
            this.dbps = CORE.iabs(this.bits) - 1;
            this.nseq = 0;
            this.counts = 0;
            this.length = 0;
            this.swaps = 0;
            this.nwsec = 0;
            this.npsec = 0L;
            this.mpsec = CORE.d2l(1.0E12);
            this.pstate = 0;
            if (this.ptype == 8) {
                this.ouid = 6971934;
            }
            if (this.ptype == 1) {
                this.bpa = 4;
                this.pkty = this.ptype;
            } else if (this.srate < 1000000.0) {
                System.out.printf("Sample Rate=%f too low for UDAT counters\n", this.srate);
            }
            this.setTime(CORE.cpuTime());
            this.setPhaseInc(this.srate);
            this.pinc = this.npinc;
            this.flags = CORE.setBit(this.flags, 4, this.bpa == 3);
            this.flags = CORE.setBit(this.flags, 5, this.sid == 65535);
            this.flags = CORE.setBit(this.flags, 8, CORE.getBit(this.flags, 8) || CORE.getBit(this.vctx, 24));
            this.flags = CORE.setBit(this.flags, 9, CORE.getBit(this.flags, 9) || CORE.getBit(this.vctx, 25));
            this.flags = CORE.setBit(this.flags, 10, CORE.getBit(this.flags, 10) || CORE.getBit(this.vctx, 26));
            this.flags = CORE.setBit(this.flags, 11, CORE.getBit(this.flags, 11) || CORE.getBit(this.vctx, 27));
            this.flags = CORE.setBit(this.flags, 7, CORE.getBit(this.flags, 7) || CORE.getBit(this.flags, 8) || CORE.getBit(this.flags, 9) || CORE.getBit(this.flags, 10) || CORE.getBit(this.flags, 11));
            this.flags = CORE.setBit(this.flags, 2, CORE.getBit(this.flags, 2) && this.ouid >= 0);
            if (this.ouid <= 0) {
                this.ouid = 1068407;
            }
            this.halo.prep = true;
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("UDAT pkty=%d:%d srate=%f bits=%d flags=%04x\n", this.ptype, this.pkty, this.srate, this.bits, this.flags);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Buffer buffer, CoreComponent.Stream stream) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if (this.halo.prep) {
                this.halo.prep = false;
                buffer.rokLen(this.maxfer << 2);
                return 0;
            }
            boolean bl4 = CORE.getBit(this.flags, 0);
            boolean bl5 = CORE.getBit(this.flags, 1);
            boolean bl6 = CORE.getBit(this.flags, 5);
            boolean bl7 = CORE.getBit(this.flags, 4);
            boolean bl8 = CORE.getBit(this.flags, 3);
            boolean bl9 = CORE.getBit(this.flags, 7);
            boolean bl10 = CORE.getBit(this.flags, 6);
            boolean bl11 = CORE.getBit(this.flags, 2);
            boolean bl12 = CORE.getBit(this.flags, 8);
            boolean bl13 = CORE.getBit(this.flags, 9);
            boolean bl14 = CORE.getBit(this.flags, 10);
            boolean bl15 = CORE.getBit(this.flags, 11);
            boolean bl16 = this.pkty == 0;
            boolean bl17 = this.pkty == 1;
            boolean bl18 = this.pkty == -1 || this.pkty == 2;
            boolean bl19 = this.pkty == 3;
            boolean bl20 = this.pkty == -1 || this.pkty >= 4;
            boolean bl21 = buffer.rok;
            int n = this.pinc;
            boolean bl22 = this.length > 0;
            boolean bl23 = bl3 = this.length < this.maxfer;
            int n2 = !bl21 ? 0 : (bl3 ? this.length : this.maxfer);
            boolean bl24 = this.nwsec > 0;
            int n3 = this.cwsec - this.nwsec;
            long l = this.cpsec - this.npsec;
            boolean bl25 = n3 > 0;
            boolean bl26 = n3 < 0;
            boolean bl27 = !bl25 && !bl26;
            boolean bl28 = l > (long)(n << 2);
            boolean bl29 = l < (long)(-n);
            boolean bl30 = !bl28 && !bl29;
            boolean bl31 = bl27 && bl30;
            boolean bl32 = bl25 || bl27 && bl28;
            boolean bl33 = bl26 || bl27 && bl29;
            boolean bl34 = bl4 && !bl21;
            boolean bl35 = bl5 && bl24 && bl33;
            boolean bl36 = this.pstate == 4 && bl5 && bl32;
            boolean bl37 = this.pstate == 9;
            long l2 = this.cpsec + (long)(this.pinc << 8);
            boolean bl38 = l2 > this.npsec;
            boolean bl39 = l2 > this.mpsec;
            boolean bl40 = (bl35 || bl34 || bl36 || bl37) && !bl17 && !bl16;
            boolean bl41 = bl2 = bl24 && bl27 && bl38 && !bl34;
            int n4 = bl39 ? CORE.l2i(this.mpsec - this.cpsec) : (bl2 ? CORE.l2i(this.npsec - this.cpsec) : this.pinc << 8);
            l2 = this.pinc << 3;
            this.sid = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if ((this.halo.vbpr & 2) != 0) {
                System.out.printf("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", this.cwsec, this.cpsec, this.nwsec, this.npsec, this.counts, bl35 ? 1 : 0, bl34 ? 1 : 0, bl36 ? 1 : 0, buffer.rok ? 1 : 0, stream.wok ? 1 : 0, 0);
            }
            if (bl40) {
                this.pstate = 1;
                int n9 = this.pad;
                for (int i = n4; stream.wok && i > 0 || n7 != 0; i -= this.pinc) {
                    this.cpsec += (long)this.pinc;
                    n7 = !bl7 ? 0 : (n7 == 2 ? 0 : n7 + 1);
                    n8 = this.ifix == this.mfix ? n8 + this.nfix : n8;
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    stream.wrLCS(n9, (long)i < l2 ? 1 : 0, 0);
                }
                this.counts = CORE.setBits(this.counts, 15, 12, CORE.getBits(this.counts, 15, 12) + 1);
                n9 = 0;
            } else if (bl22) {
                this.pstate = 2;
                int n10 = 0;
                while (stream.wok && n10 < n2) {
                    this.cpsec += (long)this.pinc;
                    n8 = this.ifix == this.mfix ? n8 + this.nfix : n8;
                    this.ifix = this.ifix == this.mfix ? 0 : this.ifix + 1;
                    int n11 = buffer.getL(n10 << 2);
                    stream.wrLCS(n11, this.length < 8 ? 1 : 0, this.swaps);
                    ++n10;
                    --this.length;
                }
                buffer.rnxt(n10 << 2);
            } else if (bl21 && bl17) {
                this.pstate = 3;
                this.length = this.maxfer;
            } else if (bl21 && !bl16) {
                int n12;
                boolean bl42;
                this.pstate = 4;
                int n13 = 0;
                int n14 = buffer.getL(0);
                int n15 = buffer.getL(4);
                int n16 = buffer.getL(8);
                boolean bl43 = !bl11 || !CORE.getBit(n14, 3);
                boolean bl44 = CORE.getBit(n14, 3);
                boolean bl45 = CORE.getBits(n14, 6, 5) > 1 ? true : CORE.getBit(n14, 4);
                boolean bl46 = CORE.bswap2(bl45 ? CORE.getBits(n15, 31, 16) : CORE.getBits(n16, 15, 0)) == this.sid;
                boolean bl47 = CORE.getBits(n14, 7, 0) == 28 && (CORE.bswap4(n16) == this.ouid || bl43);
                boolean bl48 = CORE.getBits(n14, 7, 0) == 8 && (CORE.bswap4(n15) == this.ouid || bl43);
                boolean bl49 = CORE.getBits(n14, 7, 0) == 24 && (CORE.bswap4(n16) == 6971934 || bl43);
                boolean bl50 = CORE.getBits(n14, 7, 0) == 73 && (CORE.bswap4(n16) == this.ouid || bl43);
                boolean bl51 = bl18 && n14 == 0x676665;
                boolean bl52 = !(!bl20 || !bl47 && !bl48 && !bl49 || !bl46 && !bl6);
                boolean bl53 = bl42 = bl20 && bl50 && (bl46 || bl6);
                if (bl51) {
                    n12 = 64;
                    n6 = CORE.getBits(n15, 7, 0);
                    int n17 = CORE.getBits(n16, 13, 0);
                    n13 = CORE.getBits(n16, 13, 0);
                    n14 = buffer.getL(12);
                    this.sid = CORE.getBits(n14, 31, 16);
                    n14 = buffer.getL(16);
                    int n18 = CORE.getBits(n14, 27, 24);
                    for (int i = 1; i < n18; ++i) {
                        n13 += n17;
                    }
                } else if (bl52) {
                    int n19;
                    boolean bl54;
                    int n20 = n5 = CORE.getBit(n14, 2) ? 4 : 0;
                    n12 = !bl44 ? 20 : (!bl45 ? 24 : 28);
                    n6 = CORE.getBits(n14, 11, 8);
                    this.nseq &= 0xF;
                    n13 = (CORE.bswap2(CORE.getBits(n14, 31, 16)) << 2) - n12 - n5;
                    n14 = buffer.getL(12);
                    boolean bl55 = bl47 ? CORE.getBit(n14, 22) : (bl54 = bl48 ? CORE.getBit(n16, 22) : true);
                    int n21 = bl47 ? CORE.getBits(n14, 27, 24) : (n19 = bl48 ? CORE.getBits(n16, 27, 24) : this.dbps);
                    if (bl5 || bl8) {
                        n15 = buffer.getL(n12 - 12);
                        this.nwsec = CORE.bswap4(n15);
                        n15 = buffer.getL(n12 - 8);
                        this.npsec = CORE.setBits(this.npsec, 39, 32, (long)CORE.bswap4(n15));
                        n15 = buffer.getL(n12 - 4);
                        this.npsec = CORE.setBits(this.npsec, 31, 0, (long)CORE.bswap4(n15));
                    }
                    this.swaps = CORE.setBit(this.swaps, 0, n19 == 15 && bl54);
                    this.swaps = CORE.setBit(this.swaps, 1, n19 > 15 && bl54);
                    this.swaps = CORE.setBit(this.swaps, 2, n19 == 11 && bl54);
                    if ((this.halo.vbpr & 2) != 0) {
                        System.out.printf("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", this.cwsec, this.cpsec, this.nwsec, this.npsec);
                    }
                } else if (bl42) {
                    int n22;
                    this.pstate = 5;
                    n12 = CORE.getBits(n14, 31, 24) << 2;
                    int n23 = n22 = bl44 ? 28 : 20;
                    if (bl9) {
                        int n24;
                        n14 = buffer.getL(n22);
                        n14 = CORE.brev4(CORE.bswap4(n14));
                        if ((this.halo.vbpr & 1) != 0) {
                            System.out.printf("UDAT Ctx bx=%08x coff=%d len=%d\n", n14, n22, n12);
                        }
                        stream.wrLCS(n14, 2, 0);
                        n22 += 4 + (CORE.getBits(n14, 2, 2) << 3) + (CORE.getBits(n14, 1, 1) << 2);
                        if (CORE.getBit(n14, 3) && bl13) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx IF bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 4, 0);
                        }
                        n22 += CORE.getBits(n14, 3, 3) << 3;
                        if (CORE.getBit(n14, 4) && bl14) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx RF bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 4, 0);
                        }
                        n22 += (CORE.getBits(n14, 4, 4) + CORE.getBits(n14, 5, 5) + CORE.getBits(n14, 6, 6) << 3) + (CORE.getBits(n14, 7, 7) << 2);
                        if (CORE.getBit(n14, 8) && bl15) {
                            n15 = buffer.getL(n22);
                            n24 = CORE.bswap4(n15) >> 7;
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx GAIN bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 8, 0);
                        }
                        n22 += CORE.getBits(n14, 8, 8) + CORE.getBits(n14, 9, 9) << 2;
                        if (CORE.getBit(n14, 10) && bl12) {
                            n15 = buffer.getL(n22);
                            n16 = buffer.getL(n22 + 4);
                            n24 = CORE.l2i(CORE.ii2l(CORE.bswap4(n15), CORE.bswap4(n16)) >> 20);
                            if ((this.halo.vbpr & 1) != 0) {
                                System.out.printf("UDAT Ctx SR bc=%d\n", n24);
                            }
                            stream.wrLCS(n24, 10, 0);
                        }
                        stream.wrLCS(n14, 2, 0);
                        stream.setC(0);
                    }
                    this.counts = CORE.setBits(this.counts, 23, 20, CORE.getBits(this.counts, 23, 20) + 1);
                } else {
                    n12 = 4;
                    this.counts = CORE.setBits(this.counts, 30, 24, CORE.getBits(this.counts, 30, 24) + 1);
                }
                buffer.rnxt(n12);
                if (n13 > 0) {
                    this.length = n13 >> 2;
                    this.counts = CORE.setBits(this.counts, 3, 0, CORE.getBits(this.counts, 3, 0) + 1);
                    if (n6 != this.nseq) {
                        this.counts = CORE.setBits(this.counts, 7, 4, CORE.getBits(this.counts, 7, 4) + 1);
                    }
                    this.nseq = n6 + 1;
                    stream.setC(0);
                }
            }
            if (bl36 || bl37) {
                if (n2 > 0) {
                    buffer.rnxt(n2 << 2);
                    this.length -= n2;
                }
                int n25 = this.pstate = this.length == 0 ? 1 : 9;
                if (bl36) {
                    this.counts = CORE.setBits(this.counts, 11, 8, CORE.getBits(this.counts, 11, 8) + 1);
                }
            }
            this.counts = CORE.setBits(this.counts, 19, 16, this.length > 15 ? 15 : CORE.getBits(this.length, 3, 0));
            this.counts = CORE.setBit(this.counts, 31, bl21);
            this.cpsec += (long)n8;
            boolean bl56 = bl = this.cpsec >= this.mpsec;
            if (bl) {
                this.cpsec -= this.mpsec;
                ++this.cwsec;
            }
            if (this.pass == 0) {
                this.counts = this.counts;
                this.cwsec = this.cwsec;
                this.cpsec = this.cpsec;
                this.nwsec = this.nwsec;
                this.npsec = this.npsec;
                if ((this.halo.vbpr & 2) != 0) {
                    System.out.printf("Upd  Counts=%x   Nxt w=%08x p=%012x   Cur w=%08x p=%012x   pstate=%d cnt=%d pass=%d\n", this.counts, this.nwsec, this.npsec, this.cwsec, this.cpsec, this.pstate, 0, this.pass);
                }
            }
            this.pass = this.pass >= 14 ? 0 : this.pass + 1;
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }

        @Override
        public int poll() {
            double d = CORE.cpuTime();
            int n = CORE.d2i(CORE.floor(d));
            long l = CORE.d2l(CORE.frac(d) * 1.0E12);
            if (this.ptype <= 1) {
                return 0;
            }
            if (CORE.getBit(this.flags, 1) || CORE.getBit(this.flags, 3)) {
                this.getVars("cwsec,cpsec,nwsec,npsec,counts");
                System.out.printf("Poll EECLFDSU=%08x  Cpu=%08x:%012x  Nxt=%08x:%012x  Cur=%08x:%012x\n", this.counts, n, l, this.nwsec, this.npsec, this.cwsec, this.cpsec);
            }
            return 5;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(3);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(3);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(3);
        }
    }
}

