/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.core;

import nxm.ice.core.Modefs;
import nxm.ice.core.Modems;
import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.ice.lib.CoreFactory;
import nxm.ice.lib.CoreNative;

public class RFP
extends CoreFactory {
    public static final int FLOW = 1;
    public static final int OFMT = 2;
    public static final int SELFPACE = 1;
    public static final int BW = 32;
    public static final int MO = 9;
    public static final int OLUT = 12;
    public static final int NLUT = 4096;
    public static final int COMMA = 484560571;
    public static final int LRSPB = 4194433;
    public static final int LRSPM = 0x2000023;
    public static final int MSEQ = 0xFFFFFF;
    public static final int MTU = 1536;

    public static class CORE
    extends Core
    implements Modefs {
        public int rfp;
        public int fec;
        public int scr;
        public int bpw;
        public int upp;
        public int lrsl;
        int shft;
        int mask;
        int punc;
        int ipunc;
        int mpunc;
        int iseq;
        int mseq;
        int cseq;
        int errs;
        int[] elut;
        int ilen;
        int olen;
        int flgs;
        int scrc;
        int scrv;
        int gmask;
        int lrsi;
        int lrsc;
        int lrsp;
        int uv;
        int bi;
        int crc;

        public void optimize() {
            if (CORE.getBit(this.flgs, 0)) {
                this.elut = new int[8];
            }
        }

        @Override
        public int init() {
            this.rfp = 0;
            this.fec = 0;
            this.scr = -1;
            this.bpw = -1;
            return 0;
        }

        public boolean isGen() {
            return this.bpw == 0;
        }

        @Override
        public int set(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "S:RFP")) {
                this.rfp = value.toItem("NONE,ICE,ETH,DVBS,DVBX,GSM");
            } else if (this.isMatch(string, "S:FEC")) {
                this.fec = value.toItem("NONE,REP1,REP2,REP3,HAM74,HAM84,HAM128,GLY2412,SD2216,SD3932,SD7264,V27,V27P12,V27P23,V27P34,V27P45,V27P56,V27P67,V27P78,V29,V29P12,V29P23,V29P34,V29P45,V29P56,V29P67,V29P78,V39,V615,TCM,TCM23,DTCM23");
            } else if (this.isMatch(string, "S:SCR")) {
                this.scr = value.toItem("NONE,LRS,V35,IES");
            } else if (this.isMatch(string, "L:BPW")) {
                this.bpw = value.toL();
            } else if (this.isMatch(string, "L:LRSP")) {
                this.lrsp = value.toL();
            } else if (this.isMatch(string, "L:LRSI")) {
                this.lrsi = value.toL();
            } else if (this.isMatch(string, "L:LRSL")) {
                this.lrsl = value.toL();
            } else if (!this.isMatch(string, "L:VFLG")) {
                if (this.isMatch(string, "L:ERRS")) {
                    this.errs = value.toL();
                } else if (this.isMatch(string, "L:UPP")) {
                    this.upp = value.toL();
                } else {
                    return super.set(string, value);
                }
            }
            return 0;
        }

        @Override
        public int get(String string, CoreComponent.Value value) {
            if (this.isMatch(string, "L:RFP")) {
                value.fromL(this.rfp);
            } else if (this.isMatch(string, "L:FEC")) {
                value.fromL(this.fec);
            } else if (this.isMatch(string, "L:SCR")) {
                value.fromL(this.scr);
            } else if (this.isMatch(string, "L:ERRS")) {
                value.fromL(this.errs);
            } else {
                return super.get(string, value);
            }
            return 0;
        }

        @Override
        public int open() {
            this.elut = new int[4096];
            int n = Modems.getFECLUT(this.fec, this.upp, this.elut, null);
            this.ilen = n >> 0 & 0xFF;
            this.olen = n >> 8 & 0xFF;
            this.mask = n >> 16 & 0xFFF;
            this.mpunc = n >> 28 & 0xF;
            this.gmask = (1 << this.ilen) - 1;
            this.shft = 0;
            this.ipunc = this.mpunc;
            this.lrsc = this.lrsi;
            if (this.lrsp == 0 || this.lrsp == -1) {
                this.lrsp = 0x2000023;
            }
            if (this.lrsl >= 0x1000000) {
                System.out.printf("Err: LSR repeat length=%d too long max=%d\n", this.lrsl, 0x1000000);
            }
            this.flgs = 0;
            if (this.scr < 0) {
                int n2 = this.scr = this.fec == 0 ? 1 : 0;
            }
            if (this.scr > 1) {
                this.flgs |= 4;
                if (this.fec == 0) {
                    this.olen = 1;
                    this.ilen = 1;
                }
            }
            if (this.rfp == 0 && this.fec == 0 && this.scr <= 1 && this.bpw != 0) {
                this.flgs |= 1;
            }
            if (this.bpw == 0 && this.rfp == 0) {
                this.flgs |= 8;
            }
            if (this.bpw == 0 && this.rfp != 0) {
                this.flgs |= 0x20;
            }
            if (this.fec >= 29) {
                this.flgs |= 0x10;
            }
            if (CORE.getBit(this.flgs, 0)) {
                this.olen = 32;
                this.ilen = 32;
            }
            this.iseq = 0;
            this.mseq = this.lrsl > 0 ? this.lrsl - this.ilen : (CORE.getBit(this.flgs, 3) ? 0xFFFFFF : 12288 - this.ilen);
            this.cseq = this.mseq & 0xFFFFE0;
            this.optimize();
            if ((this.halo.vbpr & 1) != 0) {
                System.out.printf("RFP rfp=%d fec=%d scr=%x bpw=%d ilen=%d olen=%d flgs=%x punc=%d\n", this.rfp, this.fec, this.scr, this.bpw, this.ilen, this.olen, this.flgs, this.mpunc + 1);
            }
            this.halo.state = 1;
            return 0;
        }

        @Override
        public int process(CoreComponent.Stream stream, CoreComponent.Stream stream2) {
            boolean bl = CORE.getBit(this.flgs, 0);
            boolean bl2 = CORE.getBit(this.flgs, 1);
            boolean bl3 = CORE.getBit(this.flgs, 2);
            boolean bl4 = CORE.getBit(this.flgs, 3);
            boolean bl5 = CORE.getBit(this.flgs, 4);
            boolean bl6 = CORE.getBit(this.flgs, 5);
            while (stream2.wok && (bl4 || bl6 || stream.rok || bl2)) {
                if (bl) {
                    this.bi = stream.rdL();
                } else if (bl4) {
                    this.bi = this.lrsc = this.iseq == 0 ? this.lrsi : CORE.iLRSP(this.lrsc, this.lrsp);
                    this.crc = this.iseq == 0 ? 484560571 : this.crc ^ this.bi;
                } else if ((this.iseq & 0x1F) != 0) {
                    this.bi >>= this.ilen;
                } else if (this.iseq == this.cseq) {
                    this.bi = this.crc;
                } else if (this.iseq == 0 || !bl6 && !stream.rok) {
                    this.crc = this.bi = 484560571;
                } else if (bl6) {
                    this.bi = 30278094;
                    this.crc ^= this.bi;
                } else {
                    this.bi = stream.rdL();
                    this.crc ^= this.bi;
                }
                boolean bl7 = this.iseq <= 32;
                int n = this.iseq = this.iseq >= this.mseq ? 0 : this.iseq + this.ilen;
                if (bl) {
                    stream2.wrBits(32, this.bi);
                    continue;
                }
                int n2 = CORE.getBits(this.bi, 0, 0) ^ (bl7 ? 0 : CORE.getBits(this.scrv, 3, 3) ^ CORE.getBits(this.scrv, 20, 20) ^ (this.scrc == 31 ? 1 : 0));
                this.scrc = bl7 ? 0 : (CORE.getBit(this.scrv, 1) != CORE.getBit(this.scrv, 9) ? 0 : this.scrc + 1);
                int n3 = this.scrv = bl7 ? 1 : n2 << 1 | this.scrv << 1;
                int n4 = bl5 ? CORE.getBits(this.bi, 1, 1) : (bl3 ? n2 : this.bi & this.gmask);
                int n5 = CORE.getBits(this.bi, 0, 0);
                this.shft = this.shft << 1 & this.mask | n4;
                int n6 = this.ipunc << 9 | this.shft;
                this.ipunc = this.ipunc >= this.mpunc ? 0 : this.ipunc + 1;
                int n7 = this.elut[n6];
                if (bl5) {
                    this.uv ^= n5 << CORE.getBits(n7, 1, 1);
                    int n8 = CORE.getBits(n7, 1, 0);
                    int n9 = CORE.getBits(n7, 1, 1);
                    int n10 = n8 | (CORE.getBit(this.uv, n9) ? 4 : 0);
                    stream2.wrBits(3, n10);
                    continue;
                }
                stream2.wrBits(this.olen - CORE.getBits(n7, 8, 8), CORE.getBits(n7, 7, 0));
            }
            return 0;
        }

        @Override
        public int close() {
            this.halo.state = 0;
            return 0;
        }
    }

    public static class ICE
    extends CoreNative {
        @Override
        public native long alloc();

        public ICE() {
            this.setFlow(1);
        }
    }

    public static class CPU
    extends CoreNative {
        @Override
        public native long alloc();

        public CPU() {
            this.setFlow(1);
        }
    }

    public static class JVM
    extends CORE {
        public JVM() {
            this.setFlow(1);
        }
    }
}

